/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EtchedBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.Commands;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.GUI;
import org.jpedal.examples.simpleviewer.gui.SignaturesTreeCellRenderer;
import org.jpedal.examples.simpleviewer.gui.VTextIcon;
import org.jpedal.examples.simpleviewer.gui.generic.GUIButton;
import org.jpedal.examples.simpleviewer.gui.generic.GUICombo;
import org.jpedal.examples.simpleviewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.simpleviewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.examples.simpleviewer.gui.popups.Preferences;
import org.jpedal.examples.simpleviewer.gui.popups.PrintPanel;
import org.jpedal.examples.simpleviewer.gui.swing.CommandListener;
import org.jpedal.examples.simpleviewer.gui.swing.FrameCloser;
import org.jpedal.examples.simpleviewer.gui.swing.PageViewChanger;
import org.jpedal.examples.simpleviewer.gui.swing.SearchList;
import org.jpedal.examples.simpleviewer.gui.swing.SwingButton;
import org.jpedal.examples.simpleviewer.gui.swing.SwingCombo;
import org.jpedal.examples.simpleviewer.gui.swing.SwingMenuItem;
import org.jpedal.examples.simpleviewer.gui.swing.SwingOutline;
import org.jpedal.examples.simpleviewer.utils.Printer;
import org.jpedal.examples.simpleviewer.utils.PropertiesFile;
import org.jpedal.exception.PdfException;
import org.jpedal.external.JPedalCustomDrawObject;
import org.jpedal.fonts.FontMappings;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.StatusBar;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.acroforms.formData.FormObject;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.utils.BrowserLauncher;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.SwingWorker;
import org.jpedal.utils.repositories.Vector_Int;
import org.w3c.dom.Node;

public class SwingGUI
extends GUI
implements GUIFactory {
    boolean finishedDecoding = false;
    static final int startSize = 30;
    static final int expandedSize = 190;
    String pageTitle;
    String bookmarksTitle;
    String signaturesTitle;
    boolean hasListener = false;
    private boolean isSetup = false;
    int lastTabSelected = -1;
    public boolean messageShown = false;
    ButtonGroup layoutGroup = new ButtonGroup();
    ButtonGroup searchLayoutGroup = new ButtonGroup();
    ButtonGroup borderGroup = new ButtonGroup();
    private CommandListener currentCommandListener;
    private JToolBar topButtons = new JToolBar();
    private JToolBar comboBar = new JToolBar();
    private JToolBar row2NavButtons = new JToolBar();
    private JMenuBar currentMenu = new JMenuBar();
    private boolean firstTimeFormMessage = true;
    private JLabel coords = new JLabel();
    private JFrame frame = new JFrame();
    private JDesktopPane desktopPane = new JDesktopPane();
    boolean isSingle = true;
    private JTabbedPane navOptionsPanel = new JTabbedPane();
    private JSplitPane displayPane;
    private JScrollPane scrollPane = new JScrollPane();
    private final Font headFont = new Font("SansSerif", 1, 14);
    private final Font textFont = new Font("Serif", 0, 12);
    private StatusBar statusBar = new StatusBar(Color.orange);
    public JTextField pageCounter2 = new JTextField(4);
    private JLabel pageCounter3;
    private JLabel optimizationLabel;
    private JTree signaturesTree = new JTree();
    private String user_dir = System.getProperty("user.dir");
    private boolean tabsNotInitialised = true;
    private JToolBar navToolBar = new JToolBar();
    private JToolBar pagesToolBar = new JToolBar();
    public GUIButton nextSearch;
    public GUIButton previousSearch;
    private Preferences p;
    GUISearchWindow searchFrame = null;
    boolean addSearchTab = false;
    boolean searchInMenu = false;
    JTextField searchText = null;
    SearchList results = null;
    private Commands currentCommands;
    PrintPanel printPanel = null;

    public SwingGUI(PdfDecoder pdfDecoder, Values values, GUIThumbnailPanel gUIThumbnailPanel, PropertiesFile propertiesFile, Preferences preferences) {
        this.decode_pdf = pdfDecoder;
        this.commonValues = values;
        this.thumbnails = gUIThumbnailPanel;
        this.properties = propertiesFile;
        this.p = preferences;
        preferences.setParent(this.frame);
        if (values.isContentExtractor()) {
            this.titleMessage = "IDRsolutions Extraction Solution 3.51b12 ";
            this.showOutlines = false;
        }
        SignaturesTreeCellRenderer signaturesTreeCellRenderer = new SignaturesTreeCellRenderer();
        this.signaturesTree.setCellRenderer(signaturesTreeCellRenderer);
        if (this.isSingle) {
            this.desktopPane.setBackground(this.frame.getBackground());
            this.desktopPane.setVisible(true);
            this.frame.getContentPane().add((Component)this.desktopPane, "Center");
        }
    }

    public JComponent getDisplayPane() {
        return this.displayPane;
    }

    public JDesktopPane getMultiViewerFrames() {
        return this.desktopPane;
    }

    public void setPdfDecoder(PdfDecoder pdfDecoder) {
        this.decode_pdf = pdfDecoder;
    }

    public void closeMultiViewerWindow(String string) {
        JInternalFrame[] jInternalFrameArray = this.desktopPane.getAllFrames();
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            JInternalFrame jInternalFrame = jInternalFrameArray[i];
            if (!jInternalFrame.getTitle().equals(string)) continue;
            try {
                jInternalFrame.setClosed(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
            break;
        }
    }

    public int AdjustForAlignment(int n) {
        if (this.decode_pdf.getPageAlignment() == 2) {
            int n2 = this.decode_pdf.getBounds().width;
            int n3 = this.decode_pdf.getPDFWidth();
            if (this.decode_pdf.getDisplayView() != 1) {
                n3 = (int)this.decode_pdf.getMaximumSize().getWidth();
            }
            if (n2 > n3) {
                n -= (n2 - n3) / 2;
            }
        }
        return n;
    }

    public String getBookmark(String string) {
        return this.tree.getPage(string);
    }

    public void reinitialiseTabs(boolean bl) {
        if (!this.isSingle) {
            return;
        }
        if (!bl) {
            this.displayPane.setDividerLocation(30);
        }
        this.lastTabSelected = -1;
        if (this.commonValues.isContentExtractor()) {
            this.navOptionsPanel.removeAll();
            this.displayPane.setDividerLocation(0);
        } else if (!this.commonValues.isPDF()) {
            this.navOptionsPanel.setVisible(false);
        } else {
            Object object;
            int n;
            this.navOptionsPanel.setVisible(true);
            if (!this.decode_pdf.hasOutline()) {
                int n2;
                n = -1;
                if (PdfDecoder.isRunningOnMac) {
                    object = "";
                    for (n2 = 0; n2 < this.navOptionsPanel.getTabCount(); ++n2) {
                        if (!this.navOptionsPanel.getTitleAt(n2).equals(this.bookmarksTitle)) continue;
                        n = n2;
                    }
                } else {
                    object = "";
                    for (n2 = 0; n2 < this.navOptionsPanel.getTabCount(); ++n2) {
                        if (!this.navOptionsPanel.getIconAt(n2).toString().equals(this.bookmarksTitle)) continue;
                        n = n2;
                    }
                }
                if (n != -1) {
                    this.navOptionsPanel.remove(n);
                }
            } else {
                n = -1;
                if (PdfDecoder.isRunningOnMac) {
                    object = "";
                    for (int i = 0; i < this.navOptionsPanel.getTabCount(); ++i) {
                        if (!this.navOptionsPanel.getTitleAt(i).equals(this.bookmarksTitle)) continue;
                        n = i;
                    }
                    if (n == -1) {
                        this.navOptionsPanel.addTab(this.bookmarksTitle, (SwingOutline)this.tree);
                    }
                } else {
                    object = "";
                    for (int i = 0; i < this.navOptionsPanel.getTabCount(); ++i) {
                        if (!this.navOptionsPanel.getIconAt(i).toString().equals(this.bookmarksTitle)) continue;
                        n = i;
                    }
                    if (n == -1) {
                        VTextIcon vTextIcon = new VTextIcon(this.navOptionsPanel, this.bookmarksTitle, 2);
                        this.navOptionsPanel.addTab(null, vTextIcon, (SwingOutline)this.tree);
                    }
                }
            }
            AcroRenderer acroRenderer = this.decode_pdf.getFormRenderer();
            object = acroRenderer.getSignatureObjects();
            if (object != null) {
                Object object2;
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Signatures");
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("The following people have digitally counter-signed this document");
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("The following signature fields are not signed");
                while (object.hasNext()) {
                    Object object3;
                    FormObject formObject = (FormObject)object.next();
                    object2 = acroRenderer.getSignatureObject(formObject.getPDFRef());
                    if (object2 == null) {
                        if (!defaultMutableTreeNode3.isNodeChild(defaultMutableTreeNode)) {
                            defaultMutableTreeNode.add(defaultMutableTreeNode3);
                        }
                        object3 = new DefaultMutableTreeNode(formObject.getFieldName() + " on page " + formObject.getPageNumber());
                        defaultMutableTreeNode3.add((MutableTreeNode)object3);
                        continue;
                    }
                    if (!defaultMutableTreeNode2.isNodeChild(defaultMutableTreeNode)) {
                        defaultMutableTreeNode.add(defaultMutableTreeNode2);
                    }
                    object3 = (String)object2.get("Name");
                    DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode("Signed by " + (String)object3);
                    defaultMutableTreeNode2.add(defaultMutableTreeNode4);
                    DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode("Type");
                    defaultMutableTreeNode4.add(defaultMutableTreeNode5);
                    String string = (String)object2.get("Filter");
                    DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode("Filter: " + string.substring(1, string.length()));
                    defaultMutableTreeNode5.add(defaultMutableTreeNode6);
                    String string2 = (String)object2.get("SubFilter");
                    DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode("Sub Filter: " + string2.substring(1, string2.length()));
                    defaultMutableTreeNode5.add(defaultMutableTreeNode7);
                    DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode("Details");
                    defaultMutableTreeNode4.add(defaultMutableTreeNode8);
                    StringBuffer stringBuffer = new StringBuffer((String)object2.get("M"));
                    stringBuffer.delete(0, 2);
                    stringBuffer.insert(4, '/');
                    stringBuffer.insert(7, '/');
                    stringBuffer.insert(10, ' ');
                    stringBuffer.insert(13, ':');
                    stringBuffer.insert(16, ':');
                    stringBuffer.insert(19, ' ');
                    DefaultMutableTreeNode defaultMutableTreeNode9 = new DefaultMutableTreeNode("Time: " + stringBuffer);
                    defaultMutableTreeNode8.add(defaultMutableTreeNode9);
                    String string3 = (String)object2.get("Reason");
                    DefaultMutableTreeNode defaultMutableTreeNode10 = new DefaultMutableTreeNode("Reason: " + string3);
                    defaultMutableTreeNode8.add(defaultMutableTreeNode10);
                    String string4 = (String)object2.get("Location");
                    DefaultMutableTreeNode defaultMutableTreeNode11 = new DefaultMutableTreeNode("Location: " + string4);
                    defaultMutableTreeNode8.add(defaultMutableTreeNode11);
                    DefaultMutableTreeNode defaultMutableTreeNode12 = new DefaultMutableTreeNode("Field: " + formObject.getFieldName() + " on page " + formObject.getPageNumber());
                    defaultMutableTreeNode8.add(defaultMutableTreeNode12);
                }
                ((DefaultTreeModel)this.signaturesTree.getModel()).setRoot(defaultMutableTreeNode);
                int n3 = -1;
                if (PdfDecoder.isRunningOnMac) {
                    object2 = "";
                    for (int i = 0; i < this.navOptionsPanel.getTabCount(); ++i) {
                        if (!this.navOptionsPanel.getTitleAt(i).equals(this.signaturesTitle)) continue;
                        n3 = i;
                    }
                    if (n3 == -1) {
                        this.navOptionsPanel.addTab(this.signaturesTitle, this.signaturesTree);
                    }
                } else {
                    object2 = "";
                    for (int i = 0; i < this.navOptionsPanel.getTabCount(); ++i) {
                        if (!this.navOptionsPanel.getIconAt(i).toString().equals(this.signaturesTitle)) continue;
                        n3 = i;
                    }
                    if (n3 == -1) {
                        VTextIcon vTextIcon = new VTextIcon(this.navOptionsPanel, this.signaturesTitle, 2);
                        this.navOptionsPanel.addTab(null, vTextIcon, this.signaturesTree);
                    }
                }
            } else {
                int n4 = -1;
                if (PdfDecoder.isRunningOnMac) {
                    String string = "";
                    for (int i = 0; i < this.navOptionsPanel.getTabCount(); ++i) {
                        if (!this.navOptionsPanel.getTitleAt(i).equals(this.signaturesTitle)) continue;
                        n4 = i;
                    }
                } else {
                    String string = "";
                    for (int i = 0; i < this.navOptionsPanel.getTabCount(); ++i) {
                        if (!this.navOptionsPanel.getIconAt(i).toString().equals(this.signaturesTitle)) continue;
                        n4 = i;
                    }
                }
                if (n4 != -1) {
                    this.navOptionsPanel.remove(n4);
                }
            }
            this.setBookmarks(false);
        }
    }

    public void stopThumbnails() {
        if (!this.isSingle) {
            return;
        }
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.terminateDrawing();
            this.thumbnails.removeAllListeners();
        }
    }

    public void reinitThumbnails() {
        this.isSetup = false;
    }

    public void resetNavBar() {
        if (!this.isSingle) {
            return;
        }
        this.displayPane.setDividerLocation(30);
        this.tabsNotInitialised = true;
        if (!this.commonValues.isContentExtractor()) {
            this.setPageLayoutButtonsEnabled(false);
        }
    }

    public void setBackNavigationButtonsEnabled(boolean bl) {
        this.back.setEnabled(bl);
        this.first.setEnabled(bl);
        this.fback.setEnabled(bl);
    }

    public void setForwardNavigationButtonsEnabled(boolean bl) {
        this.forward.setEnabled(bl);
        this.end.setEnabled(bl);
        this.fforward.setEnabled(bl);
    }

    public void setPageLayoutButtonsEnabled(boolean bl) {
        if (!this.isSingle) {
            return;
        }
        this.continuousButton.setEnabled(bl);
        this.continuousFacingButton.setEnabled(bl);
        this.facingButton.setEnabled(bl);
        Enumeration<AbstractButton> enumeration = this.layoutGroup.getElements();
        if (enumeration.hasMoreElements()) {
            ((JMenuItem)enumeration.nextElement()).setEnabled(true);
            while (enumeration.hasMoreElements()) {
                ((JMenuItem)enumeration.nextElement()).setEnabled(bl);
            }
        }
    }

    public void setSearchLayoutButtonsEnabled() {
        Enumeration<AbstractButton> enumeration = this.searchLayoutGroup.getElements();
        ((JMenuItem)enumeration.nextElement()).setEnabled(true);
        while (enumeration.hasMoreElements()) {
            ((JMenuItem)enumeration.nextElement()).setEnabled(true);
        }
    }

    public void alignLayoutMenuOption(int n) {
        Enumeration<AbstractButton> enumeration = this.layoutGroup.getElements();
        for (int i = 1; enumeration.hasMoreElements() && i != n; ++i) {
            enumeration.nextElement();
        }
        ((JMenuItem)enumeration.nextElement()).setSelected(true);
    }

    public void setDisplayMode(Integer n) {
        if (n.equals(GUIFactory.MULTIPAGE)) {
            this.isSingle = false;
        }
    }

    public boolean isSingle() {
        return this.isSingle;
    }

    public void initLayoutMenus(JMenu jMenu, String[] stringArray, int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(stringArray[i]);
            jCheckBoxMenuItem.setBorder(BorderFactory.createEmptyBorder());
            this.layoutGroup.add(jCheckBoxMenuItem);
            if (i == 0) {
                jCheckBoxMenuItem.setSelected(true);
            }
            jCheckBoxMenuItem.addActionListener(new PageViewChanger(this.decode_pdf.getPageAlignment(), nArray[i], this.decode_pdf));
            jMenu.add(jCheckBoxMenuItem);
        }
        if (!this.isSingle) {
            return;
        }
        this.setPageLayoutButtonsEnabled(false);
    }

    private JScrollPane getFontsAliasesInfoBox() {
        Object object;
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(400, 300));
        jScrollPane.getViewport().add(jPanel);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jPanel.setOpaque(true);
        jPanel.setBackground(Color.white);
        jPanel.setEnabled(false);
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = FontMappings.fontSubstitutionAliasTable.keySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            stringBuffer.append(object);
            stringBuffer.append(" ==> ");
            stringBuffer.append(FontMappings.fontSubstitutionAliasTable.get(object));
            stringBuffer.append('\n');
        }
        object = stringBuffer.toString();
        if (((String)object).length() > 0) {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setLineWrap(false);
            jTextArea.setText((String)object);
            jPanel.add(jTextArea);
            jTextArea.setCaretPosition(0);
            jTextArea.setOpaque(false);
            jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        }
        return jScrollPane;
    }

    private JScrollPane getFontsFoundInfoBox() {
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(400, 300));
        jScrollPane.getViewport().add(jPanel);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jPanel.setOpaque(true);
        jPanel.setBackground(Color.white);
        jPanel.setEnabled(false);
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        if (FontMappings.fontSubstitutionTable != null) {
            Set set = FontMappings.fontSubstitutionTable.keySet();
            Iterator iterator = FontMappings.fontSubstitutionTable.keySet().iterator();
            int n = set.size();
            ArrayList<String> arrayList = new ArrayList<String>(n);
            while (iterator.hasNext()) {
                arrayList.add(iterator.next().toString());
            }
            Collections.sort(arrayList);
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                JLabel jLabel = new JLabel(e + " = " + FontMappings.fontSubstitutionLocation.get(e));
                jPanel.setFont(new Font("Lucida", 1, 12));
                jLabel.setForeground(Color.BLUE);
                jPanel.add(jLabel);
                Map map = (Map)FontMappings.fontPropertiesTable.get(e);
                if (map != null) {
                    Iterator iterator2 = map.keySet().iterator();
                    while (iterator2.hasNext()) {
                        Object k = iterator2.next();
                        Object v = map.get(k);
                        JLabel jLabel2 = new JLabel(k + " = " + v);
                        jLabel2.setFont(new Font("Lucida", 0, 10));
                        jPanel.add(jLabel2);
                    }
                }
                jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
            }
        }
        return jScrollPane;
    }

    private JScrollPane getFontInfoBox() {
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(400, 300));
        jScrollPane.getViewport().add(jPanel);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jPanel.setOpaque(true);
        jPanel.setBackground(Color.white);
        jPanel.setEnabled(false);
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        String string = this.decode_pdf.getFontsInFile();
        String string2 = "Font Substitution mode: ";
        SwingGUI swingGUI = this;
        switch (swingGUI.decode_pdf.getFontSubstitutionMode()) {
            case 1: {
                string2 = string2 + "using file name";
                break;
            }
            case 2: {
                string2 = string2 + "using PostScript name";
                break;
            }
            case 3: {
                string2 = string2 + "using family name";
                break;
            }
            case 4: {
                string2 = string2 + "using the full font name";
                break;
            }
            default: {
                string2 = string2 + "Unknown FontSubstitutionMode";
            }
        }
        string2 = string2 + "\n";
        if (string.length() > 0) {
            JTextArea jTextArea = new JTextArea();
            JLabel jLabel = new JLabel();
            jLabel.setAlignmentX(0.5f);
            jLabel.setText(string2);
            jLabel.setForeground(Color.BLUE);
            jTextArea.setLineWrap(false);
            jTextArea.setForeground(Color.BLACK);
            jTextArea.setText("\n" + string);
            jPanel.add(jLabel);
            jPanel.add(jTextArea);
            jTextArea.setCaretPosition(0);
            jTextArea.setOpaque(false);
        }
        return jScrollPane;
    }

    public void getInfoBox() {
        Accessible accessible;
        final JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(400, 260));
        jPanel.setOpaque(false);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JLabel jLabel = new JLabel(Messages.getMessage("PdfViewerInfo.title"));
        jLabel.setOpaque(false);
        jLabel.setFont(this.headFont);
        jLabel.setAlignmentX(0.5f);
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(0, 15)));
        String string = Messages.getMessage("PdfViewerInfo1") + Messages.getMessage("PdfViewerInfo2");
        if (string.length() > 0) {
            accessible = new JTextArea();
            ((JComponent)((Object)accessible)).setOpaque(false);
            ((JTextComponent)accessible).setText(string + "\n\nVersion: " + "3.51b12" + "\n\n" + "Java version " + System.getProperty("java.version"));
            ((JTextArea)accessible).setLineWrap(true);
            ((JTextArea)accessible).setWrapStyleWord(true);
            ((JTextComponent)accessible).setEditable(false);
            jPanel.add((Component)((Object)accessible));
            ((JComponent)((Object)accessible)).setAlignmentX(0.5f);
        }
        accessible = new ImageIcon(this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/logo.gif"));
        jPanel.add(Box.createRigidArea(new Dimension(0, 25)));
        JLabel jLabel2 = new JLabel((Icon)((Object)accessible));
        jLabel2.setAlignmentX(0.5f);
        jPanel.add(jLabel2);
        final JLabel jLabel3 = new JLabel("<html><center>" + Messages.getMessage("PdfViewerJpedalLibrary.Text") + Messages.getMessage("PdfViewer.WebAddress"));
        jLabel3.setForeground(Color.blue);
        jLabel3.setHorizontalAlignment(0);
        jLabel3.setAlignmentX(0.5f);
        jLabel3.addMouseListener(new MouseListener(){

            public void mouseEntered(MouseEvent mouseEvent) {
                jPanel.setCursor(new Cursor(12));
                jLabel3.setText("<html><center>" + Messages.getMessage("PdfViewerJpedalLibrary.Link") + Messages.getMessage("PdfViewerJpedalLibrary.Text") + Messages.getMessage("PdfViewer.WebAddress") + "</a></center>");
            }

            public void mouseExited(MouseEvent mouseEvent) {
                jPanel.setCursor(new Cursor(0));
                jLabel3.setText("<html><center>" + Messages.getMessage("PdfViewerJpedalLibrary.Text") + Messages.getMessage("PdfViewer.WebAddress"));
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                try {
                    BrowserLauncher.openURL(Messages.getMessage("PdfViewer.VisitWebsite"));
                }
                catch (IOException iOException) {
                    SwingGUI.this.showMessageDialog(Messages.getMessage("PdfViewer.ErrorWebsite"));
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        jPanel.add(jLabel3);
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.showMessageDialog(jPanel, Messages.getMessage("PdfViewerInfo3"), -1);
    }

    public void resetRotationBox() {
        PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
        if (this.decode_pdf.getDisplayView() == 1) {
            this.rotation = pdfPageData.getRotation(this.commonValues.getCurrentPage());
        }
        if (this.getSelectedComboIndex(251) != this.rotation / 90) {
            this.setSelectedComboIndex(251, this.rotation / 90);
        } else if (!this.commonValues.isProcessing()) {
            this.decode_pdf.repaint();
        }
    }

    private JScrollPane getPropertiesBox(String string, String string2, String string3, long l, int n, int n2) {
        PdfFileInformation pdfFileInformation = this.decode_pdf.getFileInformationData();
        if (pdfFileInformation != null) {
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(true);
            jPanel.setBackground(Color.white);
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setPreferredSize(new Dimension(400, 300));
            jScrollPane.getViewport().add(jPanel);
            jScrollPane.setVerticalScrollBarPolicy(20);
            jScrollPane.setHorizontalScrollBarPolicy(30);
            JLabel jLabel = new JLabel(Messages.getMessage("PdfViewerGeneral"));
            jLabel.setFont(this.headFont);
            jLabel.setOpaque(false);
            jPanel.add(jLabel);
            JLabel jLabel2 = new JLabel(Messages.getMessage("PdfViewerFileName") + string);
            jLabel2.setFont(this.textFont);
            jLabel2.setOpaque(false);
            jPanel.add(jLabel2);
            JLabel jLabel3 = new JLabel(Messages.getMessage("PdfViewerFilePath") + string2);
            jLabel3.setFont(this.textFont);
            jLabel3.setOpaque(false);
            jPanel.add(jLabel3);
            JLabel jLabel4 = new JLabel(Messages.getMessage("PdfViewerCurrentWorkingDir") + ' ' + string3);
            jLabel4.setFont(this.textFont);
            jLabel4.setOpaque(false);
            jPanel.add(jLabel4);
            JLabel jLabel5 = new JLabel(Messages.getMessage("PdfViewerFileSize") + l + " K");
            jLabel5.setFont(this.textFont);
            jLabel5.setOpaque(false);
            jPanel.add(jLabel5);
            JLabel jLabel6 = new JLabel(Messages.getMessage("PdfViewerPageCount") + n);
            jLabel6.setOpaque(false);
            jLabel6.setFont(this.textFont);
            jPanel.add(jLabel6);
            JLabel jLabel7 = new JLabel("PDF " + this.decode_pdf.getPDFVersion());
            jLabel7.setOpaque(false);
            jLabel7.setFont(this.textFont);
            jPanel.add(jLabel7);
            jPanel.add(Box.createVerticalStrut(10));
            JLabel jLabel8 = new JLabel(Messages.getMessage("PdfViewerProperties"));
            jLabel8.setFont(this.headFont);
            jLabel8.setOpaque(false);
            jPanel.add(jLabel8);
            String[] stringArray = pdfFileInformation.getFieldValues();
            String[] stringArray2 = pdfFileInformation.getFieldNames();
            int n3 = stringArray2.length;
            JLabel[] jLabelArray = new JLabel[n3];
            for (int i = 0; i < n3; ++i) {
                if (stringArray[i].length() <= 0) continue;
                jLabelArray[i] = new JLabel(stringArray2[i] + " = " + stringArray[i]);
                jLabelArray[i].setFont(this.textFont);
                jLabelArray[i].setOpaque(false);
                jPanel.add(jLabelArray[i]);
            }
            jPanel.add(Box.createVerticalStrut(10));
            PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
            if (pdfPageData != null) {
                JLabel jLabel9 = new JLabel(Messages.getMessage("PdfViewerCoords.text"));
                jLabel9.setFont(this.headFont);
                jPanel.add(jLabel9);
                JLabel jLabel10 = new JLabel(Messages.getMessage("PdfViewermediaBox.text") + pdfPageData.getMediaValue(n2));
                jLabel10.setFont(this.textFont);
                jPanel.add(jLabel10);
                JLabel jLabel11 = new JLabel(Messages.getMessage("PdfViewercropBox.text") + pdfPageData.getCropValue(n2));
                jLabel11.setFont(this.textFont);
                jPanel.add(jLabel11);
                JLabel jLabel12 = new JLabel(Messages.getMessage("PdfViewerLabel.Rotation") + pdfPageData.getRotation(n2));
                jLabel4.setFont(this.textFont);
                jPanel.add(jLabel12);
            }
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            return jScrollPane;
        }
        return new JScrollPane();
    }

    private JScrollPane getXMLInfoBox(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.setOpaque(true);
        jPanel.setBackground(Color.white);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(400, 300));
        jScrollPane.getViewport().add(jPanel);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setRows(5);
        jTextArea.setColumns(15);
        jTextArea.setLineWrap(true);
        jTextArea.setText(string);
        jPanel.add(new JScrollPane(jTextArea));
        jTextArea.setCaretPosition(0);
        jTextArea.setOpaque(true);
        jTextArea.setBackground(Color.white);
        return jScrollPane;
    }

    public void showDocumentProperties(String string, String string2, long l, int n, int n2) {
        JTabbedPane jTabbedPane = new JTabbedPane();
        if (string == null) {
            this.showMessageDialog(Messages.getMessage("PdfVieweremptyFile.message"), Messages.getMessage("PdfViewerTooltip.pageSize"), -1);
        } else {
            PdfFileInformation pdfFileInformation;
            String string3;
            String string4 = string;
            int n3 = string4.lastIndexOf(92);
            if (n3 == -1) {
                n3 = string4.lastIndexOf(47);
            }
            String string5 = string4.substring(n3 + 1, string4.length());
            String string6 = string4.substring(0, n3 + 1);
            jTabbedPane.add(this.getPropertiesBox(string5, string6, this.user_dir, l, n, n2));
            jTabbedPane.setTitleAt(0, Messages.getMessage("PdfViewerTab.Properties"));
            jTabbedPane.add(this.getFontInfoBox());
            jTabbedPane.setTitleAt(1, Messages.getMessage("PdfViewerTab.Fonts"));
            jTabbedPane.add(this.getFontsFoundInfoBox());
            jTabbedPane.setTitleAt(2, "Available");
            jTabbedPane.add(this.getFontsAliasesInfoBox());
            jTabbedPane.setTitleAt(3, "Aliases");
            int n4 = 4;
            JScrollPane jScrollPane = this.getFormList();
            if (jScrollPane != null) {
                jTabbedPane.add(jScrollPane);
                jTabbedPane.setTitleAt(n4, "Forms");
                ++n4;
            }
            if ((string3 = (pdfFileInformation = this.decode_pdf.getFileInformationData()).getFileXMLMetaData()).length() > 0) {
                jTabbedPane.add(this.getXMLInfoBox(string3));
                jTabbedPane.setTitleAt(n4, "XML");
            }
            this.showMessageDialog(jTabbedPane, Messages.getMessage("PdfViewerTab.DocumentProperties"), -1);
        }
    }

    private JScrollPane getFormList() {
        JScrollPane jScrollPane = null;
        AcroRenderer acroRenderer = this.decode_pdf.getFormRenderer();
        if (acroRenderer != null) {
            List list = null;
            try {
                list = acroRenderer.getComponentNameList(this.commonValues.getCurrentPage());
            }
            catch (PdfException pdfException) {
                LogWriter.writeLog("Exception " + pdfException + " reading component list");
            }
            if (list != null) {
                int n = list.size();
                JPanel jPanel = new JPanel();
                jScrollPane = new JScrollPane();
                jScrollPane.setPreferredSize(new Dimension(400, 300));
                jScrollPane.getViewport().add(jPanel);
                jScrollPane.setVerticalScrollBarPolicy(20);
                jScrollPane.setHorizontalScrollBarPolicy(30);
                jPanel.setLayout(new BoxLayout(jPanel, 1));
                JLabel jLabel = new JLabel("This page contains " + n + " form objects");
                jLabel.setFont(this.headFont);
                jPanel.add(jLabel);
                jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
                Collections.sort(list);
                for (int i = 0; i < n; ++i) {
                    String string = (String)list.get(i);
                    Component[] componentArray = (Component[])acroRenderer.getComponentsByName(string);
                    if (componentArray == null) continue;
                    int n2 = componentArray.length;
                    for (int j = 0; j < n2; ++j) {
                        int n3 = this.decode_pdf.getFormComponentType(string);
                        String string2 = string + "  (" + FormFactory.typesAsString[n3] + ")";
                        JLabel jLabel2 = new JLabel(string2);
                        Component component = componentArray[j];
                        Object object = this.getFormValue(component);
                        Class<?> clazz = component.getClass();
                        String string3 = "java class=" + clazz + "  value=" + object;
                        JLabel jLabel3 = new JLabel();
                        if (j == 0) {
                            jLabel3.setText(string3);
                        } else {
                            jLabel3.setText(string3 + " comp count=" + j);
                        }
                        jLabel2.setFont(this.headFont);
                        jLabel2.setForeground(Color.blue);
                        jLabel3.setFont(this.textFont);
                        jLabel3.setForeground(Color.blue);
                        jPanel.add(jLabel2);
                        jPanel.add(jLabel3);
                        JButton jButton = new JButton("View Form Data");
                        jButton.setFont(this.textFont);
                        jButton.setForeground(Color.blue);
                        jButton.addActionListener(new ShowFormDataListener(string));
                        jPanel.add(jButton);
                        jPanel.add(new JLabel(" "));
                    }
                }
            }
        }
        return jScrollPane;
    }

    public Object getFormValue(Component component) {
        Object object = "";
        if (component != null) {
            object = component instanceof JCheckBox ? Boolean.valueOf(((JCheckBox)component).isSelected()) : (component instanceof JComboBox ? ((JComboBox)component).getSelectedItem() : (component instanceof JList ? ((JList)component).getSelectedValues() : (component instanceof JRadioButton ? Boolean.valueOf(((JRadioButton)component).isSelected()) : (component instanceof JTextComponent ? ((JTextComponent)component).getText() : ""))));
        }
        return object;
    }

    public void searchInTab(GUISearchWindow gUISearchWindow) {
        this.searchFrame = gUISearchWindow;
        if (PdfDecoder.isRunningOnMac) {
            if (this.thumbnails.isShownOnscreen()) {
                this.navOptionsPanel.addTab("Search", gUISearchWindow.getContentPanel());
            }
        } else {
            VTextIcon vTextIcon = new VTextIcon(this.navOptionsPanel, "Search", 2);
            this.navOptionsPanel.addTab(null, vTextIcon, gUISearchWindow.getContentPanel());
        }
        this.addSearchTab = true;
    }

    public void searchInMenu(GUISearchWindow gUISearchWindow) {
        this.searchFrame = gUISearchWindow;
        this.searchInMenu = true;
        gUISearchWindow.find(this.decode_pdf, this.commonValues);
        this.searchText.setPreferredSize(new Dimension(150, 20));
        this.topButtons.add(this.searchText);
        this.addButton(0, "Previous Search Result", "/org/jpedal/examples/simpleviewer/res/search_previous.gif", 18);
        this.addButton(0, "Next Search Result", "/org/jpedal/examples/simpleviewer/res/search_next.gif", 19);
        this.nextSearch.setVisible(false);
        this.previousSearch.setVisible(false);
    }

    public void init(String[] stringArray, final Object object, Object object2) {
        Object object3;
        Object object4;
        this.currentCommands = (Commands)object;
        this.currentCommandListener = new CommandListener((Commands)object);
        this.setViewerTitle(Messages.getMessage("PdfViewer.titlebar") + "  " + "3.51b12");
        this.decode_pdf.setInset(25, 25);
        this.decode_pdf.setBackground(new Color(190, 190, 190));
        String[] stringArray2 = new String[2];
        stringArray2[1] = Messages.getMessage("PdfViewerToolbarComboBox.imageQual");
        stringArray2[0] = Messages.getMessage("PdfViewerTooltipComboBox.imageMem");
        this.qualityBox = new SwingCombo(stringArray2);
        this.qualityBox.setBackground(Color.white);
        this.qualityBox.setSelectedIndex(0);
        this.scalingBox = new SwingCombo(stringArray);
        this.scalingBox.setBackground(Color.white);
        this.scalingBox.setEditable(true);
        this.scalingBox.setSelectedIndex(0);
        this.rotationBox = new SwingCombo(this.rotationValues);
        this.rotationBox.setBackground(Color.white);
        this.rotationBox.setSelectedIndex(0);
        if (this.isSingle) {
            this.scrollPane.getViewport().add(this.decode_pdf);
            this.scrollPane.setVerticalScrollBarPolicy(20);
            this.scrollPane.setHorizontalScrollBarPolicy(30);
            this.scrollPane.getVerticalScrollBar().setUnitIncrement(80);
            this.scrollPane.getHorizontalScrollBar().setUnitIncrement(80);
        }
        this.row2NavButtons.setBorder(BorderFactory.createEmptyBorder());
        this.row2NavButtons.setLayout(new FlowLayout(3));
        this.row2NavButtons.setFloatable(false);
        this.row2NavButtons.setFont(new Font("SansSerif", 0, 8));
        if (this.isSingle) {
            this.navOptionsPanel.setTabPlacement(2);
            this.navOptionsPanel.setOpaque(true);
            this.navOptionsPanel.setMinimumSize(new Dimension(0, 100));
            this.pageTitle = Messages.getMessage("PdfViewerJPanel.thumbnails");
            this.bookmarksTitle = Messages.getMessage("PdfViewerJPanel.bookmarks");
            this.signaturesTitle = "Signatures";
            this.displayPane = new JSplitPane(1, this.navOptionsPanel, this.scrollPane);
            this.displayPane.setOneTouchExpandable(true);
            if (!this.commonValues.isContentExtractor()) {
                if (PdfDecoder.isRunningOnMac) {
                    if (this.thumbnails.isShownOnscreen()) {
                        this.navOptionsPanel.addTab(this.bookmarksTitle, (SwingOutline)this.tree);
                    }
                    this.navOptionsPanel.addTab(this.pageTitle, (Component)((Object)this.thumbnails));
                } else {
                    object4 = new VTextIcon(this.navOptionsPanel, this.bookmarksTitle, 2);
                    this.navOptionsPanel.addTab(null, (Icon)object4, (SwingOutline)this.tree);
                    if (this.thumbnails.isShownOnscreen()) {
                        object3 = new VTextIcon(this.navOptionsPanel, this.pageTitle, 2);
                        this.navOptionsPanel.addTab(null, (Icon)object3, (Component)((Object)this.thumbnails));
                    }
                }
                this.displayPane.setDividerLocation(30);
            } else {
                this.displayPane.setDividerLocation(0);
            }
            this.frame.getContentPane().add((Component)this.displayPane, "Center");
            if (!this.hasListener) {
                this.hasListener = true;
                this.navOptionsPanel.addMouseListener(new MouseListener(){

                    public void focusLost(FocusEvent focusEvent) {
                    }

                    public void mouseClicked(MouseEvent mouseEvent) {
                        SwingGUI.this.handleTabbedPanes();
                    }

                    public void mousePressed(MouseEvent mouseEvent) {
                    }

                    public void mouseReleased(MouseEvent mouseEvent) {
                    }

                    public void mouseEntered(MouseEvent mouseEvent) {
                    }

                    public void mouseExited(MouseEvent mouseEvent) {
                    }
                });
            }
        }
        if (!this.commonValues.isContentExtractor()) {
            this.first = new SwingButton();
            this.fback = new SwingButton();
            this.back = new SwingButton();
            this.forward = new SwingButton();
            this.fforward = new SwingButton();
            this.end = new SwingButton();
        }
        this.snapshotButton = new SwingButton();
        this.singleButton = new SwingButton();
        this.continuousButton = new SwingButton();
        this.continuousFacingButton = new SwingButton();
        this.facingButton = new SwingButton();
        this.previousSearch = new SwingButton();
        this.nextSearch = new SwingButton();
        this.pageCounter2.setEditable(true);
        this.pageCounter2.setToolTipText(Messages.getMessage("PdfViewerTooltip.goto"));
        this.pageCounter2.setBorder(BorderFactory.createLineBorder(Color.black));
        this.pageCounter2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = SwingGUI.this.pageCounter2.getText().trim();
                ((Commands)object).gotoPage(string);
            }
        });
        this.pageCounter3 = new JLabel(Messages.getMessage("PdfViewerOfLabel.text") + ' ');
        this.pageCounter3.setOpaque(false);
        object4 = new JPanel();
        ((Container)object4).setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)object4, "North");
        this.navToolBar.setLayout(new BoxLayout(this.navToolBar, 2));
        this.navToolBar.setFloatable(false);
        this.pagesToolBar.setFloatable(false);
        this.comboBar.setBorder(BorderFactory.createEmptyBorder());
        this.comboBar.setLayout(new BorderLayout());
        this.comboBar.setFloatable(false);
        this.comboBar.setPreferredSize(new Dimension(5, 24));
        this.frame.getContentPane().add((Component)this.comboBar, "South");
        ((Container)object4).add((Component)this.currentMenu, "North");
        this.topButtons.setBorder(BorderFactory.createEmptyBorder());
        this.topButtons.setLayout(new FlowLayout(3));
        this.topButtons.setFloatable(false);
        this.topButtons.setFont(new Font("SansSerif", 0, 8));
        ((Container)object4).add((Component)this.topButtons, "Center");
        ((Container)object4).add((Component)this.row2NavButtons, "South");
        this.createNavbar();
        if (this.commonValues.getModeOfOperation() != 1) {
            object3 = Toolkit.getDefaultToolkit().getScreenSize();
            int n = ((Dimension)object3).width / 2;
            int n2 = ((Dimension)object3).height / 2;
            if (n < 700) {
                n = 700;
            }
            this.frame.setSize(n, n2);
            this.frame.setLocationRelativeTo(null);
            this.frame.setDefaultCloseOperation(0);
            this.frame.addWindowListener(new FrameCloser((Commands)object, this, this.decode_pdf, (Printer)object2, this.thumbnails, this.commonValues, this.properties));
            this.frame.setVisible(true);
        }
        this.frame.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                if (SwingGUI.this.decode_pdf.getParent() != null && SwingGUI.this.getSelectedComboIndex(252) < 3) {
                    SwingGUI.this.zoom(false);
                }
            }

            public void componentShown(ComponentEvent componentEvent) {
            }
        });
    }

    private void handleTabbedPanes() {
        if (this.tabsNotInitialised) {
            return;
        }
        int n = this.displayPane.getDividerLocation();
        int n2 = this.navOptionsPanel.getSelectedIndex();
        if (n2 == -1) {
            return;
        }
        if (n == 30) {
            String string = "";
            string = PdfDecoder.isRunningOnMac ? this.navOptionsPanel.getTitleAt(n2) : this.navOptionsPanel.getIconAt(n2).toString();
            this.setupThumbnailPanel();
            this.setBookmarks(true);
            this.displayPane.setDividerLocation(190);
        } else if (n2 == this.lastTabSelected) {
            this.displayPane.setDividerLocation(30);
        }
        this.lastTabSelected = n2;
    }

    public void addCursor() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setBorder(BorderFactory.createEmptyBorder());
        jToolBar.setLayout(new FlowLayout(3));
        jToolBar.setFloatable(false);
        jToolBar.setFont(new Font("SansSerif", 2, 10));
        jToolBar.add(new JLabel(Messages.getMessage("PdfViewerToolbarCursorLoc.text")));
        jToolBar.add(this.initCoordBox());
        jToolBar.setPreferredSize(new Dimension(200, 32));
        this.topButtons.add(jToolBar);
    }

    private void setKeyAccelerators(int n, JMenuItem jMenuItem) {
        switch (n) {
            case 12: {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
                break;
            }
            case 5: {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
                break;
            }
            case 6: {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
                break;
            }
            case 7: {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
                break;
            }
            case 9: {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
                break;
            }
            case 10: {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
                break;
            }
            case 14: {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(85, 2));
                break;
            }
            case 16: {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(37, 9));
                break;
            }
            case 17: {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(39, 9));
                break;
            }
            case 50: {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(36, 2));
                break;
            }
            case 52: {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(37, 2));
                break;
            }
            case 53: {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(39, 2));
                break;
            }
            case 55: {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(35, 2));
                break;
            }
            case 56: {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 3));
                break;
            }
            case 2: {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, 8));
            }
        }
    }

    public void addButton(int n, String string, String string2, int n2) {
        GUIButton gUIButton = new SwingButton();
        switch (n2) {
            case 50: {
                gUIButton = this.first;
                break;
            }
            case 51: {
                gUIButton = this.fback;
                break;
            }
            case 52: {
                gUIButton = this.back;
                break;
            }
            case 53: {
                gUIButton = this.forward;
                break;
            }
            case 54: {
                gUIButton = this.fforward;
                break;
            }
            case 55: {
                gUIButton = this.end;
                break;
            }
            case 13: {
                gUIButton = this.snapshotButton;
                break;
            }
            case 57: {
                gUIButton = this.singleButton;
                break;
            }
            case 58: {
                gUIButton = this.continuousButton;
                break;
            }
            case 59: {
                gUIButton = this.continuousFacingButton;
                break;
            }
            case 60: {
                gUIButton = this.facingButton;
                break;
            }
            case 18: {
                gUIButton = this.previousSearch;
                break;
            }
            case 19: {
                gUIButton = this.nextSearch;
            }
        }
        if (n2 == 10) {
            gUIButton.setName("open");
        }
        if (n2 == 12) {
            gUIButton.setName("search");
        }
        if (n2 == 6) {
            gUIButton.setName("print");
        }
        gUIButton.init(string2, n2, string);
        ((AbstractButton)((Object)gUIButton)).addActionListener(this.currentCommandListener);
        if (n == 0) {
            this.topButtons.add((AbstractButton)((Object)gUIButton));
            this.topButtons.add(Box.createHorizontalGlue());
        } else if (n == 1) {
            this.navToolBar.add((AbstractButton)((Object)gUIButton));
        } else if (n == 2) {
            this.pagesToolBar.add((Component)((AbstractButton)((Object)gUIButton)), "Center");
        }
    }

    public void addMenuItem(JMenu jMenu, String string, String string2, int n) {
        SwingMenuItem swingMenuItem = new SwingMenuItem(string);
        if (string2.length() > 0) {
            swingMenuItem.setToolTipText(string2);
        }
        swingMenuItem.setID(n);
        this.setKeyAccelerators(n, swingMenuItem);
        swingMenuItem.addActionListener(this.currentCommandListener);
        jMenu.add(swingMenuItem);
    }

    public void addCombo(String string, String string2, int n) {
        GUICombo gUICombo = null;
        switch (n) {
            case 250: {
                gUICombo = this.qualityBox;
                break;
            }
            case 252: {
                gUICombo = this.scalingBox;
                break;
            }
            case 251: {
                gUICombo = this.rotationBox;
            }
        }
        gUICombo.setID(n);
        this.optimizationLabel = new JLabel(string);
        if (string2.length() > 0) {
            gUICombo.setToolTipText(string2);
        }
        this.row2NavButtons.add(this.optimizationLabel);
        this.row2NavButtons.add((SwingCombo)gUICombo);
        ((SwingCombo)gUICombo).addActionListener(this.currentCommandListener);
    }

    public void setViewerTitle(String string) {
        if (string != null) {
            this.frame.setTitle(string);
        } else {
            String string2 = "";
            string2 = this.titleMessage == null ? Messages.getMessage("PdfViewer.titlebar") + "3.51b12" + ' ' + this.commonValues.getSelectedFile() : this.titleMessage + this.commonValues.getSelectedFile();
            if (this.commonValues.isFormsChanged()) {
                string2 = "* " + string2;
            }
            this.frame.setTitle(string2);
        }
    }

    public void resetComboBoxes(boolean bl) {
        this.qualityBox.setEnabled(bl);
        this.scalingBox.setEnabled(bl);
        this.rotationBox.setEnabled(bl);
    }

    public final JScrollPane createPane(JTextPane jTextPane, String string, boolean bl) throws BadLocationException {
        Object object;
        jTextPane.setEditable(true);
        jTextPane.setFont(new Font("Lucida", 0, 14));
        jTextPane.setToolTipText(Messages.getMessage("PdfViewerTooltip.text"));
        Document document = jTextPane.getDocument();
        jTextPane.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(), Messages.getMessage("PdfViewerTitle.text")));
        jTextPane.setForeground(Color.black);
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        SimpleAttributeSet simpleAttributeSet2 = new SimpleAttributeSet();
        SimpleAttributeSet simpleAttributeSet3 = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.blue);
        StyleConstants.setForeground(simpleAttributeSet2, Color.black);
        StyleConstants.setForeground(simpleAttributeSet3, Color.black);
        int n = 0;
        if (bl && string != null) {
            object = new StringTokenizer(string, "<>", true);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object).nextToken();
                if (string2.equals("<") && ((StringTokenizer)object).hasMoreTokens()) {
                    String string3 = string2 + ((StringTokenizer)object).nextToken() + ((StringTokenizer)object).nextToken();
                    document.insertString(n, string3, simpleAttributeSet);
                    n += string3.length();
                    continue;
                }
                document.insertString(n, string2, simpleAttributeSet2);
                n += string2.length();
            }
        } else {
            document.insertString(n, string, simpleAttributeSet3);
        }
        object = new JScrollPane();
        ((JScrollPane)object).getViewport().add(jTextPane);
        ((JScrollPane)object).setHorizontalScrollBarPolicy(31);
        ((JScrollPane)object).setVerticalScrollBarPolicy(20);
        return object;
    }

    public int getSelectedComboIndex(int n) {
        switch (n) {
            case 250: {
                return this.qualityBox.getSelectedIndex();
            }
            case 252: {
                return this.scalingBox.getSelectedIndex();
            }
            case 251: {
                return this.rotationBox.getSelectedIndex();
            }
        }
        return -1;
    }

    public void setSelectedComboIndex(int n, int n2) {
        switch (n) {
            case 250: {
                this.qualityBox.setSelectedIndex(n2);
                break;
            }
            case 252: {
                this.scalingBox.setSelectedIndex(n2);
                break;
            }
            case 251: {
                this.rotationBox.setSelectedIndex(n2);
            }
        }
    }

    public void setSelectedComboItem(int n, String string) {
        switch (n) {
            case 250: {
                this.qualityBox.setSelectedItem(string);
                break;
            }
            case 252: {
                this.scalingBox.setSelectedItem(string);
                break;
            }
            case 251: {
                this.rotationBox.setSelectedItem(string);
            }
        }
    }

    public Object getSelectedComboItem(int n) {
        switch (n) {
            case 250: {
                return this.qualityBox.getSelectedItem();
            }
            case 252: {
                return this.scalingBox.getSelectedItem();
            }
            case 251: {
                return this.rotationBox.getSelectedItem();
            }
        }
        return null;
    }

    public void zoom(boolean bl) {
        float f;
        float f2;
        if (this.isSingle()) {
            f2 = this.scrollPane.getViewport().getWidth() - 25 - 25;
            f = this.scrollPane.getViewport().getHeight() - 25 - 25;
        } else {
            f2 = this.desktopPane.getWidth();
            f = this.desktopPane.getHeight();
        }
        if (this.decode_pdf != null) {
            int n;
            Object object;
            int n2 = this.getSelectedComboIndex(252);
            if (n2 == -1) {
                object = (String)this.getSelectedComboItem(252);
                float f3 = -1.0f;
                if (object != null && ((String)object).length() > 0) {
                    block25: {
                        try {
                            f3 = Float.parseFloat((String)object);
                        }
                        catch (Exception exception) {
                            char c;
                            int n3;
                            f3 = -1.0f;
                            n = ((String)object).length();
                            for (n3 = 0; n3 < n && ((c = ((String)object).charAt(n3)) >= '0' && c <= '9') | c == '.'; ++n3) {
                            }
                            if (n3 > 0) {
                                object = ((String)object).substring(0, n3);
                            }
                            if (f3 != -1.0f) break block25;
                            try {
                                f3 = Float.parseFloat((String)object);
                            }
                            catch (Exception exception2) {
                                f3 = -1.0f;
                            }
                        }
                    }
                    if (f3 > 1000.0f) {
                        f3 = 1000.0f;
                    }
                }
                if (f3 == -1.0f) {
                    n2 = 0;
                    this.setSelectedComboIndex(252, n2);
                } else {
                    this.scaling = this.convertToCorrectedScaling(f3 / 100.0f);
                    this.setSelectedComboItem(252, String.valueOf(f3));
                }
            }
            if (n2 != -1) {
                if (n2 < 3) {
                    int n4;
                    int n5;
                    object = this.decode_pdf.getPdfPageData();
                    n = ((PdfPageData)object).getRotation(this.commonValues.getCurrentPage());
                    if (this.rotation == 90 || this.rotation == 270) {
                        n5 = ((PdfPageData)object).getCropBoxHeight(this.commonValues.getCurrentPage());
                        n4 = ((PdfPageData)object).getCropBoxWidth(this.commonValues.getCurrentPage());
                    } else {
                        n5 = ((PdfPageData)object).getCropBoxWidth(this.commonValues.getCurrentPage());
                        n4 = ((PdfPageData)object).getCropBoxHeight(this.commonValues.getCurrentPage());
                    }
                    if (this.isSingle() && this.displayPane != null) {
                        f2 -= (float)this.displayPane.getDividerSize();
                    }
                    float f4 = 0.0f;
                    float f5 = 0.0f;
                    f4 = f2 / (float)n5;
                    f5 = f / (float)n4;
                    if (n2 == 0) {
                        this.scaling = f4 < f5 ? f4 : f5;
                    } else if (n2 == 1) {
                        this.scaling = f5;
                    } else if (n2 == 2) {
                        this.scaling = f4;
                    }
                } else {
                    this.scaling = this.convertToCorrectedScaling(this.scalingFloatValues[n2]);
                }
            }
            this.decode_pdf.setPageParameters(this.scaling, this.commonValues.getCurrentPage(), this.rotation);
            object = new Runnable(){

                public void run() {
                    SwingGUI.this.decode_pdf.invalidate();
                    SwingGUI.this.decode_pdf.updateUI();
                    SwingGUI.this.decode_pdf.validate();
                    SwingGUI.this.scrollPane.invalidate();
                    SwingGUI.this.scrollPane.updateUI();
                    SwingGUI.this.scrollPane.validate();
                    if (SwingGUI.this.commonValues.isPDF()) {
                        SwingGUI.this.scrollToPage(SwingGUI.this.commonValues.getCurrentPage());
                    }
                }
            };
            SwingUtilities.invokeLater((Runnable)object);
        }
    }

    private float convertToCorrectedScaling2(float f) {
        if (PdfDecoder.isRunningOnWindows) {
            return f * 1.533f;
        }
        return f;
    }

    public void rotate() {
        this.rotation = Integer.parseInt((String)this.getSelectedComboItem(251));
        this.zoom(true);
        this.decode_pdf.updateUI();
    }

    public void scrollToPage(int n) {
        this.commonValues.setCurrentPage(n);
        if (this.commonValues.getCurrentPage() > 0) {
            int n2 = 0;
            int n3 = 0;
            if (this.decode_pdf.getDisplayView() != 1) {
                n2 = this.decode_pdf.getYCordForPage(this.commonValues.getCurrentPage(), this.scaling);
                n3 = this.decode_pdf.getXDisplacement();
            }
            PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
            int n4 = (int)((float)pdfPageData.getCropBoxHeight(this.commonValues.getCurrentPage()) * this.scaling);
            int n5 = (int)((float)pdfPageData.getCropBoxWidth(this.commonValues.getCurrentPage()) * this.scaling);
            int n6 = n3 + (n5 - this.scrollPane.getHorizontalScrollBar().getVisibleAmount()) / 2;
            int n7 = n2 + (n4 - this.scrollPane.getVerticalScrollBar().getVisibleAmount()) / 2;
            this.scrollPane.getHorizontalScrollBar().setValue(n6);
            this.scrollPane.getVerticalScrollBar().setValue(n7);
        }
        if (this.decode_pdf.getPageCount() > 1 && !this.commonValues.isContentExtractor()) {
            this.setPageLayoutButtonsEnabled(true);
        }
    }

    public void decodePage(boolean bl) {
        if (this.decode_pdf.getHighlightImage() != null) {
            this.commonValues.toggleExtractImageOnSelection();
            this.toggleSnapshotButton();
        }
        this.decode_pdf.setHighlightedImage(null);
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.terminateDrawing();
        }
        if (this.thumbnails.isShownOnscreen()) {
            this.setupThumbnailPanel();
        }
        if (this.decode_pdf.getDisplayView() == 1) {
            this.pageCounter2.setForeground(Color.black);
            this.pageCounter2.setText(" " + this.commonValues.getCurrentPage());
            this.pageCounter3.setText(Messages.getMessage("PdfViewerOfLabel.text") + ' ' + this.commonValues.getPageCount());
        }
        this.tabsNotInitialised = false;
        boolean bl2 = this.commonValues.isContentExtractor();
        this.decode_pdf.unsetScaling();
        if (bl2) {
            this.decode_pdf.setExtractionMode(1);
        } else {
            this.decode_pdf.setExtractionMode(65);
        }
        this.decode_pdf.setFoundTextArea(null);
        this.decode_pdf.setFoundTextAreas(null);
        this.setRectangle(null);
        if (this.decode_pdf.getDisplayView() == 3) {
            this.zoom(false);
            this.scrollToPage(this.commonValues.getCurrentPage());
            this.decode_pdf.decodeOtherPages(this.commonValues.getPageCount());
            return;
        }
        if (this.decode_pdf.getDisplayView() == 2 || this.decode_pdf.getDisplayView() == 4) {
            this.zoom(false);
            this.scrollToPage(this.commonValues.getCurrentPage());
            return;
        }
        this.resetComboBoxes(false);
        if (!this.commonValues.isContentExtractor()) {
            this.setPageLayoutButtonsEnabled(false);
        }
        if (!this.commonValues.isContentExtractor()) {
            this.commonValues.setProcessing(true);
        }
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                try {
                    Object object;
                    SwingGUI.this.statusBar.updateStatus("Decoding Page", 0);
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    try {
                        SwingGUI.this.decode_pdf.decodePage(SwingGUI.this.commonValues.getCurrentPage());
                        if (!SwingGUI.this.decode_pdf.getPageDecodeStatus(2)) {
                            object = Messages.getMessage("PdfViewer.ImageDisplayError") + Messages.getMessage("PdfViewer.ImageDisplayError1") + Messages.getMessage("PdfViewer.ImageDisplayError2") + Messages.getMessage("PdfViewer.ImageDisplayError3") + Messages.getMessage("PdfViewer.ImageDisplayError4") + Messages.getMessage("PdfViewer.ImageDisplayError5") + Messages.getMessage("PdfViewer.ImageDisplayError6") + Messages.getMessage("PdfViewer.ImageDisplayError7");
                            SwingGUI.this.showMessageDialog(object);
                        }
                        if (SwingGUI.this.decode_pdf.getPageDecodeStatus(4)) {
                            object = "This page contains non-embedded CID fonts \n" + SwingGUI.this.decode_pdf.getPageDecodeStatusReport(4) + "\nwhich may need mapping to display correctly.\n" + "See http://idrsolutions.fogbugzhosting.com/default.asp?W45";
                            SwingGUI.this.showMessageDialog(object);
                        }
                        object = SwingGUI.this.decode_pdf.getPdfPageData();
                        SwingGUI.this.mediaW = ((PdfPageData)object).getMediaBoxWidth(SwingGUI.this.commonValues.getCurrentPage());
                        SwingGUI.this.mediaH = ((PdfPageData)object).getMediaBoxHeight(SwingGUI.this.commonValues.getCurrentPage());
                        SwingGUI.this.mediaX = ((PdfPageData)object).getMediaBoxX(SwingGUI.this.commonValues.getCurrentPage());
                        SwingGUI.this.mediaY = ((PdfPageData)object).getMediaBoxY(SwingGUI.this.commonValues.getCurrentPage());
                        SwingGUI.this.cropX = ((PdfPageData)object).getCropBoxX(SwingGUI.this.commonValues.getCurrentPage());
                        SwingGUI.this.cropY = ((PdfPageData)object).getCropBoxY(SwingGUI.this.commonValues.getCurrentPage());
                        SwingGUI.this.cropW = ((PdfPageData)object).getCropBoxWidth(SwingGUI.this.commonValues.getCurrentPage());
                        SwingGUI.this.cropH = ((PdfPageData)object).getCropBoxHeight(SwingGUI.this.commonValues.getCurrentPage());
                        SwingGUI.this.resetRotationBox();
                        SwingGUI.this.commonValues.setPageAnnotations(SwingGUI.this.decode_pdf.getPdfAnnotsData(null));
                        if (!SwingGUI.this.decode_pdf.showAnnotations) {
                            SwingGUI.this.createUniqueAnnotationIcons();
                        }
                        SwingGUI.this.statusBar.updateStatus("Displaying Page", 0);
                    }
                    catch (Exception exception) {
                        System.err.println(Messages.getMessage("PdfViewerError.Exception") + ' ' + exception + ' ' + Messages.getMessage("PdfViewerError.DecodePage"));
                        exception.printStackTrace();
                        SwingGUI.this.commonValues.setProcessing(false);
                    }
                    object = SwingGUI.this.decode_pdf.getPageDecodeReport();
                    if (((String)object).indexOf("java.lang.OutOfMemoryError") != -1 && PdfDecoder.showErrorMessages) {
                        object = Messages.getMessage("PdfViewer.OutOfMemoryDisplayError") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError1") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError2") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError3") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError4") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError5");
                        SwingGUI.this.showMessageDialog(object);
                    }
                    if (SwingGUI.this.thumbnails != null && SwingGUI.this.decode_pdf.getDisplayView() == 1) {
                        SwingGUI.this.thumbnails.addDisplayedPageAsThumbnail(SwingGUI.this.commonValues.getCurrentPage(), null);
                    }
                    SwingGUI.this.commonValues.setProcessing(false);
                    SwingGUI.this.setViewerTitle(null);
                    SwingGUI.this.currentCommands.setPageProperties(SwingGUI.this.getSelectedComboItem(251), SwingGUI.this.getSelectedComboItem(252));
                    if (SwingGUI.this.thumbnails.isShownOnscreen() && SwingGUI.this.decode_pdf.getDisplayView() == 1) {
                        SwingGUI.this.thumbnails.generateOtherVisibleThumbnails(SwingGUI.this.commonValues.getCurrentPage());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    SwingGUI.this.setViewerTitle(null);
                }
                SwingGUI.this.selectBookmark();
                SwingGUI.this.statusBar.setProgress(100);
                SwingGUI.this.resetComboBoxes(true);
                if (SwingGUI.this.decode_pdf.getPageCount() > 1 && !SwingGUI.this.commonValues.isContentExtractor()) {
                    SwingGUI.this.setPageLayoutButtonsEnabled(true);
                }
                SwingGUI.this.addFormsListeners();
                SwingGUI.this.decode_pdf.setPDFBorder(BorderFactory.createLineBorder(Color.black, 1));
                SwingGUI.this.decode_pdf.disableBorderForPrinting();
                SwingGUI.this.zoom(false);
                if (SwingGUI.this.displayPane != null) {
                    SwingGUI.this.reinitialiseTabs(SwingGUI.this.displayPane.getDividerLocation() > 30);
                }
                SwingGUI.this.finishedDecoding = true;
                SwingGUI.this.zoom(false);
                return null;
            }
        };
        swingWorker.start();
    }

    public void addFormsListeners() {
        Serializable serializable;
        Object object;
        Object object2;
        AcroRenderer acroRenderer;
        this.commonValues.setFormsChanged(false);
        boolean bl = false;
        String string = System.getProperty("org.jpedal.listenforms");
        if (string != null) {
            bl = true;
        }
        if ((acroRenderer = this.decode_pdf.getFormRenderer()) == null) {
            return;
        }
        List list = null;
        try {
            list = acroRenderer.getComponentNameList(this.commonValues.getCurrentPage());
        }
        catch (PdfException pdfException) {
            LogWriter.writeLog("Exception " + pdfException + " reading component list");
        }
        if (list == null) {
            if (bl) {
                this.showMessageDialog(Messages.getMessage("PdfViewer.NoFields"));
            }
            return;
        }
        int n = list.size();
        JPanel jPanel = new JPanel();
        if (bl) {
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            JLabel jLabel = new JLabel("This page contains " + n + " form objects");
            jLabel.setFont(this.headFont);
            jPanel.add(jLabel);
            jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
            object2 = new JTextPane();
            ((JComponent)object2).setPreferredSize(new Dimension(450, 180));
            ((JTextComponent)object2).setEditable(false);
            ((JEditorPane)object2).setText("This provides a simple example of Forms handling. We have added a listener to each form so clicking on it shows the form name.\n\nCode is in addExampleListeners() in org.examples.simpleviewer.SimpleViewer\n\nThis could be easily be extended to interface with a database directly or collect results on an action and write back using itext.\n\nForms have been converted into Swing components and are directly accessible (as is the original data).\n\nIf you don't like the standard SwingSet you can replace with your own set.");
            ((JComponent)object2).setFont(this.textFont);
            jPanel.add((Component)object2);
            jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        }
        for (int i = 0; i < n; ++i) {
            object2 = (String)list.get(i);
            object = (Component[])acroRenderer.getComponentsByName((String)object2);
            serializable = new Integer(i);
            if (object == null || this.pagesDecoded.get(serializable) != null) continue;
            this.pagesDecoded.put(serializable, "x");
            int n2 = ((Component[])object).length;
            for (int j = 0; j < n2; ++j) {
                Object object3;
                if (bl && j == 0) {
                    object3 = new JLabel();
                    JLabel jLabel = new JLabel("Form name=" + (String)object2);
                    String string2 = "type=" + object[j].getClass();
                    if (n2 > 1) {
                        string2 = "Group of " + n2 + " Objects, type=" + object[j].getClass();
                        ((JComponent)object3).setForeground(Color.red);
                    }
                    ((JLabel)object3).setText(string2);
                    jLabel.setFont(this.headFont);
                    ((JComponent)object3).setFont(this.textFont);
                    jPanel.add(jLabel);
                    jPanel.add((Component)object3);
                    jPanel.add(new JLabel(" "));
                }
                object3 = new FormActionListener((String)object2 + j, this.frame, bl);
                if (object[j] instanceof JComboBox) {
                    ((JComboBox)object[j]).addActionListener((ActionListener)object3);
                    continue;
                }
                if (object[j] instanceof JCheckBox) {
                    ((JCheckBox)object[j]).addActionListener((ActionListener)object3);
                    continue;
                }
                if (object[j] instanceof JRadioButton) {
                    ((JRadioButton)object[j]).addActionListener((ActionListener)object3);
                    continue;
                }
                if (!(object[j] instanceof JTextField)) continue;
                ((JTextField)object[j]).addActionListener((ActionListener)object3);
            }
        }
        if (bl) {
            final JDialog jDialog = new JDialog((Frame)this.frame, true);
            if (this.commonValues.getModeOfOperation() != 1) {
                jDialog.setLocationRelativeTo(null);
                jDialog.setLocation(this.frame.getLocationOnScreen().x + 10, this.frame.getLocationOnScreen().y + 10);
            }
            object2 = new JScrollPane();
            ((JScrollPane)object2).getViewport().add(jPanel);
            ((JScrollPane)object2).setHorizontalScrollBarPolicy(30);
            ((JScrollPane)object2).setVerticalScrollBarPolicy(20);
            jDialog.setSize(500, 500);
            jDialog.setTitle("List of forms on this page");
            jDialog.getContentPane().setLayout(new BorderLayout());
            jDialog.getContentPane().add((Component)object2, "Center");
            object = new JPanel();
            ((Container)object).setLayout(new BorderLayout());
            jDialog.getContentPane().add((Component)object, "South");
            serializable = new JButton(Messages.getMessage("PdfViewerButton.Close"));
            ((JComponent)serializable).setFont(new Font("SansSerif", 0, 12));
            ((Container)object).add((Component)serializable, "East");
            ((AbstractButton)serializable).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jDialog.dispose();
                }
            });
            jDialog.setVisible(true);
        }
    }

    private void createOutlinePanels() {
        this.setupThumbnailPanel();
        this.setBookmarks(false);
    }

    private void setupThumbnailPanel() {
        this.decode_pdf.addExternalHandler(this.thumbnails, 8);
        if (this.isSetup) {
            return;
        }
        this.isSetup = true;
        if (!this.commonValues.isContentExtractor() && this.thumbnails.isShownOnscreen()) {
            int n = this.decode_pdf.getPageCount();
            this.thumbnails.setupThumbnails(n, this.textFont, Messages.getMessage("PdfViewerPageLabel.text"), this.decode_pdf.getPdfPageData());
            Object[] objectArray = this.thumbnails.getButtons();
            for (int i = 0; i < n; ++i) {
                ((JButton)objectArray[i]).addActionListener(new PageChanger(i));
            }
            this.thumbnails.addComponentListener();
        }
    }

    public void setBookmarks(boolean bl) {
        int n = this.displayPane.getDividerLocation();
        if (n == 30 && !bl) {
            return;
        }
        org.w3c.dom.Document document = this.decode_pdf.getOutlineAsXML();
        Node node = null;
        if (document != null) {
            node = document.getFirstChild();
        }
        if (node != null) {
            this.tree.reset(node);
            ((JTree)this.tree.getTree()).addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    if (SwingGUI.this.tree.isIgnoreAlteredBookmark()) {
                        return;
                    }
                    DefaultMutableTreeNode defaultMutableTreeNode = SwingGUI.this.tree.getLastSelectedPathComponent();
                    if (defaultMutableTreeNode == null) {
                        return;
                    }
                    String string = (String)defaultMutableTreeNode.getUserObject();
                    JTree jTree = (JTree)SwingGUI.this.tree.getTree();
                    DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
                    ArrayList arrayList = new ArrayList();
                    SwingGUI.this.getFlattenedTreeNodes((TreeNode)defaultTreeModel.getRoot(), arrayList);
                    arrayList.remove(0);
                    int n = arrayList.indexOf(defaultMutableTreeNode);
                    String string2 = SwingGUI.this.tree.getPageViaNodeNumber(n);
                    if (string2 != null && string2.length() > 0) {
                        Point point;
                        int n2 = Integer.parseInt(string2);
                        if (!SwingGUI.this.commonValues.isProcessing() && SwingGUI.this.commonValues.getCurrentPage() != n2) {
                            SwingGUI.this.commonValues.setCurrentPage(n2);
                            SwingGUI.this.setScalingToDefault();
                            SwingGUI.this.decode_pdf.setPageParameters(SwingGUI.this.getScaling(), SwingGUI.this.commonValues.getCurrentPage());
                            SwingGUI.this.decodePage(false);
                        }
                        if ((point = SwingGUI.this.tree.getPoint(string)) != null) {
                            SwingGUI.this.decode_pdf.ensurePointIsVisible(point);
                        }
                    } else {
                        SwingGUI.this.showMessageDialog(Messages.getMessage("PdfViewerError.NoBookmarkLink") + string);
                        System.out.println("No dest page set for " + string);
                    }
                }
            });
        } else {
            this.tree.reset(null);
        }
    }

    private void getFlattenedTreeNodes(TreeNode treeNode, List list) {
        list.add(treeNode);
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        while (enumeration.hasMoreElements()) {
            this.getFlattenedTreeNodes(enumeration.nextElement(), list);
        }
    }

    private void selectBookmark() {
        if (this.decode_pdf.hasOutline() && this.tree != null) {
            this.tree.selectBookmark();
        }
    }

    public void initStatus() {
        this.decode_pdf.setStatusBarObject(this.statusBar);
        this.resetStatus();
    }

    public void resetStatus() {
        this.statusBar.setColorForSubroutines(Color.blue);
        this.row2NavButtons.add(this.statusBar.getStatusObject());
    }

    public void initThumbnails(int n, Vector_Int vector_Int) {
        this.navOptionsPanel.removeAll();
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.setupThumbnails(n - 1, vector_Int.get(), this.commonValues.getPageCount());
        }
        if (PdfDecoder.isRunningOnMac) {
            this.navOptionsPanel.add((Component)((Object)this.thumbnails), "Extracted items");
        } else {
            VTextIcon vTextIcon = new VTextIcon(this.navOptionsPanel, "Extracted items", 2);
            this.navOptionsPanel.addTab(null, vTextIcon, (Component)((Object)this.thumbnails));
        }
        this.displayPane.setDividerLocation(150);
    }

    public void setCoordText(String string) {
        this.coords.setText(string);
    }

    private JLabel initCoordBox() {
        this.coords.setBackground(Color.white);
        this.coords.setOpaque(true);
        this.coords.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.coords.setText("  X:  Y:   ");
        this.coords.setPreferredSize(new Dimension(120, 20));
        return this.coords;
    }

    public void toggleSnapshotButton() {
        if (!this.commonValues.isExtractImageOnSelection()) {
            this.snapshotButton.setIcon(new ImageIcon(this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/snapshotX.gif")));
        } else {
            this.snapshotButton.setIcon(new ImageIcon(this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/snapshot.gif")));
        }
    }

    public void setPageNumber() {
        this.pageCounter2.setForeground(Color.black);
        this.pageCounter2.setText(" " + this.commonValues.getCurrentPage());
        this.pageCounter3.setText(Messages.getMessage("PdfViewerOfLabel.text") + ' ' + this.commonValues.getPageCount());
    }

    private void createNavbar() {
        JComponent jComponent;
        Dimension dimension;
        this.comboBar.add(Box.createHorizontalGlue());
        JLabel jLabel = new JLabel(Messages.getMessage("PdfViewerPageLabel.text"));
        jLabel.setOpaque(false);
        this.navToolBar.add(Box.createHorizontalGlue());
        this.addButton(1, Messages.getMessage("PdfViewerNavBar.RewindToStart"), "/org/jpedal/examples/simpleviewer/res/start.gif", 50);
        this.addButton(1, Messages.getMessage("PdfViewerNavBar.Rewind10"), "/org/jpedal/examples/simpleviewer/res/fback.gif", 51);
        this.addButton(1, Messages.getMessage("PdfViewerNavBar.Rewind1"), "/org/jpedal/examples/simpleviewer/res/back.gif", 52);
        this.navToolBar.add(jLabel);
        this.pageCounter2.setMaximumSize(new Dimension(5, 50));
        this.navToolBar.add(this.pageCounter2);
        this.navToolBar.add(this.pageCounter3);
        this.addButton(1, Messages.getMessage("PdfViewerNavBar.Forward1"), "/org/jpedal/examples/simpleviewer/res/forward.gif", 53);
        this.addButton(1, Messages.getMessage("PdfViewerNavBar.Forward10"), "/org/jpedal/examples/simpleviewer/res/fforward.gif", 54);
        this.addButton(1, Messages.getMessage("PdfViewerNavBar.ForwardLast"), "/org/jpedal/examples/simpleviewer/res/end.gif", 55);
        this.navToolBar.add(Box.createHorizontalGlue());
        if (!this.commonValues.isContentExtractor() && this.isSingle()) {
            this.addButton(2, Messages.getMessage("PageLayoutButton.SinglePage"), "/org/jpedal/examples/simpleviewer/res/single.gif", 57);
            this.addButton(2, Messages.getMessage("PageLayoutButton.Continuous"), "/org/jpedal/examples/simpleviewer/res/continuous.gif", 58);
            this.addButton(2, Messages.getMessage("PageLayoutButton.ContinousFacing"), "/org/jpedal/examples/simpleviewer/res/continuous_facing.gif", 59);
            this.addButton(2, Messages.getMessage("PageLayoutButton.Facing"), "/org/jpedal/examples/simpleviewer/res/facing.gif", 60);
        }
        boolean bl = true;
        bl = false;
        if (bl) {
            dimension = new Dimension(110, 0);
            jComponent = new Box.Filler(dimension, dimension, dimension);
            this.comboBar.add((Component)jComponent, "East");
        } else {
            this.comboBar.add((Component)this.pagesToolBar, "East");
            dimension = this.pagesToolBar.getPreferredSize();
        }
        this.comboBar.add((Component)this.navToolBar, "Center");
        jComponent = new JProgressBar();
        jComponent.setPreferredSize(dimension);
        Timer timer = new Timer(500, new ActionListener((JProgressBar)jComponent){
            private final /* synthetic */ JProgressBar val$pb;
            {
                this.val$pb = jProgressBar;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                int n = (int)(Runtime.getRuntime().freeMemory() / 0x100000L);
                int n2 = (int)(Runtime.getRuntime().totalMemory() / 0x100000L);
                if (SwingGUI.this.finishedDecoding) {
                    SwingGUI.this.finishedDecoding = false;
                }
                this.val$pb.setMaximum(n2);
                this.val$pb.setValue(n2 - n);
                this.val$pb.setStringPainted(true);
                this.val$pb.setString(n2 - n + "M of " + n2 + 'M');
            }
        });
        timer.start();
        this.comboBar.add((Component)jComponent, "West");
    }

    public void setPage(int n) {
        this.commonValues.setCurrentPage(n);
        this.pageCounter2.setText(String.valueOf(n));
        this.setThumbnails();
    }

    public void resetPageNav() {
        this.pageCounter2.setText("");
        this.pageCounter3.setText("");
    }

    public void setRotation() {
        PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
        this.rotation = pdfPageData.getRotation(this.commonValues.getCurrentPage());
        System.out.println("rotation ==" + this.rotation + '<');
        this.rotation += this.getSelectedComboIndex(251) * 90;
        System.out.println("rotation ==" + this.rotation + '<');
        if (this.rotation > 360) {
            this.rotation -= 360;
        }
        System.out.println("rotation ==" + this.rotation + '<');
        if (this.getSelectedComboIndex(251) != this.rotation / 90) {
            this.setSelectedComboIndex(251, this.rotation / 90);
        } else if (!this.commonValues.isProcessing()) {
            this.decode_pdf.repaint();
        }
    }

    public void addToMainMenu(JMenu jMenu) {
        this.currentMenu.add(jMenu);
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public JToolBar getTopButtonBar() {
        return this.topButtons;
    }

    public void showMessageDialog(Object object) {
        JOptionPane.showMessageDialog(this.frame, object);
    }

    public void showMessageDialog(Object object, String string, int n) {
        JOptionPane.showMessageDialog(this.frame, object, string, n);
    }

    public String showInputDialog(Object object, String string, int n) {
        return JOptionPane.showInputDialog(this.frame, object, string, n);
    }

    public String showInputDialog(String string) {
        return JOptionPane.showInputDialog(this.frame, (Object)string);
    }

    public int showOptionDialog(Object object, String string, int n, int n2, Object object2, Object[] objectArray, Object object3) {
        return JOptionPane.showOptionDialog(this.frame, object, string, n, n2, (Icon)object2, objectArray, object3);
    }

    public int showConfirmDialog(String string, String string2, int n) {
        return JOptionPane.showConfirmDialog(this.frame, string, string2, n);
    }

    public int showOverwriteDialog(String string, boolean bl) {
        int n = -1;
        if (bl) {
            Object[] objectArray = new Object[]{Messages.getMessage("PdfViewerConfirmButton.Yes"), Messages.getMessage("PdfViewerConfirmButton.YesToAll"), Messages.getMessage("PdfViewerConfirmButton.No"), Messages.getMessage("PdfViewerConfirmButton.Cancel")};
            n = JOptionPane.showOptionDialog(this.frame, string + '\n' + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + '\n' + Messages.getMessage("PdfViewerMessage.ConfirmResave"), Messages.getMessage("PdfViewerMessage.Overwrite"), -1, 3, null, objectArray, objectArray[0]);
        } else {
            n = JOptionPane.showOptionDialog(this.frame, string + '\n' + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + '\n' + Messages.getMessage("PdfViewerMessage.ConfirmResave"), Messages.getMessage("PdfViewerMessage.Overwrite"), 0, 3, null, null, null);
        }
        return n;
    }

    public void showMessageDialog(JTextArea jTextArea) {
        JOptionPane.showMessageDialog(this.frame, jTextArea);
    }

    public void showItextPopup() {
        JEditorPane jEditorPane = new JEditorPane("text/html", "Itext is not on the classpath.<BR>JPedal includes code to take advantage of itext and<BR>provide additional functionality with options<BR>to spilt pdf files, and resave forms data<BR>\nItext website - <a href=http://www.lowagie.com/iText/>http://www.lowagie.com/iText/</a>");
        jEditorPane.setEditable(false);
        jEditorPane.setOpaque(false);
        jEditorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    try {
                        BrowserLauncher.openURL("http://www.lowagie.com/iText/");
                    }
                    catch (IOException iOException) {
                        SwingGUI.this.showMessageDialog(Messages.getMessage("PdfViewer.ErrorWebsite"));
                    }
                }
            }
        });
        this.showMessageDialog(jEditorPane);
    }

    public void showFirstTimePopup() {
        try {
            final JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            JLabel jLabel = new JLabel(new ImageIcon(this.getClass().getResource("/org/jpedal/objects/acroforms/ceo.jpg")));
            jPanel.add((Component)jLabel, "North");
            final JLabel jLabel2 = new JLabel("<html><center>" + Messages.getMessage("PdfViewerJpedalLibrary.Text") + Messages.getMessage("PdfViewer.WebAddress"));
            jLabel2.setHorizontalAlignment(0);
            jLabel2.setForeground(Color.blue);
            jLabel2.setFont(new Font("Lucida", 0, 16));
            jLabel2.addMouseListener(new MouseListener(){

                public void mouseEntered(MouseEvent mouseEvent) {
                    jPanel.setCursor(new Cursor(12));
                    jLabel2.setText("<html><center>" + Messages.getMessage("PdfViewerJpedalLibrary.Link") + Messages.getMessage("PdfViewerJpedalLibrary.Text") + Messages.getMessage("PdfViewer.WebAddress") + "</a></center>");
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    jPanel.setCursor(new Cursor(0));
                    jLabel2.setText("<html><center>" + Messages.getMessage("PdfViewerJpedalLibrary.Text") + Messages.getMessage("PdfViewer.WebAddress"));
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    try {
                        BrowserLauncher.openURL(Messages.getMessage("PdfViewer.VisitWebsite"));
                    }
                    catch (IOException iOException) {
                        SwingGUI.this.showMessageDialog(Messages.getMessage("PdfViewer.ErrorWebsite"));
                    }
                }

                public void mousePressed(MouseEvent mouseEvent) {
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }
            });
            jPanel.add((Component)jLabel2, "Center");
            jPanel.setPreferredSize(new Dimension(300, 240));
            Object[] objectArray = new Object[]{Messages.getMessage("PdfViewerButton.RunSoftware")};
            int n = JOptionPane.showOptionDialog(this.frame, jPanel, Messages.getMessage("PdfViewerTitle.RunningFirstTime"), -1, -1, null, objectArray, objectArray[0]);
        }
        catch (Exception exception) {
            System.err.println(Messages.getMessage("PdfViewerFirstRunDialog.Error"));
        }
        catch (Error error) {
            System.err.println(Messages.getMessage("PdfViewerFirstRunDialog.Error"));
        }
    }

    public int showConfirmDialog(Object object, String string, int n, int n2) {
        return JOptionPane.showConfirmDialog(this.frame, object, string, n, n2);
    }

    public void updateStatusMessage(String string) {
        this.statusBar.updateStatus(string, 0);
    }

    public void resetStatusMessage(String string) {
        this.statusBar.resetStatus(string);
    }

    public void setStatusProgress(int n) {
        this.statusBar.setProgress(n);
    }

    public boolean isPDFOutlineVisible() {
        return this.navOptionsPanel.isVisible();
    }

    public void setPDFOutlineVisible(boolean bl) {
        this.navOptionsPanel.setVisible(bl);
    }

    public void setSplitDividerLocation(int n) {
        this.displayPane.setDividerLocation(n);
    }

    public Object printDialog(String[] stringArray, String string) {
        JDialog jDialog = new JDialog(this.frame, "Print", true);
        if (this.printPanel == null) {
            this.printPanel = new PrintPanel(stringArray, string, this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
        } else {
            this.printPanel.resetDefaults(stringArray, string, this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
        }
        jDialog.getContentPane().add(this.printPanel);
        jDialog.setSize(510, 500);
        jDialog.setLocationRelativeTo(this.frame);
        jDialog.setName("printDialog");
        jDialog.setVisible(true);
        jDialog.remove(this.printPanel);
        return this.printPanel;
    }

    public void setQualityBoxVisible(boolean bl) {
        this.qualityBox.setVisible(bl);
        this.optimizationLabel.setVisible(bl);
    }

    private void setThumbnails() {
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                if (SwingGUI.this.thumbnails.isShownOnscreen()) {
                    SwingGUI.this.setupThumbnailPanel();
                    if (SwingGUI.this.decode_pdf.getDisplayView() == 1) {
                        SwingGUI.this.thumbnails.generateOtherVisibleThumbnails(SwingGUI.this.commonValues.getCurrentPage());
                    }
                }
                return null;
            }
        };
        swingWorker.start();
    }

    public void setSearchText(JTextField jTextField) {
        this.searchText = jTextField;
    }

    public void setResults(SearchList searchList) {
        this.results = searchList;
    }

    public SearchList getResults() {
        return this.results;
    }

    public JToolBar getComboBar() {
        return this.comboBar;
    }

    public ButtonGroup getSearchLayoutGroup() {
        return this.searchLayoutGroup;
    }

    public void setSearchFrame(GUISearchWindow gUISearchWindow) {
        this.searchFrame = gUISearchWindow;
    }

    public void removeSearchWindow(boolean bl) {
        this.searchFrame.removeSearchWindow(bl);
    }

    public void showPreferencesDialog() {
        this.p.showPreferenceWindow(this);
    }

    private class ExampleCustomDrawObject
    implements JPedalCustomDrawObject {
        private boolean isVisible = true;
        private int page = 0;
        public int medX = 0;
        public int medY = 0;

        public ExampleCustomDrawObject() {
        }

        public ExampleCustomDrawObject(Integer n) {
            if (!n.equals(JPedalCustomDrawObject.ALLPAGES)) {
                throw new RuntimeException("Only valid setting is JPedalCustomDrawObject.ALLPAGES");
            }
            this.page = -1;
        }

        public int getPage() {
            return this.page;
        }

        public void print(Graphics2D graphics2D, int n) {
            if (this.page == n || this.page == -1 || this.page == 0) {
                this.paint(graphics2D);
            }
        }

        public void paint(Graphics2D graphics2D) {
            if (this.isVisible) {
                Paint paint = graphics2D.getPaint();
                graphics2D.setPaint(Color.orange);
                graphics2D.fillRect(100 + this.medX, 100 + this.medY, 100, 100);
                graphics2D.setPaint(Color.RED);
                graphics2D.drawRect(100 + this.medX, 100 + this.medY, 100, 100);
                graphics2D.setPaint(paint);
            }
        }

        public void setVisible(boolean bl) {
            this.isVisible = bl;
        }

        public void setMedX(int n) {
            this.medX = n;
        }

        public void setMedY(int n) {
            this.medY = n;
        }
    }

    class FormActionListener
    implements ActionListener {
        private Container c;
        private String formName;
        boolean showMessage;

        public FormActionListener(String string, Container container, boolean bl) {
            this.c = container;
            this.formName = string;
            this.showMessage = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            Object object2 = null;
            if (object instanceof JComboBox) {
                object2 = ((JComboBox)object).getSelectedItem();
            } else if (object instanceof JCheckBox) {
                object2 = String.valueOf(((JCheckBox)object).isSelected());
            } else if (object instanceof JRadioButton) {
                object2 = String.valueOf(((JRadioButton)object).isSelected());
            } else if (object instanceof JTextField) {
                object2 = ((JTextField)object).getText();
            }
            boolean bl = SwingGUI.this.properties.getValue("showsaveformsmessage").equals("true");
            if (bl && SwingGUI.this.firstTimeFormMessage && !SwingGUI.this.commonValues.isFormsChanged()) {
                SwingGUI.this.firstTimeFormMessage = false;
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.anchor = 17;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                String string = Messages.getMessage("PdfViewerFormsWarning.ChangedFormsValue");
                if (!SwingGUI.this.commonValues.isItextOnClasspath()) {
                    string = Messages.getMessage("PdfViewerFormsWarning.ChangedFormsValueNoItext");
                }
                JCheckBox jCheckBox = new JCheckBox();
                jCheckBox.setText(Messages.getMessage("PdfViewerFormsWarning.CheckBox"));
                Font font = jCheckBox.getFont();
                JTextArea jTextArea = new JTextArea(string);
                jTextArea.setOpaque(false);
                jTextArea.setFont(font);
                gridBagConstraints.ipady = 20;
                jPanel.add((Component)jTextArea, gridBagConstraints);
                gridBagConstraints.ipady = 0;
                gridBagConstraints.gridy = 1;
                jPanel.add((Component)jCheckBox, gridBagConstraints);
                JOptionPane.showMessageDialog(this.c, jPanel);
                if (jCheckBox.isSelected()) {
                    SwingGUI.this.properties.setValue("showsaveformsmessage", "false");
                }
            }
            SwingGUI.this.commonValues.setFormsChanged(true);
            SwingGUI.this.setViewerTitle(null);
            if (this.showMessage) {
                JOptionPane.showMessageDialog(this.c, "FormName >>" + this.formName + "<<. Value changed to " + object2);
            }
        }
    }

    private class ShowFormDataListener
    implements ActionListener {
        private String formName;

        public ShowFormDataListener(String string) {
            this.formName = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = SwingGUI.this.decode_pdf.getFormRenderer().getCompData().getRawForm(this.formName);
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                int n = objectArray.length;
                JTabbedPane jTabbedPane = new JTabbedPane();
                for (int i = 0; i < n; ++i) {
                    if (objectArray[i] == null) continue;
                    String string = objectArray[i].toString();
                    JTextArea jTextArea = new JTextArea();
                    jTextArea.setText(string);
                    jTextArea.setWrapStyleWord(true);
                    JScrollPane jScrollPane = new JScrollPane();
                    jScrollPane.setPreferredSize(new Dimension(400, 300));
                    jScrollPane.getViewport().add(jTextArea);
                    jScrollPane.setVerticalScrollBarPolicy(20);
                    jScrollPane.setHorizontalScrollBarPolicy(30);
                    jTabbedPane.add("" + i, jScrollPane);
                }
                JOptionPane.showMessageDialog(SwingGUI.this.getFrame(), jTabbedPane, "Raw Form Data", 0);
            } else {
                String string = object.toString();
                JTextArea jTextArea = new JTextArea();
                jTextArea.setText(string);
                jTextArea.setWrapStyleWord(true);
                JScrollPane jScrollPane = new JScrollPane();
                jScrollPane.setPreferredSize(new Dimension(400, 300));
                jScrollPane.getViewport().add(jTextArea);
                jScrollPane.setVerticalScrollBarPolicy(20);
                jScrollPane.setHorizontalScrollBarPolicy(30);
                JOptionPane.showMessageDialog(SwingGUI.this.getFrame(), jScrollPane, "Raw Form Data", 0);
            }
        }
    }

    private class PageChanger
    implements ActionListener {
        int page;

        public PageChanger(int n) {
            this.page = ++n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!SwingGUI.this.commonValues.isProcessing() && SwingGUI.this.commonValues.getCurrentPage() != this.page) {
                SwingGUI.this.commonValues.setCurrentPage(this.page);
                SwingGUI.this.statusBar.resetStatus("");
                SwingGUI.this.decodePage(false);
            }
        }
    }
}

