/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.transaction.xa.XAResource;
import oracle.jdbc.driver.ClosedConnection;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleCloseCallback;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCLOB;
import oracle.jdbc.pool.OracleConnectionCacheCallback;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.CLOB;
import oracle.sql.ClobDBAccess;
import oracle.sql.CustomDatum;
import oracle.sql.Datum;
import oracle.sql.StructDescriptor;

class LogicalConnection
extends OracleConnection {
    static final ClosedConnection closedConnection = new ClosedConnection();
    PhysicalConnection internalConnection;
    OraclePooledConnection pooledConnection;
    boolean closed;
    OracleCloseCallback m_occ = null;
    Object m_privData = null;
    long m_startTime = 0L;
    OracleConnectionCacheCallback m_occc = null;
    Object m_occcUserObj = null;
    int m_cbkFlag = 0;
    int m_releasePriority = 0;
    int m_heartbeatCount = 0;
    int m_heartbeatLastCount = 0;
    int m_heartbeatNoChangeCount = 0;
    boolean m_isAbandonedTimeoutEnabled = false;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "051228";

    LogicalConnection(OraclePooledConnection oraclePooledConnection, PhysicalConnection physicalConnection, boolean bl) throws SQLException {
        this.internalConnection = physicalConnection;
        this.pooledConnection = oraclePooledConnection;
        this.connection = this.internalConnection;
        this.connection.setWrapper(this);
        this.closed = false;
        this.internalConnection.setAutoCommit(bl);
    }

    void registerHeartbeat() throws SQLException {
        if (this.m_isAbandonedTimeoutEnabled) {
            try {
                ++this.m_heartbeatCount;
            }
            catch (ArithmeticException arithmeticException) {
                this.m_heartbeatCount = 0;
            }
        }
    }

    public int getHeartbeatNoChangeCount() throws SQLException {
        if (this.m_heartbeatCount == this.m_heartbeatLastCount) {
            ++this.m_heartbeatNoChangeCount;
        } else {
            this.m_heartbeatLastCount = this.m_heartbeatCount;
            this.m_heartbeatNoChangeCount = 0;
        }
        return this.m_heartbeatNoChangeCount;
    }

    public oracle.jdbc.internal.OracleConnection physicalConnectionWithin() {
        return this.internalConnection;
    }

    public synchronized void registerCloseCallback(OracleCloseCallback oracleCloseCallback, Object object) {
        this.m_occ = oracleCloseCallback;
        this.m_privData = object;
    }

    public Connection _getPC() {
        return this.internalConnection;
    }

    public synchronized boolean isLogicalConnection() {
        return true;
    }

    public oracle.jdbc.internal.OracleConnection getPhysicalConnection() {
        return this.internalConnection;
    }

    public Connection getLogicalConnection(OraclePooledConnection oraclePooledConnection, boolean bl) throws SQLException {
        DatabaseError.throwSqlException(153);
        return null;
    }

    public void getPropertyForPooledConnection(OraclePooledConnection oraclePooledConnection) throws SQLException {
        DatabaseError.throwSqlException(153);
    }

    public synchronized void close() throws SQLException {
        this.closeInternal(true);
    }

    public void closeInternal(boolean bl) throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.m_occ != null) {
            this.m_occ.beforeClose(this, this.m_privData);
        }
        this.internalConnection.closeLogicalConnection();
        this.m_startTime = 0L;
        this.closed = true;
        if (this.pooledConnection != null && bl) {
            this.pooledConnection.logicalClose();
        }
        this.internalConnection = closedConnection;
        this.connection = closedConnection;
        if (this.m_occ != null) {
            this.m_occ.afterClose(this.m_privData);
        }
    }

    public synchronized void close(Properties properties) throws SQLException {
        if (this.pooledConnection != null) {
            this.pooledConnection.cachedConnectionAttributes.clear();
            this.pooledConnection.cachedConnectionAttributes.putAll((Map<?, ?>)properties);
        }
        this.close();
    }

    public synchronized void close(int n) throws SQLException {
        if ((n & 0x1000) != 0) {
            if (this.pooledConnection != null) {
                this.pooledConnection.m_closeOption = n;
            }
            this.close();
            return;
        }
        if ((n & 1) != 0) {
            this.internalConnection.close(1);
        }
    }

    public synchronized void applyConnectionAttributes(Properties properties) throws SQLException {
        if (this.pooledConnection != null) {
            this.pooledConnection.cachedConnectionAttributes.putAll((Map<?, ?>)properties);
        }
    }

    public synchronized Properties getConnectionAttributes() throws SQLException {
        if (this.pooledConnection != null) {
            return this.pooledConnection.cachedConnectionAttributes;
        }
        return null;
    }

    public synchronized Properties getUnMatchedConnectionAttributes() throws SQLException {
        if (this.pooledConnection != null) {
            return this.pooledConnection.unMatchedCachedConnAttr;
        }
        return null;
    }

    public synchronized void setAbandonedTimeoutEnabled(boolean bl) throws SQLException {
        this.m_isAbandonedTimeoutEnabled = true;
    }

    public synchronized void registerConnectionCacheCallback(OracleConnectionCacheCallback oracleConnectionCacheCallback, Object object, int n) throws SQLException {
        this.m_occc = oracleConnectionCacheCallback;
        this.m_occcUserObj = object;
        this.m_cbkFlag = n;
    }

    public OracleConnectionCacheCallback getConnectionCacheCallbackObj() throws SQLException {
        return this.m_occc;
    }

    public Object getConnectionCacheCallbackPrivObj() throws SQLException {
        return this.m_occcUserObj;
    }

    public int getConnectionCacheCallbackFlag() throws SQLException {
        return this.m_cbkFlag;
    }

    public synchronized void setConnectionReleasePriority(int n) throws SQLException {
        this.m_releasePriority = n;
    }

    public int getConnectionReleasePriority() throws SQLException {
        return this.m_releasePriority;
    }

    public synchronized boolean isClosed() throws SQLException {
        return this.closed;
    }

    public void setStartTime(long l) throws SQLException {
        if (l <= 0L) {
            DatabaseError.throwSqlException(68);
        } else {
            this.m_startTime = l;
        }
    }

    public long getStartTime() throws SQLException {
        return this.m_startTime;
    }

    public Object getClientData(Object object) {
        return this.internalConnection.getClientData(object);
    }

    public Object setClientData(Object object, Object object2) {
        return this.internalConnection.setClientData(object, object2);
    }

    public Object removeClientData(Object object) {
        return this.internalConnection.removeClientData(object);
    }

    public void setClientIdentifier(String string) throws SQLException {
        this.internalConnection.setClientIdentifier(string);
    }

    public void clearClientIdentifier(String string) throws SQLException {
        this.internalConnection.clearClientIdentifier(string);
    }

    public short getStructAttrNCsId() throws SQLException {
        return this.internalConnection.getStructAttrNCsId();
    }

    public Map getTypeMap() throws SQLException {
        return this.internalConnection.getTypeMap();
    }

    public Properties getDBAccessProperties() throws SQLException {
        return this.internalConnection.getDBAccessProperties();
    }

    public Properties getOCIHandles() throws SQLException {
        return this.internalConnection.getOCIHandles();
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this.internalConnection.getDatabaseProductVersion();
    }

    public void cancel() throws SQLException {
        this.internalConnection.cancel();
    }

    public String getURL() throws SQLException {
        return this.internalConnection.getURL();
    }

    public void trace(String string) {
        this.internalConnection.trace(string);
    }

    public boolean getIncludeSynonyms() {
        return this.internalConnection.getIncludeSynonyms();
    }

    public boolean getRemarksReporting() {
        return this.internalConnection.getRemarksReporting();
    }

    public boolean getRestrictGetTables() {
        return this.internalConnection.getRestrictGetTables();
    }

    public short getVersionNumber() throws SQLException {
        return this.internalConnection.getVersionNumber();
    }

    public Map getJavaObjectTypeMap() {
        return this.internalConnection.getJavaObjectTypeMap();
    }

    public void setJavaObjectTypeMap(Map map) {
        this.internalConnection.setJavaObjectTypeMap(map);
    }

    public BfileDBAccess createBfileDBAccess() throws SQLException {
        return this.internalConnection.createBfileDBAccess();
    }

    public BlobDBAccess createBlobDBAccess() throws SQLException {
        return this.internalConnection.createBlobDBAccess();
    }

    public ClobDBAccess createClobDBAccess() throws SQLException {
        return this.internalConnection.createClobDBAccess();
    }

    public void setDefaultFixedString(boolean bl) {
        this.internalConnection.setDefaultFixedString(bl);
    }

    public boolean getDefaultFixedString() {
        return this.internalConnection.getDefaultFixedString();
    }

    public oracle.jdbc.OracleConnection getWrapper() {
        return this;
    }

    public Class classForNameAndSchema(String string, String string2) throws ClassNotFoundException {
        return this.internalConnection.classForNameAndSchema(string, string2);
    }

    public void setFDO(byte[] byArray) throws SQLException {
        this.internalConnection.setFDO(byArray);
    }

    public byte[] getFDO(boolean bl) throws SQLException {
        return this.internalConnection.getFDO(bl);
    }

    public boolean getBigEndian() throws SQLException {
        return this.internalConnection.getBigEndian();
    }

    public Object getDescriptor(byte[] byArray) {
        return this.internalConnection.getDescriptor(byArray);
    }

    public void putDescriptor(byte[] byArray, Object object) throws SQLException {
        this.internalConnection.putDescriptor(byArray, object);
    }

    public void removeDescriptor(String string) {
        this.internalConnection.removeDescriptor(string);
    }

    public void removeAllDescriptor() {
        this.internalConnection.removeAllDescriptor();
    }

    public void getOracleTypeADT(OracleTypeADT oracleTypeADT) throws SQLException {
        this.internalConnection.getOracleTypeADT(oracleTypeADT);
    }

    public short getDbCsId() throws SQLException {
        return this.internalConnection.getDbCsId();
    }

    public short getJdbcCsId() throws SQLException {
        return this.internalConnection.getJdbcCsId();
    }

    public short getNCharSet() {
        return this.internalConnection.getNCharSet();
    }

    public ResultSet newArrayDataResultSet(Datum[] datumArray, long l, int n, Map map) throws SQLException {
        return this.internalConnection.newArrayDataResultSet(datumArray, l, n, map);
    }

    public ResultSet newArrayDataResultSet(ARRAY aRRAY, long l, int n, Map map) throws SQLException {
        return this.internalConnection.newArrayDataResultSet(aRRAY, l, n, map);
    }

    public ResultSet newArrayLocatorResultSet(ArrayDescriptor arrayDescriptor, byte[] byArray, long l, int n, Map map) throws SQLException {
        return this.internalConnection.newArrayLocatorResultSet(arrayDescriptor, byArray, l, n, map);
    }

    public ResultSetMetaData newStructMetaData(StructDescriptor structDescriptor) throws SQLException {
        return this.internalConnection.newStructMetaData(structDescriptor);
    }

    public void getForm(OracleTypeADT oracleTypeADT, OracleTypeCLOB oracleTypeCLOB, int n) throws SQLException {
        this.internalConnection.getForm(oracleTypeADT, oracleTypeCLOB, n);
    }

    public int CHARBytesToJavaChars(byte[] byArray, int n, char[] cArray) throws SQLException {
        return this.internalConnection.CHARBytesToJavaChars(byArray, n, cArray);
    }

    public int NCHARBytesToJavaChars(byte[] byArray, int n, char[] cArray) throws SQLException {
        return this.internalConnection.NCHARBytesToJavaChars(byArray, n, cArray);
    }

    public boolean IsNCharFixedWith() {
        return this.internalConnection.IsNCharFixedWith();
    }

    public short getDriverCharSet() {
        return this.internalConnection.getDriverCharSet();
    }

    public int getC2SNlsRatio() {
        return this.internalConnection.getC2SNlsRatio();
    }

    public int getMaxCharSize() throws SQLException {
        return this.internalConnection.getMaxCharSize();
    }

    public int getMaxCharbyteSize() {
        return this.internalConnection.getMaxCharbyteSize();
    }

    public int getMaxNCharbyteSize() {
        return this.internalConnection.getMaxNCharbyteSize();
    }

    public boolean isCharSetMultibyte(short s) {
        return this.internalConnection.isCharSetMultibyte(s);
    }

    public int javaCharsToCHARBytes(char[] cArray, int n, byte[] byArray) throws SQLException {
        return this.internalConnection.javaCharsToCHARBytes(cArray, n, byArray);
    }

    public int javaCharsToNCHARBytes(char[] cArray, int n, byte[] byArray) throws SQLException {
        return this.internalConnection.javaCharsToNCHARBytes(cArray, n, byArray);
    }

    public int getStmtCacheSize() {
        return this.internalConnection.getStmtCacheSize();
    }

    public int getStatementCacheSize() throws SQLException {
        return this.internalConnection.getStatementCacheSize();
    }

    public boolean getImplicitCachingEnabled() throws SQLException {
        return this.internalConnection.getImplicitCachingEnabled();
    }

    public boolean getExplicitCachingEnabled() throws SQLException {
        return this.internalConnection.getExplicitCachingEnabled();
    }

    public void purgeImplicitCache() throws SQLException {
        this.internalConnection.purgeImplicitCache();
    }

    public void purgeExplicitCache() throws SQLException {
        this.internalConnection.purgeExplicitCache();
    }

    public PreparedStatement getStatementWithKey(String string) throws SQLException {
        return this.internalConnection.getStatementWithKey(string);
    }

    public CallableStatement getCallWithKey(String string) throws SQLException {
        return this.internalConnection.getCallWithKey(string);
    }

    public boolean isStatementCacheInitialized() {
        return this.internalConnection.isStatementCacheInitialized();
    }

    public void setTypeMap(Map map) {
        this.internalConnection.setTypeMap(map);
    }

    public String getProtocolType() {
        return this.internalConnection.getProtocolType();
    }

    public void setTxnMode(int n) {
        this.internalConnection.setTxnMode(n);
    }

    public int getTxnMode() {
        return this.internalConnection.getTxnMode();
    }

    public int getHeapAllocSize() throws SQLException {
        return this.internalConnection.getHeapAllocSize();
    }

    public int getOCIEnvHeapAllocSize() throws SQLException {
        return this.internalConnection.getOCIEnvHeapAllocSize();
    }

    public CLOB createClob(byte[] byArray) throws SQLException {
        return this.internalConnection.createClob(byArray);
    }

    public CLOB createClob(byte[] byArray, short s) throws SQLException {
        return this.internalConnection.createClob(byArray, s);
    }

    public BLOB createBlob(byte[] byArray) throws SQLException {
        return this.internalConnection.createBlob(byArray);
    }

    public BFILE createBfile(byte[] byArray) throws SQLException {
        return this.internalConnection.createBfile(byArray);
    }

    public boolean isDescriptorSharable(oracle.jdbc.internal.OracleConnection oracleConnection) throws SQLException {
        return this.internalConnection.isDescriptorSharable(oracleConnection);
    }

    public OracleStatement refCursorCursorToStatement(int n) throws SQLException {
        return this.internalConnection.refCursorCursorToStatement(n);
    }

    public Datum toDatum(CustomDatum customDatum) throws SQLException {
        return this.internalConnection.toDatum(customDatum);
    }

    public void abort() throws SQLException {
        if (this.closed) {
            return;
        }
        this.internalConnection.abort();
        this.closed = true;
        this.internalConnection = closedConnection;
        this.connection = closedConnection;
    }

    public boolean isV8Compatible() throws SQLException {
        return this.internalConnection.isV8Compatible();
    }

    public XAResource getXAResource() throws SQLException {
        return this.pooledConnection.getXAResource();
    }
}

