/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.Util;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.SQLName;
import oracle.xdb.RealInputStream;
import oracle.xdb.XDBError;
import oracle.xdb.XMLTypeFactory;
import oracle.xdb.dom.XDBDocFragment;
import oracle.xdb.dom.XDBDocument;
import oracle.xdb.spi.XDBResource;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLType
extends OPAQUE
implements ORAData {
    public static final int _SQL_TYPECODE = 2007;
    public static final String _SQL_NAME = "SYS.XMLTYPE";
    public static final int CONNTYPE_THIN = 0;
    public static final int CONNTYPE_OCI8 = 1;
    public static final int CONNTYPE_KPRB = 2;
    private static final int LOBTYPE_BLOB = 1;
    int m_conntype;
    long m_gpCState;
    String m_stringval;
    ByteArrayOutputStream m_bytesval;
    CLOB m_clobval;
    BLOB m_blobval;
    long m_cstate;
    OracleConnection m_local_conn;
    Document m_dom;
    CharacterSet m_charSet;
    private boolean m_isClosed;
    private static boolean m_libLoaded = false;
    private int m_csid;
    private CharacterSet m_blobCS;
    String m_kind;
    private static final XMLTypeFactory xmlfactory = new XMLTypeFactory();
    private int m_thinflags;
    private byte[] m_thinsnapshot;
    private byte[] m_thinschoid;
    private byte[] m_thinelemnum;
    static final int XMLTYPE_VERSION = 1;
    static final int XMLTYPE_LOB = 1;
    static final int XMLTYPE_STR = 4;
    static final int XMLTYPE_PTR = 8;
    static final int XMLTYPE_FLAG_SNAPSHOT = 4096;
    static final int XMLTYPE_FLAG_SCHMOID = 8;
    static final int XMLTYPE_SCHMOIDLEN = 16;
    static final int XMLTYPE_ELEMNUMLEN = 4;
    static final int XMLTYPE_KOSNPLEN = 24;

    public XMLType() throws SQLException {
        super(null, null, (Object)new byte[1]);
        this.m_gpCState = 0L;
        this.m_stringval = null;
        this.m_bytesval = null;
        this.m_clobval = null;
        this.m_blobval = null;
        this.m_cstate = 0L;
        this.m_dom = null;
        this.m_charSet = CharacterSet.make((int)-1);
        this.m_isClosed = false;
        this.m_csid = 0;
        this.m_blobCS = null;
    }

    private XMLType(Connection conn, long cstate) throws SQLException {
        this(conn, cstate, null);
    }

    private XMLType(Connection conn, long cstate, String kind) throws SQLException {
        super(OpaqueDescriptor.createDescriptor((String)_SQL_NAME, (Connection)conn), conn, (Object)new byte[1]);
        this.m_gpCState = 0L;
        this.m_stringval = null;
        this.m_bytesval = null;
        this.m_clobval = null;
        this.m_blobval = null;
        this.m_cstate = 0L;
        this.m_dom = null;
        this.m_charSet = CharacterSet.make((int)-1);
        this.m_isClosed = false;
        this.m_csid = 0;
        this.m_blobCS = null;
        this.initConn(conn, kind);
        this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
        this.m_cstate = cstate;
    }

    public XMLType(Connection conn, InputStream is) throws SQLException {
        this(conn, is, null);
    }

    public XMLType(Connection conn, InputStream is, String kind) throws SQLException {
        super(OpaqueDescriptor.createDescriptor((String)_SQL_NAME, (Connection)conn), conn, (Object)new byte[1]);
        this.m_gpCState = 0L;
        this.m_stringval = null;
        this.m_bytesval = null;
        this.m_clobval = null;
        this.m_blobval = null;
        this.m_cstate = 0L;
        this.m_dom = null;
        this.m_charSet = CharacterSet.make((int)-1);
        this.m_isClosed = false;
        this.m_csid = 0;
        this.m_blobCS = null;
        this.initConn(conn, kind);
        this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
        if (is == null) {
            return;
        }
        byte[] buf = new byte[1024];
        if (this.m_kind.equals("oracle.xml.parser.XMLDocument.THIN")) {
            this.m_bytesval = new ByteArrayOutputStream();
            try {
                int nread;
                while ((nread = is.read(buf)) != -1) {
                    this.m_bytesval.write(buf, 0, nread);
                }
            }
            catch (IOException iOException) {
                throw new SQLException();
            }
        }
        if (this.m_kind.equals("oracle.xml.parser.XMLDocument.THICK")) {
            try {
                long segstream = 0L;
                try {
                    int nread;
                    int off = 0;
                    while ((nread = is.read(buf)) != -1) {
                        segstream = this.WriteToSegStreamNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), segstream, buf, off, nread);
                        off += buf.length;
                    }
                }
                catch (IOException iOException) {
                    throw new SQLException();
                }
                this.m_cstate = this.createXMLTypeFromStreamNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), segstream);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.m_conntype = 0;
                this.m_bytesval = new ByteArrayOutputStream();
                try {
                    int nread;
                    while ((nread = is.read(buf)) != -1) {
                        this.m_bytesval.write(buf, 0, nread);
                    }
                }
                catch (IOException iOException) {
                    throw new SQLException();
                }
            }
        }
    }

    public XMLType(Connection conn, String xmlval) throws SQLException {
        this(conn, xmlval, null);
    }

    public XMLType(Connection conn, String xmlval, String kind) throws SQLException {
        block4: {
            block3: {
                super(OpaqueDescriptor.createDescriptor((String)_SQL_NAME, (Connection)conn), conn, (Object)new byte[1]);
                this.m_gpCState = 0L;
                this.m_stringval = null;
                this.m_bytesval = null;
                this.m_clobval = null;
                this.m_blobval = null;
                this.m_cstate = 0L;
                this.m_dom = null;
                this.m_charSet = CharacterSet.make((int)-1);
                this.m_isClosed = false;
                this.m_csid = 0;
                this.m_blobCS = null;
                this.initConn(conn, kind);
                this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
                if (xmlval == null) {
                    return;
                }
                if (!this.m_kind.equals("oracle.xml.parser.XMLDocument.THIN")) break block3;
                this.m_stringval = xmlval;
                break block4;
            }
            if (!this.m_kind.equals("oracle.xml.parser.XMLDocument.THICK")) break block4;
            try {
                this.m_cstate = this.createXMLTypeFromStringNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), xmlval, null, false, false);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.m_conntype = 0;
                this.m_kind = "oracle.xml.parser.XMLDocument.THIN";
                this.m_stringval = xmlval;
            }
        }
    }

    public XMLType(Connection conn, String xmlval, String schemaURL, boolean wellformed, boolean valid) throws SQLException {
        this(conn, xmlval, schemaURL, wellformed, valid, null);
    }

    public XMLType(Connection conn, String xmlval, String schemaURL, boolean wellformed, boolean valid, String kind) throws SQLException {
        block4: {
            block3: {
                super(OpaqueDescriptor.createDescriptor((String)_SQL_NAME, (Connection)conn), conn, (Object)new byte[1]);
                this.m_gpCState = 0L;
                this.m_stringval = null;
                this.m_bytesval = null;
                this.m_clobval = null;
                this.m_blobval = null;
                this.m_cstate = 0L;
                this.m_dom = null;
                this.m_charSet = CharacterSet.make((int)-1);
                this.m_isClosed = false;
                this.m_csid = 0;
                this.m_blobCS = null;
                this.initConn(conn, kind);
                this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
                if (xmlval == null) {
                    return;
                }
                if (!this.m_kind.equals("oracle.xml.parser.XMLDocument.THIN")) break block3;
                this.m_stringval = xmlval;
                break block4;
            }
            if (!this.m_kind.equals("oracle.xml.parser.XMLDocument.THICK")) break block4;
            try {
                this.m_cstate = this.createXMLTypeFromStringNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), xmlval, schemaURL, wellformed, valid);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.m_conntype = 0;
                this.m_kind = "oracle.xml.parser.XMLDocument.THIN";
                this.m_stringval = xmlval;
            }
        }
    }

    public XMLType(Connection conn, BLOB xmlval, int csid) throws SQLException {
        this(conn, xmlval, csid, null);
    }

    public XMLType(Connection conn, BLOB xmlval, int csid, String kind) throws SQLException {
        block5: {
            block4: {
                super(OpaqueDescriptor.createDescriptor((String)_SQL_NAME, (Connection)conn), conn, (Object)new byte[1]);
                this.m_gpCState = 0L;
                this.m_stringval = null;
                this.m_bytesval = null;
                this.m_clobval = null;
                this.m_blobval = null;
                this.m_cstate = 0L;
                this.m_dom = null;
                this.m_charSet = CharacterSet.make((int)-1);
                this.m_isClosed = false;
                this.m_csid = 0;
                this.m_blobCS = null;
                this.initConn(conn, kind);
                if (csid < 0 || this.m_conntype == 0 && csid == 0) {
                    throw new SQLException(XDBError.getMsg("INVALID_CSID"));
                }
                this.m_csid = csid;
                this.m_blobCS = CharacterSet.make((int)this.m_csid);
                this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
                if (xmlval == null) {
                    return;
                }
                if (!this.m_kind.equals("oracle.xml.parser.XMLDocument.THIN")) break block4;
                this.m_blobval = xmlval;
                break block5;
            }
            if (!this.m_kind.equals("oracle.xml.parser.XMLDocument.THICK")) break block5;
            try {
                this.m_cstate = this.createXMLTypeFromLobNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), xmlval.getLocator(), csid, 1, null, false, false);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.m_conntype = 0;
                this.m_kind = "oracle.xml.parser.XMLDocument.THIN";
                this.m_blobval = xmlval;
            }
        }
    }

    public XMLType(Connection conn, CLOB xmlval) throws SQLException {
        this(conn, xmlval, null);
    }

    public XMLType(Connection conn, CLOB xmlval, String kind) throws SQLException {
        super(OpaqueDescriptor.createDescriptor((String)_SQL_NAME, (Connection)conn), conn, (Object)new byte[1]);
        this.m_gpCState = 0L;
        this.m_stringval = null;
        this.m_bytesval = null;
        this.m_clobval = null;
        this.m_blobval = null;
        this.m_cstate = 0L;
        this.m_dom = null;
        this.m_charSet = CharacterSet.make((int)-1);
        this.m_isClosed = false;
        this.m_csid = 0;
        this.m_blobCS = null;
        this.initConn(conn, kind);
        this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
        if (xmlval == null) {
            return;
        }
        this.getCStateFromLocator(xmlval);
    }

    public XMLType(Connection conn, CLOB xmlval, String schemaURL, boolean wellformed, boolean valid) throws SQLException {
        this(conn, xmlval, schemaURL, wellformed, valid, null);
    }

    public XMLType(Connection conn, CLOB xmlval, String schemaURL, boolean wellformed, boolean valid, String kind) throws SQLException {
        block4: {
            block3: {
                super(OpaqueDescriptor.createDescriptor((String)_SQL_NAME, (Connection)conn), conn, (Object)new byte[1]);
                this.m_gpCState = 0L;
                this.m_stringval = null;
                this.m_bytesval = null;
                this.m_clobval = null;
                this.m_blobval = null;
                this.m_cstate = 0L;
                this.m_dom = null;
                this.m_charSet = CharacterSet.make((int)-1);
                this.m_isClosed = false;
                this.m_csid = 0;
                this.m_blobCS = null;
                this.initConn(conn, kind);
                this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
                if (xmlval == null) {
                    return;
                }
                if (!this.m_kind.equals("oracle.xml.parser.XMLDocument.THIN")) break block3;
                this.m_clobval = xmlval;
                break block4;
            }
            if (!this.m_kind.equals("oracle.xml.parser.XMLDocument.THICK")) break block4;
            try {
                this.m_cstate = this.createXMLTypeFromLobNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), xmlval.getLocator(), 0, 0, schemaURL, wellformed, valid);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.m_conntype = 0;
                this.m_kind = "oracle.xml.parser.XMLDocument.THIN";
                this.m_clobval = xmlval;
            }
        }
    }

    public XMLType(Connection conn, Document domdoc) throws SQLException {
        super(OpaqueDescriptor.createDescriptor((String)_SQL_NAME, (Connection)conn), conn, (Object)new byte[1]);
        this.m_gpCState = 0L;
        this.m_stringval = null;
        this.m_bytesval = null;
        this.m_clobval = null;
        this.m_blobval = null;
        this.m_cstate = 0L;
        this.m_dom = null;
        this.m_charSet = CharacterSet.make((int)-1);
        this.m_isClosed = false;
        this.m_csid = 0;
        this.m_blobCS = null;
        this.initConn(conn);
        this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
        if (domdoc instanceof XDBDocument) {
            this.m_cstate = XMLType.getCStateFromXobd(conn, domdoc);
        } else if (domdoc instanceof XMLDocument) {
            if (((XMLDocument)domdoc).isNodeFlag(2)) {
                this.m_cstate = XMLType.getCStateFromXobd(conn, domdoc);
            } else {
                CLOB tmpclob = CLOB.createTemporary((Connection)conn, (boolean)true, (int)10);
                try {
                    PrintWriter p = new PrintWriter(tmpclob.getCharacterOutputStream());
                    ((XMLDocument)domdoc).print(p);
                }
                catch (IOException iOException) {
                    throw new SQLException();
                }
                this.getCStateFromLocator(tmpclob);
            }
        }
    }

    public XMLType(OpaqueDescriptor type, Connection conn, Object value) throws SQLException {
        this(type, conn, value, null);
    }

    public XMLType(OpaqueDescriptor type, Connection conn, Object value, String kind) throws SQLException {
        block4: {
            int bytepos;
            byte[] byteVal;
            block3: {
                super(type, conn, value == null ? (Object)new byte[1] : value);
                this.m_gpCState = 0L;
                this.m_stringval = null;
                this.m_bytesval = null;
                this.m_clobval = null;
                this.m_blobval = null;
                this.m_cstate = 0L;
                this.m_dom = null;
                this.m_charSet = CharacterSet.make((int)-1);
                this.m_isClosed = false;
                this.m_csid = 0;
                this.m_blobCS = null;
                this.initConn(conn, kind);
                this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
                if (value == null) {
                    return;
                }
                byteVal = (byte[])value;
                bytepos = 0;
                if (!this.m_kind.equals("oracle.xml.parser.XMLDocument.THIN")) break block3;
                this.processThin(byteVal, bytepos);
                break block4;
            }
            if (!this.m_kind.equals("oracle.xml.parser.XMLDocument.THICK")) break block4;
            try {
                this.processCState(byteVal, bytepos);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.m_conntype = 0;
                this.m_kind = "oracle.xml.parser.XMLDocument.THIN";
                this.processThin(byteVal, 0);
                this.m_cstate = 0L;
            }
        }
    }

    private synchronized native long WriteToSegStreamNative(long var1, long var3, long var5, long var7, byte[] var9, int var10, int var11);

    private static int bytesToInt(byte[] val, int pos) {
        int i = 0;
        i += XMLType.unsignedByteToInt(val[pos++]) << 24;
        i += XMLType.unsignedByteToInt(val[pos++]) << 16;
        i += XMLType.unsignedByteToInt(val[pos++]) << 8;
        return i += XMLType.unsignedByteToInt(val[pos++]);
    }

    public void close() {
        this.freeXMLType();
    }

    private synchronized native void closeNative(long var1, long var3, long var5, long var7);

    public static long createContext(Connection conn) throws SQLException {
        return XDBResource.getServerCtx();
    }

    public XMLType createSchemaBasedXML(String schemaURL) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        return new XMLType((Connection)this.m_local_conn, this.getClobVal(), schemaURL, false, false);
    }

    public static XMLType createXML(Connection conn, InputStream is) throws SQLException {
        return XMLType.createXML(conn, is, null);
    }

    public static XMLType createXML(Connection conn, InputStream is, String kind) throws SQLException {
        return new XMLType(conn, is, kind);
    }

    public static XMLType createXML(Connection conn, String xmlval) throws SQLException {
        return XMLType.createXML(conn, xmlval, null);
    }

    public static XMLType createXML(Connection conn, String xmlval, String kind) throws SQLException {
        return new XMLType(conn, xmlval, kind);
    }

    public static XMLType createXML(Connection conn, String xmlval, String schemaURL, boolean wellformed, boolean valid) throws SQLException {
        return XMLType.createXML(conn, xmlval, schemaURL, wellformed, valid, null);
    }

    public static XMLType createXML(Connection conn, String xmlval, String schemaURL, boolean wellformed, boolean valid, String kind) throws SQLException {
        return new XMLType(conn, xmlval, schemaURL, wellformed, valid, kind);
    }

    public static XMLType createXML(Connection conn, CLOB xmlval) throws SQLException {
        return XMLType.createXML(conn, xmlval, null);
    }

    public static XMLType createXML(Connection conn, CLOB xmlval, String kind) throws SQLException {
        return new XMLType(conn, xmlval, kind);
    }

    public static XMLType createXML(Connection conn, CLOB xmlval, String schemaURL, boolean wellformed, boolean valid) throws SQLException {
        return XMLType.createXML(conn, xmlval, schemaURL, wellformed, valid, null);
    }

    public static XMLType createXML(Connection conn, CLOB xmlval, String schemaURL, boolean wellformed, boolean valid, String kind) throws SQLException {
        return new XMLType(conn, xmlval, schemaURL, wellformed, valid, kind);
    }

    public static XMLType createXML(Connection conn, Document domdoc) throws SQLException {
        XMLType xtype = null;
        if (domdoc instanceof XDBDocument) {
            long xmlcstate = XMLType.getCStateFromXobd(conn, domdoc);
            xtype = new XMLType(conn, xmlcstate);
        } else if (domdoc instanceof XMLDocument) {
            if (((XMLDocument)domdoc).isNodeFlag(2)) {
                long xmlcstate = XMLType.getCStateFromXobd(conn, domdoc);
                xtype = new XMLType(conn, xmlcstate, "oracle.xml.parser.XMLDocument.THICK");
            } else {
                CLOB tmpclob = CLOB.createTemporary((Connection)conn, (boolean)true, (int)10);
                try {
                    PrintWriter p = new PrintWriter(tmpclob.getCharacterOutputStream());
                    ((XMLDocument)domdoc).print(p);
                }
                catch (IOException iOException) {
                    throw new SQLException();
                }
                xtype = XMLType.createXML(conn, tmpclob);
            }
        }
        return xtype;
    }

    public static XMLType createXML(OPAQUE opq) throws SQLException {
        return XMLType.createXML(opq, null);
    }

    public static XMLType createXML(OPAQUE opq, String kind) throws SQLException {
        String opqname = opq.getSQLTypeName();
        String[] schema = new String[1];
        String[] typename = new String[1];
        SQLName.setHandleDoubleQuote((boolean)true);
        SQLName.parse((String)opqname, (String[])schema, (String[])typename);
        if (typename[0].compareTo("XMLTYPE") != 0) {
            return null;
        }
        return new XMLType(opq.getDescriptor(), opq.getJavaSqlConnection(), opq.getBytesValue(), kind);
    }

    private synchronized native long createXMLTypeFromLobNative(long var1, long var3, long var5, byte[] var7, int var8, int var9, String var10, boolean var11, boolean var12);

    private synchronized native long createXMLTypeFromStreamNative(long var1, long var3, long var5, long var7);

    private synchronized native long createXMLTypeFromStringNative(long var1, long var3, long var5, String var7, String var8, boolean var9, boolean var10);

    public static void destroyContext(long xmctx) throws SQLException {
        XDBResource.freeServerCtx(xmctx);
    }

    public boolean existsNode(String xpath, String nsmap) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        boolean retval = this.existsNodeNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate, xpath, nsmap);
        return retval;
    }

    private synchronized native boolean existsNodeNative(long var1, long var3, long var5, long var7, String var9, String var10);

    public XMLType extract(String xpath, String nsmap) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        long retcstate = this.extractNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate, xpath, nsmap);
        if (retcstate != 0L) {
            return new XMLType((Connection)this.m_local_conn, retcstate);
        }
        return null;
    }

    private synchronized native long extractNative(long var1, long var3, long var5, long var7, String var9, String var10);

    public void finalize() {
    }

    private void freeXMLType() {
        if (this.m_isClosed) {
            return;
        }
        switch (this.m_conntype) {
            case 0: {
                if (this.m_clobval != null) {
                    try {
                        if (CLOB.isTemporary((CLOB)this.m_clobval)) {
                            this.m_clobval.freeTemporary();
                        } else {
                            this.m_clobval.close();
                        }
                        this.m_clobval = null;
                    }
                    catch (SQLException sQLException) {}
                }
                if (this.m_blobval == null) break;
                try {
                    if (BLOB.isTemporary((BLOB)this.m_blobval)) {
                        this.m_blobval.freeTemporary();
                    } else {
                        this.m_blobval.close();
                    }
                    this.m_blobval = null;
                }
                catch (SQLException sQLException) {}
                break;
            }
            case 1: 
            case 2: {
                if (this.m_dom != null) {
                    ((XDBDocument)this.m_dom).close();
                }
                try {
                    this.closeNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate);
                    this.m_cstate = 0L;
                }
                catch (SQLException sQLException) {
                    this.m_cstate = 0L;
                }
                break;
            }
        }
        this.m_isClosed = true;
    }

    private ByteArrayOutputStream getBinaryStream(BLOB blob) throws SQLException {
        if (blob == null) {
            return null;
        }
        ByteArrayOutputStream bytestrm = new ByteArrayOutputStream();
        try {
            int nread;
            byte[] buf = new byte[1024];
            InputStream instrm = blob.getBinaryStream();
            while ((nread = instrm.read(buf)) != -1) {
                bytestrm.write(buf, 0, nread);
            }
            instrm.close();
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
        return bytestrm;
    }

    public BLOB getBlobVal(int csid) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (csid <= 0) {
            throw new SQLException(XDBError.getMsg("INVALID_CSID"));
        }
        if (this.m_blobval != null && this.m_csid == csid) {
            return this.m_blobval;
        }
        BLOB tmpblob = BLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)10);
        CharacterSet dstcs = CharacterSet.make((int)csid);
        if (this.m_blobval != null) {
            ByteArrayOutputStream bytestrm = this.getBinaryStream(this.m_blobval);
            byte[] bytebuf = dstcs.convert(this.m_blobCS, bytestrm.toByteArray(), 0, bytestrm.size());
            tmpblob.putBytes(1L, bytebuf);
        } else if (this.m_bytesval != null) {
            if (this.m_csid == 0) {
                tmpblob.putBytes(1L, this.m_bytesval.toByteArray());
            } else {
                byte[] bytebuf = dstcs.convert(this.m_blobCS, this.m_bytesval.toByteArray(), 0, this.m_bytesval.size());
                tmpblob.putBytes(1L, bytebuf);
            }
        } else if (this.m_conntype == 0) {
            if (this.m_stringval == null) {
                this.m_stringval = this.getStringVal();
            }
            if (this.m_stringval != null) {
                byte[] bytebuf = dstcs.convert(this.m_stringval);
                tmpblob.putBytes(1L, bytebuf);
            }
        } else if (this.m_cstate != 0L) {
            this.printToLobNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate, tmpblob.getLocator(), csid);
        }
        return tmpblob;
    }

    private byte[] getBytesBytes() throws SQLException {
        try {
            ByteArrayOutputStream strm = new ByteArrayOutputStream();
            this.writePreamble(strm, 1, 4);
            strm.write(this.m_bytesval.toByteArray());
            return strm.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private byte[] getBytesLob() throws SQLException {
        try {
            ByteArrayOutputStream strm = new ByteArrayOutputStream();
            this.writePreamble(strm, 1, 1);
            strm.write(this.m_clobval.getLocator());
            return strm.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private byte[] getBytesPtr(OracleConnection conn) throws SQLException {
        byte[] b = this.pickleXMLTypeNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate);
        return b;
    }

    private byte[] getBytesString() throws SQLException {
        try {
            ByteArrayOutputStream strm = new ByteArrayOutputStream();
            this.writePreamble(strm, 1, 4);
            strm.write(this.m_charSet.convert(this.m_stringval));
            return strm.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public byte[] getBytesValue() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_blobval != null) {
            this.m_clobval = this.getClobVal();
        }
        if (this.m_clobval != null) {
            return this.getBytesLob();
        }
        if (this.m_stringval != null) {
            return this.getBytesString();
        }
        if (this.m_bytesval != null) {
            return this.getBytesBytes();
        }
        if (this.m_conntype == 2 || this.m_conntype == 1) {
            return this.getBytesPtr(this.m_local_conn);
        }
        return null;
    }

    private void getCStateFromLocator(CLOB xmlclob) throws SQLException {
        switch (this.m_conntype) {
            case 0: {
                this.m_clobval = xmlclob;
                break;
            }
            case 1: 
            case 2: {
                try {
                    this.m_cstate = this.createXMLTypeFromLobNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), xmlclob.getLocator(), 0, 0, null, false, false);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    this.m_conntype = 0;
                    this.m_clobval = xmlclob;
                }
                break;
            }
        }
    }

    private static long getCStateFromXobd(Connection conn, Document domdoc) throws SQLException {
        long gpCState = 0L;
        long svchandle = 0L;
        long errhandle = 0L;
        long m_cstate = 0L;
        long cstate = 0L;
        OracleConnection iconn = conn == null ? null : ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin();
        if (iconn.getProtocolType().equals("kprb")) {
            gpCState = XDBResource.getServerEnv();
        } else {
            Properties prop = iconn.getOCIHandles();
            svchandle = Long.parseLong(prop.getProperty("OCISvcCtxHandle"));
            errhandle = Long.parseLong(prop.getProperty("OCIErrHandle"));
        }
        cstate = domdoc instanceof XDBDocument ? ((XDBDocument)domdoc).toCState() : ((XMLDocument)domdoc).xdbGetNodeId();
        m_cstate = XMLType.getXMLTypeFromXobd(gpCState, svchandle, errhandle, cstate);
        return m_cstate;
    }

    private String getClobStr(CLOB clob) throws SQLException {
        String tmpstr = null;
        try {
            int nread;
            CharArrayWriter cwriter = new CharArrayWriter();
            char[] buf = new char[1024];
            Reader rdr = clob.getCharacterStream();
            while ((nread = rdr.read(buf)) != -1) {
                cwriter.write(buf, 0, nread);
            }
            rdr.close();
            tmpstr = cwriter.toString();
            cwriter.close();
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
        return tmpstr;
    }

    public CLOB getClobVal() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_clobval != null) {
            return this.m_clobval;
        }
        if (this.m_stringval != null) {
            CLOB tmpclob = CLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)10);
            tmpclob.putString(1L, this.m_stringval);
            return tmpclob;
        }
        if (this.m_blobval != null) {
            CLOB tmpclob = CLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)10);
            tmpclob.putString(1L, this.getStringVal());
            return tmpclob;
        }
        if (this.m_cstate != 0L) {
            CLOB tmpclob = CLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)10);
            this.printToLobNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate, tmpclob.getLocator(), 0);
            return tmpclob;
        }
        if (this.m_bytesval != null) {
            CLOB tmpclob = CLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)10);
            tmpclob.putString(1L, this.getStringFromBinaryStream());
            return tmpclob;
        }
        return null;
    }

    public static int getConnType(Connection conn) throws SQLException {
        int conntype;
        block10: {
            if (conn == null) {
                return 2;
            }
            OracleConnection localconn = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin();
            if (localconn.getProtocolType().equals("thin")) {
                conntype = 0;
            } else if (localconn.getProtocolType().equals("oci8") || localconn.getProtocolType().equals("oci")) {
                conntype = 1;
                try {
                    if (m_libLoaded) break block10;
                    String osName = System.getProperty("os.name");
                    if (osName.toUpperCase().startsWith("WINDOWS")) {
                        System.loadLibrary("orageneric10");
                        m_libLoaded = true;
                        break block10;
                    }
                    m_libLoaded = true;
                }
                catch (Exception exception) {
                    conntype = 0;
                }
            } else if (localconn.getProtocolType().equals("kprb")) {
                conntype = 2;
            } else {
                throw new SQLException("Unknown connection type.");
            }
        }
        return conntype;
    }

    public Document getDOM() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_dom != null) {
            return this.m_dom;
        }
        switch (this.m_conntype) {
            case 0: {
                DOMParser p = new DOMParser();
                if (this.m_blobval != null && this.m_clobval == null) {
                    this.m_clobval = this.getClobVal();
                }
                if (this.m_stringval != null) {
                    try {
                        p.parse((Reader)new StringReader(this.m_stringval));
                    }
                    catch (XMLParseException xMLParseException) {
                        throw new SQLException();
                    }
                    catch (IOException iOException) {
                        throw new SQLException();
                    }
                    catch (SAXException sAXException) {
                        throw new SQLException();
                    }
                    this.m_dom = p.getDocument();
                    break;
                }
                if (this.m_clobval != null) {
                    try {
                        p.parse(this.m_clobval.getCharacterStream());
                    }
                    catch (XMLParseException e) {
                        throw new SQLException(((SAXException)((Object)e)).getMessage());
                    }
                    catch (IOException e) {
                        throw new SQLException(e.getMessage());
                    }
                    catch (SAXException e) {
                        throw new SQLException(e.getMessage());
                    }
                    this.m_dom = p.getDocument();
                    break;
                }
                if (this.m_bytesval == null) break;
                try {
                    p.parse((Reader)new StringReader(this.getStringFromBinaryStream()));
                }
                catch (XMLParseException xMLParseException) {
                    throw new SQLException();
                }
                catch (IOException iOException) {
                    throw new SQLException();
                }
                catch (SAXException sAXException) {
                    throw new SQLException();
                }
                this.m_dom = p.getDocument();
                break;
            }
            case 1: 
            case 2: {
                long xobdcstate = this.getXobdFromXMLType(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate);
                this.m_dom = new XDBDocument(this, (Connection)this.m_local_conn, xobdcstate);
                break;
            }
        }
        return this.m_dom;
    }

    public Document getDocument() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_dom != null) {
            return this.m_dom;
        }
        if (this.m_kind.equals("oracle.xml.parser.XMLDocument.THIN")) {
            DOMParser p = new DOMParser();
            if (this.m_blobval != null && this.m_clobval == null) {
                this.m_clobval = this.getClobVal();
            }
            if (this.m_stringval != null) {
                try {
                    p.parse((Reader)new StringReader(this.m_stringval));
                }
                catch (XMLParseException xMLParseException) {
                    throw new SQLException();
                }
                catch (IOException iOException) {
                    throw new SQLException();
                }
                catch (SAXException sAXException) {
                    throw new SQLException();
                }
                this.m_dom = p.getDocument();
            } else if (this.m_clobval != null) {
                try {
                    p.parse(this.m_clobval.getCharacterStream());
                }
                catch (XMLParseException e) {
                    throw new SQLException(((SAXException)((Object)e)).getMessage());
                }
                catch (IOException e) {
                    throw new SQLException(e.getMessage());
                }
                catch (SAXException e) {
                    throw new SQLException(e.getMessage());
                }
                this.m_dom = p.getDocument();
            } else if (this.m_bytesval != null) {
                try {
                    p.parse((Reader)new StringReader(this.getStringFromBinaryStream()));
                }
                catch (XMLParseException xMLParseException) {
                    throw new SQLException();
                }
                catch (IOException iOException) {
                    throw new SQLException();
                }
                catch (SAXException sAXException) {
                    throw new SQLException();
                }
                this.m_dom = p.getDocument();
            }
        } else if (this.m_kind.equals("oracle.xml.parser.XMLDocument.THICK")) {
            long xobdcstate = this.getXobdFromXMLType(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate);
            this.m_dom = new XMLDocument((Connection)this.m_local_conn, xobdcstate);
        }
        return this.m_dom;
    }

    public XDBDocFragment getDocumentFragment() throws SQLException {
        XDBDocFragment fragment = null;
        switch (this.m_conntype) {
            case 1: 
            case 2: {
                if (this.isFragment()) {
                    XDBDocument d = (XDBDocument)this.getDOM();
                    fragment = new XDBDocFragment(d, this.m_cstate);
                    break;
                }
                throw new SQLException();
            }
            default: {
                throw new SQLException();
            }
        }
        return fragment;
    }

    private long getErrHandle() throws SQLException {
        return XMLType.getErrorHandle((Connection)this.m_local_conn, this.m_conntype);
    }

    public static long getErrorHandle(Connection conn, int conntype) throws SQLException {
        long retval;
        switch (conntype) {
            case 1: {
                OracleConnection iconn = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin();
                Properties prop = iconn.getOCIHandles();
                retval = Long.parseLong(prop.getProperty("OCIErrHandle"));
                break;
            }
            default: {
                retval = 0L;
            }
        }
        return retval;
    }

    public InputStream getInputStream() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        long strm_c_state = this.getInputStreamNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate);
        return new RealInputStream(this.getErrHandle(), strm_c_state);
    }

    private synchronized native long getInputStreamNative(long var1, long var3, long var5, long var7);

    public String getNamespace() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        return this.getNamespaceNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate);
    }

    private synchronized native String getNamespaceNative(long var1, long var3, long var5, long var7);

    public NUMBER getNumberVal() throws SQLException {
        NUMBER result = null;
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        String strValue = this.getStringVal();
        result = NUMBER.formattedTextToNumber((String)strValue, null, null);
        return result;
    }

    public static ORADataFactory getORADataFactory() {
        return xmlfactory;
    }

    public String getRootElement() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        return this.getRootElementNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate);
    }

    private synchronized native String getRootElementNative(long var1, long var3, long var5, long var7);

    public String getSchemaURL() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        return this.getSchemaURLNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate);
    }

    private synchronized native String getSchemaURLNative(long var1, long var3, long var5, long var7);

    public static long getServiceHandle(Connection conn, int conntype) throws SQLException {
        long retval;
        switch (conntype) {
            case 1: {
                OracleConnection iconn = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin();
                Properties prop = iconn.getOCIHandles();
                retval = Long.parseLong(prop.getProperty("OCISvcCtxHandle"));
                break;
            }
            default: {
                retval = 0L;
            }
        }
        return retval;
    }

    private String getStringFromBinaryStream() throws SQLException {
        if (this.m_bytesval == null) {
            return null;
        }
        if (this.m_csid == 0) {
            return this.m_bytesval.toString();
        }
        return this.processString(this.m_blobCS, this.m_bytesval.toByteArray(), 0);
    }

    public String getStringVal() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_stringval != null) {
            return this.m_stringval;
        }
        if (this.m_clobval != null) {
            return this.getClobStr(this.m_clobval);
        }
        if (this.m_blobval != null) {
            String tmpstr = null;
            try {
                ByteArrayOutputStream bytestrm = this.getBinaryStream(this.m_blobval);
                tmpstr = this.processString(this.m_blobCS, bytestrm.toByteArray(), 0);
                bytestrm.close();
            }
            catch (IOException e) {
                throw new SQLException(e.getMessage());
            }
            return tmpstr;
        }
        if (this.m_cstate != 0L) {
            CLOB tmpclob = CLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)10);
            byte[] locbytes = tmpclob.getLocator();
            this.printToLobNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate, tmpclob.getLocator(), 0);
            String retval = this.getClobStr(tmpclob);
            CLOB.freeTemporary((CLOB)tmpclob);
            return retval;
        }
        if (this.m_bytesval != null) {
            return this.getStringFromBinaryStream();
        }
        if (this.m_dom != null) {
            CLOB tmpclob = CLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)10);
            switch (this.m_conntype) {
                case 0: {
                    try {
                        Writer xmlwr = tmpclob.getCharacterOutputStream();
                        ((XMLDocument)this.m_dom).print(xmlwr);
                        xmlwr.flush();
                        break;
                    }
                    catch (IOException iOException) {
                        throw new SQLException();
                    }
                }
                case 1: 
                case 2: {
                    this.printToLobNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate, tmpclob.getLocator(), 0);
                    break;
                }
            }
            String tmpstr = this.getClobStr(tmpclob);
            CLOB.freeTemporary((CLOB)tmpclob);
            return tmpstr;
        }
        return null;
    }

    private long getSvcHandle() throws SQLException {
        return XMLType.getServiceHandle((Connection)this.m_local_conn, this.m_conntype);
    }

    private static synchronized native long getXMLTypeFromXobd(long var0, long var2, long var4, long var6);

    private native long getXMLTypeNative(long var1, long var3, long var5, byte[] var7, int var8);

    private synchronized native long getXobdFromXMLType(long var1, long var3, long var5, long var7);

    private void initConn(Connection conn) throws SQLException {
        this.initConn(conn, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initConn(Connection conn, String kind) throws SQLException {
        block5: {
            block4: {
                this.m_local_conn = conn == null ? null : ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin();
                this.m_conntype = XMLType.getConnType(conn);
                if (kind != null) break block4;
                switch (this.m_conntype) {
                    case 0: {
                        this.m_kind = "oracle.xml.parser.XMLDocument.THIN";
                        break block5;
                    }
                    case 1: 
                    case 2: {
                        this.m_kind = "oracle.xml.parser.XMLDocument.THICK";
                        break block5;
                    }
                    default: {
                        if (this.m_conntype != 2) return;
                    }
                }
            }
            this.m_kind = kind;
        }
        if (this.m_conntype != 2) return;
        this.m_gpCState = XDBResource.getServerEnv();
    }

    private void int2Byte(int val, byte[] byteVal) {
        byteVal[0] = (byte)(val >> 24);
        byteVal[1] = (byte)((val &= 0xFFFFFF) >> 16);
        byteVal[2] = (byte)((val &= 0xFFFF) >> 8);
        byteVal[3] = (byte)(val &= 0xFF);
    }

    public boolean isFragment() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        boolean retval = this.isFragmentNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate);
        return retval;
    }

    private synchronized native boolean isFragmentNative(long var1, long var3, long var5, long var7);

    public boolean isSchemaBased() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        return this.isSchemaBasedNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate);
    }

    private synchronized native boolean isSchemaBasedNative(long var1, long var3, long var5, long var7);

    public boolean isSchemaValid(String schurl, String elname) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        boolean retval = this.isSchemaValidNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate, schurl, elname);
        return retval;
    }

    private synchronized native boolean isSchemaValidNative(long var1, long var3, long var5, long var7, String var9, String var10);

    public boolean isSchemaValidated() throws SQLException {
        boolean validated = false;
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        return this.isSchemaValidatedNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate);
    }

    private synchronized native boolean isSchemaValidatedNative(long var1, long var3, long var5, long var7);

    private synchronized native byte[] pickleXMLTypeNative(long var1, long var3, long var5, long var7);

    private synchronized native void printToLobNative(long var1, long var3, long var5, long var7, byte[] var9, int var10);

    private void processCState(byte[] byteval, int bytepos) throws SQLException {
        this.m_cstate = this.getXMLTypeNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), byteval, this.m_local_conn.getDbCsId());
    }

    private void processLob(byte[] byteval, int bytepos) throws SQLException {
        byte[] lobloc = new byte[byteval.length - bytepos];
        System.arraycopy(byteval, bytepos, lobloc, 0, byteval.length - bytepos);
        this.m_clobval = new CLOB((oracle.jdbc.OracleConnection)this.m_local_conn, lobloc);
    }

    private String processString(CharacterSet byteCS, byte[] byteval, int bytepos) throws SQLException {
        byte[] byt = new byte[byteval.length - bytepos];
        System.arraycopy(byteval, bytepos, byt, 0, byteval.length - bytepos);
        return byteCS.toString(byt, 0, byt.length);
    }

    private void processThin(byte[] byteVal, int bytepos) throws SQLException {
        short version = Util.getUnsignedByte((byte)byteVal[bytepos]);
        ++bytepos;
        if (version != 1) {
            throw new SQLException("error occurred in XMLtype conversion" + version);
        }
        this.m_thinflags = XMLType.bytesToInt(byteVal, bytepos);
        bytepos += 4;
        if ((this.m_thinflags & 0x1000) == 4096) {
            this.m_thinsnapshot = new byte[24];
            System.arraycopy(byteVal, bytepos, this.m_thinsnapshot, 0, 24);
            bytepos += 24;
        }
        if ((this.m_thinflags & 8) == 8) {
            this.m_thinschoid = new byte[16];
            System.arraycopy(byteVal, bytepos, this.m_thinschoid, 0, 16);
            this.m_thinelemnum = new byte[16];
            System.arraycopy(byteVal, bytepos += 16, this.m_thinelemnum, 0, 4);
            bytepos += 4;
        }
        if ((this.m_thinflags & 1) == 1) {
            this.processLob(byteVal, bytepos);
        } else if ((this.m_thinflags & 4) == 4) {
            this.m_stringval = this.processString(this.m_charSet, byteVal, bytepos);
        } else {
            throw new SQLException("Only LOB or String Storage is supported in Thin XMLType");
        }
    }

    public void schemaValidate() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        this.schemaValidateNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate);
    }

    private synchronized native void schemaValidateNative(long var1, long var3, long var5, long var7);

    public void setSchemaValidated(boolean validateFlag) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        this.setSchemaValidatedNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate, validateFlag);
    }

    private synchronized native void setSchemaValidatedNative(long var1, long var3, long var5, long var7, boolean var9);

    public byte[] toBytes() throws SQLException {
        return ((OPAQUE)this.toDatum((Connection)this.m_local_conn)).toBytes();
    }

    public Datum toDatum(Connection conn) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        switch (this.m_conntype) {
            case 0: {
                return new OPAQUE(OpaqueDescriptor.createDescriptor((String)_SQL_NAME, (Connection)conn), conn, (Object)this.getBytesValue());
            }
            case 1: 
            case 2: {
                OracleConnection iconn = conn == null ? null : ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin();
                byte[] bval = this.getBytesPtr(iconn);
                OPAQUE opq = new OPAQUE(OpaqueDescriptor.createDescriptor((String)_SQL_NAME, (Connection)iconn), (Connection)iconn, (Object)bval);
                return opq;
            }
        }
        return null;
    }

    public XMLType transform(XMLType xsldoc, String parammap) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0 || xsldoc == null) {
            throw new SQLException();
        }
        long retcstate = this.transformNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate, xsldoc.m_cstate, parammap);
        if (retcstate != 0L) {
            return new XMLType((Connection)this.m_local_conn, retcstate);
        }
        return null;
    }

    private synchronized native long transformNative(long var1, long var3, long var5, long var7, long var9, String var11);

    private static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    private void writePreamble(ByteArrayOutputStream strm, int ver, int flag) throws IOException {
        strm.write(1);
        byte[] flagVal = new byte[4];
        if ((this.m_thinflags & 0x1000) == 4096) {
            flag &= 0x1000;
        }
        if ((this.m_thinflags & 8) == 8) {
            flag &= 8;
        }
        this.int2Byte(flag, flagVal);
        strm.write(flagVal);
        if ((this.m_thinflags & 0x1000) == 4096) {
            strm.write(this.m_thinsnapshot);
        }
        if ((this.m_thinflags & 8) == 8) {
            strm.write(this.m_thinschoid);
            strm.write(this.m_thinelemnum);
        }
    }

    public void writeToOutputStream(OutputStream os) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        InputStream is = this.getInputStream();
        byte[] buf = new byte[1024];
        try {
            int len;
            while ((len = is.read(buf)) != -1) {
                os.write(buf, 0, len);
            }
        }
        catch (IOException iOException) {
            throw new SQLException();
        }
    }
}

