/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.dependency;

import com.projity.association.AssociationFormat;
import com.projity.association.AssociationFormatParameters;
import com.projity.configuration.Settings;
import com.projity.datatype.Duration;
import com.projity.datatype.DurationFormat;
import com.projity.field.FieldParseException;
import com.projity.options.GeneralOption;
import com.projity.pm.dependency.Dependency;
import com.projity.pm.dependency.DependencyType;
import com.projity.pm.dependency.HasDependencies;
import com.projity.pm.task.Task;
import com.projity.strings.Messages;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Collection;

public class DependencyFormat
extends AssociationFormat {
    private static NumberFormat integerFormat = NumberFormat.getIntegerInstance();

    public static DependencyFormat getInstance(AssociationFormatParameters associationFormatParameters) {
        return new DependencyFormat(associationFormatParameters);
    }

    private DependencyFormat(AssociationFormatParameters associationFormatParameters) {
        super(associationFormatParameters);
    }

    private String getErrorMessage(String string) {
        String string2 = MessageFormat.format(Messages.getString("Message.invalidDependency.mf"), this.parameters.isLeftAssociation() ? Messages.getString("Text.predecessor") : Messages.getString("Text.successor"));
        return string2;
    }

    private Object doParse(String string, ParsePosition parsePosition) throws ParseException {
        Duration duration;
        Integer n;
        Long l = (Long)integerFormat.parseObject(string, parsePosition);
        if (l == null) {
            throw new ParseException(this.getErrorMessage(string), parsePosition.getIndex());
        }
        Object object = null;
        Collection collection = this.getContainer(this.parameters.isLeftAssociation());
        if (collection != null) {
            object = this.parameters.getIdField().find(l, collection);
        }
        if (object == null) {
            if (GeneralOption.getInstance().isAutomaticallyAddNewResourcesAndTasks()) {
                object = this.createNewObject(this.parameters.isLeftAssociation());
                try {
                    this.parameters.getIdField().setText(object, l.toString(), null);
                }
                catch (FieldParseException fieldParseException) {
                    throw new ParseException(fieldParseException.getMessage(), 0);
                }
            } else {
                throw new ParseException(this.getErrorMessage(string), parsePosition.getIndex());
            }
        }
        if ((n = (Integer)DependencyType.Format.getInstance().parseObject(string, parsePosition)) == null) {
            throw new ParseException(this.getErrorMessage(string), parsePosition.getIndex());
        }
        String string2 = string.substring(parsePosition.getIndex()).trim();
        if (string2.length() == 0) {
            duration = Duration.ZERO;
        } else {
            duration = (Duration)DurationFormat.getInstance().parseObject(string, parsePosition);
            if (duration == null) {
                throw new ParseException(this.getErrorMessage(string), parsePosition.getIndex());
            }
        }
        return Dependency.getInstance(this.parameters.isLeftAssociation() ? (HasDependencies)object : (HasDependencies)this.parameters.getThisObject(), this.parameters.isLeftAssociation() ? (HasDependencies)this.parameters.getThisObject() : (HasDependencies)object, n, duration.getEncodedMillis());
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        try {
            return this.doParse(string, parsePosition);
        }
        catch (ParseException parseException) {
            this.parameters.setError(parseException.getMessage());
            return null;
        }
    }

    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        Dependency dependency = (Dependency)object;
        Task task = (Task)(this.parameters.isLeftAssociation() ? dependency.getPredecessor() : dependency.getSuccessor());
        stringBuffer.append(this.parameters.getIdField().getValue(task, null));
        boolean bl = !Duration.isZero(dependency.getLag());
        StringBuffer stringBuffer2 = new StringBuffer();
        if (!DependencyType.isDefault(dependency.getDependencyType()) || bl) {
            stringBuffer2.append(DependencyType.mapValueToString(new Integer(dependency.getDependencyType())));
        }
        Duration duration = new Duration(dependency.getLag());
        if (bl) {
            stringBuffer2.append(DurationFormat.getSignedInstance().format(duration));
        }
        if (stringBuffer2.length() != 0) {
            if (this.parameters.isEncloseInBrackets()) {
                stringBuffer.append(Settings.LEFT_BRACKET);
            }
            stringBuffer.append(stringBuffer2);
            if (this.parameters.isEncloseInBrackets()) {
                stringBuffer.append(Settings.RIGHT_BRACKET);
            }
        }
        return stringBuffer;
    }

    protected Collection getContainer(boolean bl) {
        return ((Task)this.parameters.getThisObject()).getProject().getTasks();
    }

    protected Object createNewObject(boolean bl) {
        return ((Task)this.parameters.getThisObject()).getProject().newNormalTaskInstance();
    }
}

