/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre.core.pm.exchange.converters.openproj;

import com.projectlibre.core.pm.exchange.converters.openproj.OpenprojImportState;
import com.projectlibre.core.pm.exchange.converters.openproj.OpenprojRangeConverter;
import com.projectlibre.pm.calendar.WorkCalendar;
import com.projectlibre.pm.calendar.WorkCalendarException;
import com.projectlibre.pm.calendar.WorkDay;
import com.projectlibre.pm.calendar.WorkWeek;
import com.projity.configuration.CircularDependencyException;
import com.projity.pm.calendar.CalendarService;
import com.projity.pm.calendar.WorkingCalendar;
import com.projity.util.DateTime;

public class OpenprojCalendarConverter {
    public void to(WorkingCalendar workingCalendar, WorkCalendar workCalendar, OpenprojImportState openprojImportState) {
        workingCalendar.setId(workCalendar.getId().getLocalId());
        String string = workCalendar.getName();
        workingCalendar.setName(workCalendar.getName());
        WorkingCalendar workingCalendar2 = CalendarService.getInstance().getStandardInstance();
        WorkingCalendar workingCalendar3 = null;
        if (workCalendar.getBase() != null) {
            workingCalendar3 = openprojImportState.getMappedOpenprojBaseCalendar(workCalendar.getId());
            try {
                workingCalendar.setBaseCalendar(workingCalendar3);
            }
            catch (CircularDependencyException circularDependencyException) {
                circularDependencyException.printStackTrace();
            }
        }
        OpenprojRangeConverter openprojRangeConverter = new OpenprojRangeConverter();
        WorkWeek workWeek = workCalendar.getWeek();
        for (int i = 0; i < 7; ++i) {
            com.projity.pm.calendar.WorkDay workDay;
            WorkDay workDay2 = workWeek.getDay(i);
            if (workDay2 == null) {
                workDay = null;
                if (workCalendar.getBase() == null && workingCalendar2.getWeekDay(i).isWorking()) {
                    workDay = com.projity.pm.calendar.WorkDay.getNonWorkingDay();
                }
            } else {
                switch (workDay2.getType()) {
                    case NON_WORKING: {
                        workDay = com.projity.pm.calendar.WorkDay.getNonWorkingDay();
                        break;
                    }
                    default: {
                        workDay = new com.projity.pm.calendar.WorkDay();
                        openprojRangeConverter.to(workDay, workDay2);
                        if (workCalendar.getBase() != null || !workingCalendar2.getWeekDay(i).hasSameWorkHours(workDay)) break;
                        workDay = null;
                    }
                }
            }
            workingCalendar.setWeekDay(i, workDay);
        }
        for (WorkCalendarException workCalendarException : workCalendar.getExceptions()) {
            long l = workCalendarException.getStart();
            while (l < workCalendarException.getEnd()) {
                com.projity.pm.calendar.WorkDay workDay = new com.projity.pm.calendar.WorkDay(l, l);
                openprojRangeConverter.to(workDay, workCalendarException);
                workingCalendar.addOrReplaceException(workDay);
                l = DateTime.nextDay(l);
            }
        }
        workingCalendar.removeEmptyDays();
        for (int i = 0; i < 7; ++i) {
            System.out.println(workingCalendar.getWeekDay(i));
        }
    }
}

