/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.indent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.php.editor.indent.CodeStyle;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.CastExpression;
import org.netbeans.modules.php.editor.parser.astnodes.CatchClause;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ConditionalExpression;
import org.netbeans.modules.php.editor.parser.astnodes.DoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ForEachStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ForStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionName;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.IfStatement;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.editor.parser.astnodes.SwitchStatement;
import org.netbeans.modules.php.editor.parser.astnodes.TryStatement;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatement;
import org.netbeans.modules.php.editor.parser.astnodes.WhileStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultTreePathVisitor;

class WSTransformer
extends DefaultTreePathVisitor {
    private String newLineReplacement = "\n";
    private Context context;
    private List<Replacement> replacements = new LinkedList<Replacement>();
    private Collection<CodeRange> unbreakableRanges = new TreeSet<CodeRange>();
    private Collection<Integer> breakPins = new LinkedList<Integer>();
    protected static List<PHPTokenId> WS_AND_COMMENT_TOKENS = Arrays.asList(PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.WHITESPACE, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_LINE_COMMENT);
    private final List<PHPTokenId> COMMENT_TOKENS = Arrays.asList(PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_LINE_COMMENT);
    private final Collection<PHPTokenId> NO_BREAK_B4_TKNS = Arrays.asList(PHPTokenId.PHP_CLOSETAG, PHPTokenId.PHP_ELSE, PHPTokenId.PHP_ELSEIF, PHPTokenId.PHP_ELSE, PHPTokenId.PHP_CATCH, PHPTokenId.PHP_WHILE);
    private final List<String> ASSIGN_OPERATORS = Arrays.asList("=", ".=", "=.", "+=", "=+", "=-", "-=");
    private final List<String> BINARY_OPERATORS = Arrays.asList("+", "-", "*", "/", "<", ">", "<>", "<=", ">=", "==", "===", "%", "&", "|", "^", "~", "<<", ">>", "!=", "!==", ".", "&&", "||");
    private final List<String> UNARY_OPERATOS = Arrays.asList("++", "--", "!");
    private boolean isMethod;

    public WSTransformer(Context context) {
        this.context = context;
        this.isMethod = false;
    }

    @Override
    public void visit(Program node) {
        super.visit(node);
        TokenSequence<PHPTokenId> ts = this.tokenSequence(node.getStartOffset());
        boolean spaceCheckAfterKeywords = CodeStyle.get(this.context.document()).spaceCheckAfterKeywords();
        List<PHPTokenId> keywordsToCheckSpaceAfter = Arrays.asList(PHPTokenId.PHP_ABSTRACT, PHPTokenId.PHP_CLASS, PHPTokenId.PHP_CONST, PHPTokenId.PHP_DECLARE, PHPTokenId.PHP_ECHO, PHPTokenId.PHP_FINAL, PHPTokenId.PHP_FUNCTION, PHPTokenId.PHP__FILE__, PHPTokenId.PHP__FUNCTION__, PHPTokenId.PHP_GLOBAL, PHPTokenId.PHP_GOTO, PHPTokenId.PHP_IMPLEMENTS, PHPTokenId.PHP_INCLUDE, PHPTokenId.PHP_INCLUDE_ONCE, PHPTokenId.PHP_INTERFACE, PHPTokenId.PHP_NAMESPACE, PHPTokenId.PHP_NEW, PHPTokenId.PHP_PRINT, PHPTokenId.PHP_PRIVATE, PHPTokenId.PHP_PROTECTED, PHPTokenId.PHP_PUBLIC, PHPTokenId.PHP_REQUIRE, PHPTokenId.PHP_REQUIRE_ONCE, PHPTokenId.PHP_RETURN, PHPTokenId.PHP_STATIC, PHPTokenId.PHP_THROW, PHPTokenId.PHP_USE, PHPTokenId.PHP_VAR);
        List<PHPTokenId> keywordsNewLine = Arrays.asList(PHPTokenId.PHP_ELSE, PHPTokenId.PHP_ELSEIF, PHPTokenId.PHP_CATCH, PHPTokenId.PHP_WHILE);
        ArrayList<PHPTokenId> lookingForTokens = new ArrayList<PHPTokenId>();
        lookingForTokens.addAll(Arrays.asList(PHPTokenId.PHP_TOKEN, PHPTokenId.PHP_OPERATOR, PHPTokenId.PHP_OBJECT_OPERATOR, PHPTokenId.PHP_SEMICOLON, PHPTokenId.PHP_INSTANCEOF));
        lookingForTokens.addAll(keywordsToCheckSpaceAfter);
        lookingForTokens.addAll(keywordsNewLine);
        while (ts.moveNext()) {
            int offset;
            Token<? extends PHPTokenId> token = LexUtilities.findNextToken(ts, lookingForTokens);
            if (token.id() == PHPTokenId.PHP_OBJECT_OPERATOR) {
                this.checkSpaceAroundToken(ts, CodeStyle.get(this.context.document()).spaceAroundObjectOps());
                continue;
            }
            if (token.id() == PHPTokenId.PHP_INSTANCEOF) {
                this.checkSpaceAroundToken(ts, true);
                continue;
            }
            if (token.id() == PHPTokenId.PHP_RETURN && ts.moveNext()) {
                if (ts.token().id() == PHPTokenId.PHP_SEMICOLON) continue;
                LexUtilities.findNext(ts, Arrays.asList(PHPTokenId.WHITESPACE));
                if (ts.token().id() != PHPTokenId.PHP_SEMICOLON) {
                    this.replaceSpaceBeforeToken(ts, true, null);
                    continue;
                }
                this.replaceSpaceBeforeToken(ts, false, null);
                continue;
            }
            if ((token.id() == PHPTokenId.PHP_REQUIRE || token.id() == PHPTokenId.PHP_REQUIRE_ONCE || token.id() == PHPTokenId.PHP_INCLUDE || token.id() == PHPTokenId.PHP_INCLUDE_ONCE) && ts.moveNext()) {
                LexUtilities.findNext(ts, Arrays.asList(PHPTokenId.WHITESPACE));
                if (ts.token().id() == PHPTokenId.PHP_TOKEN) {
                    this.replaceSpaceBeforeToken(ts, CodeStyle.get(this.context.document()).spaceBeforeMethodDeclParen(), null);
                    continue;
                }
                this.replaceSpaceBeforeToken(ts, true, null);
                continue;
            }
            if (keywordsToCheckSpaceAfter.contains(ts.token().id()) && spaceCheckAfterKeywords && ts.moveNext()) {
                LexUtilities.findNext(ts, WS_AND_COMMENT_TOKENS);
                this.replaceSpaceBeforeToken(ts, true, null);
                continue;
            }
            if (token.id() == PHPTokenId.PHP_SEMICOLON) {
                this.replaceSpaceBeforeToken(ts, CodeStyle.get(this.context.document()).spaceBeforeSemi(), null);
                LexUtilities.findNextToken(ts, Arrays.asList(PHPTokenId.PHP_SEMICOLON));
                if (!ts.moveNext() || ts.token().id() != PHPTokenId.WHITESPACE || WSTransformer.textContainsBreak(ts.token().text()) || !ts.moveNext() || ts.token().id() == PHPTokenId.WHITESPACE || this.isComment((Token<? extends PHPTokenId>)ts.token())) continue;
                int offset2 = ts.offset();
                this.replaceSpaceBeforeToken(ts, CodeStyle.get(this.context.document()).spaceAfterSemi(), null);
                ts.move(offset2);
                ts.moveNext();
                continue;
            }
            if (keywordsNewLine.contains(token.id())) {
                int offset3 = ts.offset();
                if (ts.movePrevious()) {
                    LexUtilities.findPrevious(ts, WS_AND_COMMENT_TOKENS);
                    if (ts.token().id() == PHPTokenId.PHP_CURLY_CLOSE) {
                        ts.move(offset3);
                        ts.moveNext();
                        boolean newLine = false;
                        boolean space = true;
                        if (token.id() == PHPTokenId.PHP_ELSE || token.id() == PHPTokenId.PHP_ELSEIF) {
                            newLine = CodeStyle.get(this.context.document()).placeElseOnNewLine();
                            space = CodeStyle.get(this.context.document()).spaceBeforeElse();
                        } else if (token.id() == PHPTokenId.PHP_WHILE) {
                            newLine = CodeStyle.get(this.context.document()).placeWhileOnNewLine();
                            space = CodeStyle.get(this.context.document()).spaceBeforeWhile();
                        } else if (token.id() == PHPTokenId.PHP_CATCH) {
                            newLine = CodeStyle.get(this.context.document()).placeCatchOnNewLine();
                            space = CodeStyle.get(this.context.document()).spaceBeforeCatch();
                        }
                        Object replace = null;
                        if (ts.movePrevious() && ts.token().id() == PHPTokenId.WHITESPACE) {
                            int countNewLines = this.countOfNewLines(ts.token().text());
                            if (newLine && countNewLines != 1) {
                                this.replacements.add(new Replacement(ts.offset() + ts.token().length(), ts.token().length(), "\n"));
                            }
                            if (!newLine && countNewLines > 0 || !newLine && (!space && ts.token().length() > 0 || space && ts.token().length() != 1)) {
                                ts.moveNext();
                                this.replaceSpaceBeforeToken(ts, space, Arrays.asList(PHPTokenId.PHP_CURLY_CLOSE));
                            }
                        } else if (newLine) {
                            this.replacements.add(new Replacement(offset3, 0, "\n"));
                        } else {
                            ts.moveNext();
                            this.replaceSpaceBeforeToken(ts, space, Arrays.asList(PHPTokenId.PHP_CURLY_CLOSE));
                        }
                    }
                }
                ts.move(offset3);
                ts.moveNext();
                continue;
            }
            String text = ((Object)token.text()).toString();
            if (".".equals(text)) {
                offset = ts.offset();
                boolean isStringConcat = false;
                if (ts.moveNext()) {
                    token = LexUtilities.findNext(ts, WS_AND_COMMENT_TOKENS);
                    isStringConcat = token.id() == PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING;
                    ts.move(offset);
                    ts.moveNext();
                }
                if (!isStringConcat && ts.movePrevious()) {
                    token = LexUtilities.findPrevious(ts, WS_AND_COMMENT_TOKENS);
                    isStringConcat = token.id() == PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING;
                    ts.move(offset);
                    ts.moveNext();
                }
                if (!isStringConcat) continue;
                this.checkSpaceAroundToken(ts, CodeStyle.get(this.context.document()).spaceAroundStringConcatOps());
                continue;
            }
            if (",".equals(text)) {
                offset = ts.offset();
                this.replaceSpaceBeforeToken(ts, CodeStyle.get(this.context.document()).spaceBeforeComma(), null);
                ts.move(offset);
                if (!ts.moveNext() || !ts.moveNext()) continue;
                LexUtilities.findNext(ts, WS_AND_COMMENT_TOKENS);
                this.replaceSpaceBeforeToken(ts, CodeStyle.get(this.context.document()).spaceAfterComma(), null);
                continue;
            }
            if ("=>".equals(text)) {
                this.checkSpaceAroundToken(ts, CodeStyle.get(this.context.document()).spaceAroundKeyValueOps());
                continue;
            }
            if (this.ASSIGN_OPERATORS.contains(text)) {
                this.checkSpaceAroundToken(ts, CodeStyle.get(this.context.document()).spaceAroundAssignOps());
                continue;
            }
            if (this.BINARY_OPERATORS.contains(text)) {
                this.checkSpaceAroundToken(ts, CodeStyle.get(this.context.document()).spaceAroundBinaryOps());
                continue;
            }
            if (!this.UNARY_OPERATOS.contains(text)) continue;
            boolean check = false;
            int position = ts.offset();
            if (ts.moveNext()) {
                LexUtilities.findNext(ts, WS_AND_COMMENT_TOKENS);
                if (ts.token().id() != PHPTokenId.PHP_TOKEN) {
                    check = true;
                    ts.move(position);
                    ts.moveNext();
                }
            } else {
                check = true;
            }
            if (!check) continue;
            this.checkSpaceAroundToken(ts, CodeStyle.get(this.context.document()).spaceAroundUnaryOps());
        }
    }

    @Override
    public void visit(Block node) {
        ASTNode parent = this.getPath().get(0);
        if (parent instanceof NamespaceDeclaration) {
            super.visit(node);
            return;
        }
        if (node.isCurly()) {
            CodeStyle.BracePlacement openingBraceStyle = parent instanceof ClassDeclaration || parent instanceof InterfaceDeclaration ? CodeStyle.get(this.context.document()).getClassDeclBracePlacement() : (parent instanceof FunctionDeclaration || parent instanceof MethodDeclaration ? CodeStyle.get(this.context.document()).getMethodDeclBracePlacement() : (parent instanceof IfStatement ? CodeStyle.get(this.context.document()).getIfBracePlacement() : (parent instanceof ForStatement || parent instanceof ForEachStatement ? CodeStyle.get(this.context.document()).getForBracePlacement() : (parent instanceof WhileStatement || parent instanceof DoStatement ? CodeStyle.get(this.context.document()).getWhileBracePlacement() : (parent instanceof SwitchStatement ? CodeStyle.get(this.context.document()).getSwitchBracePlacement() : (parent instanceof CatchClause || parent instanceof TryStatement ? CodeStyle.get(this.context.document()).getCatchBracePlacement() : CodeStyle.get(this.context.document()).getOtherBracePlacement()))))));
            String string = this.newLineReplacement = CodeStyle.BracePlacement.NEW_LINE == openingBraceStyle || CodeStyle.BracePlacement.NEW_LINE_INDENTED == openingBraceStyle ? "\n" : " ";
            if (CodeStyle.BracePlacement.NEW_LINE != openingBraceStyle && CodeStyle.BracePlacement.NEW_LINE_INDENTED != openingBraceStyle && this.getPath().size() > 0) {
                if (parent instanceof ClassDeclaration || parent instanceof InterfaceDeclaration) {
                    this.newLineReplacement = CodeStyle.get(this.context.document()).spaceBeforeClassDeclLeftBrace() ? " " : "";
                } else if (parent instanceof FunctionDeclaration) {
                    this.newLineReplacement = CodeStyle.get(this.context.document()).spaceBeforeMethodDeclLeftBrace() ? " " : "";
                } else if (parent instanceof IfStatement) {
                    IfStatement ifStatement = (IfStatement)parent;
                    this.newLineReplacement = node.getStartOffset() == ifStatement.getTrueStatement().getStartOffset() ? (CodeStyle.get(this.context.document()).spaceBeforeIfLeftBrace() ? " " : "") : (CodeStyle.get(this.context.document()).spaceBeforeElseLeftBrace() ? " " : "");
                } else if (parent instanceof WhileStatement) {
                    this.newLineReplacement = CodeStyle.get(this.context.document()).spaceBeforeWhileLeftBrace() ? " " : "";
                } else if (parent instanceof DoStatement) {
                    this.newLineReplacement = CodeStyle.get(this.context.document()).spaceBeforeDoLeftBrace() ? " " : "";
                } else if (parent instanceof SwitchStatement) {
                    this.newLineReplacement = CodeStyle.get(this.context.document()).spaceBeforeSwitchLeftBrace() ? " " : "";
                } else if (parent instanceof ForStatement || parent instanceof ForEachStatement) {
                    this.newLineReplacement = CodeStyle.get(this.context.document()).spaceBeforeForLeftBrace() ? " " : "";
                } else if (parent instanceof TryStatement) {
                    this.newLineReplacement = CodeStyle.get(this.context.document()).spaceBeforeTryLeftBrace() ? " " : "";
                } else if (parent instanceof CatchClause) {
                    this.newLineReplacement = CodeStyle.get(this.context.document()).spaceBeforeCatchLeftBrace() ? " " : "";
                }
            }
            TokenSequence<PHPTokenId> tokenSequence = this.tokenSequence(node.getStartOffset());
            tokenSequence.move(node.getStartOffset());
            if (tokenSequence.moveNext() && tokenSequence.token().id() == PHPTokenId.PHP_CURLY_OPEN) {
                boolean precededByOpenTag;
                int start = tokenSequence.offset();
                int length = 0;
                if (tokenSequence.movePrevious() && tokenSequence.token().id() == PHPTokenId.WHITESPACE) {
                    length = tokenSequence.token().length();
                    if (CodeStyle.BracePlacement.PRESERVE_EXISTING == openingBraceStyle && this.countOfNewLines(tokenSequence.token().text()) > 0) {
                        this.newLineReplacement = "\n";
                    }
                }
                boolean bl = precededByOpenTag = tokenSequence.token().id() == PHPTokenId.PHP_OPENTAG;
                if (!precededByOpenTag && length > 0 && tokenSequence.movePrevious()) {
                    boolean bl2 = precededByOpenTag = tokenSequence.token().id() == PHPTokenId.PHP_OPENTAG;
                }
                if (!precededByOpenTag) {
                    Replacement preOpenBracket = new Replacement(start, length, this.newLineReplacement);
                    this.replacements.add(preOpenBracket);
                }
            }
            tokenSequence.move(node.getStartOffset());
            if (tokenSequence.moveNext() && !this.doNotSplitLine(tokenSequence, true)) {
                Replacement postOpen = new Replacement(tokenSequence.offset() + tokenSequence.token().length(), 0, "\n");
                this.replacements.add(postOpen);
            }
            tokenSequence.move(node.getEndOffset());
            if (tokenSequence.movePrevious()) {
                int closPos = tokenSequence.offset();
                if (!this.doNotSplitLine(tokenSequence, false)) {
                    tokenSequence.movePrevious();
                    if (tokenSequence.token().id() != PHPTokenId.PHP_SEMICOLON && tokenSequence.token().id() != PHPTokenId.PHP_OPENTAG) {
                        Replacement preClose = new Replacement(closPos, 0, "\n");
                        this.replacements.add(preClose);
                    }
                    tokenSequence.moveNext();
                }
                tokenSequence.move(node.getEndOffset());
                if (tokenSequence.movePrevious() && !this.doNotSplitLine(tokenSequence, true)) {
                    tokenSequence.move(node.getEndOffset());
                    if (tokenSequence.moveNext()) {
                        PHPTokenId id;
                        if (tokenSequence.token().id() == PHPTokenId.WHITESPACE) {
                            tokenSequence.moveNext();
                        }
                        if (!((id = (PHPTokenId)tokenSequence.token().id()) == PHPTokenId.PHP_SEMICOLON || id == PHPTokenId.PHP_TOKEN && TokenUtilities.equals((CharSequence)tokenSequence.token().text(), (Object)","))) {
                            Replacement postClose = new Replacement(tokenSequence.offset() + tokenSequence.token().length(), 0, "\n");
                            this.replacements.add(postClose);
                        }
                    }
                }
            }
        }
        super.visit(node);
    }

    @Override
    public void visit(ClassDeclaration node) {
        ASTNode nextNode;
        int insertLines = 0;
        ASTNode previousNode = this.previousNode(node);
        insertLines = previousNode == null ? CodeStyle.get(this.context.document()).getBlankLinesBeforeClass() : this.insertLineBeforeAfter(this.astNodeToType(previousNode), this.astNodeToType(node));
        this.checkEmptyLinesBefore(node.getStartOffset(), insertLines, true);
        TokenSequence<PHPTokenId> ts = this.tokenSequence(node.getStartOffset());
        List<Statement> statements = node.getBody().getStatements();
        if (statements.size() == 0 || !this.isBlankLinesInteresting(statements.get(0))) {
            insertLines = this.insertLineBeforeAfter(ElemType.CLASS, ElemType.CLASS_HEADER);
            ts.move(node.getStartOffset());
            if (ts.moveNext() && ts.moveNext()) {
                LexUtilities.findNextToken(ts, Arrays.asList(PHPTokenId.PHP_CURLY_OPEN));
                this.checkEmptyLinesBefore(ts.offset() + 1, insertLines, true);
            }
        }
        ts = this.tokenSequence(node.getEndOffset());
        ts.move(node.getEndOffset());
        if (ts.movePrevious()) {
            LexUtilities.findNextToken(ts, Arrays.asList(PHPTokenId.PHP_CURLY_CLOSE));
            if (ts.token().id() == PHPTokenId.PHP_CURLY_CLOSE) {
                insertLines = statements.size() == 0 ? this.insertLineBeforeAfter(ElemType.CLASS_HEADER, ElemType.CLASS_BEFORE_END) : this.insertLineBeforeAfter(this.astNodeToType(statements.get(statements.size() - 1)), ElemType.CLASS_BEFORE_END);
                this.checkEmptyLinesBefore(node.getEndOffset() - 1, insertLines, true);
            }
        }
        if ((nextNode = this.nextNode(node)) == null || !this.isBlankLinesInteresting(nextNode)) {
            this.checkEmptyLinesBefore(node.getEndOffset() + 1, CodeStyle.get(this.context.document()).getBlankLinesAfterClass(), false);
        }
        if (node.getInterfaes() != null && node.getInterfaes().size() > 1) {
            CodeStyle.WrapStyle style = CodeStyle.get(this.context.document()).wrapExtendsImplementsList();
            this.wrapNodes(node.getInterfaes(), false, style);
        }
        super.visit(node);
    }

    @Override
    public void visit(MethodDeclaration node) {
        this.visitFunctionMethodDeclaration(node);
        this.isMethod = true;
        super.visit(node);
        this.isMethod = false;
    }

    @Override
    public void visit(FunctionDeclaration node) {
        if (!this.isMethod) {
            this.visitFunctionMethodDeclaration(node);
        }
        super.visit(node);
    }

    private void visitFunctionMethodDeclaration(ASTNode node) {
        int insertLines = 0;
        ASTNode previousNode = this.previousNode(node);
        insertLines = previousNode == null ? CodeStyle.get(this.context.document()).getBlankLinesBeforeFunction() : this.insertLineBeforeAfter(this.astNodeToType(previousNode), this.astNodeToType(node));
        this.checkEmptyLinesBefore(node.getStartOffset(), insertLines, true);
        List<FormalParameter> parameters = null;
        List<Statement> statements = null;
        int endOffset = node.getEndOffset() - 1;
        if (node instanceof MethodDeclaration) {
            MethodDeclaration md = (MethodDeclaration)node;
            if (md.getFunction().getBody() != null) {
                statements = md.getFunction().getBody().getStatements();
            } else {
                endOffset = node.getEndOffset();
            }
            parameters = md.getFunction().getFormalParameters();
        } else if (node instanceof FunctionDeclaration) {
            FunctionDeclaration fd = (FunctionDeclaration)node;
            statements = fd.getBody().getStatements();
            parameters = fd.getFormalParameters();
        }
        insertLines = statements == null || statements.size() == 0 ? this.insertLineBeforeAfter(ElemType.FUNCTION, ElemType.FUNCTION_BEFORE_END) : this.insertLineBeforeAfter(this.astNodeToType(statements.get(statements.size() - 1)), ElemType.FUNCTION_BEFORE_END);
        this.checkEmptyLinesBefore(endOffset, insertLines, true);
        ASTNode nextNode = this.nextNode(node);
        if (nextNode == null || !this.isBlankLinesInteresting(nextNode)) {
            this.checkEmptyLinesBefore(node.getEndOffset(), CodeStyle.get(this.context.document()).getBlankLinesAfterFunction(), false);
        }
        Identifier name = null;
        if (node instanceof FunctionDeclaration) {
            name = ((FunctionDeclaration)node).getFunctionName();
        }
        if (node instanceof MethodDeclaration) {
            name = ((MethodDeclaration)node).getFunction().getFunctionName();
        }
        if (name != null) {
            this.checkSpaceBetweenTokenAndOpenParen(name.getStartOffset(), CodeStyle.get(this.context.document()).spaceBeforeMethodDeclParen(), Arrays.asList(PHPTokenId.PHP_STRING));
        }
        if (parameters != null && parameters.size() > 0) {
            this.checkSpacesWithinParents(parameters.get(0).getStartOffset(), parameters.get(parameters.size() - 1).getEndOffset(), CodeStyle.get(this.context.document()).spaceWithinMethodDeclParens());
        }
        if (parameters != null && parameters.size() > 1) {
            CodeStyle.WrapStyle style = CodeStyle.get(this.context.document()).wrapMethodParams();
            this.wrapNodes(parameters, false, style);
        }
    }

    @Override
    public void visit(FunctionName node) {
        super.visit(node);
        this.checkSpaceBetweenTokenAndOpenParen(node.getName().getEndOffset(), CodeStyle.get(this.context.document()).spaceBeforeMethodCallParen(), Arrays.asList(PHPTokenId.PHP_STRING));
    }

    @Override
    public void visit(FunctionInvocation node) {
        List<Expression> parameters = node.getParameters();
        if (parameters != null && parameters.size() > 0) {
            this.checkSpacesWithinParents(parameters.get(0).getStartOffset(), parameters.get(parameters.size() - 1).getEndOffset(), CodeStyle.get(this.context.document()).spaceWithinMethodCallParens());
        }
        if (parameters != null && parameters.size() > 1) {
            CodeStyle.WrapStyle style = CodeStyle.get(this.context.document()).wrapMethodCallArgs();
            this.wrapNodes(parameters, false, style);
        }
        super.visit(node);
    }

    @Override
    public void visit(ClassInstanceCreation node) {
        List<Expression> parameters = node.ctorParams();
        if (parameters != null && parameters.size() > 0) {
            this.checkSpacesWithinParents(parameters.get(0).getStartOffset(), parameters.get(parameters.size() - 1).getEndOffset(), CodeStyle.get(this.context.document()).spaceWithinMethodCallParens());
        }
        super.visit(node);
    }

    @Override
    public void visit(CastExpression node) {
        TokenSequence<PHPTokenId> ts = this.tokenSequence(node.getStartOffset());
        ts.move(node.getStartOffset());
        if (ts.movePrevious() && ts.moveNext() && ts.token().id() == PHPTokenId.PHP_CASTING) {
            CharSequence text = ts.token().text();
            boolean space = CodeStyle.get(this.context.document()).spaceWithinTypeCastParens();
            int spaceAtStart = 0;
            int spaceAtEnd = 0;
            while (text.charAt(1 + spaceAtStart) == ' ') {
                ++spaceAtStart;
            }
            while (text.charAt(text.length() - 2 - spaceAtEnd) == ' ') {
                ++spaceAtEnd;
            }
            if (space && spaceAtStart != 1) {
                this.replacements.add(new Replacement(ts.offset() + 1 + spaceAtStart, spaceAtStart, " "));
            }
            if (space && spaceAtEnd != 1) {
                this.replacements.add(new Replacement(ts.offset() + text.length() - 1, spaceAtEnd, " "));
            }
            if (!space && spaceAtStart > 0) {
                this.replacements.add(new Replacement(ts.offset() + 1 + spaceAtStart, spaceAtStart, ""));
            }
            if (!space && spaceAtEnd > 0) {
                this.replacements.add(new Replacement(ts.offset() + text.length() - 1, spaceAtEnd, ""));
            }
            ts.moveNext();
            LexUtilities.findNext(ts, WS_AND_COMMENT_TOKENS);
            this.replaceSpaceBeforeToken(ts, CodeStyle.get(this.context.document()).spaceAfterTypeCast(), Arrays.asList(PHPTokenId.PHP_CASTING));
        }
        super.visit(node);
    }

    @Override
    public void visit(NamespaceDeclaration node) {
        int insertLines = 0;
        ASTNode pnode = this.previousNode(node);
        insertLines = pnode == null ? CodeStyle.get(this.context.document()).getBlankLinesBeforeNamespace() : this.insertLineBeforeAfter(this.astNodeToType(pnode), this.astNodeToType(node));
        this.checkEmptyLinesBefore(node.getStartOffset(), insertLines, true);
        ASTNode aSTNode = pnode = node.getBody().getStatements().size() > 0 ? node.getBody().getStatements().get(0) : null;
        if (pnode == null || !this.isBlankLinesInteresting(pnode)) {
            insertLines = CodeStyle.get(this.context.document()).getBlankLinesAfterNamespace();
            TokenSequence<PHPTokenId> ts = this.tokenSequence(node.getStartOffset());
            ts.move(node.getStartOffset());
            if (ts.moveNext() && ts.moveNext()) {
                LexUtilities.findEndOfLine(ts);
                this.checkEmptyLinesBefore(ts.offset(), insertLines, true);
            }
        }
        super.visit(node);
    }

    @Override
    public void visit(UseStatement node) {
        int insertLines = 0;
        ASTNode previousNode = this.previousNode(node);
        insertLines = previousNode == null ? CodeStyle.get(this.context.document()).getBlankLinesBeforeUse() : this.insertLineBeforeAfter(this.astNodeToType(previousNode), this.astNodeToType(node));
        this.checkEmptyLinesBefore(node.getStartOffset(), insertLines, true);
        ASTNode nextNode = this.nextNode(node);
        if (nextNode == null || !this.isBlankLinesInteresting(nextNode)) {
            insertLines = CodeStyle.get(this.context.document()).getBlankLinesAfterUse();
            this.checkEmptyLinesBefore(node.getEndOffset(), insertLines, false);
        }
        super.visit(node);
    }

    @Override
    public void visit(FieldsDeclaration node) {
        int insertLines = 0;
        ASTNode previousNode = this.previousNode(node);
        insertLines = previousNode == null ? CodeStyle.get(this.context.document()).getBlankLinesBeforeField() : this.insertLineBeforeAfter(this.astNodeToType(previousNode), this.astNodeToType(node));
        this.checkEmptyLinesBefore(node.getStartOffset(), insertLines, true);
        ASTNode nextNode = this.nextNode(node);
        if (nextNode == null || !this.isBlankLinesInteresting(nextNode)) {
            insertLines = CodeStyle.get(this.context.document()).getBlankLinesAfterField();
            this.checkEmptyLinesBefore(node.getEndOffset(), insertLines, false);
        }
        super.visit(node);
    }

    @Override
    public void visit(DoStatement node) {
        super.visit(node);
        int offset = node.getEndOffset();
        TokenSequence<PHPTokenId> ts = this.tokenSequence(offset);
        ts.move(offset);
        if (ts.moveNext() && ts.movePrevious()) {
            LexUtilities.findPreviousToken(ts, Arrays.asList(PHPTokenId.PHP_WHILE));
            offset = ts.offset();
            this.checkSpaceBetweenTokenAndOpenParen(offset, CodeStyle.get(this.context.document()).spaceBeforeWhileParen(), Arrays.asList(PHPTokenId.PHP_WHILE));
        }
        this.checkSpacesWithinParents(node.getCondition().getStartOffset(), node.getCondition().getEndOffset(), CodeStyle.get(this.context.document()).spaceWithinWhileParens());
    }

    @Override
    public void visit(IfStatement node) {
        super.visit(node);
        this.checkSpaceBetweenTokenAndOpenParen(node.getStartOffset(), CodeStyle.get(this.context.document()).spaceBeforeIfParen(), Arrays.asList(PHPTokenId.PHP_IF));
        this.checkSpacesWithinParents(node.getCondition().getStartOffset(), node.getCondition().getEndOffset(), CodeStyle.get(this.context.document()).spaceWithinIfParens());
    }

    @Override
    public void visit(ConditionalExpression node) {
        boolean space = CodeStyle.get(this.context.document()).spaceAroundTernaryOps();
        TokenSequence<PHPTokenId> ts = this.tokenSequence(node.getCondition().getEndOffset());
        ts.move(node.getCondition().getEndOffset());
        if (ts.movePrevious() && ts.moveNext()) {
            LexUtilities.findNext(ts, WS_AND_COMMENT_TOKENS);
            if (ts.token().id() == PHPTokenId.PHP_TOKEN && "?".equals(((Object)ts.token().text()).toString())) {
                this.checkSpaceAroundToken(ts, space);
            }
        }
        if (node.getIfTrue() != null) {
            ts.move(node.getIfTrue().getEndOffset());
            if (ts.movePrevious() && ts.moveNext()) {
                LexUtilities.findNext(ts, WS_AND_COMMENT_TOKENS);
                if (ts.token().id() == PHPTokenId.PHP_TOKEN && ":".equals(((Object)ts.token().text()).toString())) {
                    this.checkSpaceAroundToken(ts, space);
                }
            }
        }
        super.visit(node);
    }

    @Override
    public void visit(WhileStatement node) {
        super.visit(node);
        this.checkSpaceBetweenTokenAndOpenParen(node.getStartOffset(), CodeStyle.get(this.context.document()).spaceBeforeWhileParen(), Arrays.asList(PHPTokenId.PHP_WHILE));
        this.checkSpacesWithinParents(node.getCondition().getStartOffset(), node.getCondition().getEndOffset(), CodeStyle.get(this.context.document()).spaceWithinWhileParens());
    }

    @Override
    public void visit(SwitchStatement node) {
        super.visit(node);
        this.checkSpaceBetweenTokenAndOpenParen(node.getStartOffset(), CodeStyle.get(this.context.document()).spaceBeforeSwitchParen(), Arrays.asList(PHPTokenId.PHP_SWITCH));
        this.checkSpacesWithinParents(node.getExpression().getStartOffset(), node.getExpression().getEndOffset(), CodeStyle.get(this.context.document()).spaceWithinSwitchParens());
    }

    @Override
    public void visit(CatchClause node) {
        super.visit(node);
        this.checkSpaceBetweenTokenAndOpenParen(node.getStartOffset(), CodeStyle.get(this.context.document()).spaceBeforeCatchParen(), Arrays.asList(PHPTokenId.PHP_CATCH));
        this.checkSpacesWithinParents(node.getClassName().getStartOffset(), node.getVariable().getEndOffset(), CodeStyle.get(this.context.document()).spaceWithinCatchParens());
    }

    @Override
    public void visit(ForStatement node) {
        int start = node.getStartOffset();
        int end = node.getBody().getStartOffset();
        this.unbreakableRanges.add(new CodeRange(start, end));
        this.checkSpaceBetweenTokenAndOpenParen(node.getStartOffset(), CodeStyle.get(this.context.document()).spaceBeforeForParen(), Arrays.asList(PHPTokenId.PHP_FOR));
        if (node.getInitializers().size() > 0 && node.getUpdaters().size() > 0) {
            this.checkSpacesWithinParents(node.getInitializers().get(0).getStartOffset(), node.getUpdaters().get(node.getUpdaters().size() - 1).getEndOffset(), CodeStyle.get(this.context.document()).spaceWithinForParens());
        }
        super.visit(node);
    }

    @Override
    public void visit(ForEachStatement node) {
        this.checkSpaceBetweenTokenAndOpenParen(node.getStartOffset(), CodeStyle.get(this.context.document()).spaceBeforeForParen(), Arrays.asList(PHPTokenId.PHP_FOREACH));
        this.checkSpacesWithinParents(node.getExpression().getStartOffset(), node.getValue().getEndOffset(), CodeStyle.get(this.context.document()).spaceWithinForParens());
        super.visit(node);
    }

    @Override
    public void visit(ArrayCreation node) {
        if (node.getElements().size() > 0) {
            this.checkSpacesWithinParents(node.getElements().get(0).getStartOffset(), node.getElements().get(node.getElements().size() - 1).getEndOffset(), CodeStyle.get(this.context.document()).spaceWithinArrayDeclParens());
        }
        super.visit(node);
    }

    @Override
    public void visit(ArrayAccess node) {
        if (node.getIndex() != null) {
            this.checkSpacesWithinParents(node.getIndex().getStartOffset(), node.getIndex().getEndOffset(), CodeStyle.get(this.context.document()).spaceWithinArrayBrackets());
        }
        super.visit(node);
    }

    private void checkSpaceBetweenCurlyCloseAndToken(int offset, boolean insertSpace, List<PHPTokenId> beforeTokens) {
        TokenSequence<PHPTokenId> ts = this.tokenSequence(offset);
        ts.move(offset);
        if (ts.moveNext() && ts.movePrevious()) {
            LexUtilities.findNextToken(ts, Arrays.asList(PHPTokenId.PHP_CURLY_OPEN, PHPTokenId.PHP_SEMICOLON));
            LexUtilities.findPreviousToken(ts, beforeTokens);
            if (beforeTokens.contains(ts.token().id())) {
                this.replaceSpaceBeforeToken(ts, insertSpace, Arrays.asList(PHPTokenId.PHP_CURLY_CLOSE));
            }
        }
    }

    private void checkSpaceBetweenTokenAndOpenParen(int offset, boolean insertSpace, List<PHPTokenId> afterTokens) {
        Token<? extends PHPTokenId> token;
        TokenSequence<PHPTokenId> ts = this.tokenSequence(offset);
        ts.move(offset);
        if (ts.moveNext() && ts.movePrevious() && (token = LexUtilities.findNextToken(ts, Arrays.asList(PHPTokenId.PHP_TOKEN))).text().charAt(0) == '(') {
            this.replaceSpaceBeforeToken(ts, insertSpace, afterTokens);
        }
    }

    private void checkSpaceAroundToken(TokenSequence<PHPTokenId> ts, boolean insertSpace) {
        int offset = ts.offset();
        this.replaceSpaceBeforeToken(ts, insertSpace, null);
        ts.move(offset);
        ts.moveNext();
        if (ts.moveNext()) {
            LexUtilities.findNext(ts, WS_AND_COMMENT_TOKENS);
            this.replaceSpaceBeforeToken(ts, insertSpace, null);
            ts.move(offset);
            ts.moveNext();
        }
    }

    private void checkSpacesWithinParents(int start, int end, boolean space) {
        TokenSequence<PHPTokenId> ts = this.tokenSequence(start);
        ts.move(start);
        if (ts.moveNext() && ts.movePrevious()) {
            if (ts.token().id() == PHPTokenId.PHP_TOKEN) {
                ts.moveNext();
            }
            LexUtilities.findNext(ts, WS_AND_COMMENT_TOKENS);
            this.replaceSpaceBeforeToken(ts, space, Arrays.asList(PHPTokenId.PHP_TOKEN));
        }
        ts.move(end);
        if (ts.moveNext() && ts.movePrevious()) {
            PHPTokenId tokenid = (PHPTokenId)ts.token().id();
            ts.moveNext();
            LexUtilities.findNextToken(ts, Arrays.asList(PHPTokenId.PHP_TOKEN));
            this.replaceSpaceBeforeToken(ts, space, Arrays.asList(tokenid));
        }
    }

    private void replaceSpaceBeforeToken(TokenSequence<PHPTokenId> ts, boolean space, List<PHPTokenId> afterTokens) {
        if (ts.movePrevious()) {
            Token token = ts.token();
            if ((afterTokens == null && token.id() != PHPTokenId.WHITESPACE || afterTokens != null && afterTokens.contains(token.id()) || token.id() == PHPTokenId.PHP_COMMENT_END) && space) {
                this.replacements.add(new Replacement(ts.offset() + token.length(), 0, " "));
            } else if (token.id() == PHPTokenId.WHITESPACE && this.countOfNewLines(token.text()) == 0) {
                if (space) {
                    this.replacements.add(new Replacement(ts.offset() + token.length(), token.length(), " "));
                } else {
                    this.replacements.add(new Replacement(ts.offset() + token.length(), token.length(), ""));
                }
                ts.movePrevious();
                token = ts.token();
            }
            if (token.id() == PHPTokenId.PHP_COMMENT_END) {
                token = LexUtilities.findPrevious(ts, Arrays.asList(PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_START));
                ts.moveNext();
                this.replaceSpaceBeforeToken(ts, space, afterTokens);
            }
        }
    }

    public void tokenScan() {
        TokenSequence<PHPTokenId> tokenSequence = this.tokenSequence(0);
        tokenSequence.moveStart();
        while (tokenSequence.moveNext()) {
            if (this.isWithinUnbreakableRange(tokenSequence.offset()) || !this.splitTrigger(tokenSequence)) continue;
            int splitPos = tokenSequence.offset() + 1;
            if (this.doNotSplitLine(tokenSequence, true)) continue;
            Replacement replacement = new Replacement(splitPos, 0, "\n");
            this.replacements.add(replacement);
        }
    }

    private boolean splitTrigger(TokenSequence<PHPTokenId> tokenSequence) {
        PHPTokenId tokenId = (PHPTokenId)tokenSequence.token().id();
        return tokenId == PHPTokenId.PHP_SEMICOLON;
    }

    private void checkEmptyLinesBefore(int offset, int countOfLines, boolean checkCommentsBefore) {
        TokenSequence<PHPTokenId> ts = this.tokenSequence(offset);
        ts.move(offset);
        if (ts.moveNext() && ts.movePrevious()) {
            int currentNewLines = 0;
            Token token = LexUtilities.findPrevious(ts, Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHP_PRIVATE, PHPTokenId.PHP_PUBLIC, PHPTokenId.PHP_PROTECTED));
            boolean lineCommentBefore = false;
            while (this.isComment(token) && checkCommentsBefore || token.id() == PHPTokenId.PHP_PRIVATE || token.id() == PHPTokenId.PHP_PUBLIC || token.id() == PHPTokenId.PHP_PROTECTED) {
                currentNewLines = 0;
                lineCommentBefore = token.id() == PHPTokenId.PHP_LINE_COMMENT;
                ts.moveNext();
                token = ts.token();
                if (token.id() == PHPTokenId.WHITESPACE) {
                    for (int i = 0; i < token.text().length(); ++i) {
                        if (token.text().charAt(i) != '\n') continue;
                        ++currentNewLines;
                    }
                    if (lineCommentBefore && currentNewLines > 0) {
                        this.replacements.add(new Replacement(ts.offset() + token.length(), token.length(), ""));
                    } else if (currentNewLines > 1) {
                        this.replacements.add(new Replacement(ts.offset() + token.length(), token.length(), "\n"));
                    }
                }
                if (lineCommentBefore) {
                    lineCommentBefore = false;
                }
                if (!ts.movePrevious() || !ts.movePrevious()) break;
                token = LexUtilities.findPrevious(ts, Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHP_PRIVATE, PHPTokenId.PHP_PUBLIC, PHPTokenId.PHP_PROTECTED));
            }
            currentNewLines = 0;
            if (ts.moveNext()) {
                int i;
                int delta;
                int insertPosition = ts.offset();
                token = ts.token();
                if (token.id() == PHPTokenId.WHITESPACE) {
                    for (int i2 = 0; i2 < token.text().length(); ++i2) {
                        if (token.text().charAt(i2) != '\n') continue;
                        ++currentNewLines;
                    }
                }
                String insertText = "";
                int n = delta = lineCommentBefore ? 0 : 1;
                if (currentNewLines > countOfLines) {
                    for (i = 0; i < countOfLines + delta; ++i) {
                        insertText = insertText + "\n";
                    }
                    this.replacements.add(new Replacement(ts.offset() + token.length(), token.length(), insertText));
                }
                if (currentNewLines <= countOfLines) {
                    for (i = currentNewLines; i < countOfLines + delta; ++i) {
                        insertText = insertText + "\n";
                    }
                    this.replacements.add(new Replacement(insertPosition, 0, insertText));
                }
            }
        }
    }

    private boolean isComment(Token<? extends PHPTokenId> token) {
        return token.id() == PHPTokenId.PHPDOC_COMMENT || token.id() == PHPTokenId.PHPDOC_COMMENT_END || token.id() == PHPTokenId.PHPDOC_COMMENT_START || token.id() == PHPTokenId.PHP_COMMENT || token.id() == PHPTokenId.PHP_COMMENT_END || token.id() == PHPTokenId.PHP_COMMENT_START || token.id() == PHPTokenId.PHP_LINE_COMMENT;
    }

    private ElemType astNodeToType(ASTNode node) {
        if (node instanceof FieldsDeclaration) {
            return ElemType.FIELD;
        }
        if (node instanceof ClassDeclaration) {
            return ElemType.CLASS;
        }
        if (node instanceof FunctionDeclaration) {
            return ElemType.FUNCTION;
        }
        if (node instanceof MethodDeclaration) {
            return ElemType.FUNCTION;
        }
        if (node instanceof UseStatement) {
            return ElemType.USE;
        }
        if (node instanceof NamespaceDeclaration) {
            return ElemType.NAMESPACE;
        }
        return ElemType.UNKNOWN;
    }

    private int insertLineBeforeAfter(ElemType afterElem, ElemType beforeElem) {
        if (afterElem == beforeElem && (afterElem == ElemType.FIELD || afterElem == ElemType.USE)) {
            return 0;
        }
        if (afterElem == ElemType.CLASS && beforeElem != ElemType.CLASS) {
            afterElem = ElemType.CLASS_HEADER;
        }
        int after = 0;
        int before = 0;
        switch (afterElem) {
            case CLASS: {
                after = CodeStyle.get(this.context.document()).getBlankLinesAfterClass();
                break;
            }
            case CLASS_HEADER: {
                after = CodeStyle.get(this.context.document()).getBlankLinesAfterClassHeader();
                break;
            }
            case NAMESPACE: {
                after = CodeStyle.get(this.context.document()).getBlankLinesAfterNamespace();
                break;
            }
            case USE: {
                after = CodeStyle.get(this.context.document()).getBlankLinesAfterUse();
                break;
            }
            case FIELD: {
                after = CodeStyle.get(this.context.document()).getBlankLinesAfterField();
                break;
            }
            case FUNCTION: {
                after = CodeStyle.get(this.context.document()).getBlankLinesAfterFunction();
            }
        }
        switch (beforeElem) {
            case CLASS: {
                before = CodeStyle.get(this.context.document()).getBlankLinesBeforeClass();
                break;
            }
            case CLASS_HEADER: {
                before = CodeStyle.get(this.context.document()).getBlankLinesAfterClassHeader();
                break;
            }
            case NAMESPACE: {
                before = CodeStyle.get(this.context.document()).getBlankLinesBeforeNamespace();
                break;
            }
            case USE: {
                before = CodeStyle.get(this.context.document()).getBlankLinesBeforeUse();
                break;
            }
            case FIELD: {
                before = CodeStyle.get(this.context.document()).getBlankLinesBeforeField();
                break;
            }
            case FUNCTION: {
                before = CodeStyle.get(this.context.document()).getBlankLinesBeforeFunction();
                break;
            }
            case FUNCTION_BEFORE_END: {
                before = CodeStyle.get(this.context.document()).getBlankLinesBeforeFunctionEnd();
                break;
            }
            case CLASS_BEFORE_END: {
                before = CodeStyle.get(this.context.document()).getBlankLinesBeforeClassEnd();
            }
        }
        if (beforeElem == ElemType.CLASS_BEFORE_END) {
            if (afterElem == ElemType.CLASS_HEADER) {
                return Math.max(Math.max(after, before), 1);
            }
            if (afterElem == ElemType.FUNCTION) {
                return before;
            }
        }
        return Math.max(after, before);
    }

    private boolean isBlankLinesInteresting(ASTNode node) {
        return node != null && (node instanceof ClassDeclaration || node instanceof FunctionDeclaration || node instanceof NamespaceDeclaration || node instanceof UseStatement || node instanceof FieldsDeclaration || node instanceof MethodDeclaration);
    }

    private ASTNode previousNode(ASTNode node) {
        ASTNode previous = null;
        List<ASTNode> path = this.getPath();
        if (path.get(0) instanceof Block) {
            int index;
            Block block = (Block)path.get(0);
            List<Statement> statements = block.getStatements();
            for (index = 0; index < statements.size() && statements.get(index).getEndOffset() < node.getStartOffset(); ++index) {
                previous = statements.get(index);
            }
            if (previous == null) {
                for (index = 1; index < path.size() && !(path.get(index) instanceof ClassDeclaration); ++index) {
                }
                if (index < path.size() && path.get(index) instanceof ClassDeclaration) {
                    previous = path.get(index);
                }
            }
        }
        return previous;
    }

    private ASTNode nextNode(ASTNode node) {
        ASTNode next = null;
        List<ASTNode> path = this.getPath();
        List<Statement> statements = null;
        if (path.size() == 1 && path.get(0) instanceof Program) {
            statements = ((Program)path.get(0)).getStatements();
        } else {
            for (ASTNode astNode : path) {
                if (!(astNode instanceof Block)) continue;
                statements = ((Block)astNode).getStatements();
                break;
            }
        }
        if (statements != null) {
            int index;
            for (index = statements.size() - 1; index > 0 && statements.get(index).getStartOffset() > node.getEndOffset(); --index) {
                next = statements.get(index);
            }
            if (next == null) {
                for (index = 1; index < path.size() && !(path.get(index) instanceof ClassDeclaration); ++index) {
                }
                if (index < path.size() && path.get(index) instanceof ClassDeclaration) {
                    next = path.get(index);
                }
            }
        }
        return next;
    }

    private boolean doNotSplitLine(TokenSequence<PHPTokenId> tokenSequence, boolean fwd) {
        boolean retVal = false;
        while (fwd && tokenSequence.moveNext() || !fwd && tokenSequence.movePrevious()) {
            if (WS_AND_COMMENT_TOKENS.contains(tokenSequence.token().id())) {
                if (!WSTransformer.textContainsBreak(tokenSequence.token().text())) continue;
                retVal = true;
                break;
            }
            retVal = this.NO_BREAK_B4_TKNS.contains(tokenSequence.token().id());
            if (fwd) {
                tokenSequence.movePrevious();
                break;
            }
            tokenSequence.moveNext();
            break;
        }
        return retVal;
    }

    private void wrapNodes(List<? extends ASTNode> nodes, boolean wrapFirst, CodeStyle.WrapStyle style) {
        int i;
        int n = i = wrapFirst ? 0 : 1;
        while (i < nodes.size()) {
            ASTNode node = nodes.get(i);
            TokenSequence<PHPTokenId> ts = this.tokenSequence(node.getStartOffset());
            ts.move(node.getStartOffset());
            if (ts.moveNext() && ts.movePrevious()) {
                Token token = ts.token();
                int tokenOffset = ts.offset();
                if (style == CodeStyle.WrapStyle.WRAP_ALWAYS) {
                    if (ts.movePrevious() && ts.token().id() == PHPTokenId.PHP_LINE_COMMENT) {
                        if (token.id() == PHPTokenId.WHITESPACE) {
                            this.replacements.add(new Replacement(tokenOffset + token.length(), token.length(), " ", 1));
                        }
                    } else if (token.id() == PHPTokenId.WHITESPACE) {
                        if (this.countOfNewLines(token.text()) != 1) {
                            this.replacements.add(new Replacement(tokenOffset + token.length(), token.length(), "\n", 1));
                        }
                    } else {
                        this.replacements.add(new Replacement(tokenOffset + token.length(), 0, "\n", 1));
                    }
                } else if (style == CodeStyle.WrapStyle.WRAP_NEVER) {
                    if (ts.movePrevious() && ts.token().id() == PHPTokenId.PHP_LINE_COMMENT) {
                        if (token.id() == PHPTokenId.WHITESPACE) {
                            this.replacements.add(new Replacement(tokenOffset + token.length(), token.length(), " ", 1));
                        }
                    } else if (token.id() == PHPTokenId.WHITESPACE && this.countOfNewLines(token.text()) > 1) {
                        this.replacements.add(new Replacement(tokenOffset + token.length(), token.length(), "\n", 1));
                    }
                }
            }
            ++i;
        }
    }

    private static final boolean textContainsBreak(CharSequence charSequence) {
        for (int i = 0; i < charSequence.length(); ++i) {
            if (charSequence.charAt(i) != '\n') continue;
            return true;
        }
        return false;
    }

    private boolean isWithinUnbreakableRange(int offset) {
        for (CodeRange codeRange : this.unbreakableRanges) {
            if (!codeRange.contains(offset)) continue;
            return true;
        }
        return false;
    }

    List<Replacement> getReplacements() {
        return this.replacements;
    }

    private TokenSequence<PHPTokenId> tokenSequence(int offset) {
        return LexUtilities.getPHPTokenSequence(this.context.document(), offset);
    }

    private int countOfNewLines(CharSequence chs) {
        int count = 0;
        for (int i = 0; i < chs.length(); ++i) {
            if (chs.charAt(i) != '\n') continue;
            ++count;
        }
        return count;
    }

    private static enum ElemType {
        CLASS,
        CLASS_HEADER,
        CLASS_BEFORE_END,
        NAMESPACE,
        USE,
        FUNCTION,
        FUNCTION_BEFORE_END,
        FIELD,
        UNKNOWN;

    }

    static class CodeRange
    implements Comparable<CodeRange> {
        private Integer start;
        private Integer end;

        public CodeRange(int start, int end) {
            this.start = start;
            this.end = end;
        }

        boolean contains(int offset) {
            return offset >= this.start && offset <= this.end;
        }

        @Override
        public int compareTo(CodeRange o) {
            int r = this.start.compareTo(o.start);
            if (r == 0) {
                return this.end.compareTo(o.end);
            }
            return r;
        }
    }

    static class Replacement
    implements Comparable<Replacement> {
        private Integer offset;
        private int length;
        private int priority;
        private String newString;
        private boolean soft;

        public Replacement(int offset, int length, String newString) {
            this(offset, length, newString, 5);
        }

        public Replacement(int offset, int length, String newString, int priority) {
            this.offset = offset;
            this.length = length;
            this.newString = newString;
            this.priority = priority;
        }

        public int length() {
            return this.length;
        }

        public String newString() {
            return this.newString;
        }

        public int offset() {
            return this.offset;
        }

        public int getPriority() {
            return this.priority;
        }

        public boolean isSoft() {
            return this.soft;
        }

        @Override
        public int compareTo(Replacement r) {
            return this.offset.compareTo(r.offset);
        }
    }
}

