/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.codegen;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class DatabaseURL {
    public static DatabaseURL detect(String url) {
        MySQLURL mySQL = new MySQLURL(url);
        return mySQL.matches() ? mySQL : null;
    }

    abstract boolean matches();

    public abstract Server getServer();

    public abstract String getHost();

    public abstract String getPort();

    public abstract String getDatabase();

    private static final class MySQLURL
    extends DatabaseURL {
        private static final Pattern PATTERN = Pattern.compile("jdbc:mysql://([^/]+)(/(.*))?");
        private final String url;
        private final Matcher matcher;
        private String host;
        private String port;

        public MySQLURL(String url) {
            this.url = url;
            this.matcher = PATTERN.matcher(url);
        }

        @Override
        boolean matches() {
            boolean result = this.matcher.matches();
            if (result) {
                String hostAndPort = this.matcher.group(1);
                if (hostAndPort != null) {
                    String[] split = hostAndPort.split(":");
                    this.host = split[0].trim();
                    if (split.length > 1) {
                        this.port = split[1].trim();
                    }
                }
                if (this.host == null || this.host.length() == 0) {
                    result = false;
                }
            }
            return result;
        }

        @Override
        public Server getServer() {
            return Server.MYSQL;
        }

        @Override
        public String getHost() {
            return this.host;
        }

        @Override
        public String getPort() {
            return this.port;
        }

        @Override
        public String getDatabase() {
            String database = this.matcher.group(3);
            if (database == null) {
                return null;
            }
            if ((database = database.trim()).length() == 0) {
                return null;
            }
            return database;
        }
    }

    public static enum Server {
        MYSQL;

    }
}

