/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.breakpoints;

import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.modules.cnd.debugger.common.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.common.breakpoints.BreakpointAnnotationProvider;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.SessionBreakpointAnnotationProvider;
import org.netbeans.modules.cnd.debugger.common.disassembly.DisassemblyService;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.AddressBreakpointImpl;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.BreakpointImpl;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.FunctionBreakpointImpl;
import org.openide.filesystems.FileObject;

public class GdbBreakpointAnnotationImpl
implements SessionBreakpointAnnotationProvider {
    public int[] getBreakpointAnnotationLines(CndBreakpoint b, FileObject fo) {
        int res;
        DisassemblyService disProvider;
        BreakpointImpl<?> bptImpl = GdbDebugger.getBreakpointImpl((Breakpoint)b);
        if (bptImpl instanceof FunctionBreakpointImpl) {
            int line;
            if (fo.getPath().equals(bptImpl.getFullname()) && (line = bptImpl.getLine()) >= 0) {
                return new int[]{line};
            }
        } else if (bptImpl instanceof AddressBreakpointImpl && (disProvider = EditorContextBridge.getCurrentDisassemblyService()) != null && (res = disProvider.getAddressLine(bptImpl.getAddress())) >= 0) {
            return new int[]{res};
        }
        return null;
    }

    public String getAnnotationType(CndBreakpoint b) {
        String orig = BreakpointAnnotationProvider.getAnnotationType((CndBreakpoint)b);
        BreakpointImpl<?> bptImpl = GdbDebugger.getBreakpointImpl((Breakpoint)b);
        if (bptImpl == null && b.isEnabled()) {
            return orig + "_broken";
        }
        return orig;
    }
}

