/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.navigation;

import java.awt.Image;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.GsfHtmlFormatter;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.gsf.api.StructureItem;
import org.netbeans.modules.gsfret.navigation.ClassMemberFilters;
import org.netbeans.modules.gsfret.navigation.ClassMemberPanelUI;
import org.netbeans.modules.gsfret.navigation.ElementScanningTask;
import org.netbeans.modules.gsfret.navigation.Icons;
import org.netbeans.modules.gsfret.navigation.actions.OpenAction;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class ElementNode
extends AbstractNode {
    private static Node WAIT_NODE;
    private OpenAction openAction;
    private StructureItem description;
    private ClassMemberPanelUI ui;
    private FileObject fileObject;
    private static NavigatorFormatter FORMATTER;

    public ElementNode(StructureItem description, ClassMemberPanelUI ui, FileObject fileObject) {
        super((Children)(description.isLeaf() ? Children.LEAF : new ElementChildren(description.getNestedItems(), ui.getFilters(), ui, fileObject)));
        this.description = description;
        this.setDisplayName(description.getName());
        this.ui = ui;
        this.fileObject = fileObject;
    }

    public Image getIcon(int type) {
        if (this.description.getCustomIcon() != null) {
            return ImageUtilities.icon2Image((Icon)this.description.getCustomIcon());
        }
        ImageIcon icon = Icons.getElementIcon(this.description.getKind(), this.description.getModifiers());
        if (icon != null) {
            return ImageUtilities.icon2Image((Icon)icon);
        }
        return super.getIcon(type);
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public String getDisplayName() {
        return this.description.getName();
    }

    public String getHtmlDisplayName() {
        FORMATTER.reset();
        return this.description.getHtml((HtmlFormatter)FORMATTER);
    }

    public Action[] getActions(boolean context) {
        if (context || this.description.getName() == null) {
            return this.ui.getActions();
        }
        Action[] panelActions = this.ui.getActions();
        Action[] actions = new Action[2 + panelActions.length];
        actions[0] = this.getOpenAction();
        actions[1] = null;
        for (int i = 0; i < panelActions.length; ++i) {
            actions[2 + i] = panelActions[i];
        }
        return actions;
    }

    public Action getPreferredAction() {
        return this.getOpenAction();
    }

    private synchronized Action getOpenAction() {
        if (this.openAction == null) {
            FileObject fo = this.ui.getFileObject();
            this.openAction = new OpenAction(this.description.getElementHandle(), fo, this.description.getPosition());
        }
        return this.openAction;
    }

    static synchronized Node getWaitNode() {
        if (WAIT_NODE == null) {
            WAIT_NODE = new WaitNode();
        }
        return WAIT_NODE;
    }

    public void refreshRecursively() {
        Children ch = this.getChildren();
        if (ch instanceof ElementChildren) {
            ((ElementChildren)ch).resetKeys(this.description.getNestedItems(), this.ui.getFilters());
            for (Node sub : ch.getNodes()) {
                this.ui.expandNode(sub);
                ((ElementNode)sub).refreshRecursively();
            }
        }
    }

    public ElementNode getMimeRootNodeForOffset(CompilationInfo info, int offset) {
        Children ch;
        if (this.getDescription().getPosition() > (long)offset) {
            return null;
        }
        Document document = info.getDocument();
        if (document == null) {
            return null;
        }
        BaseDocument doc = (BaseDocument)document;
        List<Language> languages = LanguageRegistry.getInstance().getEmbeddedLanguages(doc, offset);
        if (languages.size() > 0 && (ch = this.getChildren()) instanceof ElementChildren) {
            Node[] children = ch.getNodes();
            for (Language language : languages) {
                for (int i = 0; i < children.length; ++i) {
                    ElementNode c = (ElementNode)children[i];
                    if (!(c.getDescription() instanceof ElementScanningTask.MimetypeRootNode)) continue;
                    ElementScanningTask.MimetypeRootNode mr = (ElementScanningTask.MimetypeRootNode)c.getDescription();
                    if (mr.language != language) continue;
                    return c.getNodeForOffset(offset);
                }
            }
        }
        return this.getNodeForOffset(offset);
    }

    public ElementNode getNodeForOffset(int offset) {
        if (this.getDescription().getPosition() > (long)offset) {
            return null;
        }
        Children ch = this.getChildren();
        if (ch instanceof ElementChildren) {
            Node[] children = ch.getNodes();
            for (int i = 0; i < children.length; ++i) {
                long end;
                ElementNode c = (ElementNode)children[i];
                long start = c.getDescription().getPosition();
                if (start > (long)offset || (end = c.getDescription().getEndPosition()) < (long)offset) continue;
                return c.getNodeForOffset(offset);
            }
        }
        return this;
    }

    public void updateRecursively(StructureItem newDescription) {
        Children ch = this.getChildren();
        if (ch instanceof ElementChildren) {
            HashSet oldSubs = new HashSet(this.description.getNestedItems());
            Node[] nodes = ch.getNodes(true);
            HashMap<StructureItem, ElementNode> oldD2node = new HashMap<StructureItem, ElementNode>();
            for (Node node : nodes) {
                oldD2node.put(((ElementNode)node).description, (ElementNode)node);
            }
            ((ElementChildren)ch).resetKeys(newDescription.getNestedItems(), this.ui.getFilters());
            nodes = ch.getNodes(true);
            for (StructureItem newSub : newDescription.getNestedItems()) {
                ElementNode node = (ElementNode)((Object)oldD2node.get(newSub));
                if (node == null) continue;
                if (!oldSubs.contains(newSub) && node.getChildren() != Children.LEAF) {
                    this.ui.expandNode((Node)node);
                }
                node.updateRecursively(newSub);
            }
        }
        StructureItem oldDescription = this.description;
        this.description = newDescription;
        FORMATTER.reset();
        String oldHtml = oldDescription.getHtml((HtmlFormatter)FORMATTER);
        FORMATTER.reset();
        String descHtml = this.description.getHtml((HtmlFormatter)FORMATTER);
        if (oldHtml != null && !oldHtml.equals(descHtml)) {
            this.fireDisplayNameChange(oldHtml, descHtml);
        }
        if (oldDescription.getModifiers() != null && !((Object)oldDescription.getModifiers()).equals(newDescription.getModifiers())) {
            this.fireIconChange();
            this.fireOpenedIconChange();
        }
    }

    public StructureItem getDescription() {
        return this.description;
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    static {
        FORMATTER = new NavigatorFormatter();
    }

    private static class NavigatorFormatter
    extends GsfHtmlFormatter {
        private NavigatorFormatter() {
        }

        @Override
        public void name(ElementKind kind, boolean start) {
        }
    }

    private static class WaitNode
    extends AbstractNode {
        private Image waitIcon = ImageUtilities.loadImage((String)"org/netbeans/modules/gsfret/navigation/resources/wait.gif");

        WaitNode() {
            super(Children.LEAF);
        }

        public Image getIcon(int type) {
            return this.waitIcon;
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public String getDisplayName() {
            return NbBundle.getMessage(ElementNode.class, (String)"TXT_PleaseWait");
        }
    }

    static class Description {
        public static final Comparator<StructureItem> ALPHA_COMPARATOR = new DescriptionComparator(true);
        public static final Comparator<StructureItem> POSITION_COMPARATOR = new DescriptionComparator(false);
        ClassMemberPanelUI ui;
        String name;
        ElementHandle elementHandle;
        ElementKind kind;
        Set<Modifier> modifiers;
        List<Description> subs;
        String htmlHeader;
        long pos;

        Description(ClassMemberPanelUI ui) {
            this.ui = ui;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Description)) {
                return false;
            }
            Description d = (Description)o;
            if (this.kind != d.kind) {
                return false;
            }
            return this.name.equals(d.name);
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + (this.name != null ? this.name.hashCode() : 0);
            hash = 29 * hash + (this.kind != null ? this.kind.hashCode() : 0);
            return hash;
        }

        private static class DescriptionComparator
        implements Comparator<StructureItem> {
            boolean alpha;

            DescriptionComparator(boolean alpha) {
                this.alpha = alpha;
            }

            @Override
            public int compare(StructureItem d1, StructureItem d2) {
                if (this.alpha) {
                    if (this.k2i(d1.getKind()) != this.k2i(d2.getKind())) {
                        return this.k2i(d1.getKind()) - this.k2i(d2.getKind());
                    }
                    return d1.getSortText().compareTo(d2.getSortText());
                }
                return d1.getPosition() == d2.getPosition() ? 0 : (d1.getPosition() < d2.getPosition() ? -1 : 1);
            }

            int k2i(ElementKind kind) {
                switch (kind) {
                    case CONSTRUCTOR: {
                        return 1;
                    }
                    case METHOD: 
                    case DB: {
                        return 2;
                    }
                    case FIELD: {
                        return 3;
                    }
                }
                return 100;
            }
        }
    }

    private static final class ElementChildren
    extends Children.Keys<StructureItem> {
        private ClassMemberPanelUI ui;
        private FileObject fileObject;

        public ElementChildren(List<StructureItem> descriptions, ClassMemberFilters filters, ClassMemberPanelUI ui, FileObject fileObject) {
            this.resetKeys(descriptions, filters);
            this.ui = ui;
            this.fileObject = fileObject;
        }

        protected Node[] createNodes(StructureItem key) {
            return new Node[]{new ElementNode(key, this.ui, this.fileObject)};
        }

        void resetKeys(List<StructureItem> descriptions, ClassMemberFilters filters) {
            this.setKeys(filters.filter(descriptions));
        }
    }
}

