/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.gsfret;

import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.editor.gsfret.InstantRenamePerformer;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.DataLoadersBridge;
import org.netbeans.modules.gsf.api.EditRegions;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class EditRegionsImpl
extends EditRegions {
    public void edit(final FileObject fo, final Set<OffsetRange> regions, final int caretOffset) throws BadLocationException {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        EditRegionsImpl.this.edit(fo, regions, caretOffset);
                    }
                    catch (BadLocationException ble) {
                        Exceptions.printStackTrace((Throwable)ble);
                    }
                }
            });
            return;
        }
        JEditorPane[] panes = DataLoadersBridge.getDefault().getOpenedPanes(fo);
        if (panes == null || panes.length == 0) {
            return;
        }
        JEditorPane pane = panes[0];
        Document doc = pane.getDocument();
        Language language = LanguageRegistry.getInstance().getLanguageByMimeType(fo.getMIMEType());
        if (language == null) {
            return;
        }
        if (regions != null && regions.size() > 0) {
            InstantRenamePerformer.performInstantRename(pane, regions, caretOffset);
        }
    }
}

