/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer.api;

import hidden.org.codehaus.plexus.util.IOUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;

public final class RepositoryUtil {
    private static Logger LOGGER = Logger.getLogger(RepositoryUtil.class.getName());

    private RepositoryUtil() {
    }

    public static Artifact createArtifact(NBVersionInfo info) {
        return RepositoryUtil.createArtifact(info, null);
    }

    public static Artifact createJavadocArtifact(NBVersionInfo info) {
        return RepositoryUtil.createArtifact(info, "javadoc");
    }

    private static Artifact createArtifact(NBVersionInfo info, String classifier) {
        MavenEmbedder online = EmbedderFactory.getOnlineEmbedder();
        Artifact art = info.getClassifier() != null || classifier != null ? online.createArtifactWithClassifier(info.getGroupId(), info.getArtifactId(), info.getVersion(), info.getType() != null ? info.getType() : "jar", classifier == null ? info.getClassifier() : classifier) : online.createArtifact(info.getGroupId(), info.getArtifactId(), info.getVersion(), null, info.getType() != null ? info.getType() : "jar");
        ArtifactRepository repo = online.getLocalRepository();
        String localPath = repo.pathOf(art);
        art.setFile(new File(repo.getBasedir(), localPath));
        return art;
    }

    public static String calculateMD5Checksum(File file) throws IOException {
        byte[] buffer = RepositoryUtil.readFile(file);
        String md5sum = DigestUtils.md5Hex((byte[])buffer);
        return md5sum;
    }

    public static String calculateSHA1Checksum(File file) throws IOException {
        byte[] buffer = RepositoryUtil.readFile(file);
        String sha1sum = DigestUtils.shaHex((byte[])buffer);
        return sha1sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] readFile(File file) throws IOException {
        FileInputStream is = null;
        byte[] bytes = new byte[(int)file.length()];
        try {
            is = new FileInputStream(file);
            int numRead = 0;
            for (int offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(is);
            throw throwable;
        }
        IOUtil.close((InputStream)is);
        return bytes;
    }

    @Deprecated
    public static MavenProject readMavenProject(String grId, String artId, String ver, ArtifactRepository repository) {
        MavenProject mavenProject = null;
        try {
            MavenEmbedder online = EmbedderFactory.getOnlineEmbedder();
            ArtifactFactory artifactFactory = (ArtifactFactory)online.getPlexusContainer().lookup(ArtifactFactory.class);
            Artifact projectArtifact = artifactFactory.createProjectArtifact(grId, artId, ver, null);
            MavenProjectBuilder builder = (MavenProjectBuilder)online.getPlexusContainer().lookup(MavenProjectBuilder.class);
            mavenProject = builder.buildFromRepository(projectArtifact, new ArrayList(), repository);
        }
        catch (InvalidProjectModelException ex) {
            LOGGER.log(Level.FINE, "Failed to load project model from repository.", ex);
        }
        catch (ProjectBuildingException ex) {
            LOGGER.log(Level.FINE, "Failed to load project model from repository.", ex);
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, "Failed to load project model from repository.", exception);
        }
        return mavenProject;
    }
}

