/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.tools.impl;

import java.math.BigInteger;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public final class LinuxProcfsSupport {
    private LinuxProcfsSupport() {
    }

    public static CpuStat parseCpuStat(String line) {
        CpuStat cpu;
        block3: {
            StringTokenizer t = new StringTokenizer(line);
            if (!t.hasMoreTokens() || !t.nextToken().equals("cpu")) {
                throw new IllegalArgumentException("CPU line must start with \"cpu\"");
            }
            cpu = new CpuStat();
            boolean gotMandatoryFields = false;
            try {
                cpu.user = new BigInteger(t.nextToken());
                cpu.nice = new BigInteger(t.nextToken());
                cpu.system = new BigInteger(t.nextToken());
                cpu.idle = new BigInteger(t.nextToken());
                gotMandatoryFields = true;
                cpu.iowait = new BigInteger(t.nextToken());
                cpu.irq = new BigInteger(t.nextToken());
                cpu.softirq = new BigInteger(t.nextToken());
                cpu.steal = new BigInteger(t.nextToken());
                cpu.guest = new BigInteger(t.nextToken());
            }
            catch (NoSuchElementException ex) {
                if (gotMandatoryFields) break block3;
                throw new IllegalArgumentException("CPU line must have at least 4 counters: user, nice, system, idle", ex);
            }
        }
        return cpu;
    }

    public static ProcessStat parseProcessStat(String line) {
        ProcessStat proc;
        block2: {
            proc = new ProcessStat();
            boolean gotMandatoryFields = false;
            try {
                LinuxProcfsSupport.extractPid(proc, line);
                int commEndIdx = LinuxProcfsSupport.extractComm(proc, line);
                StringTokenizer t = new StringTokenizer(line.substring(commEndIdx));
                proc.state = t.nextToken().charAt(0);
                proc.ppid = Integer.parseInt(t.nextToken());
                t.nextToken();
                t.nextToken();
                t.nextToken();
                t.nextToken();
                t.nextToken();
                t.nextToken();
                t.nextToken();
                t.nextToken();
                t.nextToken();
                proc.utime = new BigInteger(t.nextToken());
                proc.stime = new BigInteger(t.nextToken());
                proc.cutime = new BigInteger(t.nextToken());
                proc.cstime = new BigInteger(t.nextToken());
                proc.priority = Long.parseLong(t.nextToken());
                proc.nice = Long.parseLong(t.nextToken());
                proc.num_threads = Long.parseLong(t.nextToken());
                t.nextToken();
                proc.starttime = new BigInteger(t.nextToken());
                t.nextToken();
                t.nextToken();
                t.nextToken();
                t.nextToken();
                t.nextToken();
                t.nextToken();
                t.nextToken();
                t.nextToken();
                t.nextToken();
                t.nextToken();
                t.nextToken();
                t.nextToken();
                t.nextToken();
                t.nextToken();
                t.nextToken();
                gotMandatoryFields = true;
                t.nextToken();
                t.nextToken();
                t.nextToken();
                t.nextToken();
                proc.delayacct_blkio_ticks = new BigInteger(t.nextToken());
                proc.guest_time = new BigInteger(t.nextToken());
                proc.cguest_time = new BigInteger(t.nextToken());
            }
            catch (NoSuchElementException ex) {
                if (gotMandatoryFields) break block2;
                throw new IllegalArgumentException("Fields up to cnswap must be here", ex);
            }
        }
        return proc;
    }

    private static int extractPid(ProcessStat proc, String line) {
        int pidEndIdx = line.indexOf(32);
        if (pidEndIdx < 0) {
            pidEndIdx = line.length();
        }
        proc.pid = Integer.parseInt(line.substring(0, pidEndIdx));
        return pidEndIdx;
    }

    private static int extractComm(ProcessStat proc, String line) {
        int lparenIdx = line.indexOf(40);
        int rparenIdx = line.lastIndexOf(41);
        if (lparenIdx < 0 || rparenIdx < 0) {
            throw new IllegalArgumentException("Failed to parse comm");
        }
        proc.comm = line.substring(lparenIdx + 1, rparenIdx);
        return rparenIdx + 1;
    }

    public static final class ProcessStat {
        private int pid;
        private String comm;
        private char state;
        private int ppid;
        private BigInteger utime;
        private BigInteger stime;
        private BigInteger cutime;
        private BigInteger cstime;
        private long priority;
        private long nice;
        private long num_threads;
        private BigInteger starttime;
        private BigInteger delayacct_blkio_ticks;
        private BigInteger guest_time;
        private BigInteger cguest_time;

        private ProcessStat() {
        }

        public int pid() {
            return this.pid;
        }

        public String comm() {
            return this.comm;
        }

        public char state() {
            return this.state;
        }

        public int ppid() {
            return this.ppid;
        }

        public BigInteger utime() {
            return this.utime;
        }

        public BigInteger stime() {
            return this.stime;
        }

        public BigInteger cutime() {
            return this.cutime;
        }

        public BigInteger cstime() {
            return this.cstime;
        }

        public long priority() {
            return this.priority;
        }

        public long nice() {
            return this.nice;
        }

        public long num_threads() {
            return this.num_threads;
        }

        public BigInteger starttime() {
            return this.starttime;
        }

        public BigInteger delayacct_blkio_ticks() {
            return this.delayacct_blkio_ticks;
        }

        public BigInteger guest_time() {
            return this.guest_time;
        }

        public BigInteger cguest_time() {
            return this.cguest_time;
        }
    }

    public static final class CpuStat {
        private BigInteger user;
        private BigInteger nice;
        private BigInteger system;
        private BigInteger idle;
        private BigInteger iowait;
        private BigInteger irq;
        private BigInteger softirq;
        private BigInteger steal;
        private BigInteger guest;

        private CpuStat() {
        }

        public BigInteger user() {
            return this.user;
        }

        public BigInteger nice() {
            return this.nice;
        }

        public BigInteger system() {
            return this.system;
        }

        public BigInteger idle() {
            return this.idle;
        }

        public BigInteger iowait() {
            return this.iowait;
        }

        public BigInteger irq() {
            return this.irq;
        }

        public BigInteger softirq() {
            return this.softirq;
        }

        public BigInteger steal() {
            return this.steal;
        }

        public BigInteger guest() {
            return this.guest;
        }

        public BigInteger all() {
            BigInteger sum = this.user.add(this.nice).add(this.system).add(this.idle);
            if (this.iowait != null) {
                sum = sum.add(this.iowait);
            }
            if (this.irq != null) {
                sum = sum.add(this.irq);
            }
            if (this.softirq != null) {
                sum = sum.add(this.softirq);
            }
            if (this.steal != null) {
                sum = sum.add(this.steal);
            }
            if (this.guest != null) {
                sum = sum.add(this.guest);
            }
            return sum;
        }
    }
}

