/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.cnd.remote.server.RemoteServerList;
import org.netbeans.modules.cnd.remote.server.RemoteServerRecord;
import org.netbeans.modules.cnd.remote.sync.SyncUtils;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.ValidatablePanelListener;
import org.netbeans.modules.nativeexecution.api.util.ValidateablePanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class HostPropertiesDialog
extends JPanel {
    private final ValidatablePanelListener validationListener = new ValidationListenerImpl();
    private final JButton ok;
    private final ValidateablePanel vpanel;
    private JComboBox cbSync;
    private JCheckBox cbX11;
    private JPanel connectionPanel;
    private JLabel errorLabel;
    private JLabel lblName;
    private JLabel lblSync;
    private JPanel serverRecordPanel;
    private JTextField tfName;

    public static boolean invokeMe(RemoteServerRecord record) {
        HostPropertiesDialog pane = new HostPropertiesDialog(record);
        Object[] buttons = new Object[]{pane.ok, DialogDescriptor.CANCEL_OPTION};
        DialogDescriptor dd = new DialogDescriptor((Object)pane, NbBundle.getMessage(HostPropertiesDialog.class, (String)"TITLE_HostProperties"), true, buttons, (Object)pane.ok, 0, null, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.setResizable(false);
        dialog.setVisible(true);
        if (dd.getValue() == pane.ok) {
            boolean x11forwarding;
            RemoteSyncFactory syncFactory;
            pane.vpanel.applyChanges(null);
            String displayName = pane.tfName.getText();
            boolean changed = false;
            if (!displayName.equals(record.getDisplayName())) {
                record.setDisplayName(displayName);
                changed = true;
            }
            if (!(syncFactory = (RemoteSyncFactory)pane.cbSync.getSelectedItem()).equals(record.getSyncFactory())) {
                record.setSyncFactory(syncFactory);
                changed = true;
            }
            if ((x11forwarding = pane.cbX11.isSelected()) != record.getX11Forwarding()) {
                record.setX11Forwarding(x11forwarding);
                changed = true;
            }
            if (changed) {
                RemoteServerList.storePreferences();
                return true;
            }
        }
        return false;
    }

    @SuppressWarnings(value={"Se"})
    private HostPropertiesDialog(RemoteServerRecord serverRecord) {
        this.initComponents();
        this.ok = new JButton("OK");
        this.vpanel = ConnectionManager.getInstance().getConfigurationPanel(serverRecord.getExecutionEnvironment());
        this.vpanel.addValidationListener(this.validationListener);
        this.connectionPanel.add((Component)this.vpanel);
        this.tfName.setText(serverRecord.getDisplayName());
        SyncUtils.arrangeComboBox(this.cbSync, serverRecord.getExecutionEnvironment());
        this.cbSync.setSelectedItem(serverRecord.getSyncFactory());
        this.cbX11.setSelected(serverRecord.getX11Forwarding());
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                HostPropertiesDialog.this.tfName.requestFocus();
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
        this.setError(null);
    }

    private void initComponents() {
        this.connectionPanel = new JPanel();
        this.serverRecordPanel = new JPanel();
        this.cbSync = new JComboBox();
        this.tfName = new JTextField();
        this.lblName = new JLabel();
        this.cbX11 = new JCheckBox();
        this.lblSync = new JLabel();
        this.errorLabel = new JLabel();
        this.connectionPanel.setLayout(new BorderLayout());
        this.serverRecordPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(HostPropertiesDialog.class, (String)"HostPropertiesDialog.serverRecordPanel.border.title")));
        this.tfName.setText(NbBundle.getMessage(HostPropertiesDialog.class, (String)"HostPropertiesDialog.tfName.text"));
        this.lblName.setLabelFor(this.tfName);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getMessage(HostPropertiesDialog.class, (String)"HostPropertiesDialog.lblName.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbX11, (String)NbBundle.getMessage(HostPropertiesDialog.class, (String)"HostPropertiesDialog.cbX11.text"));
        this.cbX11.setMargin(new Insets(0, 0, 0, 0));
        this.lblSync.setLabelFor(this.cbSync);
        Mnemonics.setLocalizedText((JLabel)this.lblSync, (String)NbBundle.getMessage(HostPropertiesDialog.class, (String)"HostPropertiesDialog.lblSync.text"));
        GroupLayout serverRecordPanelLayout = new GroupLayout(this.serverRecordPanel);
        this.serverRecordPanel.setLayout(serverRecordPanelLayout);
        serverRecordPanelLayout.setHorizontalGroup(serverRecordPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(serverRecordPanelLayout.createSequentialGroup().addContainerGap().addGroup(serverRecordPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(serverRecordPanelLayout.createSequentialGroup().addGroup(serverRecordPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblName, -1, -1, Short.MAX_VALUE).addComponent(this.lblSync, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(serverRecordPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbSync, 0, 319, Short.MAX_VALUE).addComponent(this.tfName, -1, 319, Short.MAX_VALUE)).addGap(12, 12, 12)).addGroup(serverRecordPanelLayout.createSequentialGroup().addComponent(this.cbX11).addContainerGap(288, Short.MAX_VALUE)))));
        serverRecordPanelLayout.setVerticalGroup(serverRecordPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(serverRecordPanelLayout.createSequentialGroup().addGroup(serverRecordPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfName, -2, -1, -2).addComponent(this.lblName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(serverRecordPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblSync).addComponent(this.cbSync, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.cbX11).addContainerGap(-1, Short.MAX_VALUE)));
        this.errorLabel.setForeground(Color.red);
        this.errorLabel.setText(NbBundle.getMessage(HostPropertiesDialog.class, (String)"HostPropertiesDialog.errorLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.connectionPanel, GroupLayout.Alignment.LEADING, -1, 459, Short.MAX_VALUE).addComponent(this.serverRecordPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.errorLabel, -1, 447, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.connectionPanel, -1, 107, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.serverRecordPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorLabel)));
    }

    private void setError(final String error) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                HostPropertiesDialog.this.ok.setEnabled(error == null);
                HostPropertiesDialog.this.errorLabel.setText(error == null ? " " : error);
            }
        });
    }

    private class ValidationListenerImpl
    implements ValidatablePanelListener {
        private ValidationListenerImpl() {
        }

        public void stateChanged(ValidateablePanel src) {
            HostPropertiesDialog.this.setError(src.hasProblem() ? src.getProblem() : null);
        }
    }
}

