/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync.download;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.util.Exceptions;

class HostUpdatesPersistence {
    private final Properties data = new Properties();
    private final File dataFile;
    private static final String VERSION = "1.0";
    private static final String VERSION_KEY = "____VERSION";

    public HostUpdatesPersistence(File privProjectStorageDir, ExecutionEnvironment executionEnvironment) {
        String dataFileName = "downloads-" + executionEnvironment.getHost() + '-' + executionEnvironment.getUser() + '-' + executionEnvironment.getSSHPort();
        this.dataFile = new File(privProjectStorageDir, dataFileName);
        try {
            this.load();
            if (!VERSION.equals(this.data.get(VERSION_KEY))) {
                this.data.clear();
            }
        }
        catch (IOException ex) {
            this.data.clear();
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws IOException {
        if (this.dataFile.exists()) {
            FileInputStream is = new FileInputStream(this.dataFile);
            BufferedInputStream bs = new BufferedInputStream(is);
            try {
                this.data.load(bs);
            }
            finally {
                bs.close();
            }
        }
    }

    @SuppressWarnings(value={"RV"})
    public void store() {
        block3: {
            File dir = this.dataFile.getParentFile();
            if (!dir.exists() && !dir.mkdirs()) {
                System.err.printf("Error creating directory %s\n", dir.getAbsolutePath());
            }
            try {
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this.dataFile));
                this.data.setProperty(VERSION_KEY, VERSION);
                this.data.store(os, null);
                ((OutputStream)os).close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                if (this.dataFile.delete()) break block3;
                System.err.printf("Error deleting file %s\n", this.dataFile.getAbsolutePath());
            }
        }
    }

    public boolean getFileSelected(File file, boolean defaultValue) {
        return this.getBoolean(file.getAbsolutePath(), defaultValue);
    }

    public void setFileSelected(File file, boolean selected) {
        this.setBoolean(file.getAbsolutePath(), selected);
    }

    public boolean getRememberChoice() {
        return this.getBoolean("", false);
    }

    public void setRememberChoice(boolean value) {
        this.setBoolean("", value);
    }

    private boolean getBoolean(String key, boolean defaultValue) {
        Object value = this.data.get(key);
        if ("1".equals(value)) {
            return true;
        }
        if ("0".equals(value)) {
            return false;
        }
        return defaultValue;
    }

    private void setBoolean(String key, boolean value) {
        this.data.put(key, value ? "1" : "0");
    }
}

