/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.io;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import org.netbeans.api.project.Project;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.modules.vmd.api.io.ActiveViewSupport;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.DesignDocumentAwareness;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.io.providers.DocumentSerializer;
import org.netbeans.modules.vmd.api.io.providers.IOSupport;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;

public class DataObjectContextImpl
implements DataObjectContext {
    private static final String PROJECT_TYPE_VMD_UNKNOWN = "#vmd-unknown-project-type";
    public static final transient HashMap<String, WeakReference<Project>> projectID2project = new HashMap();
    private static final long serialVersionUID = -1L;
    private DataObject dataObject;
    private volatile transient boolean initialized;
    private transient String projectID;
    private transient String projectType;

    public DataObjectContextImpl() {
    }

    public DataObjectContextImpl(DataObject dataObject) {
        this();
        assert (dataObject != null);
        this.dataObject = dataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        DataObjectContextImpl dataObjectContextImpl = this;
        synchronized (dataObjectContextImpl) {
            if (this.initialized) {
                return;
            }
            if (ProjectUtils.getProject(this) == null) {
                return;
            }
            this.projectID = ProjectUtils.getProjectID(ProjectUtils.getProject(this));
            DocumentSerializer documentSerializer = IOSupport.getDocumentSerializer(this.dataObject);
            this.projectType = documentSerializer.getProjectType();
            if (this.projectType == null) {
                this.projectType = PROJECT_TYPE_VMD_UNKNOWN;
            }
            this.initialized = true;
        }
    }

    @Override
    public String getProjectID() {
        this.initialize();
        return this.projectID;
    }

    @Override
    public String getProjectType() {
        this.initialize();
        return this.projectType;
    }

    @Override
    public DataObject getDataObject() {
        return this.dataObject;
    }

    @Override
    public CloneableEditorSupport getCloneableEditorSupport() {
        return IOSupport.getCloneableEditorSupport(this.dataObject);
    }

    @Override
    public void notifyModified() {
        IOSupport.getDataObjectInteface(this.dataObject).notifyEditorSupportModified();
    }

    public void updateFromMultiViewElementCallback(MultiViewElementCallback callback) {
    }

    @Override
    public void addDesignDocumentAwareness(DesignDocumentAwareness listener) {
        IOSupport.getDocumentSerializer(this.dataObject).addDesignDocumentAwareness(listener);
    }

    @Override
    public void removeDesignDocumentAwareness(DesignDocumentAwareness listener) {
        IOSupport.getDocumentSerializer(this.dataObject).removeDesignDocumentAwareness(listener);
    }

    @Override
    public void forceSave() {
        IOSupport.getDocumentSerializer(this.dataObject).saveDocument();
    }

    static {
        ActiveViewSupport.getDefault();
    }
}

