/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.filter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.tasklist.filter.FilterCondition;
import org.netbeans.modules.tasklist.filter.Util;
import org.netbeans.modules.tasklist.trampoline.TaskGroup;
import org.netbeans.modules.tasklist.ui.checklist.CheckList;
import org.netbeans.modules.tasklist.ui.checklist.DefaultCheckListModel;
import org.openide.util.NbBundle;

class TaskGroupCondition
extends FilterCondition {
    private boolean[] groupState;
    private TaskGroup[] groups;

    public static TaskGroupCondition[] createConditions() {
        return new TaskGroupCondition[]{new TaskGroupCondition()};
    }

    public TaskGroupCondition() {
        ArrayList groupList = new ArrayList(TaskGroup.getGroups());
        this.groups = groupList.toArray(new TaskGroup[groupList.size()]);
        this.groupState = new boolean[this.groups.length];
        Arrays.fill(this.groupState, true);
    }

    public TaskGroupCondition(TaskGroupCondition rhs) {
        super(rhs);
        this.groups = new TaskGroup[rhs.groups.length];
        this.groupState = new boolean[rhs.groupState.length];
        assert (this.groups.length == this.groupState.length);
        for (int i = 0; i < this.groups.length; ++i) {
            this.groups[i] = rhs.groups[i];
            this.groupState[i] = rhs.groupState[i];
        }
    }

    @Override
    public Object clone() {
        return new TaskGroupCondition(this);
    }

    @Override
    public boolean isTrue(Object o1) {
        TaskGroup g = (TaskGroup)o1;
        for (int i = 0; i < this.groups.length; ++i) {
            if (!this.groups[i].equals((Object)g)) continue;
            return this.groupState[i];
        }
        return true;
    }

    @Override
    public JComponent createConstantComponent() {
        CheckList list = new CheckList(new DefaultCheckListModel(this.groupState, this.groups));
        final JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createCompoundBorder(UIManager.getBorder("TextField.border"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        panel.add((Component)list, "Center");
        panel.setToolTipText(Util.getString("group_desc"));
        list.getAccessibleContext().setAccessibleName(Util.getString("LBL_PriorityCheckList"));
        list.getAccessibleContext().setAccessibleDescription(Util.getString("LBL_PriorityCheckList"));
        list.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                boolean atLeastOneGroupSelected = false;
                for (int i = 0; i < TaskGroupCondition.this.groupState.length; ++i) {
                    if (!TaskGroupCondition.this.groupState[i]) continue;
                    atLeastOneGroupSelected = true;
                    break;
                }
                panel.putClientProperty("value-valid", new Boolean(atLeastOneGroupSelected));
            }
        });
        return panel;
    }

    @Override
    public void getConstantFrom(JComponent cmp) {
    }

    @Override
    protected String getDisplayName() {
        return NbBundle.getMessage(TaskGroupCondition.class, (String)"IsOneOf");
    }

    @Override
    void load(Preferences prefs, String prefix) throws BackingStoreException {
        for (int i = 0; i < this.groups.length; ++i) {
            String groupName = this.groups[i].getName();
            this.groupState[i] = prefs.getBoolean(prefix + "_enabled_" + groupName, true);
        }
    }

    @Override
    void save(Preferences prefs, String prefix) throws BackingStoreException {
        for (int i = 0; i < this.groups.length; ++i) {
            String groupName = this.groups[i].getName();
            prefs.putBoolean(prefix + "_enabled_" + groupName, this.groupState[i]);
        }
    }
}

