/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.startup.StartLog;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

class WarmUpSupport
implements Runnable {
    private static final int WARMUP_DELAY = 1500;
    static boolean finished = false;
    private Logger err = Logger.getLogger("org.netbeans.core.WarmUpSupport");

    WarmUpSupport() {
    }

    static void warmUp() {
        RequestProcessor.getDefault().post((Runnable)new WarmUpSupport(), 1500);
    }

    @Override
    public void run() {
        this.err.fine("Warmup starting...");
        StartLog.logStart((String)"Warmup");
        Collection warmObjects = Lookups.forPath((String)"WarmUp").lookupResult(Runnable.class).allItems();
        this.err.log(Level.FINE, "Found {0} warm up task(s)", warmObjects.size());
        for (Lookup.Item warmer : warmObjects) {
            try {
                Runnable r = (Runnable)warmer.getInstance();
                r.run();
                StartLog.logProgress((String)("Warmup task executed " + warmer.getId()));
            }
            catch (Exception ex) {
                Logger.getLogger(WarmUpSupport.class.getName()).log(Level.WARNING, null, ex);
            }
        }
        this.err.fine("Warmup done.");
        StartLog.logEnd((String)"Warmup");
        finished = true;
    }
}

