/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.api;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.csl.api.InstantRenamer;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.csl.editor.InstantRenamePerformer;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class InstantRenameAction
extends BaseAction {
    public InstantRenameAction() {
        super("in-place-refactoring", 10);
    }

    public void actionPerformed(ActionEvent evt, final JTextComponent target) {
        try {
            final int caret = target.getCaretPosition();
            String ident = Utilities.getIdentifier((BaseDocument)Utilities.getDocument((JTextComponent)target), (int)caret);
            if (ident == null) {
                Utilities.setStatusBoldText((JTextComponent)target, (String)NbBundle.getMessage(InstantRenameAction.class, (String)"InstantRenameDenied"));
                return;
            }
            if (IndexingManager.getDefault().isIndexing()) {
                Utilities.setStatusBoldText((JTextComponent)target, (String)NbBundle.getMessage(InstantRenameAction.class, (String)"scanning-in-progress"));
                return;
            }
            Source js = Source.create((FileObject)DataLoadersBridge.getDefault().getFileObject(target));
            if (js == null) {
                return;
            }
            final Set[] changePoints = new Set[1];
            ParserManager.parse(Collections.singleton(js), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    HashMap<String, Parser.Result> embeddedResults = new HashMap<String, Parser.Result>();
                    block0: while (true) {
                        embeddedResults.put(resultIterator.getParserResult().getSnapshot().getMimeType(), resultIterator.getParserResult());
                        Iterable embeddings = resultIterator.getEmbeddings();
                        for (Embedding e : embeddings) {
                            if (!e.containsOriginalOffset(caret)) continue;
                            resultIterator = resultIterator.getResultIterator(e);
                            continue block0;
                        }
                        break;
                    }
                    BaseDocument baseDoc = (BaseDocument)target.getDocument();
                    List<Language> list = LanguageRegistry.getInstance().getEmbeddedLanguages(baseDoc, caret);
                    for (Language language : list) {
                        if (language.getInstantRenamer() == null) continue;
                        Parser.Result result = (Parser.Result)embeddedResults.get(language.getMimeType());
                        if (!(result instanceof ParserResult)) {
                            return;
                        }
                        ParserResult parserResult = (ParserResult)result;
                        InstantRenamer renamer = language.getInstantRenamer();
                        assert (renamer != null);
                        String[] descRetValue = new String[1];
                        if (!renamer.isRenameAllowed(parserResult, caret, descRetValue)) {
                            return;
                        }
                        Set<OffsetRange> regions = renamer.getRenameRegions(parserResult, caret);
                        if (regions == null || regions.size() <= 0) break;
                        changePoints[0] = regions;
                        break;
                    }
                }
            });
            if (changePoints[0] != null) {
                this.doInstantRename(changePoints[0], target, caret, ident);
            } else {
                this.doFullRename(DataLoadersBridge.getDefault().getCookie(target, EditorCookie.class), DataLoadersBridge.getDefault().getNodeDelegate(target));
            }
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
        }
        catch (ParseException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
        }
    }

    protected Class getShortDescriptionBundleClass() {
        return InstantRenameAction.class;
    }

    private void doInstantRename(Set<OffsetRange> changePoints, JTextComponent target, int caret, String ident) throws BadLocationException {
        InstantRenamePerformer.performInstantRename(target, changePoints, caret);
    }

    private void doFullRename(EditorCookie ec, Node n) {
        InstanceContent ic = new InstanceContent();
        ic.add((Object)ec);
        ic.add((Object)n);
        AbstractLookup actionContext = new AbstractLookup((AbstractLookup.Content)ic);
        Action a = RefactoringActionsFactory.renameAction().createContextAwareInstance((Lookup)actionContext);
        a.actionPerformed(RefactoringActionsFactory.DEFAULT_EVENT);
    }
}

