/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.zend.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.api.editor.PhpBaseElement;
import org.netbeans.modules.php.api.editor.PhpClass;
import org.netbeans.modules.php.api.editor.PhpVariable;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.spi.editor.EditorExtender;
import org.netbeans.modules.php.zend.util.ZendUtils;
import org.openide.filesystems.FileObject;

public class ZendEditorExtender
extends EditorExtender {
    static final Logger LOGGER = Logger.getLogger(ZendEditorExtender.class.getName());

    public List<PhpBaseElement> getElementsForCodeCompletion(FileObject fo) {
        if (ZendUtils.isView(fo)) {
            return new ArrayList<PhpVariable>(this.parseAction(fo));
        }
        return Collections.emptyList();
    }

    private Set<PhpVariable> parseAction(final FileObject view) {
        assert (ZendUtils.isView(view)) : "Not a view: " + view;
        FileObject action = ZendUtils.getAction(view);
        if (action == null) {
            return Collections.emptySet();
        }
        final HashSet<PhpVariable> phpVariables = new HashSet<PhpVariable>();
        try {
            ParserManager.parse(Collections.singleton(Source.create((FileObject)action)), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    ParserResult parseResult = (ParserResult)resultIterator.getParserResult();
                    ZendControllerVisitor controllerVisitor = new ZendControllerVisitor(view, (PHPParseResult)parseResult);
                    controllerVisitor.scan((ASTNode)Utils.getRoot((ParserResult)parseResult));
                    phpVariables.add(controllerVisitor.getView());
                }
            });
        }
        catch (ParseException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        return phpVariables;
    }

    private static final class ZendControllerVisitor
    extends DefaultVisitor {
        private final String actionName;
        private final FileObject action;
        private final PHPParseResult actionParseResult;
        private final PhpVariable view = new PhpVariable("$this", new PhpClass("Zend_View_Interface", "Zend_View_Interface"));
        private String className = null;
        private String methodName = null;

        public ZendControllerVisitor(FileObject view, PHPParseResult actionParseResult) {
            assert (view != null);
            assert (actionParseResult != null);
            this.actionParseResult = actionParseResult;
            this.actionName = ZendUtils.getActionName(view);
            this.action = ZendUtils.getAction(view);
        }

        public void visit(ClassDeclaration node) {
            this.className = CodeUtils.extractClassName((ClassDeclaration)node).toLowerCase();
            super.visit(node);
        }

        public void visit(MethodDeclaration node) {
            this.methodName = CodeUtils.extractMethodName((MethodDeclaration)node).toLowerCase();
            super.visit(node);
        }

        public void visit(Assignment assignment) {
            super.visit(assignment);
            if (assignment.getLeftHandSide() instanceof FieldAccess) {
                Variable var;
                FieldAccess fieldAccess;
                FieldAccess node = (FieldAccess)assignment.getLeftHandSide();
                if (this.className != null && this.methodName != null && this.className.endsWith("Controller".toLowerCase()) && this.methodName.equalsIgnoreCase(this.actionName) && node.getDispatcher() instanceof FieldAccess && "view".equals(CodeUtils.extractVariableName((Variable)(fieldAccess = (FieldAccess)node.getDispatcher()).getField())) && fieldAccess.getDispatcher() instanceof Variable && "$this".equals(CodeUtils.extractVariableName((Variable)(var = (Variable)fieldAccess.getDispatcher())))) {
                    String name = null;
                    String fqn = null;
                    Iterator i$ = ModelUtils.resolveType((Model)this.actionParseResult.getModel(), (Assignment)assignment).iterator();
                    if (i$.hasNext()) {
                        TypeScope typeScope = (TypeScope)i$.next();
                        name = typeScope.getName();
                        fqn = typeScope.getFullyQualifiedName().toString();
                    }
                    Variable field = node.getField();
                    PhpClass type = this.view.getType();
                    type.addField("$" + CodeUtils.extractVariableName((Variable)field), name != null ? new PhpClass(name, fqn) : null, this.action, ASTNodeInfo.toOffsetRangeVar((Variable)field).getStart());
                }
            }
        }

        public PhpVariable getView() {
            return this.view;
        }
    }
}

