/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplateManager;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.html.editor.api.gsf.HtmlExtension;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.spi.lexer.MutableTextInput;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class HtmlHintsProvider
implements HintsProvider {
    private static final HtmlRule ERROR_RULE = new HtmlRule(HintSeverity.ERROR, true);
    private static final HtmlRule WARNING_RULE = new HtmlRule(HintSeverity.WARNING, true);
    static final String DISABLE_ERROR_CHECKS_KEY = "disable_error_checking";

    public void computeHints(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints) {
    }

    public void computeSuggestions(HintsProvider.HintsManager manager, RuleContext context, List<Hint> suggestions, int caretOffset) {
    }

    public void computeSelectionHints(HintsProvider.HintsManager manager, RuleContext context, List<Hint> suggestions, int start, int end) {
        for (HtmlExtension ext : HtmlExtension.getRegisteredExtensions(context.parserResult.getSnapshot().getSource().getMimeType())) {
            ext.computeSelectionHints(manager, context, suggestions, start, end);
        }
    }

    public void computeErrors(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints, List<Error> unhandled) {
        Snapshot snapshot = context.parserResult.getSnapshot();
        FileObject fo = snapshot.getSource().getFileObject();
        if (HtmlHintsProvider.isErrorCheckingEnabled(fo)) {
            for (Error e : context.parserResult.getDiagnostics()) {
                assert (e.getDescription() != null);
                DisableErrorChecksFix disableChecksFix = new DisableErrorChecksFix(snapshot);
                int astFrom = e.getStartPosition();
                int astTo = e.getEndPosition();
                int from = snapshot.getOriginalOffset(astFrom);
                int to = snapshot.getOriginalOffset(astTo);
                if (from == -1 && to == -1) continue;
                if (from == -1 && to != -1) {
                    from = to;
                } else if (from != -1 && to == -1) {
                    to = from;
                }
                ArrayList<HintFix> fixes = new ArrayList<HintFix>(3);
                fixes.addAll(HtmlHintsProvider.getCustomHintFixesForError(context, e));
                fixes.add(disableChecksFix);
                Hint h = new Hint((Rule)HtmlHintsProvider.getRule(e.getSeverity()), e.getDescription(), e.getFile(), new OffsetRange(from, to), fixes, 20);
                hints.add(h);
            }
        } else {
            EnableErrorChecksFix fix = new EnableErrorChecksFix(snapshot);
            Hint h = new Hint((Rule)new HtmlRule(HintSeverity.WARNING, false), NbBundle.getMessage(HtmlHintsProvider.class, (String)"MSG_HINT_ENABLE_ERROR_CHECKS_FILE_DESCR"), fo, new OffsetRange(0, 0), Collections.singletonList(fix), 50);
            hints.add(h);
        }
        for (HtmlExtension ext : HtmlExtension.getRegisteredExtensions(context.parserResult.getSnapshot().getSource().getMimeType())) {
            ext.computeErrors(manager, context, hints, unhandled);
        }
    }

    private static Collection<HintFix> getCustomHintFixesForError(final RuleContext context, final Error e) {
        ArrayList<HintFix> fixes = new ArrayList<1>();
        if (e.getKey().equals("missing_required_attribute")) {
            fixes.add(new HintFix(){

                public String getDescription() {
                    return NbBundle.getMessage(HtmlHintsProvider.class, (String)"MSG_HINT_GENERATE_REQUIRED_ATTRIBUTES");
                }

                public void implement() throws Exception {
                    AstNode node = HtmlParserResult.getBoundAstNode(e);
                    Collection missingAttrs = (Collection)node.getProperty("missing_required_attribute");
                    assert (missingAttrs != null);
                    int astOffset = node.startOffset() + 1 + node.name().length();
                    int insertOffset = context.parserResult.getSnapshot().getOriginalOffset(astOffset);
                    if (insertOffset == -1) {
                        return;
                    }
                    StringBuffer templateText = new StringBuffer();
                    templateText.append(' ');
                    for (String attr : missingAttrs) {
                        templateText.append(attr);
                        templateText.append('=');
                        templateText.append('\"');
                        templateText.append("${");
                        templateText.append(attr);
                        templateText.append(" default=\"\"}");
                        templateText.append('\"');
                        templateText.append(' ');
                    }
                    templateText.append("${cursor}");
                    CodeTemplate ct = CodeTemplateManager.get((Document)context.doc).createTemporary(templateText.toString());
                    JTextComponent pane = EditorRegistry.focusedComponent();
                    if (pane != null) {
                        pane.setCaretPosition(insertOffset);
                        ct.insert(pane);
                    }
                }

                public boolean isSafe() {
                    return true;
                }

                public boolean isInteractive() {
                    return false;
                }
            });
        } else {
            fixes = Collections.emptyList();
        }
        return fixes;
    }

    public void cancel() {
    }

    public List<Rule> getBuiltinRules() {
        return null;
    }

    public RuleContext createRuleContext() {
        return new RuleContext();
    }

    private static HtmlRule getRule(Severity s) {
        switch (s) {
            case WARNING: {
                return WARNING_RULE;
            }
            case ERROR: {
                return ERROR_RULE;
            }
        }
        throw new AssertionError((Object)"Unexpected severity level");
    }

    public static boolean isErrorCheckingEnabled(FileObject fo) {
        return fo.getAttribute(DISABLE_ERROR_CHECKS_KEY) == null;
    }

    private static void forceReparse(final Document doc) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NbEditorDocument nbdoc = (NbEditorDocument)doc;
                nbdoc.runAtomic(new Runnable(){

                    @Override
                    public void run() {
                        MutableTextInput mti = (MutableTextInput)doc.getProperty(MutableTextInput.class);
                        if (mti != null) {
                            mti.tokenHierarchyControl().rebuild();
                        }
                    }
                });
            }
        });
    }

    private static final class EnableErrorChecksFix
    implements HintFix {
        private Snapshot snapshot;

        public EnableErrorChecksFix(Snapshot snapshot) {
            this.snapshot = snapshot;
        }

        public String getDescription() {
            return NbBundle.getMessage(HtmlHintsProvider.class, (String)"MSG_HINT_ENABLE_ERROR_CHECKS_FILE");
        }

        public void implement() throws Exception {
            Document doc;
            FileObject fo = this.snapshot.getSource().getFileObject();
            if (fo != null) {
                fo.setAttribute(HtmlHintsProvider.DISABLE_ERROR_CHECKS_KEY, null);
            }
            if ((doc = this.snapshot.getSource().getDocument(false)) != null) {
                HtmlHintsProvider.forceReparse(doc);
            }
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private static final class DisableErrorChecksFix
    implements HintFix {
        private static String VALUE = "true";
        private Snapshot snapshot;

        public DisableErrorChecksFix(Snapshot snapshot) {
            this.snapshot = snapshot;
        }

        public String getDescription() {
            return NbBundle.getMessage(HtmlHintsProvider.class, (String)"MSG_HINT_DISABLE_ERROR_CHECKS_FILE");
        }

        public void implement() throws Exception {
            Document doc;
            FileObject fo = this.snapshot.getSource().getFileObject();
            if (fo != null) {
                fo.setAttribute(HtmlHintsProvider.DISABLE_ERROR_CHECKS_KEY, (Object)VALUE);
            }
            if ((doc = this.snapshot.getSource().getDocument(false)) != null) {
                HtmlHintsProvider.forceReparse(doc);
            }
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private static final class HtmlRule
    implements Rule.ErrorRule {
        private HintSeverity severity;
        private boolean showInTasklist;

        private HtmlRule(HintSeverity severity, boolean showInTaskList) {
            this.severity = severity;
            this.showInTasklist = showInTaskList;
        }

        public Set<?> getCodes() {
            return Collections.emptySet();
        }

        public boolean appliesTo(RuleContext context) {
            return true;
        }

        public String getDisplayName() {
            return "html";
        }

        public boolean showInTasklist() {
            return this.showInTasklist;
        }

        public HintSeverity getDefaultSeverity() {
            return this.severity;
        }
    }
}

