/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.impl;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.spi.HudsonLogger;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class JavaHudsonLogger
implements HudsonLogger {
    private static final Logger LOG = Logger.getLogger(JavaHudsonLogger.class.getName());
    private static final Pattern STACK_TRACE = Pattern.compile("(?:\t|\\[catch\\] )at ((?:[a-zA-Z_$][a-zA-Z0-9_$]*\\.)*)[a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z_$<][a-zA-Z0-9_$>]*\\(([a-zA-Z_$][a-zA-Z0-9_$]*\\.java):([0-9]+)\\)");

    @Override
    public HudsonLogger.HudsonLogSession createSession(HudsonJob job) {
        return new Session();
    }

    private static class Hyperlink
    implements OutputListener {
        private final FileObject source;
        private final int lineNumber;

        Hyperlink(FileObject source, int lineNumber) {
            this.source = source;
            this.lineNumber = lineNumber;
        }

        public void outputLineAction(OutputEvent ev) {
            this.acted(true);
        }

        public void outputLineSelected(OutputEvent ev) {
            this.acted(false);
        }

        public void outputLineCleared(OutputEvent ev) {
        }

        private void acted(final boolean force) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    HudsonLogger.Helper.openAt(Hyperlink.this.source, Hyperlink.this.lineNumber - 1, -1, force);
                }
            });
        }
    }

    private static class Session
    implements HudsonLogger.HudsonLogSession {
        private Session() {
        }

        @Override
        public boolean handle(String line, OutputWriter stream) {
            Matcher m = STACK_TRACE.matcher(line);
            if (!m.matches()) {
                return false;
            }
            String pkg = m.group(1);
            String filename = m.group(2);
            String resource = pkg.replace('.', '/') + filename;
            int lineNumber = Integer.parseInt(m.group(3));
            FileObject source = GlobalPathRegistry.getDefault().findResource(resource);
            if (source != null) {
                try {
                    stream.println(line, (OutputListener)new Hyperlink(source, lineNumber));
                    return true;
                }
                catch (IOException x) {
                    LOG.log(Level.INFO, null, x);
                }
            }
            stream.println(line);
            return true;
        }
    }
}

