/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.core.assistance;

import java.awt.Color;
import java.util.Iterator;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.modules.cnd.asm.core.assistance.RegisterHighlightAction;
import org.netbeans.modules.cnd.asm.core.dataobjects.AsmObjectUtilities;
import org.netbeans.modules.cnd.asm.core.ui.top.RegisterUsagesPanel;
import org.netbeans.modules.cnd.asm.model.AsmModelAccessor;
import org.netbeans.modules.cnd.asm.model.lang.OperandElement;
import org.netbeans.modules.cnd.asm.model.util.IntervalSet;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;

public class RegisterHighlightAssistance
extends AbstractHighlightsContainer
implements CaretListener,
AsmModelAccessor.ParseListener {
    public static final String LAYER_NAME = "reg-highlight-layer";
    public static final Color READ_COLORING = RegisterUsagesPanel.READ_COLOR;
    public static final Color WRITE_COLORING = RegisterUsagesPanel.WRITE_COLOR;
    private final JTextComponent pane;
    private IntervalSet<RegisterHighlightAction.HighlightEntry> highlight = new IntervalSet();
    private final RegisterHighlightAction action = new RegisterHighlightAction();

    public RegisterHighlightAssistance(JTextComponent pane, Document doc) {
        this.pane = pane;
        pane.addCaretListener(this);
        AsmModelAccessor acc = AsmObjectUtilities.getAccessor(doc);
        if (acc == null) {
            return;
        }
        acc.addParseListener(this);
    }

    private void update() {
        AsmModelAccessor acc = AsmObjectUtilities.getAccessor(this.pane);
        if (acc == null) {
            return;
        }
        IntervalSet<RegisterHighlightAction.HighlightEntry> newHighlight = this.action.getHighlight(acc.getState(), this.pane.getCaretPosition());
        if (newHighlight.isEmpty() && this.highlight.isEmpty()) {
            return;
        }
        int start = 0;
        int end = 0;
        if (newHighlight.isEmpty()) {
            start = this.highlight.getLowerBound();
            end = this.highlight.getUpperBound();
        } else if (this.highlight.isEmpty()) {
            start = newHighlight.getLowerBound();
            end = newHighlight.getUpperBound();
        } else {
            start = Math.min(this.highlight.getLowerBound(), newHighlight.getLowerBound());
            end = Math.max(this.highlight.getUpperBound(), newHighlight.getUpperBound());
        }
        this.highlight = newHighlight;
        super.fireHighlightsChange(start, end);
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.update();
    }

    @Override
    public void notifyParsed() {
        this.update();
    }

    public HighlightsSequence getHighlights(int startOffset, int endOffset) {
        return new RegisterHighlightsSequence(this.highlight.getFromBounds(startOffset, endOffset));
    }

    private static class RegisterHighlightsSequence
    implements HighlightsSequence {
        private RegisterHighlightAction.HighlightEntry cur;
        private Iterator<RegisterHighlightAction.HighlightEntry> it;

        public RegisterHighlightsSequence(IntervalSet<RegisterHighlightAction.HighlightEntry> acc) {
            this.it = acc.iterator();
        }

        public boolean moveNext() {
            if (!this.it.hasNext()) {
                return false;
            }
            this.cur = this.it.next();
            return true;
        }

        public int getStartOffset() {
            return this.cur.getStartOffset();
        }

        public int getEndOffset() {
            return this.cur.getEndOffset();
        }

        public AttributeSet getAttributes() {
            Color res = null;
            if (this.cur.getUsage().contains(OperandElement.Usage.OP_USE_WRITE)) {
                res = WRITE_COLORING;
            } else if (this.cur.getUsage().contains(OperandElement.Usage.OP_USE_READ)) {
                res = READ_COLORING;
            }
            SimpleAttributeSet attrs = new SimpleAttributeSet();
            if (res != null) {
                attrs.addAttribute(StyleConstants.Background, res);
            }
            return attrs;
        }
    }
}

