/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.checkout;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.checkout.CheckoutCommand;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.executor.CheckoutExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.wizards.CheckoutWizard;
import org.netbeans.modules.versioning.util.ProjectUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public final class CheckoutAction
extends SystemAction {
    private static final String SHOW_CHECKOUT_COMPLETED = "checkoutAction.showCheckoutCompleted";

    public CheckoutAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getBundle(CheckoutAction.class).getString("CTL_MenuItem_Checkout_Label");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CheckoutAction.class);
    }

    public void actionPerformed(ActionEvent ev) {
        this.perform();
    }

    public CheckoutExecutor checkout(String cvsRoot, String modules, String tag, String workingDir, boolean scanProject, ExecutorGroup group) {
        StringTokenizer tokenizer;
        CheckoutCommand cmd = new CheckoutCommand();
        String moduleString = modules;
        if (moduleString == null || moduleString.length() == 0) {
            moduleString = ".";
        }
        if ((tokenizer = new StringTokenizer(moduleString, ",;")).countTokens() == 1) {
            cmd.setModule(moduleString);
        } else {
            ArrayList<String> moduleList = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                String s = tokenizer.nextToken().trim();
                moduleList.add(s);
            }
            String[] modules2 = moduleList.toArray(new String[moduleList.size()]);
            cmd.setModules(modules2);
        }
        cmd.setDisplayName(NbBundle.getMessage(CheckoutAction.class, (String)"BK1006"));
        if (tag != null) {
            cmd.setCheckoutByRevision(tag);
        } else {
            cmd.setResetStickyOnes(true);
        }
        cmd.setPruneDirectories(CvsModuleConfig.getDefault().getAutoPruneDirectories());
        cmd.setRecursive(true);
        File workingFolder = new File(workingDir);
        File[] files = new File[]{workingFolder};
        cmd.setFiles(files);
        CvsVersioningSystem cvs = CvsVersioningSystem.getInstance();
        GlobalOptions gtx = CvsVersioningSystem.createGlobalOptions();
        gtx.setCVSRoot(cvsRoot);
        boolean execute = false;
        if (group == null) {
            execute = true;
            group = new ExecutorGroup(NbBundle.getMessage(CheckoutAction.class, (String)"BK1013"));
        }
        CheckoutExecutor executor = new CheckoutExecutor(cvs, cmd, gtx, workingFolder);
        group.addExecutor(executor);
        if (CvsModuleConfig.getDefault().getPreferences().getBoolean(SHOW_CHECKOUT_COMPLETED, true) && scanProject) {
            group.addBarrier(new CheckoutCompletedController(executor, workingFolder));
        }
        if (execute) {
            group.execute();
        }
        return executor;
    }

    public void perform() {
        CheckoutWizard wizard = new CheckoutWizard();
        if (!wizard.show()) {
            return;
        }
        final String tag = wizard.getTag();
        final String modules = wizard.getModules();
        final String workDir = wizard.getWorkingDir();
        final String cvsRoot = wizard.getCvsRoot();
        CvsVersioningSystem.getInstance().getParallelRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                CheckoutAction.this.checkout(cvsRoot, modules, tag, workDir, true, null);
            }
        });
    }

    private class CheckoutCompletedController
    implements Runnable {
        private final CheckoutExecutor executor;
        private final File workingFolder;

        public CheckoutCompletedController(CheckoutExecutor executor, File workingFolder) {
            this.executor = executor;
            this.workingFolder = workingFolder;
        }

        @Override
        public void run() {
            if (!this.executor.isSuccessful()) {
                return;
            }
            HashMap checkedOutProjects = new HashMap();
            checkedOutProjects.put(null, new HashSet());
            File normalizedWorkingFolder = FileUtil.normalizeFile((File)this.workingFolder);
            this.refreshRecursively(normalizedWorkingFolder);
            FileObject fo = FileUtil.toFileObject((File)normalizedWorkingFolder);
            if (fo != null) {
                String name = NbBundle.getMessage(CheckoutAction.class, (String)"BK1007");
                this.executor.getGroup().progress(name);
                for (String module : this.executor.getExpandedModules()) {
                    if (".".equals(module)) {
                        ProjectUtilities.scanForProjects((FileObject)fo, checkedOutProjects);
                        break;
                    }
                    FileObject subfolder = fo.getFileObject(module);
                    if (subfolder == null) continue;
                    this.executor.getGroup().progress(name);
                    ProjectUtilities.scanForProjects((FileObject)subfolder, checkedOutProjects);
                }
            }
            ProjectUtilities.openCheckedOutProjects(checkedOutProjects, (File)this.workingFolder);
        }

        private void refreshRecursively(File folder) {
            if (folder == null) {
                return;
            }
            this.refreshRecursively(folder.getParentFile());
            CvsVersioningSystem.getInstance().getStatusCache().refresh(folder, 0);
        }
    }
}

