/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.provider.jffi.StubCompiler;
import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.NativeMethod;
import com.kenai.jffi.NativeMethods;
import com.kenai.jffi.PageManager;
import com.kenai.jnr.x86asm.Assembler;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

abstract class AbstractX86StubCompiler
extends StubCompiler {
    static final Map<Class, PageHolder> pages = Collections.synchronizedMap(new WeakHashMap());
    final List<Stub> stubs = new LinkedList<Stub>();

    AbstractX86StubCompiler() {
    }

    void attach(Class clazz) {
        long npages;
        if (this.stubs.isEmpty()) {
            return;
        }
        long codeSize = 0L;
        for (Stub stub : this.stubs) {
            codeSize += (long)(stub.assembler.codeSize() + 8);
        }
        PageManager pm = PageManager.getInstance();
        long code = pm.allocatePages((int)(npages = (codeSize + pm.pageSize() - 1L) / pm.pageSize()), 3);
        if (code == 0L) {
            throw new OutOfMemoryError("allocatePages failed for codeSize=" + codeSize);
        }
        PageHolder page = new PageHolder(code, npages);
        ArrayList<NativeMethod> methods2 = new ArrayList<NativeMethod>(this.stubs.size());
        long fn = code;
        for (Stub stub : this.stubs) {
            Assembler asm = stub.assembler;
            fn = AbstractX86StubCompiler.align(fn, 8L);
            ByteBuffer buf = MemoryIO.getInstance().newDirectByteBuffer(fn, asm.codeSize()).order(ByteOrder.LITTLE_ENDIAN);
            stub.assembler.relocCode(buf, fn);
            methods2.add(new NativeMethod(fn, stub.name, stub.signature));
            fn += (long)asm.codeSize();
        }
        pm.protectPages(code, (int)npages, 5);
        NativeMethods.register(clazz, methods2);
        pages.put(clazz, page);
    }

    static final int align(int offset2, int align) {
        return align + (offset2 - 1 & ~(align - 1));
    }

    static final long align(long offset2, long align) {
        return align + (offset2 - 1L & (align - 1L ^ 0xFFFFFFFFFFFFFFFFL));
    }

    final class PageHolder {
        final long memory;
        final long pageCount;

        public PageHolder(long memory, long pageCount) {
            this.memory = memory;
            this.pageCount = pageCount;
        }

        protected void finalize() throws Throwable {
            PageManager.getInstance().freePages(this.memory, (int)this.pageCount);
        }
    }

    final class Stub {
        final String name;
        final String signature;
        final Assembler assembler;

        public Stub(String name2, String signature, Assembler assembler) {
            this.name = name2;
            this.signature = signature;
            this.assembler = assembler;
        }
    }
}

