/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer.regex;

import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.swing.UIManager;
import org.netbeans.modules.mobility.project.ui.customizer.regex.CheckedNodeEditor;
import org.netbeans.modules.mobility.project.ui.customizer.regex.CheckedNodeRenderer;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class CheckedTreeBeanView
extends BeanTreeView {
    private FileObject root;
    private Pattern filter;
    private Map<String, Object> data;
    private final CheckedNodeRenderer renderer;
    private final CheckedNodeEditor editor;
    private Map<String, Object> properties;
    private String propertyName;
    static final Object SELECTED = new Object();
    static final Object UNSELECTED = new Object();
    static final Object MIXED = new Object();

    public CheckedTreeBeanView() {
        FocusListener[] fl = this.tree.getFocusListeners();
        for (int i = 0; i < fl.length; ++i) {
            if (!fl[i].getClass().getName().startsWith("org.openide")) continue;
            this.tree.removeFocusListener(fl[i]);
        }
        MouseListener[] ml = this.tree.getMouseListeners();
        for (int i = 0; i < ml.length; ++i) {
            if (!ml[i].getClass().getName().startsWith("org.openide")) continue;
            this.tree.removeMouseListener(ml[i]);
        }
        this.renderer = new CheckedNodeRenderer(this.tree.getCellRenderer());
        this.tree.setCellRenderer(this.renderer);
        this.editor = new CheckedNodeEditor(this.tree);
        this.tree.setCellEditor(this.editor);
        this.tree.setEditable(true);
    }

    public void setEditable(boolean editable) {
        this.tree.setEditable(editable);
        this.tree.setBackground(UIManager.getDefaults().getColor(editable ? "Tree.background" : "TextField.inactiveBackground"));
    }

    public void setSrcRoot(FileObject root) {
        this.root = root;
    }

    private boolean acceptPath(String path) {
        return path != null && (path.length() == 0 || !this.filter.matcher(path).matches());
    }

    private synchronized Object updateState(FileObject fo) {
        String path = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fo);
        if (!this.acceptPath(path)) {
            return null;
        }
        Object state = this.data.get(path);
        boolean forceState = state == SELECTED || state == UNSELECTED;
        Enumeration en = fo.getChildren(forceState);
        while (en.hasMoreElements()) {
            FileObject ch = (FileObject)en.nextElement();
            if (forceState) {
                String cp = FileUtil.getRelativePath((FileObject)this.root, (FileObject)ch);
                if (!this.acceptPath(cp)) continue;
                this.data.put(cp, state);
                continue;
            }
            Object childState = this.updateState(ch);
            if (childState == null) continue;
            if (state == null) {
                state = childState;
                continue;
            }
            if (state == childState) continue;
            state = MIXED;
        }
        if (state == null) {
            state = SELECTED;
        }
        if (path.length() > 0) {
            this.data.put(path, state);
        }
        return state;
    }

    public Object getState(FileObject fo) {
        String path = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fo);
        if (!this.acceptPath(path)) {
            return null;
        }
        return this.data.get(path);
    }

    public synchronized void setState(FileObject fo, boolean selected) {
        String path = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fo);
        if (path == null) {
            return;
        }
        this.data.put(path, selected ? SELECTED : UNSELECTED);
        for (fo = fo.getParent(); fo != null && !this.root.equals(fo); fo = fo.getParent()) {
            this.data.remove(FileUtil.getRelativePath((FileObject)this.root, (FileObject)fo));
        }
        this.updateState(this.root);
        if (this.properties != null && this.propertyName != null) {
            this.properties.put(this.propertyName, this.getExcludesRegex());
        }
    }

    public String getExcludesRegex() {
        StringBuffer sb = new StringBuffer();
        this.addExcludes(this.root, sb);
        return sb.toString();
    }

    private void addExcludes(FileObject fo, StringBuffer sb) {
        String path = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fo);
        if (!this.acceptPath(path)) {
            return;
        }
        Object state = this.data.get(path);
        if (path.length() > 0 && state == null || state == SELECTED) {
            return;
        }
        if (state == UNSELECTED) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(path);
            if (fo.isFolder()) {
                sb.append(',').append(path).append("/**");
            }
        } else {
            Enumeration en = fo.getChildren(false);
            while (en.hasMoreElements()) {
                this.addExcludes((FileObject)en.nextElement(), sb);
            }
        }
    }

    public synchronized void registerProperty(Map<String, Object> properties, String propertyName, Pattern filter) {
        this.properties = properties;
        this.propertyName = propertyName;
        if (properties == null || propertyName == null) {
            return;
        }
        this.filter = filter;
        this.data = new HashMap<String, Object>();
        String initialExcludes = (String)properties.get(propertyName);
        if (initialExcludes != null) {
            StringTokenizer stk = new StringTokenizer(initialExcludes, ",");
            while (stk.hasMoreTokens()) {
                String exclude = stk.nextToken();
                if (exclude.indexOf(42) >= 0) continue;
                this.data.put(exclude, UNSELECTED);
            }
        }
        this.updateState(this.root);
        this.renderer.setContentStorage(this);
        this.editor.setContentStorage(this);
    }
}

