/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.deployment;

import java.io.File;
import java.util.Collection;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.mobility.project.deployment.MobilityDeploymentProperties;
import org.netbeans.spi.mobility.deployment.DeploymentPlugin;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class DeploymentPropertiesHandler {
    public static void loadDeploymentProperties(final Collection<Lookup.Result> result) {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Object>(){

                public Object run() throws Exception {
                    MobilityDeploymentProperties mp = new MobilityDeploymentProperties(new RequestProcessor());
                    EditableProperties props = PropertyUtils.getGlobalProperties();
                    for (DeploymentPlugin plugin : result) {
                        String name = plugin.getDeploymentMethodName();
                        String loc = plugin.getAntScriptLocation();
                        if (loc != null) {
                            File f = new File(loc);
                            if (!f.isFile()) {
                                f = InstalledFileLocator.getDefault().locate(loc, null, false);
                            }
                            if (name != null && f != null && Utilities.isJavaIdentifier((String)name)) {
                                props.setProperty("deployment." + name + ".scriptfile", f.getAbsolutePath());
                            }
                        }
                        if (mp.getInstanceList(name).contains("default")) continue;
                        mp.createInstance(name, "default");
                    }
                    PropertyUtils.putGlobalProperties((EditableProperties)props);
                    return null;
                }
            });
        }
        catch (MutexException me) {
            ErrorManager.getDefault().notify((Throwable)me.getException());
        }
    }
}

