/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.packager.model;

import com.sun.javacard.packager.ErrorKey;
import com.sun.javacard.packager.Packager;
import com.sun.javacard.packager.model.ClassicModule;
import com.sun.javacard.packager.model.ClassicModuleJCRD;
import com.sun.javacard.packager.model.ExtendedModule;
import com.sun.javacard.packager.model.ExtendedModuleJCRD;
import com.sun.javacard.packager.model.FolderOrJar;
import com.sun.javacard.packager.model.JavaCardXML;
import com.sun.javacard.packager.model.ModuleJCRD;
import com.sun.javacard.packager.model.WebModule;
import com.sun.javacard.packager.model.WebModuleJCRD;
import com.sun.javacard.util.FileUtils;
import java.io.File;

public abstract class Module
extends FolderOrJar {
    private JavaCardXML javaCardXML;
    protected ModuleJCRD jcrd;

    public Module(String string) {
        super(string);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.isOk()) {
            return;
        }
        File file = new File(this.folder, "META-INF/MANIFEST.MF");
        if (!file.exists()) {
            this.addError(ErrorKey.JCRDDoesNotExist, new Object[0]);
        } else {
            if (this instanceof WebModule) {
                this.jcrd = new WebModuleJCRD(this, file);
            } else if (this instanceof ExtendedModule) {
                this.jcrd = new ExtendedModuleJCRD(this, file);
            } else if (this instanceof ClassicModule) {
                this.jcrd = new ClassicModuleJCRD(this, file);
            }
            this.addItem(this.jcrd);
            this.jcrd.initialize();
        }
        File file2 = new File(this.folder, "META-INF/javacard.xml");
        if (file2.exists()) {
            this.javaCardXML = new JavaCardXML(file2);
            this.addItem(this.javaCardXML);
            this.javaCardXML.initialize();
        }
    }

    @Override
    public void processInternal() {
        File file;
        if (!this.isOk()) {
            return;
        }
        this.jcrd.process();
        if (this.javaCardXML != null) {
            this.javaCardXML.process();
        }
        if (!(file = new File(Packager.getPackager().getWorkDir().getAbsolutePath())).equals(this.folder)) {
            file.mkdirs();
            try {
                FileUtils.copyDir(this.folder, file);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.javaCardXML != null) {
            try {
                this.javaCardXML.saveCanonicalizedTo(new File(file, "META-INF/javacard.xml"));
            }
            catch (Exception exception) {
                this.addError(ErrorKey.UnexpectedException, exception.toString());
            }
        }
    }

    @Override
    public String getItemDisplayName() {
        return "Module[" + this.folder + "]";
    }

    public JavaCardXML getJavaCardXML() {
        return this.javaCardXML;
    }

    public ModuleJCRD getJCRD() {
        return this.jcrd;
    }
}

