/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassAndMethodDescriptor;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.ConstantPoolEntry;
import com.sun.javacard.offcardverifier.FieldDescriptor;
import com.sun.javacard.offcardverifier.FieldTypeAndFlags;
import com.sun.javacard.offcardverifier.Fieldref;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.MethodTypeAndFlags;
import com.sun.javacard.offcardverifier.Methodref;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.SafeptrError;
import com.sun.javacard.offcardverifier.Type;
import com.sun.javacard.offcardverifier.TypeMethod;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;

public class ConstantPoolComponent
extends Safeptr {
    ConstantPoolComponent(byte[] byArray) {
        super(byArray, "ConstantPool");
    }

    public int count() {
        return this.u2(0);
    }

    public ConstantPoolEntry entry(int n) {
        return new ConstantPoolEntry(this.offset(2 + n * 4));
    }

    void verify() {
        if (Verifier.verbose >= 2) {
            Messages.println("ConstantPoolComponent.100");
        }
        if (this.count() != Cap.TypeDescr.constantPoolCount()) {
            throw new VerifierError("ConstantPoolComponent.1");
        }
        for (int i = 0; i < this.count(); ++i) {
            try {
                this.verifyCpoolEntry(i, this.entry(i));
                continue;
            }
            catch (SafeptrError safeptrError) {
                throw new SafeptrError("ConstantPoolComponent.2", i, (Object)safeptrError.getMessage(), safeptrError);
            }
            catch (VerifierError verifierError) {
                throw new VerifierError("ConstantPoolComponent.2", i, (Object)verifierError.getMessage());
            }
        }
        if (this.size() != 2 + 4 * this.count()) {
            throw new VerifierError("ConstantPoolComponent.16");
        }
    }

    private void verifyCpoolEntry(int n, ConstantPoolEntry constantPoolEntry) {
        switch (constantPoolEntry.tag()) {
            case 1: {
                Classref.check(constantPoolEntry.classRef());
                if (constantPoolEntry.classPadding() != 0) {
                    throw new VerifierError("ConstantPoolComponent.3");
                }
                if (Cap.TypeDescr.constantPoolType(n) == 65535) break;
                throw new VerifierError("ConstantPoolComponent.15");
            }
            case 2: {
                FieldTypeAndFlags fieldTypeAndFlags = Fieldref.findByToken(constantPoolEntry.classRefVirtualRef(), constantPoolEntry.tokenVirtualRef(), false);
                int n2 = Cap.TypeDescr.constantPoolType(n);
                if (fieldTypeAndFlags.fty.equals(Type.parseCap(Cap.TypeDescr.at(n2)))) break;
                throw new VerifierError("ConstantPoolComponent.4");
            }
            case 3: 
            case 4: {
                MethodTypeAndFlags methodTypeAndFlags = Methodref.findByToken(constantPoolEntry.classRefVirtualRef(), constantPoolEntry.tokenVirtualRef(), false);
                if (methodTypeAndFlags == null) {
                    throw new VerifierError("ConstantPoolComponent.5");
                }
                int n3 = Cap.TypeDescr.constantPoolType(n);
                if (!methodTypeAndFlags.mty.equals(TypeMethod.parseCap(Cap.TypeDescr.at(n3)))) {
                    throw new VerifierError("ConstantPoolComponent.6");
                }
                if (constantPoolEntry.tag() != 4 || !Classref.isExternal(constantPoolEntry.classRefVirtualRef())) break;
                throw new VerifierError("ConstantPoolComponent.14");
            }
            case 5: {
                Type type;
                Object object;
                if (constantPoolEntry.isExternalStaticRef()) {
                    object = Fieldref.findByToken(constantPoolEntry.classStaticRef(), constantPoolEntry.tokenStaticRef(), true);
                    type = ((FieldTypeAndFlags)object).fty;
                } else {
                    if (constantPoolEntry.internalStaticPadding() != 0) {
                        throw new VerifierError("ConstantPoolComponent.7");
                    }
                    object = Fieldref.checkInternalStatic(constantPoolEntry.internalStaticRef());
                    type = Type.parseField(((FieldDescriptor)object).type());
                }
                int n4 = Cap.TypeDescr.constantPoolType(n);
                if (type.equals(Type.parseCap(Cap.TypeDescr.at(n4)))) break;
                throw new VerifierError("ConstantPoolComponent.8");
            }
            case 6: {
                int n5;
                TypeMethod typeMethod;
                int n6;
                if (constantPoolEntry.isExternalStaticRef()) {
                    int n7;
                    n6 = constantPoolEntry.classStaticRef();
                    MethodTypeAndFlags methodTypeAndFlags = Methodref.findByToken(n6, n7 = constantPoolEntry.tokenStaticRef(), true);
                    if (methodTypeAndFlags == null) {
                        throw new SafeptrError("ConstantPoolComponent.9", constantPoolEntry);
                    }
                    typeMethod = methodTypeAndFlags.mty;
                    n5 = methodTypeAndFlags.flags;
                } else {
                    if (constantPoolEntry.internalStaticPadding() != 0) {
                        throw new VerifierError("ConstantPoolComponent.10");
                    }
                    ClassAndMethodDescriptor classAndMethodDescriptor = Methodref.findDescr(constantPoolEntry.internalStaticRef());
                    MethodDescriptor methodDescriptor = classAndMethodDescriptor.methodDescr;
                    typeMethod = TypeMethod.parseCap(Cap.TypeDescr.at(methodDescriptor.type()));
                    n5 = methodDescriptor.flags();
                }
                n6 = Cap.TypeDescr.constantPoolType(n);
                if (!typeMethod.equals(TypeMethod.parseCap(Cap.TypeDescr.at(n6)))) {
                    throw new VerifierError("ConstantPoolComponent.11");
                }
                if ((n5 & 8) != 0) break;
                constantPoolEntry.write1(0, 7);
                break;
            }
            default: {
                throw new VerifierError("ConstantPoolComponent.12", constantPoolEntry.tag());
            }
        }
    }

    static int flagsMethodReference(int n) {
        ConstantPoolEntry constantPoolEntry = Cap.ConstantPool.entry(n);
        switch (constantPoolEntry.tag()) {
            case 4: {
                MethodTypeAndFlags methodTypeAndFlags = Methodref.findByToken(constantPoolEntry.classRefVirtualRef(), constantPoolEntry.tokenVirtualRef(), false);
                return methodTypeAndFlags.flags;
            }
            case 7: {
                if (constantPoolEntry.isExternalStaticRef()) {
                    MethodTypeAndFlags methodTypeAndFlags = Methodref.findByToken(constantPoolEntry.classRefVirtualRef(), constantPoolEntry.tokenVirtualRef(), true);
                    return methodTypeAndFlags.flags;
                }
                ClassAndMethodDescriptor classAndMethodDescriptor = Methodref.findDescr(constantPoolEntry.internalStaticRef());
                return classAndMethodDescriptor.methodDescr.flags();
            }
        }
        throw new VerifierError("ConstantPoolComponent.13");
    }

    public static boolean methodIsInit(int n) {
        int n2 = ConstantPoolComponent.flagsMethodReference(n);
        return (n2 & 0x80) != 0;
    }

    static boolean methodIsExternalProtected(int n) {
        boolean bl = false;
        ConstantPoolEntry constantPoolEntry = Cap.ConstantPool.entry(n);
        if (!Classref.isExternal(constantPoolEntry.classRefVirtualRef())) {
            return false;
        }
        if (constantPoolEntry.tag() == 6 || constantPoolEntry.tag() == 7) {
            bl = true;
        }
        MethodTypeAndFlags methodTypeAndFlags = Methodref.findByToken(constantPoolEntry.classRefVirtualRef(), constantPoolEntry.tokenVirtualRef(), bl);
        return (methodTypeAndFlags.flags & 4) != 0;
    }

    static boolean fieldIsExternalProtected(int n) {
        ConstantPoolEntry constantPoolEntry = Cap.ConstantPool.entry(n);
        if (!Classref.isExternal(constantPoolEntry.classRefVirtualRef())) {
            return false;
        }
        FieldTypeAndFlags fieldTypeAndFlags = Fieldref.findByToken(constantPoolEntry.classRefVirtualRef(), constantPoolEntry.tokenVirtualRef(), false);
        return (fieldTypeAndFlags.flags & 4) != 0;
    }
}

