/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.lib.profiler.client.ProfilingPointsProcessor;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ProfilerIDESettings;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.GlobalProfilingPoint;
import org.netbeans.modules.profiler.ppoints.GlobalProfilingPointsProcessor;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.ProfilingPointsWindow;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.netbeans.modules.profiler.ppoints.ui.ValidityListener;
import org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.DialogDescriptor;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.text.Annotatable;
import org.openide.text.Line;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class ProfilingPointsManager
extends ProfilingPointsProcessor
implements PropertyChangeListener,
ProfilingStateListener {
    private static final String ANOTHER_PP_EDITED_MSG = NbBundle.getMessage(ProfilingPointsManager.class, (String)"ProfilingPointsManager_AnotherPpEditedMsg");
    private static final String PP_CUSTOMIZER_CAPTION = NbBundle.getMessage(ProfilingPointsManager.class, (String)"ProfilingPointsManager_PpCustomizerCaption");
    private static final String CANNOT_STORE_PP_MSG = NbBundle.getMessage(ProfilingPointsManager.class, (String)"ProfilingPointsManager_CannotStorePpMsg");
    private static final String OK_BUTTON_TEXT = NbBundle.getMessage(ProfilingPointsManager.class, (String)"ProfilingPointsManager_OkButtonText");
    public static final String PROPERTY_PROJECTS_CHANGED = "p_projects_changed";
    public static final String PROPERTY_PROFILING_POINTS_CHANGED = "p_profiling_points_changed";
    public static final int SORT_BY_PROJECT = 1;
    public static final int SORT_BY_SCOPE = 2;
    public static final int SORT_BY_NAME = 3;
    public static final int SORT_BY_RESULTS = 4;
    private static ProfilingPointsManager defaultInstance;
    private CustomizerButton customizerButton;
    private List<GlobalProfilingPoint> activeGlobalProfilingPoints = new ArrayList<GlobalProfilingPoint>();
    private Map<Integer, RuntimeProfilingPointMapper> activeCodeProfilingPoints = new HashMap<Integer, RuntimeProfilingPointMapper>();
    private PropertyChangeListener pcl = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(ProfilingPointFactory.AVAILABILITY_PROPERTY)) {
                ProfilingPointsManager.this.refreshProfilingPointFactories();
                ProfilingPointsManager.this.firePropertyChanged(ProfilingPointsManager.PROPERTY_PROFILING_POINTS_CHANGED);
            }
        }
    };
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Set<ProfilingPoint> dirtyProfilingPoints = Collections.synchronizedSet(new HashSet());
    private Vector<ValidityAwarePanel> customizers = new Vector();
    private final Vector<Project> openedProjects = new Vector();
    private Vector<ProfilingPoint> profilingPoints = new Vector();
    private ProfilingPointFactory[] profilingPointFactories = new ProfilingPointFactory[0];
    private boolean profilingInProgress = false;
    private boolean profilingSessionInProgress = false;
    private int nextUniqueRPPIdentificator;
    private Map<File, FileWatch> profilingPointsFiles = new HashMap<File, FileWatch>();
    private boolean ignoreStoreProfilingPoints = false;

    private ProfilingPointsManager() {
        this.refreshProfilingPointFactories();
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                ProfilingPointsManager.this.processOpenedProjectsChanged();
                NetBeansProfiler.getDefaultNB().addProfilingStateListener(ProfilingPointsManager.this);
                OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)ProfilingPointsManager.this);
            }
        });
    }

    public static synchronized ProfilingPointsManager getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new ProfilingPointsManager();
        }
        return defaultInstance;
    }

    public List<ProfilingPoint> getCompatibleProfilingPoints(Project project, ProfilingSettings profilingSettings, boolean bl) {
        List<ProfilingPoint> list = bl ? this.getSortedProfilingPoints(project, 1, false) : this.getProfilingPoints(project, ProfilerIDESettings.getInstance().getIncludeProfilingPointsDependencies(), false);
        ArrayList<ProfilingPoint> arrayList = new ArrayList<ProfilingPoint>();
        for (ProfilingPoint profilingPoint : list) {
            if (!profilingPoint.supportsProfilingSettings(profilingSettings)) continue;
            arrayList.add(profilingPoint);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProfilingInProgress() {
        ProfilingPointsManager profilingPointsManager = this;
        synchronized (profilingPointsManager) {
            return this.profilingInProgress;
        }
    }

    public ProfilingPointFactory[] getProfilingPointFactories() {
        return this.profilingPointFactories;
    }

    public List<ProfilingPoint> getProfilingPoints(Project project, boolean bl, boolean bl2) {
        return this.getProfilingPoints(ProfilingPoint.class, project, bl, bl2);
    }

    public <T extends ProfilingPoint> List<T> getProfilingPoints(Class<T> clazz, Project project, boolean bl) {
        return this.getProfilingPoints(clazz, project, bl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ProfilingPoint> List<T> getProfilingPoints(Class<T> clazz, Project project, boolean bl, boolean bl2) {
        AbstractList abstractList;
        HashSet<Project> hashSet = new HashSet<Project>();
        if (project == null) {
            abstractList = this.openedProjects;
            synchronized (abstractList) {
                hashSet.addAll(this.openedProjects);
            }
        } else {
            hashSet.add(project);
            if (bl) {
                hashSet.addAll(this.getOpenSubprojects(project));
            }
        }
        abstractList = new ArrayList();
        for (ProfilingPoint profilingPoint : this.profilingPoints) {
            ProfilingPointFactory profilingPointFactory = profilingPoint.getFactory();
            if (profilingPointFactory == null || !clazz.isInstance(profilingPoint) || !ProfilingPointsManager.containsProject(hashSet, profilingPoint.getProject()) || !bl2 && !profilingPointFactory.isAvailable()) continue;
            ((ArrayList)abstractList).add((ProfilingPoint)profilingPoint);
        }
        return abstractList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProfilingSessionInProgress() {
        ProfilingPointsManager profilingPointsManager = this;
        synchronized (profilingPointsManager) {
            return this.profilingSessionInProgress;
        }
    }

    public List<ProfilingPoint> getSortedProfilingPoints(Project project, int n, boolean bl) {
        List<ProfilingPoint> list = this.getProfilingPoints(project, ProfilerIDESettings.getInstance().getIncludeProfilingPointsDependencies(), false);
        Collections.sort(list, new ProfilingPointsComparator(n, bl));
        return list;
    }

    public void addProfilingPoint(ProfilingPoint profilingPoint) {
        this.addProfilingPoints(new ProfilingPoint[]{profilingPoint});
    }

    public void addProfilingPoints(ProfilingPoint[] profilingPointArray) {
        this.addProfilingPoints(profilingPointArray, false);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public RuntimeProfilingPoint[] createCodeProfilingConfiguration(Project project, ProfilingSettings profilingSettings) {
        this.checkProfilingPoints();
        this.nextUniqueRPPIdentificator = 0;
        ArrayList<RuntimeProfilingPoint> arrayList = new ArrayList<RuntimeProfilingPoint>();
        List<ProfilingPoint> list = this.getCompatibleProfilingPoints(project, profilingSettings, false);
        for (ProfilingPoint profilingPoint : list) {
            if (!profilingPoint.isEnabled() || !(profilingPoint instanceof CodeProfilingPoint)) continue;
            CodeProfilingPoint codeProfilingPoint = (CodeProfilingPoint)profilingPoint;
            RuntimeProfilingPoint[] runtimeProfilingPointArray = codeProfilingPoint.createRuntimeProfilingPoints();
            if (runtimeProfilingPointArray.length == 0) {
                ErrorManager.getDefault().log(256, "Cannot resolve RuntimeProfilingPoint(s) for " + codeProfilingPoint.getName() + ", check location");
            }
            for (int i = 0; i < runtimeProfilingPointArray.length; ++i) {
                arrayList.add(runtimeProfilingPointArray[i]);
                this.activeCodeProfilingPoints.put(runtimeProfilingPointArray[i].getId(), new RuntimeProfilingPointMapper(codeProfilingPoint, i));
            }
        }
        return arrayList.toArray(new RuntimeProfilingPoint[arrayList.size()]);
    }

    public GlobalProfilingPoint[] createGlobalProfilingConfiguration(Project project, ProfilingSettings profilingSettings) {
        this.checkProfilingPoints();
        List<ProfilingPoint> list = this.getCompatibleProfilingPoints(project, profilingSettings, false);
        for (ProfilingPoint profilingPoint : list) {
            if (!profilingPoint.isEnabled() || !(profilingPoint instanceof GlobalProfilingPoint)) continue;
            this.activeGlobalProfilingPoints.add((GlobalProfilingPoint)profilingPoint);
        }
        return this.activeGlobalProfilingPoints.toArray(new GlobalProfilingPoint[this.activeGlobalProfilingPoints.size()]);
    }

    public synchronized int createUniqueRuntimeProfilingPointIdentificator() {
        return this.nextUniqueRPPIdentificator++;
    }

    public void firePropertyChanged(String string) {
        this.propertyChangeSupport.firePropertyChange(string, false, true);
    }

    public void ideClosing() {
        this.storeDirtyProfilingPoints();
    }

    public void instrumentationChanged(int n, int n2) {
    }

    public void profilingPointHit(RuntimeProfilingPoint.HitEvent hitEvent) {
        RuntimeProfilingPointMapper runtimeProfilingPointMapper = this.activeCodeProfilingPoints.get(hitEvent.getId());
        if (runtimeProfilingPointMapper != null) {
            runtimeProfilingPointMapper.getOwner().hit(hitEvent, runtimeProfilingPointMapper.getIndex());
        } else {
            ErrorManager.getDefault().log(65536, "Cannot resolve ProfilingPoint for event: " + hitEvent);
        }
    }

    public void profilingStateChanged(final ProfilingStateEvent profilingStateEvent) {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean bl = ProfilingPointsManager.this.profilingInProgress;
                boolean bl2 = ProfilingPointsManager.this.profilingSessionInProgress;
                ProfilingPointsManager profilingPointsManager = ProfilingPointsManager.this;
                synchronized (profilingPointsManager) {
                    switch (profilingStateEvent.getNewState()) {
                        case 1: 
                        case 16: {
                            ProfilingPointsManager.this.profilingInProgress = false;
                            ProfilingPointsManager.this.profilingSessionInProgress = false;
                            break;
                        }
                        case 2: 
                        case 128: {
                            ProfilingPointsManager.this.profilingInProgress = false;
                            ProfilingPointsManager.this.profilingSessionInProgress = true;
                            break;
                        }
                        default: {
                            ProfilingPointsManager.this.profilingInProgress = true;
                            ProfilingPointsManager.this.profilingSessionInProgress = true;
                        }
                    }
                }
                if (bl != ProfilingPointsManager.this.profilingInProgress || bl2 != ProfilingPointsManager.this.profilingSessionInProgress) {
                    GlobalProfilingPointsProcessor.getDefault().notifyProfilingStateChanged();
                    IDEUtils.runInEventDispatchThread(new Runnable(){

                        @Override
                        public void run() {
                            ProfilingPointsWindow.getDefault().notifyProfilingStateChanged();
                        }
                    });
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() instanceof Line && "lineNumber".equals(propertyChangeEvent.getPropertyName())) {
            final Line line = (Line)propertyChangeEvent.getSource();
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    for (ProfilingPoint profilingPoint : ProfilingPointsManager.this.profilingPoints) {
                        if (!(profilingPoint instanceof CodeProfilingPoint)) continue;
                        CodeProfilingPoint codeProfilingPoint = (CodeProfilingPoint)profilingPoint;
                        for (CodeProfilingPoint.Annotation annotation : codeProfilingPoint.getAnnotations()) {
                            if (!line.equals(annotation.getAttachedAnnotatable())) continue;
                            codeProfilingPoint.internalUpdateLocation(annotation, line.getLineNumber() + 1);
                        }
                        ProfilingPointsManager.this.dirtyProfilingPoints.add(codeProfilingPoint);
                    }
                }
            });
        } else if (propertyChangeEvent.getSource() instanceof ProfilingPoint) {
            ProfilingPoint profilingPoint = (ProfilingPoint)propertyChangeEvent.getSource();
            if (!propertyChangeEvent.getPropertyName().equals("p_results")) {
                this.storeProfilingPoints(new ProfilingPoint[]{profilingPoint});
            }
            if (this.isAnnotationChange(propertyChangeEvent)) {
                this.deannotate((CodeProfilingPoint.Annotation[])propertyChangeEvent.getOldValue());
                this.annotate((CodeProfilingPoint)profilingPoint, (CodeProfilingPoint.Annotation[])propertyChangeEvent.getNewValue());
            }
            if (this.isLocationChange(propertyChangeEvent)) {
                CodeProfilingPoint.Location location;
                CodeProfilingPoint.Location location2 = (CodeProfilingPoint.Location)propertyChangeEvent.getOldValue();
                if (location2 != null && !CodeProfilingPoint.Location.EMPTY.equals(location2)) {
                    this.removeFileWatch(new File(location2.getFile()));
                }
                if ((location = (CodeProfilingPoint.Location)propertyChangeEvent.getNewValue()) != null && !CodeProfilingPoint.Location.EMPTY.equals(location)) {
                    this.addFileWatch(new File(location.getFile()));
                }
            }
            if (this.isAppearanceChange(propertyChangeEvent)) {
                this.firePropertyChanged(PROPERTY_PROFILING_POINTS_CHANGED);
            }
        } else if ("openProjects".equals(propertyChangeEvent.getPropertyName())) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    ProfilingPointsManager.this.processOpenedProjectsChanged();
                }
            });
        }
    }

    public void removeProfilingPoint(ProfilingPoint profilingPoint) {
        this.removeProfilingPoints(new ProfilingPoint[]{profilingPoint});
    }

    public synchronized void removeProfilingPoints(ProfilingPoint[] profilingPointArray) {
        this.removeProfilingPoints(profilingPointArray, false);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void reset() {
        LinkedList<ProfilingPoint> linkedList = new LinkedList<ProfilingPoint>();
        Collection<RuntimeProfilingPointMapper> collection = this.activeCodeProfilingPoints.values();
        for (RuntimeProfilingPointMapper object : collection) {
            linkedList.add(object.getOwner());
        }
        this.activeCodeProfilingPoints.clear();
        linkedList.addAll(this.activeGlobalProfilingPoints);
        this.activeGlobalProfilingPoints.clear();
        for (ProfilingPoint profilingPoint : linkedList) {
            profilingPoint.reset();
        }
        linkedList.clear();
    }

    public void threadsMonitoringChanged() {
    }

    public void timeAdjust(int n, long l, long l2) {
        Iterator<RuntimeProfilingPointMapper> iterator = this.activeCodeProfilingPoints.values().iterator();
        HashSet<CodeProfilingPoint> hashSet = new HashSet<CodeProfilingPoint>();
        while (iterator.hasNext()) {
            CodeProfilingPoint codeProfilingPoint = iterator.next().getOwner();
            if (!(codeProfilingPoint instanceof CodeProfilingPoint.Paired) || !hashSet.add(codeProfilingPoint)) continue;
            ((CodeProfilingPoint.Paired)codeProfilingPoint).timeAdjust(n, l, l2);
        }
    }

    boolean isAnyCustomizerShowing() {
        return this.getShowingCustomizer() != null;
    }

    ValidityAwarePanel getShowingCustomizer() {
        for (ValidityAwarePanel validityAwarePanel : this.customizers) {
            if (!validityAwarePanel.isShowing()) continue;
            return validityAwarePanel;
        }
        return null;
    }

    void customize(final ValidityAwarePanel validityAwarePanel, Runnable runnable) {
        ValidityAwarePanel validityAwarePanel2 = this.getShowingCustomizer();
        if (validityAwarePanel2 != null) {
            NetBeansProfiler.getDefaultNB().displayWarningAndWait(ANOTHER_PP_EDITED_MSG);
            SwingUtilities.getWindowAncestor(validityAwarePanel2).requestFocus();
            validityAwarePanel2.requestFocusInWindow();
        } else {
            CustomizerButton customizerButton = this.getCustomizerButton();
            validityAwarePanel.addValidityListener(customizerButton);
            customizerButton.setEnabled(validityAwarePanel.areSettingsValid());
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 20, 0));
            jPanel2.add((Component)validityAwarePanel, "Center");
            jPanel.add((Component)jPanel2, "Center");
            jPanel.add((Component)new JSeparator(), "South");
            HelpCtx helpCtx = null;
            if (validityAwarePanel instanceof HelpCtx.Provider) {
                helpCtx = ((HelpCtx.Provider)validityAwarePanel).getHelpCtx();
            }
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, PP_CUSTOMIZER_CAPTION, false, new Object[]{customizerButton, DialogDescriptor.CANCEL_OPTION}, (Object)customizerButton, 0, helpCtx, null);
            Dialog dialog = ProfilerDialogs.createDialog(dialogDescriptor);
            dialog.addWindowListener(new CustomizerListener(dialog, dialogDescriptor, runnable));
            dialog.setVisible(true);
            if (validityAwarePanel.getInitialFocusTarget() != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        validityAwarePanel.getInitialFocusTarget().requestFocusInWindow();
                    }
                });
            }
        }
    }

    void documentOpened(Line.Set set, FileObject fileObject) {
        block0: for (ProfilingPoint profilingPoint : this.profilingPoints) {
            if (!(profilingPoint instanceof CodeProfilingPoint)) continue;
            CodeProfilingPoint codeProfilingPoint = (CodeProfilingPoint)profilingPoint;
            for (CodeProfilingPoint.Annotation annotation : codeProfilingPoint.getAnnotations()) {
                File file;
                File file2 = new File(codeProfilingPoint.getLocation(annotation).getFile());
                if (file2 == null || fileObject == null || (file = FileUtil.toFile((FileObject)fileObject)) == null || !file.equals(file2)) continue;
                this.deannotateProfilingPoint(codeProfilingPoint);
                this.annotateProfilingPoint(codeProfilingPoint);
                continue block0;
            }
        }
    }

    ValidityAwarePanel safeGetCustomizer(ValidityAwarePanel validityAwarePanel) {
        if (!this.customizers.contains(validityAwarePanel)) {
            this.customizers.add(validityAwarePanel);
        }
        return this.isAnyCustomizerShowing() ? null : validityAwarePanel;
    }

    private boolean isAnnotationChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        return string.equals("p_annotation");
    }

    private boolean isLocationChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        return string.equals("p_location");
    }

    private boolean isAppearanceChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        return string.equals("p_name") || string.equals("p_enabled") || string.equals("p_project") || string.equals("p_results");
    }

    private static boolean containsProject(Collection<Project> collection, Project project) {
        if (project != null) {
            FileObject fileObject = project.getProjectDirectory();
            for (Project project2 : collection) {
                if (!project2.getProjectDirectory().equals(fileObject)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Project> getOpenSubprojects(Project project) {
        HashSet<Project> hashSet = new HashSet<Project>();
        ProjectUtilities.fetchSubprojects((Project)project, hashSet);
        if (hashSet.isEmpty()) {
            return hashSet;
        }
        HashSet<Project> hashSet2 = new HashSet<Project>();
        Vector<Project> vector = this.openedProjects;
        synchronized (vector) {
            for (Project project2 : this.openedProjects) {
                if (!ProfilingPointsManager.containsProject(hashSet, project2)) continue;
                hashSet2.add(project2);
            }
        }
        return hashSet2;
    }

    private ProfilingPoint[] getValidProfilingPoints(ProfilingPoint[] profilingPointArray) {
        ArrayList<ProfilingPoint> arrayList = new ArrayList<ProfilingPoint>();
        for (ProfilingPoint profilingPoint : profilingPointArray) {
            if (!profilingPoint.isValid()) continue;
            arrayList.add(profilingPoint);
        }
        return arrayList.toArray(new ProfilingPoint[arrayList.size()]);
    }

    private ProfilingPoint[] getInvalidProfilingPoints(ProfilingPoint[] profilingPointArray) {
        ArrayList<ProfilingPoint> arrayList = new ArrayList<ProfilingPoint>();
        for (ProfilingPoint profilingPoint : profilingPointArray) {
            if (profilingPoint.isValid()) continue;
            arrayList.add(profilingPoint);
        }
        return arrayList.toArray(new ProfilingPoint[arrayList.size()]);
    }

    private void checkProfilingPoints() {
        ProfilingPoint[] profilingPointArray = this.getInvalidProfilingPoints(this.profilingPoints.toArray(new ProfilingPoint[this.profilingPoints.size()]));
        if (profilingPointArray.length > 0) {
            this.removeProfilingPoints(profilingPointArray);
        }
    }

    private void addFileWatch(File file) {
        FileObject fileObject = null;
        if (file.isFile()) {
            fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        }
        if (fileObject != null) {
            FileWatch fileWatch = this.profilingPointsFiles.get(file);
            if (fileWatch == null) {
                LocationFileListener locationFileListener = new LocationFileListener(file);
                fileWatch = new FileWatch(locationFileListener);
                fileObject.addFileChangeListener((FileChangeListener)locationFileListener);
                this.profilingPointsFiles.put(file, fileWatch);
            }
            fileWatch.increaseReferences();
        }
    }

    private void removeFileWatch(File file) {
        FileObject fileObject = null;
        if (file.isFile()) {
            fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        }
        if (fileObject != null) {
            FileWatch fileWatch = this.profilingPointsFiles.get(file);
            if (fileWatch != null) {
                fileWatch.decreaseReferences();
                if (!fileWatch.hasReferences()) {
                    fileObject.removeFileChangeListener((FileChangeListener)this.profilingPointsFiles.remove(file).getListener());
                }
            }
        } else {
            this.profilingPointsFiles.remove(file);
        }
    }

    private void addProfilingPointFileWatch(CodeProfilingPoint codeProfilingPoint) {
        CodeProfilingPoint.Annotation[] annotationArray;
        for (CodeProfilingPoint.Annotation annotation : annotationArray = codeProfilingPoint.getAnnotations()) {
            CodeProfilingPoint.Location location = codeProfilingPoint.getLocation(annotation);
            String string = location.getFile();
            this.addFileWatch(new File(string));
        }
    }

    private void removeProfilingPointFileWatch(CodeProfilingPoint codeProfilingPoint) {
        CodeProfilingPoint.Annotation[] annotationArray;
        for (CodeProfilingPoint.Annotation annotation : annotationArray = codeProfilingPoint.getAnnotations()) {
            CodeProfilingPoint.Location location = codeProfilingPoint.getLocation(annotation);
            String string = location.getFile();
            this.removeFileWatch(new File(string));
        }
    }

    private CodeProfilingPoint[] getProfilingPointsForFile(File file) {
        ArrayList<CodeProfilingPoint> arrayList = new ArrayList<CodeProfilingPoint>();
        block0: for (ProfilingPoint profilingPoint : this.profilingPoints) {
            if (!(profilingPoint instanceof CodeProfilingPoint)) continue;
            CodeProfilingPoint codeProfilingPoint = (CodeProfilingPoint)profilingPoint;
            for (CodeProfilingPoint.Annotation annotation : codeProfilingPoint.getAnnotations()) {
                CodeProfilingPoint.Location location = codeProfilingPoint.getLocation(annotation);
                File file2 = new File(location.getFile());
                if (!file.equals(file2)) continue;
                arrayList.add(codeProfilingPoint);
                continue block0;
            }
        }
        return arrayList.toArray(new CodeProfilingPoint[arrayList.size()]);
    }

    private void deleteProfilingPointsForFile(File file) {
        this.removeProfilingPoints(this.getProfilingPointsForFile(file));
    }

    private void updateProfilingPointsFile(File file, File file2) {
        String string = file2.getAbsolutePath();
        ProfilingPoint[] profilingPointArray = this.getProfilingPointsForFile(file);
        this.ignoreStoreProfilingPoints = true;
        for (CodeProfilingPoint codeProfilingPoint : profilingPointArray) {
            for (CodeProfilingPoint.Annotation annotation : codeProfilingPoint.getAnnotations()) {
                CodeProfilingPoint.Location location = codeProfilingPoint.getLocation(annotation);
                File file3 = new File(location.getFile());
                if (!file.equals(file3)) continue;
                CodeProfilingPoint.Location location2 = new CodeProfilingPoint.Location(string, location.getLine(), location.getOffset());
                codeProfilingPoint.setLocation(annotation, location2);
            }
        }
        this.ignoreStoreProfilingPoints = false;
        this.storeProfilingPoints(profilingPointArray);
    }

    private synchronized void addProfilingPoints(ProfilingPoint[] profilingPointArray, boolean bl) {
        for (ProfilingPoint profilingPoint : profilingPointArray = this.getValidProfilingPoints(profilingPointArray)) {
            this.profilingPoints.add(profilingPoint);
            profilingPoint.addPropertyChangeListener(this);
            if (!(profilingPoint instanceof CodeProfilingPoint)) continue;
            CodeProfilingPoint codeProfilingPoint = (CodeProfilingPoint)profilingPoint;
            this.annotateProfilingPoint(codeProfilingPoint);
            this.addProfilingPointFileWatch(codeProfilingPoint);
        }
        if (!bl) {
            this.storeProfilingPoints(profilingPointArray);
            this.firePropertyChanged(PROPERTY_PROFILING_POINTS_CHANGED);
        }
    }

    private void annotate(final CodeProfilingPoint codeProfilingPoint, final CodeProfilingPoint.Annotation[] annotationArray) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                for (CodeProfilingPoint.Annotation annotation : annotationArray) {
                    Line line = Utils.getEditorLine(codeProfilingPoint.getLocation(annotation));
                    if (line == null) continue;
                    line.addPropertyChangeListener((PropertyChangeListener)ProfilingPointsManager.this);
                    annotation.attach((Annotatable)line);
                }
            }
        });
    }

    private void annotateProfilingPoint(CodeProfilingPoint codeProfilingPoint) {
        this.annotate(codeProfilingPoint, codeProfilingPoint.getAnnotations());
    }

    private void deannotate(CodeProfilingPoint.Annotation[] annotationArray) {
        for (CodeProfilingPoint.Annotation annotation : annotationArray) {
            Annotatable annotatable = annotation.getAttachedAnnotatable();
            if (annotatable != null) {
                annotatable.removePropertyChangeListener((PropertyChangeListener)this);
            }
            annotation.detach();
        }
    }

    private void deannotateProfilingPoint(CodeProfilingPoint codeProfilingPoint) {
        this.deannotate(codeProfilingPoint.getAnnotations());
    }

    private void loadProfilingPoints(Project project) {
        for (ProfilingPointFactory profilingPointFactory : this.profilingPointFactories) {
            try {
                this.addProfilingPoints(profilingPointFactory.loadProfilingPoints(project), true);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().log(65536, exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void processOpenedProjectsChanged() {
        Vector<Project> vector = new Vector<Project>();
        Iterator<Project> iterator = this.openedProjects;
        synchronized (iterator) {
            vector.addAll(this.openedProjects);
        }
        this.refreshOpenedProjects();
        for (Project project : vector) {
            if (ProfilingPointsManager.containsProject(this.openedProjects, project)) continue;
            this.projectClosed(project);
        }
        for (Project project : this.openedProjects) {
            if (ProfilingPointsManager.containsProject(vector, project)) continue;
            this.projectOpened(project);
        }
        this.firePropertyChanged(PROPERTY_PROJECTS_CHANGED);
    }

    private void projectClosed(Project project) {
        this.unloadProfilingPoints(project);
    }

    private void projectOpened(Project project) {
        this.loadProfilingPoints(project);
    }

    private void refreshOpenedProjects() {
        Project[] projectArray;
        this.openedProjects.clear();
        for (Project project : projectArray = ProjectUtilities.getOpenedProjects()) {
            this.openedProjects.add(project);
        }
    }

    private void refreshProfilingPointFactories() {
        Collection collection = Lookup.getDefault().lookupAll(ProfilingPointFactory.class);
        ArrayList<ProfilingPointFactory> arrayList = new ArrayList<ProfilingPointFactory>();
        for (ProfilingPointFactory profilingPointFactory : collection) {
            if (profilingPointFactory.isAvailable()) {
                arrayList.add(profilingPointFactory);
            }
            profilingPointFactory.addPropertyChangeListener(ProfilingPointFactory.AVAILABILITY_PROPERTY, WeakListeners.propertyChange((PropertyChangeListener)this.pcl, (Object)profilingPointFactory));
        }
        this.profilingPointFactories = new ProfilingPointFactory[arrayList.size()];
        arrayList.toArray(this.profilingPointFactories);
    }

    private synchronized void removeProfilingPoints(ProfilingPoint[] profilingPointArray, boolean bl) {
        for (ProfilingPoint profilingPoint : profilingPointArray) {
            if (profilingPoint instanceof CodeProfilingPoint) {
                CodeProfilingPoint codeProfilingPoint = (CodeProfilingPoint)profilingPoint;
                this.removeProfilingPointFileWatch(codeProfilingPoint);
                this.deannotateProfilingPoint(codeProfilingPoint);
            }
            profilingPoint.removePropertyChangeListener(this);
            profilingPoint.hideResults();
            profilingPoint.reset();
            this.profilingPoints.remove(profilingPoint);
        }
        if (!bl) {
            this.storeProfilingPoints(profilingPointArray);
            this.firePropertyChanged(PROPERTY_PROFILING_POINTS_CHANGED);
        }
    }

    private void storeDirtyProfilingPoints() {
        ProfilingPoint[] profilingPointArray = new ProfilingPoint[this.dirtyProfilingPoints.size()];
        this.dirtyProfilingPoints.toArray(profilingPointArray);
        this.storeProfilingPoints(profilingPointArray);
    }

    private synchronized void storeProfilingPoints(ProfilingPoint[] profilingPointArray) {
        if (this.ignoreStoreProfilingPoints) {
            return;
        }
        HashSet<Project> hashSet = new HashSet<Project>();
        HashSet<ProfilingPointFactory> hashSet2 = new HashSet<ProfilingPointFactory>();
        for (ProfilingPoint profilingPoint : profilingPointArray) {
            hashSet.add(profilingPoint.getProject());
            hashSet2.add(profilingPoint.getFactory());
            this.dirtyProfilingPoints.remove(profilingPoint);
        }
        for (ProfilingPointFactory profilingPointFactory : hashSet2) {
            if (profilingPointFactory == null) continue;
            for (Project project : hashSet) {
                try {
                    profilingPointFactory.saveProfilingPoints(project);
                }
                catch (IOException iOException) {
                    NetBeansProfiler.getDefaultNB().displayError(MessageFormat.format(CANNOT_STORE_PP_MSG, profilingPointFactory.getType(), ProjectUtils.getInformation((Project)project).getDisplayName()));
                }
            }
        }
    }

    private void unloadProfilingPoints(Project project) {
        List<ProfilingPoint> list = this.getProfilingPoints(project, false, true);
        ArrayList<ProfilingPoint> arrayList = new ArrayList<ProfilingPoint>();
        for (ProfilingPoint profilingPoint : list) {
            if (!this.dirtyProfilingPoints.contains(profilingPoint)) continue;
            arrayList.add(profilingPoint);
        }
        if (!arrayList.isEmpty()) {
            this.storeProfilingPoints(arrayList.toArray(new ProfilingPoint[0]));
        }
        for (ProfilingPoint profilingPoint : list) {
            if (profilingPoint instanceof CodeProfilingPoint) {
                CodeProfilingPoint codeProfilingPoint = (CodeProfilingPoint)profilingPoint;
                this.removeProfilingPointFileWatch(codeProfilingPoint);
                this.deannotateProfilingPoint(codeProfilingPoint);
            }
            profilingPoint.hideResults();
            profilingPoint.reset();
            this.profilingPoints.remove(profilingPoint);
        }
    }

    private CustomizerButton getCustomizerButton() {
        if (this.customizerButton == null) {
            this.customizerButton = new CustomizerButton();
        }
        return this.customizerButton;
    }

    private class LocationFileListener
    implements FileChangeListener {
        private File file;

        public LocationFileListener(File file) {
            this.file = file;
        }

        public void fileDeleted(FileEvent fileEvent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ProfilingPointsManager.this.deleteProfilingPointsForFile(LocationFileListener.this.file);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                RequestProcessor.getDefault().post(runnable);
            } else {
                runnable.run();
            }
        }

        public void fileRenamed(final FileRenameEvent fileRenameEvent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    FileObject fileObject = fileRenameEvent.getFile();
                    File file = FileUtil.toFile((FileObject)fileObject);
                    if (file != null && file.exists() && file.isFile()) {
                        ProfilingPointsManager.this.updateProfilingPointsFile(LocationFileListener.this.file, file);
                    } else {
                        ProfilingPointsManager.this.deleteProfilingPointsForFile(LocationFileListener.this.file);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                RequestProcessor.getDefault().post(runnable);
            } else {
                runnable.run();
            }
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileDataCreated(FileEvent fileEvent) {
        }

        public void fileChanged(FileEvent fileEvent) {
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }
    }

    private class FileWatch {
        private int references = 0;
        private LocationFileListener listener;

        public FileWatch(LocationFileListener locationFileListener) {
            this.listener = locationFileListener;
        }

        public boolean hasReferences() {
            return this.references > 0;
        }

        public LocationFileListener getListener() {
            return this.listener;
        }

        public void increaseReferences() {
            ++this.references;
        }

        public void decreaseReferences() {
            --this.references;
        }
    }

    private class RuntimeProfilingPointMapper {
        private final CodeProfilingPoint owner;
        private final int index;

        public RuntimeProfilingPointMapper(CodeProfilingPoint codeProfilingPoint, int n) {
            this.owner = codeProfilingPoint;
            this.index = n;
        }

        public int getIndex() {
            return this.index;
        }

        public CodeProfilingPoint getOwner() {
            return this.owner;
        }
    }

    private class CustomizerListener
    extends WindowAdapter {
        private Dialog d;
        private DialogDescriptor dd;
        private Runnable updater;

        public CustomizerListener(Dialog dialog, DialogDescriptor dialogDescriptor, Runnable runnable) {
            this.d = dialog;
            this.dd = dialogDescriptor;
            this.updater = runnable;
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            if (this.dd.getValue() == ProfilingPointsManager.this.getCustomizerButton()) {
                this.updater.run();
            }
            this.d.removeWindowListener(this);
            this.d = null;
            this.dd = null;
            this.updater = null;
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
            this.d.requestFocus();
        }
    }

    private class CustomizerButton
    extends JButton
    implements ValidityListener {
        public CustomizerButton() {
            super(OK_BUTTON_TEXT);
        }

        @Override
        public void validityChanged(boolean bl) {
            this.setEnabled(bl);
        }
    }

    private static class ProfilingPointsComparator
    implements Comparator {
        private boolean sortOrder;
        private int sortBy;

        public ProfilingPointsComparator(int n, boolean bl) {
            this.sortBy = n;
            this.sortOrder = bl;
        }

        public int compare(Object object, Object object2) {
            ProfilingPoint profilingPoint = this.sortOrder ? (ProfilingPoint)object : (ProfilingPoint)object2;
            ProfilingPoint profilingPoint2 = this.sortOrder ? (ProfilingPoint)object2 : (ProfilingPoint)object;
            switch (this.sortBy) {
                case -1: 
                case 1: {
                    return ProjectUtils.getInformation((Project)profilingPoint.getProject()).getDisplayName().compareTo(ProjectUtils.getInformation((Project)profilingPoint2.getProject()).getDisplayName());
                }
                case 2: {
                    int n = profilingPoint.getFactory().getScope();
                    int n2 = profilingPoint2.getFactory().getScope();
                    return n < n2 ? -1 : (n == n2 ? 0 : 1);
                }
                case 3: {
                    return profilingPoint.getName().compareTo(profilingPoint2.getName());
                }
                case 4: {
                    return profilingPoint.getResultsText().compareTo(profilingPoint2.getResultsText());
                }
            }
            throw new RuntimeException("Unsupported compare operation for " + object + ", " + object2);
        }
    }
}

