/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support.filesearch;

import java.util.Collection;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.support.Computable;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.TasksCachedProcessor;
import org.netbeans.modules.nativeexecution.support.filesearch.FileSearchParams;
import org.netbeans.modules.nativeexecution.support.filesearch.FileSearcher;
import org.openide.util.Lookup;

public final class FileSearchSupport {
    private static final java.util.logging.Logger log = Logger.getInstance();
    private static final TasksCachedProcessor<FileSearchParams, String> processor = new TasksCachedProcessor<FileSearchParams, String>(new Searcher(), false);

    public final String searchFile(FileSearchParams fileSearchParams) throws InterruptedException {
        return processor.compute(fileSearchParams);
    }

    private static final class Searcher
    implements Computable<FileSearchParams, String> {
        private Searcher() {
        }

        @Override
        public String compute(FileSearchParams fileSearchParams) throws InterruptedException {
            Collection searchers = Lookup.getDefault().lookupAll(FileSearcher.class);
            String result = null;
            for (FileSearcher searcher : searchers) {
                result = searcher.searchFile(fileSearchParams);
                if (result == null) continue;
                return result;
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "File '" + fileSearchParams.getFilename() + "' not found. {" + fileSearchParams.toString() + "}");
            }
            return null;
        }
    }
}

