/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeAttlistDecl;
import org.netbeans.tax.TreeNamedObjectMap;
import org.netbeans.tax.TreeNodeDecl;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeUtilities;
import org.netbeans.tax.Util;

public class TreeAttlistDeclAttributeDef
extends TreeNodeDecl.Content
implements TreeNamedObjectMap.NamedObject {
    public static final String PROP_NAME = "name";
    public static final String PROP_TYPE = "type";
    public static final String PROP_ENUMERATED_TYPE = "enumeratedType";
    public static final String PROP_DEFAULT_TYPE = "defaultType";
    public static final String PROP_DEFAULT_VALUE = "defaultValue";
    public static final short TYPE_CDATA = 0;
    public static final short TYPE_ID = 1;
    public static final short TYPE_IDREF = 2;
    public static final short TYPE_IDREFS = 3;
    public static final short TYPE_ENTITY = 4;
    public static final short TYPE_ENTITIES = 5;
    public static final short TYPE_NMTOKEN = 6;
    public static final short TYPE_NMTOKENS = 7;
    public static final short TYPE_ENUMERATED = 8;
    public static final short TYPE_NOTATION = 9;
    public static final short DEFAULT_TYPE_NULL = 0;
    public static final short DEFAULT_TYPE_REQUIRED = 1;
    public static final short DEFAULT_TYPE_IMPLIED = 2;
    public static final short DEFAULT_TYPE_FIXED = 3;
    public static final String[] NAMED_TYPE_LIST = new String[]{"CDATA", "ID", "IDREF", "IDREFS", "ENTITY", "ENTITIES", "NMTOKEN", "NMTOKENS", null, "NOTATION"};
    public static final String[] NAMED_DEFAULT_TYPE_LIST = new String[]{null, "#REQUIRED", "#IMPLIED", "#FIXED"};
    private String name;
    private short type;
    private String[] enumeratedType;
    private short defaultType;
    private String defaultValue;
    private TreeNamedObjectMap.KeyListener mapKeyListener;

    public TreeAttlistDeclAttributeDef(String name, short type, String[] enumeratedType, short defaultType, String defaultValue) throws InvalidArgumentException {
        this.checkName(name);
        this.checkType(type, enumeratedType);
        this.checkDefaultType(defaultType, defaultValue);
        this.name = name;
        this.type = type;
        this.enumeratedType = enumeratedType;
        this.defaultType = defaultType;
        this.defaultValue = defaultValue;
    }

    protected TreeAttlistDeclAttributeDef(TreeAttlistDeclAttributeDef attributeDef) {
        super(attributeDef);
        this.name = attributeDef.name;
        this.type = attributeDef.type;
        this.enumeratedType = this.arraycopy(attributeDef.enumeratedType);
        this.defaultType = attributeDef.defaultType;
        this.defaultValue = attributeDef.defaultValue;
    }

    private String[] arraycopy(String[] array) {
        if (array == null) {
            return null;
        }
        int length = array.length;
        String[] arrayCopy = new String[length];
        System.arraycopy(array, 0, arrayCopy, 0, length);
        return arrayCopy;
    }

    public Object clone() {
        return new TreeAttlistDeclAttributeDef(this);
    }

    public boolean equals(Object object, boolean deep) {
        if (!super.equals(object, deep)) {
            return false;
        }
        TreeAttlistDeclAttributeDef peer = (TreeAttlistDeclAttributeDef)object;
        if (!Util.equals(this.name, peer.name)) {
            return false;
        }
        if (this.type != peer.type) {
            return false;
        }
        if (!Util.equals(this.enumeratedType, peer.enumeratedType)) {
            return false;
        }
        if (this.defaultType != peer.defaultType) {
            return false;
        }
        return Util.equals(this.defaultValue, peer.defaultValue);
    }

    public void merge(TreeObject treeObject) throws CannotMergeException {
        super.merge(treeObject);
        TreeAttlistDeclAttributeDef peer = (TreeAttlistDeclAttributeDef)treeObject;
        this.setNameImpl(peer.getName());
        this.setDefaultTypeImpl(peer.getDefaultType(), peer.getDefaultValue());
        this.setTypeImpl(peer.getType(), peer.getEnumeratedType());
    }

    public final void removeFromContext() throws ReadOnlyException {
        if (this.isInContext()) {
            this.getOwnerAttlistDecl().removeAttributeDef(this.getName());
        }
    }

    public final TreeAttlistDecl getOwnerAttlistDecl() {
        return (TreeAttlistDecl)this.getNodeDecl();
    }

    public final String getElementName() {
        if (this.getNodeDecl() == null) {
            return null;
        }
        return this.getOwnerAttlistDecl().getElementName();
    }

    public final String getName() {
        return this.name;
    }

    private final void setNameImpl(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.fireMapKeyChanged(oldName);
    }

    public final void setName(String newName) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.name, newName)) {
            return;
        }
        this.checkReadOnly();
        this.checkName(newName);
        this.setNameImpl(newName);
    }

    protected final void checkName(String name) throws InvalidArgumentException {
        TreeUtilities.checkAttlistDeclAttributeName(name);
    }

    public final short getType() {
        return this.type;
    }

    public final String getTypeName() {
        try {
            return NAMED_TYPE_LIST[this.type];
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            return null;
        }
    }

    public final String[] getEnumeratedType() {
        return this.enumeratedType;
    }

    public final String getEnumeratedTypeString() {
        if (this.enumeratedType == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("( ").append(this.enumeratedType[0]);
        for (int i = 1; i < this.enumeratedType.length; ++i) {
            sb.append(" | ").append(this.enumeratedType[i]);
        }
        sb.append(" )");
        return sb.toString();
    }

    public static final String[] createEnumeratedType(String enumeratedType) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeAttlistDeclAttributeDef.createEnumeratedType: enumeratedType = " + enumeratedType);
        }
        if (enumeratedType == null) {
            return null;
        }
        int begin = enumeratedType.indexOf("(");
        int end = enumeratedType.indexOf(")");
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    begin = " + begin);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    end   = " + end);
        }
        if (begin == -1 || end == -1) {
            return null;
        }
        String noParenthesis = enumeratedType.substring(begin + 1, end);
        StringTokenizer st = new StringTokenizer(noParenthesis, "|");
        LinkedList<String> tokens = new LinkedList<String>();
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken().trim());
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    tokens = " + tokens);
        }
        if (tokens.isEmpty()) {
            return null;
        }
        String[] arrayType = tokens.toArray(new String[0]);
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    RETURN arrayType = " + arrayType);
        }
        return arrayType;
    }

    private final void setTypeImpl(short newType, String[] newEnumeratedType) {
        this.type = newType;
        this.enumeratedType = newEnumeratedType;
    }

    public final void setType(short newType, String[] newEnumeratedType) throws ReadOnlyException, InvalidArgumentException {
        boolean setEnumeratedType;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeAttlistDeclAttributeDef.setType");
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    newType           = " + newType);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    newEnumeratedType = " + (newEnumeratedType == null ? null : Arrays.asList(newEnumeratedType)));
        }
        boolean setType = this.type != newType;
        boolean bl = setEnumeratedType = !Arrays.equals(this.enumeratedType, newEnumeratedType);
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    setEnumeratedType = " + setEnumeratedType);
        }
        if (!setType && !setEnumeratedType) {
            return;
        }
        this.checkReadOnly();
        this.checkType(newType, newEnumeratedType);
        this.setTypeImpl(newType, newEnumeratedType);
    }

    protected final void checkType(short type, String[] enumeratedType) throws InvalidArgumentException {
        TreeUtilities.checkAttlistDeclAttributeType(type);
        TreeUtilities.checkAttlistDeclAttributeEnumeratedType(enumeratedType);
    }

    public static final short findType(String type) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeAttlistDeclAttributeDef::findType: type = " + type);
        }
        for (short i = 0; i < NAMED_TYPE_LIST.length; i = (short)(i + 1)) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("    test_type = " + NAMED_TYPE_LIST[i]);
            }
            if (!Util.equals(NAMED_TYPE_LIST[i], type)) continue;
            return i;
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    type[" + type + "] not found");
        }
        return -1;
    }

    public final short getDefaultType() {
        return this.defaultType;
    }

    public final String getDefaultTypeName() {
        try {
            return NAMED_DEFAULT_TYPE_LIST[this.defaultType];
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            return null;
        }
    }

    public final String getDefaultValue() {
        return this.defaultValue;
    }

    private final void setDefaultTypeImpl(short newDefaultType, String newDefaultValue) {
        this.defaultType = newDefaultType;
        this.defaultValue = newDefaultValue;
    }

    public final void setDefaultType(short newDefaultType, String newDefaultValue) throws ReadOnlyException, InvalidArgumentException {
        boolean setDefaultValue;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeAttlistDeclAttributeDef.setDefaultType");
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    newDefaultType  = " + NAMED_DEFAULT_TYPE_LIST[newDefaultType]);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    newDefaultValue = " + newDefaultValue);
        }
        boolean setDefaultType = this.defaultType != newDefaultType;
        boolean bl = setDefaultValue = !Util.equals(this.defaultValue, newDefaultValue);
        if (!setDefaultType && !setDefaultValue) {
            return;
        }
        this.checkReadOnly();
        this.checkDefaultType(newDefaultType, newDefaultValue);
        this.setDefaultTypeImpl(newDefaultType, newDefaultValue);
    }

    protected final void checkDefaultType(short defaultType, String defaultValue) throws InvalidArgumentException {
        TreeUtilities.checkAttlistDeclAttributeDefaultType(defaultType);
        TreeUtilities.checkAttlistDeclAttributeDefaultValue(defaultValue);
    }

    public static final short findDefaultType(String defaultType) {
        for (short i = 0; i < NAMED_DEFAULT_TYPE_LIST.length; i = (short)(i + 1)) {
            if (!Util.equals(NAMED_DEFAULT_TYPE_LIST[i], defaultType)) continue;
            return i;
        }
        return -1;
    }

    public Object mapKey() {
        return this.getName();
    }

    public void setKeyListener(TreeNamedObjectMap.KeyListener keyListener) {
        this.mapKeyListener = keyListener;
    }

    private void fireMapKeyChanged(Object oldKey) {
        if (this.mapKeyListener == null) {
            return;
        }
        this.mapKeyListener.mapKeyChanged(oldKey);
    }
}

