/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.marker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.marker.Marker;
import org.netbeans.lib.profiler.results.cpu.marking.MarkMapping;

public class MethodMarker
implements Marker {
    private static Logger LOGGER = Logger.getLogger(MethodMarker.class.getName());
    private Map markMap = new HashMap();

    @Override
    public MarkMapping[] getMappings() {
        ArrayList<MarkMapping> mappings = new ArrayList<MarkMapping>();
        for (ClientUtils.SourceCodeSelection markerMethod : this.markMap.keySet()) {
            markerMethod.setMarkerMethod(true);
            mappings.add(new MarkMapping(markerMethod, (Mark)this.markMap.get(markerMethod)));
        }
        return mappings.toArray(new MarkMapping[mappings.size()]);
    }

    @Override
    public Mark[] getMarks() {
        return new HashSet(this.markMap.values()).toArray(new Mark[0]);
    }

    public void addMethodMark(String className, String methodName, String signature, Mark mark) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Marking method " + className + "#" + methodName + ":" + signature + " with " + mark.getId());
        }
        this.markMap.put(new ClientUtils.SourceCodeSelection(className, methodName, signature), mark);
    }

    public void removeMethodMark(String className, String methodName, String signature) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Unmarking method " + className + "#" + methodName + ":" + signature);
        }
        this.markMap.remove(new ClientUtils.SourceCodeSelection(className, methodName, signature));
    }

    public void resetMethodMarks() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Unmarking all methods");
        }
        this.markMap.clear();
    }
}

