/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo;

import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntBasedProjectType;
import org.openide.util.Mutex;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GizmoProjectOptions {
    private AuxiliaryConfiguration aux;
    private static final String GizmoData = "gizmo-options";
    private static final String GizmoDataCollectorEnabled = "gizmo-datacollector-enabled";
    private static final String GizmoDataCollectorName = "gizmo-datacollector-name";
    private static final String GizmoSelectedToolsName = "gizmo-selected-tools-names";
    private static final String GizmoToolName = "tool-name";
    private static final String GizmoUserIntreactionRequiredActionsEnabled = "gizmo-user-interaction-required-actions-enabled";
    private final String namespace;
    private final boolean shared;

    public GizmoProjectOptions(Project project, boolean shared) {
        this.shared = shared;
        this.aux = ProjectUtils.getAuxiliaryConfiguration((Project)project);
        AntBasedProjectType antPrj = (AntBasedProjectType)project.getLookup().lookup(AntBasedProjectType.class);
        this.namespace = antPrj.getPrimaryConfigurationDataElementNamespace(shared);
    }

    public GizmoProjectOptions(Project project) {
        this(project, false);
    }

    public boolean getDataCollectorEnabled() {
        String value = this.doLoad(GizmoDataCollectorEnabled);
        return this.str2bool(value);
    }

    public void setDataCollectorEnabled(Boolean enabled) {
        this.doSave(GizmoDataCollectorEnabled, enabled.toString());
    }

    public String[] getSelectedTools() {
        String[] values = this.doLoadChildrenContent(GizmoSelectedToolsName);
        return values;
    }

    public void setSelectedTools(String[] toolNames) {
        this.doSave(GizmoSelectedToolsName, GizmoToolName, toolNames);
    }

    public boolean getUserInteractionRequiredActionsEnabled() {
        String value = this.doLoad(GizmoUserIntreactionRequiredActionsEnabled);
        return this.str2bool(value);
    }

    public void setUserInteractionRequiredActionsEnabled(Boolean enabled) {
        this.doSave(GizmoUserIntreactionRequiredActionsEnabled, enabled.toString());
    }

    public String getDataCollectorName() {
        String value = this.doLoad(GizmoDataCollectorName);
        return value;
    }

    public void setDataCollectorName(String name) {
        this.doSave(GizmoDataCollectorName, name);
    }

    private boolean str2bool(String value) {
        return value == null || value.length() == 0 ? false : Boolean.parseBoolean(value);
    }

    private Element getConfigurationFragment() {
        Element data = this.aux.getConfigurationFragment(GizmoData, this.namespace, this.shared);
        if (data == null) {
            data = GizmoProjectOptions.createDocument(this.namespace, this.shared ? "project" : "project-private").createElementNS(this.namespace, GizmoData);
        }
        if (data == null) {
            System.err.println("GizmoProjectOptions: Failed to load and create configuration fragment (gizmo-options : " + this.namespace + ")");
        }
        return data;
    }

    private Element getNode(Element configurationFragment, String name) {
        Element node;
        NodeList nodes = configurationFragment.getElementsByTagNameNS(this.namespace, name);
        if (nodes.getLength() == 0) {
            node = configurationFragment.getOwnerDocument().createElementNS(this.namespace, name);
            configurationFragment.appendChild(node);
        } else {
            node = (Element)nodes.item(0);
        }
        return node;
    }

    private String doLoad(final String name) {
        return (String)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String>(){

            public String run() {
                Element configurationFragment = GizmoProjectOptions.this.getConfigurationFragment();
                if (configurationFragment == null) {
                    return null;
                }
                return GizmoProjectOptions.this.getNode(configurationFragment, name).getTextContent();
            }
        });
    }

    private String[] doLoadChildrenContent(final String name) {
        return (String[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String[]>(){

            public String[] run() {
                Element configurationFragment = GizmoProjectOptions.this.getConfigurationFragment();
                if (configurationFragment == null) {
                    return null;
                }
                Element n = GizmoProjectOptions.this.getNode(configurationFragment, name);
                NodeList list = n.getChildNodes();
                if (list == null || list.getLength() == 0) {
                    return null;
                }
                ArrayList<String> result = new ArrayList<String>();
                int size = list.getLength();
                for (int i = 0; i < size; ++i) {
                    if (list.item(i).getNodeType() != 1) continue;
                    result.add(list.item(i).getTextContent());
                }
                return result.toArray(new String[0]);
            }
        });
    }

    private void doSave(final String name, final String childName, final String[] values) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                Element configurationFragment = GizmoProjectOptions.this.getConfigurationFragment();
                if (configurationFragment != null) {
                    Element oldElement = GizmoProjectOptions.this.getNode(configurationFragment, name);
                    Element newElement = configurationFragment.getOwnerDocument().createElementNS(GizmoProjectOptions.this.namespace, name);
                    for (int i = 0; i < values.length; ++i) {
                        Element child = configurationFragment.getOwnerDocument().createElement(childName);
                        child.setTextContent(values[i]);
                        newElement.appendChild(child);
                    }
                    configurationFragment.removeChild(oldElement);
                    configurationFragment.appendChild(newElement);
                    GizmoProjectOptions.this.aux.putConfigurationFragment(configurationFragment, GizmoProjectOptions.this.shared);
                }
            }
        });
    }

    private void doSave(final String name, final String value) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                Element configurationFragment = GizmoProjectOptions.this.getConfigurationFragment();
                if (configurationFragment != null) {
                    Element el = GizmoProjectOptions.this.getNode(configurationFragment, name);
                    el.setTextContent(value);
                    GizmoProjectOptions.this.aux.putConfigurationFragment(configurationFragment, GizmoProjectOptions.this.shared);
                }
            }
        });
    }

    private static Document createDocument(String ns, String root) throws DOMException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            return factory.newDocumentBuilder().getDOMImplementation().createDocument(ns, root, null);
        }
        catch (ParserConfigurationException ex) {
            throw (DOMException)new DOMException(9, "Cannot create parser").initCause(ex);
        }
    }
}

