/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.actions;

import java.util.concurrent.Callable;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.groovy.grails.api.ExecutionSupport;
import org.netbeans.modules.groovy.grails.api.GrailsPlatform;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.actions.ConfigurationSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public abstract class GenerateAction
extends NodeAction {
    private static final String DOMAIN_DIR = "grails-app/domain";
    private final String command;
    private final String actionName;

    public GenerateAction(String string, String string2) {
        this.command = string;
        this.actionName = string2;
    }

    protected void performAction(Node[] nodeArray) {
        GrailsPlatform grailsPlatform = GrailsPlatform.getDefault();
        if (!grailsPlatform.isConfigured()) {
            ConfigurationSupport.showConfigurationWarning(grailsPlatform);
            return;
        }
        DataObject dataObject = (DataObject)nodeArray[0].getLookup().lookup(DataObject.class);
        GrailsProject grailsProject = (GrailsProject)FileOwnerQuery.getOwner((FileObject)dataObject.getFolder().getPrimaryFile());
        FileObject fileObject = grailsProject.getProjectDirectory().getFileObject(DOMAIN_DIR);
        if (fileObject == null) {
            return;
        }
        String string = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)dataObject.getPrimaryFile());
        if (string == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(string.replace('/', '.'));
        stringBuilder.setLength(stringBuilder.length() - dataObject.getPrimaryFile().getNameExt().length());
        stringBuilder.append(dataObject.getPrimaryFile().getName());
        ProjectInformation projectInformation = (ProjectInformation)grailsProject.getLookup().lookup(ProjectInformation.class);
        String string2 = projectInformation.getDisplayName() + " (" + this.command + ")";
        Callable callable = ExecutionSupport.getInstance().createSimpleCommand(this.command, GrailsProjectConfig.forProject((Project)grailsProject), new String[]{stringBuilder.toString()});
        ExecutionDescriptor executionDescriptor = grailsProject.getCommandSupport().getDescriptor(this.command);
        ExecutionService executionService = ExecutionService.newService((Callable)callable, (ExecutionDescriptor)executionDescriptor, (String)string2);
        executionService.run();
    }

    public String getName() {
        return this.actionName;
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray.length == 0) {
            return false;
        }
        DataObject dataObject = (DataObject)nodeArray[0].getLookup().lookup(DataObject.class);
        if (dataObject == null || dataObject.getFolder() == null) {
            return false;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)dataObject.getFolder().getPrimaryFile());
        if (project == null) {
            return false;
        }
        FileObject fileObject = project.getProjectDirectory().getFileObject(DOMAIN_DIR);
        if (fileObject == null) {
            return false;
        }
        return FileUtil.isParentOf((FileObject)fileObject, (FileObject)dataObject.getPrimaryFile());
    }
}

