/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.procfs.reader.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.dlight.procfs.api.LWPUsage;
import org.netbeans.modules.dlight.procfs.api.PStatus;
import org.netbeans.modules.dlight.procfs.api.PUsage;
import org.netbeans.modules.dlight.procfs.reader.impl.DataModel;
import org.netbeans.modules.dlight.procfs.reader.impl.ProcReaderImpl;

public class LocalProcReader
extends ProcReaderImpl {
    private final File usageFile;
    private final File statusFile;
    private final File lwpDir;

    public LocalProcReader(int pid, ByteOrder byteOrder, DataModel dataModel) {
        super(byteOrder, dataModel);
        this.usageFile = new File("/proc/" + pid + "/usage");
        this.statusFile = new File("/proc/" + pid + "/status");
        this.lwpDir = new File("/proc/" + pid + "/lwp");
    }

    @Override
    public PStatus getProcessStatus() {
        PStatus status = null;
        try {
            status = this.getProcessStatus(new FileInputStream(this.statusFile));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return status;
    }

    @Override
    public PUsage getProcessUsage() throws IOException {
        return this.getProcessUsage(new FileInputStream(this.usageFile));
    }

    @Override
    public List<LWPUsage> getThreadsInfo() {
        ArrayList<LWPUsage> result = new ArrayList<LWPUsage>();
        String[] lwps = this.lwpDir.list();
        if (lwps == null) {
            return result;
        }
        for (String lwp : lwps) {
            try {
                result.add(this.getProcessUsage(new FileInputStream(new File(this.lwpDir, lwp + "/lwpusage"))));
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return result;
    }
}

