/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.dataprovider.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.api.FunctionCallWithMetric;
import org.netbeans.modules.dlight.core.stack.api.FunctionMetric;
import org.netbeans.modules.dlight.core.stack.api.support.FunctionDatatableDescription;
import org.netbeans.modules.dlight.core.stack.dataprovider.FunctionCallTreeTableNode;
import org.netbeans.modules.dlight.core.stack.dataprovider.FunctionsListDataProvider;
import org.netbeans.modules.dlight.core.stack.storage.StackDataStorage;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.openide.util.Lookup;

class FunctionsListDataProviderImpl
implements FunctionsListDataProvider {
    private final Lock lock = new Lock();
    private StackDataStorage storage;
    private ServiceInfoDataStorage serviceInfoStorage;
    private final List<DataFilter> filters = new ArrayList<DataFilter>();

    FunctionsListDataProviderImpl() {
    }

    public void attachTo(DataStorage storage) {
        this.storage = (StackDataStorage)storage;
    }

    public void attachTo(ServiceInfoDataStorage serviceInfoDataStorage) {
        this.serviceInfoStorage = serviceInfoDataStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FunctionCallWithMetric> getFunctionsList(DataTableMetadata metadata, FunctionDatatableDescription functionDescription, List<DataTableMetadata.Column> metricsColumn) {
        ArrayList<DataFilter> filtersCopy = null;
        Lock lock = this.lock;
        synchronized (lock) {
            filtersCopy = new ArrayList<DataFilter>(this.filters);
        }
        if (functionDescription.getOffsetColumn() == null) {
            ArrayList<FunctionCallWithMetric> result = new ArrayList<FunctionCallWithMetric>();
            List<FunctionCallTreeTableNode> nodes = FunctionCallTreeTableNode.getFunctionCallTreeTableNodes(this.storage.getHotSpotFunctions(FunctionMetric.CpuTimeExclusiveMetric, filtersCopy, Integer.MAX_VALUE));
            for (FunctionCallTreeTableNode node : nodes) {
                FunctionCallWithMetric call = node.getDeligator();
                result.add(call);
            }
            return result;
        }
        return this.storage.getFunctionsList(metadata, metricsColumn, functionDescription, filtersCopy);
    }

    @Override
    public List<FunctionCallWithMetric> getDetailedFunctionsList(DataTableMetadata metadata, FunctionDatatableDescription functionDescription, List<DataTableMetadata.Column> metricsColumn) {
        return this.getFunctionsList(metadata, functionDescription, metricsColumn);
    }

    @Override
    public SourceFileInfoProvider.SourceFileInfo getSourceFileInfo(FunctionCall functionCall) {
        Collection sourceInfoProviders = Lookup.getDefault().lookupAll(SourceFileInfoProvider.class);
        for (SourceFileInfoProvider provider : sourceInfoProviders) {
            SourceFileInfoProvider.SourceFileInfo sourceInfo = provider.getSourceFileInfo(functionCall.getFunction().getQuilifiedName(), -1, functionCall.getOffset(), this.serviceInfoStorage.getInfo());
            if (sourceInfo == null || !sourceInfo.isSourceKnown()) continue;
            return sourceInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataFiltersChanged(List<DataFilter> newSet, boolean isAdjusting) {
        if (isAdjusting) {
            return;
        }
        Lock lock = this.lock;
        synchronized (lock) {
            this.filters.clear();
            this.filters.addAll(newSet);
        }
    }

    @Override
    public boolean hasTheSameDetails(DataTableMetadata metadata, FunctionDatatableDescription functionDescription, List<DataTableMetadata.Column> metricsColumn) {
        return true;
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

