/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.core.ProjectWebServiceView;
import org.netbeans.modules.websvc.core.ProjectWebServiceViewImpl;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.actions.FindAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PropertiesAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class ProjectWebServiceNodeFactory
implements NodeFactory {
    public static ProjectWebServiceNodeFactory ejbproject() {
        return new ProjectWebServiceNodeFactory();
    }

    public static ProjectWebServiceNodeFactory j2seproject() {
        return new ProjectWebServiceNodeFactory();
    }

    public static ProjectWebServiceNodeFactory j2eeClientProject() {
        return new ProjectWebServiceNodeFactory();
    }

    public NodeList createNodes(Project p) {
        assert (p != null);
        return new WsNodeList(p);
    }

    private static class WsClientPrivilegedTemplates
    implements PrivilegedTemplates {
        private WsClientPrivilegedTemplates() {
        }

        public String[] getPrivilegedTemplates() {
            return new String[]{"Templates/WebServices/WebServiceClient", "Templates/WebServices/MessageHandler.java", "Templates/WebServices/LogicalHandler.java"};
        }
    }

    private static class WsPrivilegedTemplates
    implements PrivilegedTemplates {
        private WsPrivilegedTemplates() {
        }

        public String[] getPrivilegedTemplates() {
            return new String[]{"Templates/WebServices/WebService.java", "Templates/WebServices/WebServiceFromWSDL.java", "Templates/WebServices/MessageHandler.java", "Templates/WebServices/LogicalHandler.java"};
        }
    }

    private static class WSRootNode
    extends AbstractNode {
        private static final String SERVICES_BADGE = "org/netbeans/modules/websvc/core/webservices/ui/resources/webservicegroup.png";
        private Icon folderIconCache;
        private Icon openedFolderIconCache;
        private Image cachedServicesBadge;

        public WSRootNode(WsNodeList.Children children, Lookup lookup) {
            super((Children)children, lookup);
        }

        public Action[] getActions(boolean context) {
            return new Action[]{CommonProjectActions.newFileAction(), null, SystemAction.get(FindAction.class), null, SystemAction.get(PasteAction.class), null, SystemAction.get(PropertiesAction.class)};
        }

        public Image getIcon(int type) {
            return this.computeIcon(false);
        }

        public Image getOpenedIcon(int type) {
            return this.computeIcon(true);
        }

        private Image getServicesImage() {
            if (this.cachedServicesBadge == null) {
                this.cachedServicesBadge = ImageUtilities.loadImage((String)SERVICES_BADGE);
            }
            return this.cachedServicesBadge;
        }

        private Icon getFolderIcon(boolean opened) {
            if (this.openedFolderIconCache == null) {
                Node n = DataFolder.findFolder((FileObject)FileUtil.getConfigRoot()).getNodeDelegate();
                this.openedFolderIconCache = new ImageIcon(n.getOpenedIcon(1));
                this.folderIconCache = new ImageIcon(n.getIcon(1));
            }
            if (opened) {
                return this.openedFolderIconCache;
            }
            return this.folderIconCache;
        }

        private Image computeIcon(boolean opened) {
            Icon icon = this.getFolderIcon(opened);
            Image image = ((ImageIcon)icon).getImage();
            image = ImageUtilities.mergeImages((Image)image, (Image)this.getServicesImage(), (int)7, (int)7);
            return image;
        }
    }

    private static class WsNodeList
    implements NodeList<ProjectWebServiceView.ViewType>,
    ChangeListener {
        private Project project;
        private ChangeSupport changeSupport;
        private ProjectWebServiceView view;
        private Node serviceNode;
        private Node clientNode;
        private ChangeListener weakL;

        public WsNodeList(Project proj) {
            this.project = proj;
            this.changeSupport = new ChangeSupport((Object)this);
        }

        public List<ProjectWebServiceView.ViewType> keys() {
            this.initView();
            ArrayList<ProjectWebServiceView.ViewType> result = new ArrayList<ProjectWebServiceView.ViewType>();
            if (!this.view.isViewEmpty(ProjectWebServiceView.ViewType.SERVICE)) {
                result.add(ProjectWebServiceView.ViewType.SERVICE);
            }
            if (!this.view.isViewEmpty(ProjectWebServiceView.ViewType.CLIENT)) {
                result.add(ProjectWebServiceView.ViewType.CLIENT);
            }
            return result;
        }

        public synchronized void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public synchronized void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        private void fireChange() {
            this.changeSupport.fireChange();
        }

        public Node node(ProjectWebServiceView.ViewType key) {
            switch (key) {
                case SERVICE: {
                    if (this.serviceNode == null) {
                        this.serviceNode = new WSRootNode(new Children(key), this.createLookup(this.project, new WsPrivilegedTemplates()));
                        this.serviceNode.setDisplayName(NbBundle.getBundle(ProjectWebServiceNodeFactory.class).getString("LBL_WebServices"));
                    }
                    return this.serviceNode;
                }
                case CLIENT: {
                    if (this.clientNode == null) {
                        this.clientNode = new WSRootNode(new Children(key), this.createLookup(this.project, new WsClientPrivilegedTemplates()));
                        this.clientNode.setDisplayName(NbBundle.getBundle(ProjectWebServiceNodeFactory.class).getString("LBL_ServiceReferences"));
                    }
                    return this.clientNode;
                }
            }
            return null;
        }

        public void addNotify() {
            this.initView();
            this.weakL = WeakListeners.change((ChangeListener)this, (Object)this.view);
            this.view.addChangeListener(this.weakL, ProjectWebServiceView.ViewType.SERVICE);
            this.view.addChangeListener(this.weakL, ProjectWebServiceView.ViewType.CLIENT);
            this.view.addNotify();
        }

        public void removeNotify() {
            if (this.view != null) {
                this.view.removeChangeListener(this.weakL, ProjectWebServiceView.ViewType.SERVICE);
                this.view.removeChangeListener(this.weakL, ProjectWebServiceView.ViewType.CLIENT);
                this.view.removeNotify();
                this.weakL = null;
            }
        }

        @Override
        public void stateChanged(final ChangeEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WsNodeList.this.fireChange();
                    Object source = e.getSource();
                    if (source instanceof ProjectWebServiceViewImpl) {
                        ProjectWebServiceViewImpl view = (ProjectWebServiceViewImpl)source;
                        if (WsNodeList.this.serviceNode != null) {
                            ((Children)WsNodeList.this.serviceNode.getChildren()).updateKey(view);
                        }
                        if (WsNodeList.this.clientNode != null) {
                            ((Children)WsNodeList.this.clientNode.getChildren()).updateKey(view);
                        }
                    }
                }
            });
        }

        private void initView() {
            if (this.view == null) {
                this.view = ProjectWebServiceView.getProjectWebServiceView(this.project);
            }
        }

        private Lookup createLookup(Project project, PrivilegedTemplates privilegedTemplates) {
            return Lookups.fixed((Object[])new Object[]{project, privilegedTemplates});
        }

        private class Children
        extends Children.Keys<ProjectWebServiceViewImpl> {
            private ProjectWebServiceView.ViewType viewType;

            public Children(ProjectWebServiceView.ViewType viewType) {
                this.viewType = viewType;
            }

            protected Node[] createNodes(ProjectWebServiceViewImpl view) {
                return view.createView(this.viewType);
            }

            protected void addNotify() {
                super.addNotify();
                if (WsNodeList.this.view != null && !WsNodeList.this.view.isViewEmpty(this.viewType)) {
                    this.setKeys(WsNodeList.this.view.getWebServiceViews());
                } else {
                    this.setKeys(Collections.emptyList());
                }
            }

            protected void removeNotify() {
                super.removeNotify();
                this.setKeys(Collections.emptyList());
            }

            private void updateKey(ProjectWebServiceViewImpl view) {
                if (!this.isInitialized()) {
                    return;
                }
                super.refreshKey((Object)view);
            }
        }
    }
}

