/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import org.netbeans.core.startup.ManifestSection;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.lookup.InstanceContent;

public abstract class CoreBridge {
    public static CoreBridge getDefault() {
        CoreBridge b = (CoreBridge)Lookup.getDefault().lookup(CoreBridge.class);
        if (b == null) {
            b = new FakeBridge();
        }
        return b;
    }

    protected abstract void attachToCategory(Object var1);

    protected abstract void loadDefaultSection(ManifestSection var1, InstanceContent.Convertor<ManifestSection, Object> var2, boolean var3);

    protected abstract void loadActionSection(ManifestSection.ActionSection var1, boolean var2) throws Exception;

    protected abstract void loadLoaderSection(ManifestSection.LoaderSection var1, boolean var2) throws Exception;

    protected abstract void loaderPoolTransaction(boolean var1);

    public abstract void registerPropertyEditors();

    public abstract Lookup lookupCacheLoad();

    public abstract void setStatusText(String var1);

    public abstract void initializePlaf(Class var1, int var2, URL var3);

    public abstract int cli(String[] var1, InputStream var2, OutputStream var3, OutputStream var4, File var5);

    public static void defineOsTokens(Collection<? super String> provides) {
        if (Utilities.isUnix()) {
            provides.add("org.openide.modules.os.Unix");
            if (!Utilities.isMac()) {
                provides.add("org.openide.modules.os.PlainUnix");
            }
        }
        if (Utilities.isWindows()) {
            provides.add("org.openide.modules.os.Windows");
        }
        if (Utilities.isMac()) {
            provides.add("org.openide.modules.os.MacOSX");
        }
        if ((Utilities.getOperatingSystem() & 0x800) != 0) {
            provides.add("org.openide.modules.os.OS2");
        }
        if ((Utilities.getOperatingSystem() & 0x10) != 0) {
            provides.add("org.openide.modules.os.Linux");
        }
        if ((Utilities.getOperatingSystem() & 8) != 0) {
            provides.add("org.openide.modules.os.Solaris");
        }
    }

    private static final class FakeBridge
    extends CoreBridge {
        private FakeBridge() {
        }

        @Override
        protected void attachToCategory(Object category) {
        }

        protected void loadDefaultSection(ManifestSection ms, InstanceContent.Convertor convertor, boolean add) {
        }

        @Override
        protected void loadActionSection(ManifestSection.ActionSection s, boolean load) throws Exception {
            s.getInstance();
        }

        @Override
        protected void loadLoaderSection(ManifestSection.LoaderSection s, boolean load) throws Exception {
        }

        @Override
        protected void loaderPoolTransaction(boolean begin) {
        }

        protected void addToSplashMaxSteps(int cnt) {
        }

        protected void incrementSplashProgressBar() {
        }

        @Override
        public Lookup lookupCacheLoad() {
            return Lookup.EMPTY;
        }

        public void lookupCacheStore(Lookup l) throws IOException {
        }

        @Override
        public void setStatusText(String status) {
            System.err.println(status);
        }

        @Override
        public void initializePlaf(Class uiClass, int uiFontSize, URL themeURL) {
        }

        @Override
        public void registerPropertyEditors() {
        }

        @Override
        public int cli(String[] string, InputStream inputStream, OutputStream outputStream, OutputStream errorStream, File file) {
            return 0;
        }
    }
}

