/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementKindVisitor6;
import org.netbeans.modules.websvc.editor.hints.common.ProblemContext;
import org.netbeans.modules.websvc.editor.hints.common.Rule;
import org.netbeans.spi.editor.hints.ErrorDescription;

public abstract class RulesEngine
extends ElementKindVisitor6<Void, ProblemContext> {
    private ProblemContext ctx;
    private List<ErrorDescription> problemsFound = new ArrayList<ErrorDescription>();

    @Override
    public Void visitTypeAsClass(TypeElement typeElement, ProblemContext problemContext) {
        for (Rule<TypeElement> object : this.getClassRules()) {
            if (problemContext.isCancelled()) break;
            ErrorDescription[] errorDescriptionArray = object.execute(typeElement, problemContext);
            if (errorDescriptionArray == null) continue;
            for (ErrorDescription errorDescription : errorDescriptionArray) {
                if (errorDescription == null) continue;
                this.problemsFound.add(errorDescription);
            }
        }
        for (Element element : typeElement.getEnclosedElements()) {
            element.accept(this, problemContext);
        }
        return null;
    }

    @Override
    public Void visitTypeAsInterface(TypeElement typeElement, ProblemContext problemContext) {
        return this.visitTypeAsClass(typeElement, problemContext);
    }

    @Override
    public Void visitExecutableAsMethod(ExecutableElement executableElement, ProblemContext problemContext) {
        for (Rule<ExecutableElement> object : this.getOperationRules()) {
            if (problemContext.isCancelled()) break;
            ErrorDescription[] errorDescriptionArray = object.execute(executableElement, problemContext);
            if (errorDescriptionArray == null) continue;
            for (ErrorDescription errorDescription : errorDescriptionArray) {
                if (errorDescription == null) continue;
                this.problemsFound.add(errorDescription);
            }
        }
        for (VariableElement variableElement : executableElement.getParameters()) {
            variableElement.accept(this, problemContext);
        }
        return null;
    }

    @Override
    public Void visitVariableAsParameter(VariableElement variableElement, ProblemContext problemContext) {
        for (Rule<VariableElement> rule : this.getParameterRules()) {
            if (problemContext.isCancelled()) break;
            ErrorDescription[] errorDescriptionArray = rule.execute(variableElement, problemContext);
            if (errorDescriptionArray == null) continue;
            for (ErrorDescription errorDescription : errorDescriptionArray) {
                if (errorDescription == null) continue;
                this.problemsFound.add(errorDescription);
            }
        }
        return null;
    }

    public List<ErrorDescription> getProblemsFound() {
        return this.problemsFound;
    }

    protected abstract Collection<Rule<TypeElement>> getClassRules();

    protected abstract Collection<Rule<ExecutableElement>> getOperationRules();

    protected abstract Collection<Rule<VariableElement>> getParameterRules();
}

