/*
 * Decompiled with CFR 0.152.
 */
package persistence.antlr;

import persistence.antlr.ActionElement;
import persistence.antlr.Alternative;
import persistence.antlr.AlternativeBlock;
import persistence.antlr.AlternativeElement;
import persistence.antlr.BlockEndElement;
import persistence.antlr.BlockWithImpliedExitPath;
import persistence.antlr.CharFormatter;
import persistence.antlr.CharLiteralElement;
import persistence.antlr.CharRangeElement;
import persistence.antlr.CodeGenerator;
import persistence.antlr.Grammar;
import persistence.antlr.GrammarAtom;
import persistence.antlr.JavaCharFormatter;
import persistence.antlr.LLkGrammarAnalyzer;
import persistence.antlr.LexerGrammar;
import persistence.antlr.Lookahead;
import persistence.antlr.OneOrMoreBlock;
import persistence.antlr.RuleBlock;
import persistence.antlr.RuleEndElement;
import persistence.antlr.RuleRefElement;
import persistence.antlr.RuleSymbol;
import persistence.antlr.StringLiteralElement;
import persistence.antlr.SynPredBlock;
import persistence.antlr.TokenRangeElement;
import persistence.antlr.TokenRefElement;
import persistence.antlr.Tool;
import persistence.antlr.TreeElement;
import persistence.antlr.TreeWalkerGrammar;
import persistence.antlr.WildcardElement;
import persistence.antlr.ZeroOrMoreBlock;
import persistence.antlr.collections.impl.BitSet;
import persistence.antlr.collections.impl.Vector;

public class LLkAnalyzer
implements LLkGrammarAnalyzer {
    public boolean DEBUG_ANALYZER = false;
    private AlternativeBlock currentBlock;
    protected Tool tool = null;
    protected Grammar grammar = null;
    protected boolean lexicalAnalysis = false;
    CharFormatter charFormatter = new JavaCharFormatter();

    public LLkAnalyzer(Tool tool_) {
        this.tool = tool_;
    }

    protected boolean altUsesWildcardDefault(Alternative alt) {
        AlternativeElement head = alt.head;
        if (head instanceof TreeElement && ((TreeElement)head).root instanceof WildcardElement) {
            return true;
        }
        return head instanceof WildcardElement && head.next instanceof BlockEndElement;
    }

    public boolean deterministic(AlternativeBlock blk) {
        int k = 1;
        if (this.DEBUG_ANALYZER) {
            System.out.println("deterministic(" + blk + ")");
        }
        boolean det = true;
        int nalts = blk.alternatives.size();
        AlternativeBlock saveCurrentBlock = this.currentBlock;
        Alternative wildcardAlt = null;
        this.currentBlock = blk;
        if (!(blk.greedy || blk instanceof OneOrMoreBlock || blk instanceof ZeroOrMoreBlock)) {
            this.tool.warning("Being nongreedy only makes sense for (...)+ and (...)*", this.grammar.getFilename(), blk.getLine(), blk.getColumn());
        }
        if (nalts == 1) {
            AlternativeElement e = blk.getAlternativeAt((int)0).head;
            this.currentBlock.alti = 0;
            blk.getAlternativeAt((int)0).cache[1] = e.look(1);
            blk.getAlternativeAt((int)0).lookaheadDepth = 1;
            this.currentBlock = saveCurrentBlock;
            return true;
        }
        for (int i = 0; i < nalts - 1; ++i) {
            this.currentBlock.alti = i;
            this.currentBlock.analysisAlt = i;
            this.currentBlock.altj = i + 1;
            for (int j = i + 1; j < nalts; ++j) {
                boolean haveAmbiguity;
                this.currentBlock.altj = j;
                if (this.DEBUG_ANALYZER) {
                    System.out.println("comparing " + i + " against alt " + j);
                }
                this.currentBlock.analysisAlt = j;
                k = 1;
                Lookahead[] r = new Lookahead[this.grammar.maxk + 1];
                do {
                    haveAmbiguity = false;
                    if (this.DEBUG_ANALYZER) {
                        System.out.println("checking depth " + k + "<=" + this.grammar.maxk);
                    }
                    Lookahead p = this.getAltLookahead(blk, i, k);
                    Lookahead q = this.getAltLookahead(blk, j, k);
                    if (this.DEBUG_ANALYZER) {
                        System.out.println("p is " + p.toString(",", this.charFormatter, this.grammar));
                    }
                    if (this.DEBUG_ANALYZER) {
                        System.out.println("q is " + q.toString(",", this.charFormatter, this.grammar));
                    }
                    r[k] = p.intersection(q);
                    if (this.DEBUG_ANALYZER) {
                        System.out.println("intersection at depth " + k + " is " + r[k].toString());
                    }
                    if (r[k].nil()) continue;
                    haveAmbiguity = true;
                    ++k;
                } while (haveAmbiguity && k <= this.grammar.maxk);
                Alternative ai = blk.getAlternativeAt(i);
                Alternative aj = blk.getAlternativeAt(j);
                if (haveAmbiguity) {
                    det = false;
                    ai.lookaheadDepth = Integer.MAX_VALUE;
                    aj.lookaheadDepth = Integer.MAX_VALUE;
                    if (ai.synPred != null) {
                        if (!this.DEBUG_ANALYZER) continue;
                        System.out.println("alt " + i + " has a syn pred");
                        continue;
                    }
                    if (ai.semPred != null) {
                        if (!this.DEBUG_ANALYZER) continue;
                        System.out.println("alt " + i + " has a sem pred");
                        continue;
                    }
                    if (this.altUsesWildcardDefault(aj)) {
                        wildcardAlt = aj;
                        continue;
                    }
                    if (!blk.warnWhenFollowAmbig && (ai.head instanceof BlockEndElement || aj.head instanceof BlockEndElement) || !blk.generateAmbigWarnings || blk.greedySet && blk.greedy && (ai.head instanceof BlockEndElement && !(aj.head instanceof BlockEndElement) || aj.head instanceof BlockEndElement && !(ai.head instanceof BlockEndElement))) continue;
                    this.tool.errorHandler.warnAltAmbiguity(this.grammar, blk, this.lexicalAnalysis, this.grammar.maxk, r, i, j);
                    continue;
                }
                ai.lookaheadDepth = Math.max(ai.lookaheadDepth, k);
                aj.lookaheadDepth = Math.max(aj.lookaheadDepth, k);
            }
        }
        this.currentBlock = saveCurrentBlock;
        return det;
    }

    public boolean deterministic(OneOrMoreBlock blk) {
        if (this.DEBUG_ANALYZER) {
            System.out.println("deterministic(...)+(" + blk + ")");
        }
        AlternativeBlock saveCurrentBlock = this.currentBlock;
        this.currentBlock = blk;
        boolean blkOk = this.deterministic((AlternativeBlock)blk);
        boolean det = this.deterministicImpliedPath(blk);
        this.currentBlock = saveCurrentBlock;
        return det && blkOk;
    }

    public boolean deterministic(ZeroOrMoreBlock blk) {
        if (this.DEBUG_ANALYZER) {
            System.out.println("deterministic(...)*(" + blk + ")");
        }
        AlternativeBlock saveCurrentBlock = this.currentBlock;
        this.currentBlock = blk;
        boolean blkOk = this.deterministic((AlternativeBlock)blk);
        boolean det = this.deterministicImpliedPath(blk);
        this.currentBlock = saveCurrentBlock;
        return det && blkOk;
    }

    public boolean deterministicImpliedPath(BlockWithImpliedExitPath blk) {
        boolean det = true;
        Vector alts = blk.getAlternatives();
        int nalts = alts.size();
        this.currentBlock.altj = -1;
        if (this.DEBUG_ANALYZER) {
            System.out.println("deterministicImpliedPath");
        }
        for (int i = 0; i < nalts; ++i) {
            boolean haveAmbiguity;
            Alternative alt = blk.getAlternativeAt(i);
            if (alt.head instanceof BlockEndElement) {
                this.tool.warning("empty alternative makes no sense in (...)* or (...)+", this.grammar.getFilename(), blk.getLine(), blk.getColumn());
            }
            int k = 1;
            Lookahead[] r = new Lookahead[this.grammar.maxk + 1];
            do {
                Lookahead follow;
                haveAmbiguity = false;
                if (this.DEBUG_ANALYZER) {
                    System.out.println("checking depth " + k + "<=" + this.grammar.maxk);
                }
                blk.exitCache[k] = follow = blk.next.look(k);
                this.currentBlock.alti = i;
                Lookahead p = this.getAltLookahead(blk, i, k);
                if (this.DEBUG_ANALYZER) {
                    System.out.println("follow is " + follow.toString(",", this.charFormatter, this.grammar));
                }
                if (this.DEBUG_ANALYZER) {
                    System.out.println("p is " + p.toString(",", this.charFormatter, this.grammar));
                }
                r[k] = follow.intersection(p);
                if (this.DEBUG_ANALYZER) {
                    System.out.println("intersection at depth " + k + " is " + r[k]);
                }
                if (r[k].nil()) continue;
                haveAmbiguity = true;
                ++k;
            } while (haveAmbiguity && k <= this.grammar.maxk);
            if (haveAmbiguity) {
                det = false;
                alt.lookaheadDepth = Integer.MAX_VALUE;
                blk.exitLookaheadDepth = Integer.MAX_VALUE;
                Alternative ambigAlt = blk.getAlternativeAt(this.currentBlock.alti);
                if (!blk.warnWhenFollowAmbig || !blk.generateAmbigWarnings) continue;
                if (blk.greedy && blk.greedySet && !(ambigAlt.head instanceof BlockEndElement)) {
                    if (!this.DEBUG_ANALYZER) continue;
                    System.out.println("greedy loop");
                    continue;
                }
                if (!blk.greedy && !(ambigAlt.head instanceof BlockEndElement)) {
                    if (this.DEBUG_ANALYZER) {
                        System.out.println("nongreedy loop");
                    }
                    if (LLkAnalyzer.lookaheadEquivForApproxAndFullAnalysis(blk.exitCache, this.grammar.maxk)) continue;
                    this.tool.warning(new String[]{"nongreedy block may exit incorrectly due", "\tto limitations of linear approximate lookahead (first k-1 sets", "\tin lookahead not singleton)."}, this.grammar.getFilename(), blk.getLine(), blk.getColumn());
                    continue;
                }
                this.tool.errorHandler.warnAltExitAmbiguity(this.grammar, blk, this.lexicalAnalysis, this.grammar.maxk, r, i);
                continue;
            }
            alt.lookaheadDepth = Math.max(alt.lookaheadDepth, k);
            blk.exitLookaheadDepth = Math.max(blk.exitLookaheadDepth, k);
        }
        return det;
    }

    public Lookahead FOLLOW(int k, RuleEndElement end) {
        RuleBlock rb = (RuleBlock)end.block;
        String rule = this.lexicalAnalysis ? CodeGenerator.encodeLexerRuleName(rb.getRuleName()) : rb.getRuleName();
        if (this.DEBUG_ANALYZER) {
            System.out.println("FOLLOW(" + k + "," + rule + ")");
        }
        if (end.lock[k]) {
            if (this.DEBUG_ANALYZER) {
                System.out.println("FOLLOW cycle to " + rule);
            }
            return new Lookahead(rule);
        }
        if (end.cache[k] != null) {
            if (this.DEBUG_ANALYZER) {
                System.out.println("cache entry FOLLOW(" + k + ") for " + rule + ": " + end.cache[k].toString(",", this.charFormatter, this.grammar));
            }
            if (end.cache[k].cycle == null) {
                return (Lookahead)end.cache[k].clone();
            }
            RuleSymbol rs = (RuleSymbol)this.grammar.getSymbol(end.cache[k].cycle);
            RuleEndElement re = rs.getBlock().endNode;
            if (re.cache[k] == null) {
                return (Lookahead)end.cache[k].clone();
            }
            if (this.DEBUG_ANALYZER) {
                System.out.println("combining FOLLOW(" + k + ") for " + rule + ": from " + end.cache[k].toString(",", this.charFormatter, this.grammar) + " with FOLLOW for " + ((RuleBlock)re.block).getRuleName() + ": " + re.cache[k].toString(",", this.charFormatter, this.grammar));
            }
            if (re.cache[k].cycle == null) {
                end.cache[k].combineWith(re.cache[k]);
                end.cache[k].cycle = null;
            } else {
                Lookahead refFOLLOW = this.FOLLOW(k, re);
                end.cache[k].combineWith(refFOLLOW);
                end.cache[k].cycle = refFOLLOW.cycle;
            }
            if (this.DEBUG_ANALYZER) {
                System.out.println("saving FOLLOW(" + k + ") for " + rule + ": from " + end.cache[k].toString(",", this.charFormatter, this.grammar));
            }
            return (Lookahead)end.cache[k].clone();
        }
        end.lock[k] = true;
        Lookahead p = new Lookahead();
        RuleSymbol rs = (RuleSymbol)this.grammar.getSymbol(rule);
        for (int i = 0; i < rs.numReferences(); ++i) {
            RuleRefElement rr = rs.getReference(i);
            if (this.DEBUG_ANALYZER) {
                System.out.println("next[" + rule + "] is " + rr.next.toString());
            }
            Lookahead q = rr.next.look(k);
            if (this.DEBUG_ANALYZER) {
                System.out.println("FIRST of next[" + rule + "] ptr is " + q.toString());
            }
            if (q.cycle != null && q.cycle.equals(rule)) {
                q.cycle = null;
            }
            p.combineWith(q);
            if (!this.DEBUG_ANALYZER) continue;
            System.out.println("combined FOLLOW[" + rule + "] is " + p.toString());
        }
        end.lock[k] = false;
        if (p.fset.nil() && p.cycle == null) {
            if (this.grammar instanceof TreeWalkerGrammar) {
                p.fset.add(3);
            } else if (this.grammar instanceof LexerGrammar) {
                p.setEpsilon();
            } else {
                p.fset.add(1);
            }
        }
        if (this.DEBUG_ANALYZER) {
            System.out.println("saving FOLLOW(" + k + ") for " + rule + ": " + p.toString(",", this.charFormatter, this.grammar));
        }
        end.cache[k] = (Lookahead)p.clone();
        return p;
    }

    private Lookahead getAltLookahead(AlternativeBlock blk, int alt, int k) {
        Lookahead p;
        Alternative a = blk.getAlternativeAt(alt);
        AlternativeElement e = a.head;
        if (a.cache[k] == null) {
            a.cache[k] = p = e.look(k);
        } else {
            p = a.cache[k];
        }
        return p;
    }

    public Lookahead look(int k, ActionElement action) {
        if (this.DEBUG_ANALYZER) {
            System.out.println("lookAction(" + k + "," + action + ")");
        }
        return action.next.look(k);
    }

    public Lookahead look(int k, AlternativeBlock blk) {
        if (this.DEBUG_ANALYZER) {
            System.out.println("lookAltBlk(" + k + "," + blk + ")");
        }
        AlternativeBlock saveCurrentBlock = this.currentBlock;
        this.currentBlock = blk;
        Lookahead p = new Lookahead();
        for (int i = 0; i < blk.alternatives.size(); ++i) {
            if (this.DEBUG_ANALYZER) {
                System.out.println("alt " + i + " of " + blk);
            }
            this.currentBlock.analysisAlt = i;
            Alternative alt = blk.getAlternativeAt(i);
            AlternativeElement elem = alt.head;
            if (this.DEBUG_ANALYZER && alt.head == alt.tail) {
                System.out.println("alt " + i + " is empty");
            }
            Lookahead q = elem.look(k);
            p.combineWith(q);
        }
        if (k == 1 && blk.not && this.subruleCanBeInverted(blk, this.lexicalAnalysis)) {
            if (this.lexicalAnalysis) {
                BitSet b = (BitSet)((LexerGrammar)this.grammar).charVocabulary.clone();
                int[] elems = p.fset.toArray();
                for (int j = 0; j < elems.length; ++j) {
                    b.remove(elems[j]);
                }
                p.fset = b;
            } else {
                p.fset.notInPlace(4, this.grammar.tokenManager.maxTokenType());
            }
        }
        this.currentBlock = saveCurrentBlock;
        return p;
    }

    public Lookahead look(int k, BlockEndElement end) {
        Lookahead p;
        if (this.DEBUG_ANALYZER) {
            System.out.println("lookBlockEnd(" + k + ", " + end.block + "); lock is " + end.lock[k]);
        }
        if (end.lock[k]) {
            return new Lookahead();
        }
        if (end.block instanceof ZeroOrMoreBlock || end.block instanceof OneOrMoreBlock) {
            end.lock[k] = true;
            p = this.look(k, end.block);
            end.lock[k] = false;
        } else {
            p = new Lookahead();
        }
        if (end.block instanceof TreeElement) {
            p.combineWith(Lookahead.of(3));
        } else if (end.block instanceof SynPredBlock) {
            p.setEpsilon();
        } else {
            Lookahead q = end.block.next.look(k);
            p.combineWith(q);
        }
        return p;
    }

    public Lookahead look(int k, CharLiteralElement atom) {
        if (this.DEBUG_ANALYZER) {
            System.out.println("lookCharLiteral(" + k + "," + atom + ")");
        }
        if (k > 1) {
            return atom.next.look(k - 1);
        }
        if (this.lexicalAnalysis) {
            if (atom.not) {
                BitSet b = (BitSet)((LexerGrammar)this.grammar).charVocabulary.clone();
                if (this.DEBUG_ANALYZER) {
                    System.out.println("charVocab is " + b.toString());
                }
                this.removeCompetingPredictionSets(b, atom);
                if (this.DEBUG_ANALYZER) {
                    System.out.println("charVocab after removal of prior alt lookahead " + b.toString());
                }
                b.clear(atom.getType());
                return new Lookahead(b);
            }
            return Lookahead.of(atom.getType());
        }
        this.tool.panic("Character literal reference found in parser");
        return Lookahead.of(atom.getType());
    }

    public Lookahead look(int k, CharRangeElement r) {
        if (this.DEBUG_ANALYZER) {
            System.out.println("lookCharRange(" + k + "," + r + ")");
        }
        if (k > 1) {
            return r.next.look(k - 1);
        }
        BitSet p = BitSet.of(r.begin);
        for (int i = r.begin + '\u0001'; i <= r.end; ++i) {
            p.add(i);
        }
        return new Lookahead(p);
    }

    public Lookahead look(int k, GrammarAtom atom) {
        if (this.DEBUG_ANALYZER) {
            System.out.println("look(" + k + "," + atom + "[" + atom.getType() + "])");
        }
        if (this.lexicalAnalysis) {
            this.tool.panic("token reference found in lexer");
        }
        if (k > 1) {
            return atom.next.look(k - 1);
        }
        Lookahead l = Lookahead.of(atom.getType());
        if (atom.not) {
            int maxToken = this.grammar.tokenManager.maxTokenType();
            l.fset.notInPlace(4, maxToken);
            this.removeCompetingPredictionSets(l.fset, atom);
        }
        return l;
    }

    public Lookahead look(int k, OneOrMoreBlock blk) {
        if (this.DEBUG_ANALYZER) {
            System.out.println("look+" + k + "," + blk + ")");
        }
        Lookahead p = this.look(k, (AlternativeBlock)blk);
        return p;
    }

    public Lookahead look(int k, RuleBlock blk) {
        if (this.DEBUG_ANALYZER) {
            System.out.println("lookRuleBlk(" + k + "," + blk + ")");
        }
        Lookahead p = this.look(k, (AlternativeBlock)blk);
        return p;
    }

    public Lookahead look(int k, RuleEndElement end) {
        if (this.DEBUG_ANALYZER) {
            System.out.println("lookRuleBlockEnd(" + k + "); noFOLLOW=" + end.noFOLLOW + "; lock is " + end.lock[k]);
        }
        if (end.noFOLLOW) {
            Lookahead p = new Lookahead();
            p.setEpsilon();
            p.epsilonDepth = BitSet.of(k);
            return p;
        }
        Lookahead p = this.FOLLOW(k, end);
        return p;
    }

    public Lookahead look(int k, RuleRefElement rr) {
        RuleSymbol rs;
        if (this.DEBUG_ANALYZER) {
            System.out.println("lookRuleRef(" + k + "," + rr + ")");
        }
        if ((rs = (RuleSymbol)this.grammar.getSymbol(rr.targetRule)) == null || !rs.defined) {
            this.tool.error("no definition of rule " + rr.targetRule, this.grammar.getFilename(), rr.getLine(), rr.getColumn());
            return new Lookahead();
        }
        RuleBlock rb = rs.getBlock();
        RuleEndElement end = rb.endNode;
        boolean saveEnd = end.noFOLLOW;
        end.noFOLLOW = true;
        Lookahead p = this.look(k, rr.targetRule);
        if (this.DEBUG_ANALYZER) {
            System.out.println("back from rule ref to " + rr.targetRule);
        }
        end.noFOLLOW = saveEnd;
        if (p.cycle != null) {
            this.tool.error("infinite recursion to rule " + p.cycle + " from rule " + rr.enclosingRuleName, this.grammar.getFilename(), rr.getLine(), rr.getColumn());
        }
        if (p.containsEpsilon()) {
            if (this.DEBUG_ANALYZER) {
                System.out.println("rule ref to " + rr.targetRule + " has eps, depth: " + p.epsilonDepth);
            }
            p.resetEpsilon();
            int[] depths = p.epsilonDepth.toArray();
            p.epsilonDepth = null;
            for (int i = 0; i < depths.length; ++i) {
                int rk = k - (k - depths[i]);
                Lookahead q = rr.next.look(rk);
                p.combineWith(q);
            }
        }
        return p;
    }

    public Lookahead look(int k, StringLiteralElement atom) {
        if (this.DEBUG_ANALYZER) {
            System.out.println("lookStringLiteral(" + k + "," + atom + ")");
        }
        if (this.lexicalAnalysis) {
            if (k > atom.processedAtomText.length()) {
                return atom.next.look(k - atom.processedAtomText.length());
            }
            return Lookahead.of(atom.processedAtomText.charAt(k - 1));
        }
        if (k > 1) {
            return atom.next.look(k - 1);
        }
        Lookahead l = Lookahead.of(atom.getType());
        if (atom.not) {
            int maxToken = this.grammar.tokenManager.maxTokenType();
            l.fset.notInPlace(4, maxToken);
        }
        return l;
    }

    public Lookahead look(int k, SynPredBlock blk) {
        if (this.DEBUG_ANALYZER) {
            System.out.println("look=>(" + k + "," + blk + ")");
        }
        return blk.next.look(k);
    }

    public Lookahead look(int k, TokenRangeElement r) {
        if (this.DEBUG_ANALYZER) {
            System.out.println("lookTokenRange(" + k + "," + r + ")");
        }
        if (k > 1) {
            return r.next.look(k - 1);
        }
        BitSet p = BitSet.of(r.begin);
        for (int i = r.begin + 1; i <= r.end; ++i) {
            p.add(i);
        }
        return new Lookahead(p);
    }

    public Lookahead look(int k, TreeElement t) {
        if (this.DEBUG_ANALYZER) {
            System.out.println("look(" + k + "," + t.root + "[" + t.root.getType() + "])");
        }
        if (k > 1) {
            return t.next.look(k - 1);
        }
        Lookahead l = null;
        if (t.root instanceof WildcardElement) {
            l = t.root.look(1);
        } else {
            l = Lookahead.of(t.root.getType());
            if (t.root.not) {
                int maxToken = this.grammar.tokenManager.maxTokenType();
                l.fset.notInPlace(4, maxToken);
            }
        }
        return l;
    }

    public Lookahead look(int k, WildcardElement wc) {
        BitSet b;
        if (this.DEBUG_ANALYZER) {
            System.out.println("look(" + k + "," + wc + ")");
        }
        if (k > 1) {
            return wc.next.look(k - 1);
        }
        if (this.lexicalAnalysis) {
            b = (BitSet)((LexerGrammar)this.grammar).charVocabulary.clone();
        } else {
            b = new BitSet(1);
            int maxToken = this.grammar.tokenManager.maxTokenType();
            b.notInPlace(4, maxToken);
            if (this.DEBUG_ANALYZER) {
                System.out.println("look(" + k + "," + wc + ") after not: " + b);
            }
        }
        return new Lookahead(b);
    }

    public Lookahead look(int k, ZeroOrMoreBlock blk) {
        if (this.DEBUG_ANALYZER) {
            System.out.println("look*(" + k + "," + blk + ")");
        }
        Lookahead p = this.look(k, (AlternativeBlock)blk);
        Lookahead q = blk.next.look(k);
        p.combineWith(q);
        return p;
    }

    public Lookahead look(int k, String rule) {
        if (this.DEBUG_ANALYZER) {
            System.out.println("lookRuleName(" + k + "," + rule + ")");
        }
        RuleSymbol rs = (RuleSymbol)this.grammar.getSymbol(rule);
        RuleBlock rb = rs.getBlock();
        if (rb.lock[k]) {
            if (this.DEBUG_ANALYZER) {
                System.out.println("infinite recursion to rule " + rb.getRuleName());
            }
            return new Lookahead(rule);
        }
        if (rb.cache[k] != null) {
            if (this.DEBUG_ANALYZER) {
                System.out.println("found depth " + k + " result in FIRST " + rule + " cache: " + rb.cache[k].toString(",", this.charFormatter, this.grammar));
            }
            return (Lookahead)rb.cache[k].clone();
        }
        rb.lock[k] = true;
        Lookahead p = this.look(k, rb);
        rb.lock[k] = false;
        rb.cache[k] = (Lookahead)p.clone();
        if (this.DEBUG_ANALYZER) {
            System.out.println("saving depth " + k + " result in FIRST " + rule + " cache: " + rb.cache[k].toString(",", this.charFormatter, this.grammar));
        }
        return p;
    }

    public static boolean lookaheadEquivForApproxAndFullAnalysis(Lookahead[] bset, int k) {
        for (int i = 1; i <= k - 1; ++i) {
            BitSet look = bset[i].fset;
            if (look.degree() <= 1) continue;
            return false;
        }
        return true;
    }

    private void removeCompetingPredictionSets(BitSet b, AlternativeElement el) {
        AlternativeElement head = this.currentBlock.getAlternativeAt((int)this.currentBlock.analysisAlt).head;
        if (head instanceof TreeElement ? ((TreeElement)head).root != el : el != head) {
            return;
        }
        for (int i = 0; i < this.currentBlock.analysisAlt; ++i) {
            AlternativeElement e = this.currentBlock.getAlternativeAt((int)i).head;
            b.subtractInPlace(e.look((int)1).fset);
        }
    }

    private void removeCompetingPredictionSetsFromWildcard(Lookahead[] look, AlternativeElement el, int k) {
        for (int d = 1; d <= k; ++d) {
            for (int i = 0; i < this.currentBlock.analysisAlt; ++i) {
                AlternativeElement e = this.currentBlock.getAlternativeAt((int)i).head;
                look[d].fset.subtractInPlace(e.look((int)d).fset);
            }
        }
    }

    private void reset() {
        this.grammar = null;
        this.DEBUG_ANALYZER = false;
        this.currentBlock = null;
        this.lexicalAnalysis = false;
    }

    public void setGrammar(Grammar g) {
        if (this.grammar != null) {
            this.reset();
        }
        this.grammar = g;
        this.lexicalAnalysis = this.grammar instanceof LexerGrammar;
        this.DEBUG_ANALYZER = this.grammar.analyzerDebug;
    }

    public boolean subruleCanBeInverted(AlternativeBlock blk, boolean forLexer) {
        if (blk instanceof ZeroOrMoreBlock || blk instanceof OneOrMoreBlock || blk instanceof SynPredBlock) {
            return false;
        }
        if (blk.alternatives.size() == 0) {
            return false;
        }
        for (int i = 0; i < blk.alternatives.size(); ++i) {
            Alternative alt = blk.getAlternativeAt(i);
            if (alt.synPred != null || alt.semPred != null || alt.exceptionSpec != null) {
                return false;
            }
            AlternativeElement elt = alt.head;
            if ((elt instanceof CharLiteralElement || elt instanceof TokenRefElement || elt instanceof CharRangeElement || elt instanceof TokenRangeElement || elt instanceof StringLiteralElement && !forLexer) && elt.next instanceof BlockEndElement && elt.getAutoGenType() == 1) continue;
            return false;
        }
        return true;
    }
}

