/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.querykeys;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.security.PrivilegedAccessHelper;
import oracle.toplink.essentials.internal.security.PrivilegedClassForName;
import oracle.toplink.essentials.querykeys.QueryKey;

public class ForeignReferenceQueryKey
extends QueryKey {
    protected Class referenceClass;
    protected String referenceClassName;
    protected Expression joinCriteria;

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        Class referenceClass = null;
        try {
            if (this.referenceClassName != null) {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        referenceClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.referenceClassName, true, classLoader));
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.referenceClassName, exception.getException());
                    }
                } else {
                    referenceClass = PrivilegedAccessHelper.getClassForName(this.referenceClassName, true, classLoader);
                }
            }
            this.setReferenceClass(referenceClass);
        }
        catch (ClassNotFoundException exc) {
            throw ValidationException.classNotFoundWhileConvertingClassNames(this.referenceClassName, exc);
        }
    }

    public Expression getJoinCriteria() {
        return this.joinCriteria;
    }

    public Class getReferenceClass() {
        return this.referenceClass;
    }

    public String getReferenceClassName() {
        if (this.referenceClassName == null && this.referenceClass != null) {
            this.referenceClassName = this.referenceClass.getName();
        }
        return this.referenceClassName;
    }

    public boolean isForeignReferenceQueryKey() {
        return true;
    }

    public void setJoinCriteria(Expression joinCriteria) {
        this.joinCriteria = joinCriteria;
    }

    public void setReferenceClass(Class referenceClass) {
        this.referenceClass = referenceClass;
    }

    public void setReferenceClassName(String referenceClassName) {
        this.referenceClassName = referenceClassName;
    }
}

