/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jrubyparser.ast.AliasNode;
import org.jrubyparser.ast.ArgsNode;
import org.jrubyparser.ast.ArgumentNode;
import org.jrubyparser.ast.AssignableNode;
import org.jrubyparser.ast.DAsgnNode;
import org.jrubyparser.ast.DVarNode;
import org.jrubyparser.ast.ForNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.LocalAsgnNode;
import org.jrubyparser.ast.LocalVarNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.SemanticAnalyzer;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyParseResult;
import org.netbeans.modules.ruby.lexer.LexUtilities;

public class RubySemanticAnalyzer
extends SemanticAnalyzer {
    private boolean cancelled;
    private Map<OffsetRange, Set<ColoringAttributes>> semanticHighlights;
    private static final Set<String> JAVA_PREFIXES = new HashSet<String>();
    private static final Set<String> SKIP_HIGHLIGHTNING = new HashSet<String>();

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights() {
        return this.semanticHighlights;
    }

    protected final synchronized boolean isCancelled() {
        return this.cancelled;
    }

    protected final synchronized void resume() {
        this.cancelled = false;
    }

    public final synchronized void cancel() {
        this.cancelled = true;
    }

    public int getPriority() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void run(Parser.Result info, SchedulerEvent event) {
        this.resume();
        if (this.isCancelled()) {
            return;
        }
        RubyParseResult rpr = AstUtilities.getParseResult(info);
        if (rpr == null) {
            return;
        }
        Node root = rpr.getRootNode();
        if (root == null) {
            return;
        }
        HashMap<OffsetRange, Set<Object>> highlights = new HashMap<OffsetRange, Set<ColoringAttributes>>(100);
        AstPath path = new AstPath();
        path.descend(root);
        this.annotate(root, highlights, path, null, false);
        path.ascend();
        if (this.isCancelled()) {
            return;
        }
        if (highlights.size() > 0) {
            HashMap translated = new HashMap(2 * highlights.size());
            for (Map.Entry entry : highlights.entrySet()) {
                OffsetRange range = LexUtilities.getLexerOffsets(info, (OffsetRange)entry.getKey());
                if (range == OffsetRange.NONE) continue;
                translated.put(range, entry.getValue());
            }
            highlights = translated;
            this.semanticHighlights = highlights;
        } else {
            this.semanticHighlights = null;
        }
    }

    private void annotate(Node node, Map<OffsetRange, Set<ColoringAttributes>> highlights, AstPath path, List<String> parameters, boolean isParameter) {
        switch (node.getNodeType()) {
            case ARGSNODE: {
                isParameter = true;
                break;
            }
            case LOCALASGNNODE: {
                String name;
                OffsetRange range;
                LocalAsgnNode lasgn = (LocalAsgnNode)node;
                Node method = AstUtilities.findLocalScope(node, path);
                boolean isUsed = this.isUsedInMethod(method, lasgn.getName(), isParameter);
                if (!isUsed) {
                    range = AstUtilities.getLValueRange((AssignableNode)lasgn);
                    highlights.put(range, ColoringAttributes.UNUSED_SET);
                    break;
                }
                if (parameters == null || !parameters.contains(name = ((LocalAsgnNode)node).getName())) break;
                OffsetRange range2 = AstUtilities.getNameRange(node);
                highlights.put(range2, ColoringAttributes.PARAMETER_SET);
                break;
            }
            case DASGNNODE: {
                DAsgnNode dasgn = (DAsgnNode)node;
                Node method = AstUtilities.findLocalScope(node, path);
                boolean isUsed = this.isUsedInMethod(method, dasgn.getName(), false);
                if (isUsed) break;
                OffsetRange range = AstUtilities.getLValueRange((AssignableNode)dasgn);
                highlights.put(range, ColoringAttributes.UNUSED_SET);
                break;
            }
            case DEFNNODE: 
            case DEFSNODE: {
                MethodDefNode def = (MethodDefNode)node;
                parameters = AstUtilities.getDefArgs(def, true);
                if (parameters != null && parameters.size() > 0) {
                    ArrayList<String> unused = new ArrayList<String>();
                    for (String parameter : parameters) {
                        boolean isUsed = this.isUsedInMethod(node, parameter, true);
                        if (isUsed) continue;
                        unused.add(parameter);
                    }
                    if (unused.size() > 0) {
                        this.annotateUnusedParameters(def, highlights, unused);
                        parameters.removeAll(unused);
                    }
                    if (parameters != null) {
                        if (parameters.size() == 0) {
                            parameters = null;
                        } else {
                            this.annotateParameters(def, highlights, parameters);
                        }
                    }
                }
                if (SKIP_HIGHLIGHTNING.contains(AstUtilities.getName(node))) break;
                this.highlightMethodName(node, highlights);
                break;
            }
            case LOCALVARNODE: {
                if (parameters == null || !parameters.contains(((LocalVarNode)node).getName())) break;
                OffsetRange range = AstUtilities.getRange(node);
                highlights.put(range, ColoringAttributes.PARAMETER_SET);
                break;
            }
            case VCALLNODE: {
                if (JAVA_PREFIXES.contains(((INameNode)node).getName())) break;
            }
            case FCALLNODE: {
                OffsetRange range = AstUtilities.getCallRange(node);
                if (SKIP_HIGHLIGHTNING.contains(AstUtilities.getName(node))) break;
                highlights.put(range, ColoringAttributes.METHOD_SET);
                break;
            }
        }
        List list = node.childNodes();
        for (Node child : list) {
            if (child.isInvisible()) continue;
            path.descend(child);
            this.annotate(child, highlights, path, parameters, isParameter);
            path.ascend();
        }
    }

    private void annotateParameters(MethodDefNode node, Map<OffsetRange, Set<ColoringAttributes>> highlights, List<String> usedParameterNames) {
        List nodes = node.childNodes();
        for (Node c : nodes) {
            OffsetRange range;
            ArgumentNode bn;
            if (c.getNodeType() != NodeType.ARGSNODE) continue;
            ArgsNode an = (ArgsNode)c;
            if (an.getRequiredCount() > 0) {
                List args = an.childNodes();
                for (Node arg : args) {
                    if (!(arg instanceof ListNode)) continue;
                    List args2 = arg.childNodes();
                    for (Node arg2 : args2) {
                        OffsetRange range2;
                        if (arg2.getNodeType() == NodeType.ARGUMENTNODE) {
                            if (!usedParameterNames.contains(((ArgumentNode)arg2).getName())) continue;
                            range2 = AstUtilities.getRange(arg2);
                            highlights.put(range2, ColoringAttributes.PARAMETER_SET);
                            continue;
                        }
                        if (arg2.getNodeType() != NodeType.LOCALASGNNODE || !usedParameterNames.contains(((LocalAsgnNode)arg2).getName())) continue;
                        range2 = AstUtilities.getNameRange(arg2);
                        highlights.put(range2, ColoringAttributes.PARAMETER_SET);
                    }
                }
            }
            if (an.getRest() != null && usedParameterNames.contains((bn = an.getRest()).getName())) {
                range = AstUtilities.getRange((Node)bn);
                highlights.put(range, ColoringAttributes.PARAMETER_SET);
            }
            if (an.getRest() != null && usedParameterNames.contains((bn = an.getRest()).getName())) {
                range = AstUtilities.getRange((Node)bn);
                highlights.put(range, ColoringAttributes.PARAMETER_SET);
            }
            if (an.getBlock() == null || !usedParameterNames.contains((bn = an.getBlock()).getName())) continue;
            range = AstUtilities.getRange((Node)bn);
            highlights.put(range, ColoringAttributes.PARAMETER_SET);
        }
    }

    private void annotateUnusedParameters(MethodDefNode node, Map<OffsetRange, Set<ColoringAttributes>> highlights, List<String> names) {
        List nodes = node.childNodes();
        for (Node c : nodes) {
            OffsetRange range;
            ArgumentNode bn;
            if (c.getNodeType() != NodeType.ARGSNODE) continue;
            ArgsNode an = (ArgsNode)c;
            if (an.getRequiredCount() > 0) {
                List args = an.childNodes();
                for (Node arg : args) {
                    if (!(arg instanceof ListNode)) continue;
                    List args2 = arg.childNodes();
                    for (Node arg2 : args2) {
                        OffsetRange range2;
                        if (arg2.getNodeType() == NodeType.ARGUMENTNODE) {
                            if (!names.contains(((ArgumentNode)arg2).getName())) continue;
                            range2 = AstUtilities.getRange(arg2);
                            highlights.put(range2, ColoringAttributes.UNUSED_SET);
                            continue;
                        }
                        if (arg2.getNodeType() != NodeType.LOCALASGNNODE || !names.contains(((LocalAsgnNode)arg2).getName())) continue;
                        range2 = AstUtilities.getNameRange(arg2);
                        highlights.put(range2, ColoringAttributes.UNUSED_SET);
                    }
                }
            }
            if (an.getRest() != null && names.contains((bn = an.getRest()).getName())) {
                range = AstUtilities.getRange((Node)bn);
                highlights.put(range, ColoringAttributes.UNUSED_SET);
            }
            if (an.getBlock() == null || !names.contains((bn = an.getBlock()).getName())) continue;
            range = AstUtilities.getRange((Node)bn);
            highlights.put(range, ColoringAttributes.UNUSED_SET);
        }
    }

    private boolean isUsedInMethod(Node node, String targetName, boolean isParameter) {
        switch (node.getNodeType()) {
            case LOCALVARNODE: {
                String name;
                if (node.getNodeType() != NodeType.LOCALVARNODE || !targetName.equals(name = ((LocalVarNode)node).getName())) break;
                return true;
            }
            case FORNODE: {
                Node iterNode = ((ForNode)node).getIterNode();
                if (!(iterNode instanceof INameNode) || !targetName.equals(((INameNode)iterNode).getName())) break;
                return true;
            }
            case DVARNODE: {
                if (!targetName.equals(((DVarNode)node).getName())) break;
                return true;
            }
            case ALIASNODE: {
                AliasNode an = (AliasNode)node;
                if (!targetName.equals(AstUtilities.getNameOrValue(an.getOldName()))) break;
                return true;
            }
            case ZSUPERNODE: {
                if (!isParameter) break;
                return true;
            }
        }
        List list = node.childNodes();
        for (Node child : list) {
            boolean used;
            if (child.isInvisible() || child.getNodeType() == NodeType.DEFSNODE || child.getNodeType() == NodeType.DEFNNODE || !(used = this.isUsedInMethod(child, targetName, isParameter))) continue;
            return true;
        }
        return false;
    }

    private void highlightMethodName(Node node, Map<OffsetRange, Set<ColoringAttributes>> highlights) {
        OffsetRange range = AstUtilities.getFunctionNameRange(node);
        if (range != OffsetRange.NONE && !highlights.containsKey(range)) {
            highlights.put(range, ColoringAttributes.METHOD_SET);
        }
    }

    static {
        JAVA_PREFIXES.add("java");
        JAVA_PREFIXES.add("javax");
        JAVA_PREFIXES.add("org");
        JAVA_PREFIXES.add("com");
        SKIP_HIGHLIGHTNING.add("[]");
    }
}

