/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.List;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.ruby.CompletionRequest;
import org.netbeans.modules.ruby.RubyBaseCompleter;
import org.netbeans.modules.ruby.RubyCodeCompleter;
import org.netbeans.modules.ruby.RubyCompletionItem;
import org.netbeans.modules.ruby.RubyPredefinedVariable;
import org.netbeans.modules.ruby.RubyUtils;

final class RubyKeywordCompleter
extends RubyBaseCompleter {
    private final boolean isSymbol;

    static boolean complete(List<? super CompletionProposal> proposals, CompletionRequest request, int anchor, boolean caseSensitive, boolean isSymbol) {
        RubyKeywordCompleter rsc = new RubyKeywordCompleter(proposals, request, anchor, caseSensitive, isSymbol);
        return rsc.complete();
    }

    private RubyKeywordCompleter(List<? super CompletionProposal> proposals, CompletionRequest request, int anchor, boolean caseSensitive, boolean isSymbol) {
        super(proposals, request, anchor, caseSensitive);
        this.isSymbol = isSymbol;
    }

    private boolean complete() {
        RubyCompletionItem.KeywordItem item;
        String prefix = this.request.prefix;
        if (prefix.equals("$")) {
            for (RubyPredefinedVariable each : RubyPredefinedVariable.getPredefinedVariables()) {
                item = new RubyCompletionItem.KeywordItem(each.getName(), each.getDescription(), this.anchor, this.request);
                if (this.isSymbol) {
                    item.setSymbol(true);
                }
                this.propose((CompletionProposal)item);
            }
        }
        for (RubyPredefinedVariable each : RubyPredefinedVariable.getPredefinedClassVariables()) {
            if (!RubyCodeCompleter.startsWith(each.getName(), prefix, this.caseSensitive)) continue;
            item = new RubyCompletionItem.KeywordItem(each.getName(), null, this.anchor, this.request);
            if (this.isSymbol) {
                item.setSymbol(true);
            }
            this.propose((CompletionProposal)item);
        }
        for (String keyword : RubyUtils.RUBY_KEYWORDS) {
            if (!RubyCodeCompleter.startsWith(keyword, prefix, this.caseSensitive)) continue;
            RubyCompletionItem.KeywordItem item2 = new RubyCompletionItem.KeywordItem(keyword, null, this.anchor, this.request);
            if (this.isSymbol) {
                item2.setSymbol(true);
            }
            this.propose((CompletionProposal)item2);
        }
        return false;
    }
}

