/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.awt.event.ActionEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.netbeans.modules.ruby.options.CodeStyle;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class ReflowParagraphAction
extends BaseAction {
    public ReflowParagraphAction() {
        super("ruby-reflow-paragraph", 0);
    }

    public Class getShortDescriptionBundleClass() {
        return ReflowParagraphAction.class;
    }

    public void actionPerformed(ActionEvent evt, JTextComponent target) {
        if (target.getCaret() == null) {
            return;
        }
        FileObject fo = GsfUtilities.findFileObject((JTextComponent)target);
        if (fo != null) {
            int offset = target.getCaret().getDot();
            new ParagraphFormatter(false, target, null, -1).reflowParagraph(offset);
        }
    }

    public static void reflowEditedComment(JTextComponent target) {
        if (target.getCaret() == null) {
            return;
        }
        int offset = target.getCaret().getDot();
        new ParagraphFormatter(true, target, null, -1).reflowParagraph(offset);
    }

    public static void reflowComments(BaseDocument doc, int start, int end, int rightMargin) {
        ParagraphFormatter formatter = new ParagraphFormatter(false, null, doc, rightMargin);
        formatter.reflow(start, end);
    }

    private static class ParagraphFormatter {
        private JTextComponent target;
        private BaseDocument doc;
        private int oldCaretPosition = -1;
        private boolean inVerbatim;
        private boolean indentedList;
        private boolean inList;
        private int listIndentation;
        private boolean documentation;
        private final StringBuilder sb = new StringBuilder(500);
        private StringBuilder buffer = new StringBuilder();
        private int indent = 4;
        private int rightMargin;
        private boolean currentSectionOnly;
        private final char CARET_MARKER = (char)19914;

        ParagraphFormatter(boolean currentSectionOnly, JTextComponent target, BaseDocument doc, int rightMargin) {
            this.currentSectionOnly = currentSectionOnly;
            this.target = target;
            if (target != null) {
                this.doc = (BaseDocument)target.getDocument();
                this.oldCaretPosition = target.getCaret() != null ? Integer.valueOf(target.getCaret().getDot()) : null;
            } else {
                this.doc = doc;
            }
            this.rightMargin = rightMargin != -1 ? rightMargin : CodeStyle.get((Document)this.doc).getRightMargin();
        }

        private void reflow(int start, int end) {
            try {
                block2: while (end >= start) {
                    TokenSequence<? extends RubyTokenId> ts = LexUtilities.getRubyTokenSequence(this.doc, end);
                    if (ts == null) {
                        return;
                    }
                    ts.move(end);
                    int offset = end;
                    while (ts.movePrevious() && ts.offset() >= start) {
                        OffsetRange range;
                        offset = ts.offset();
                        Token token = ts.token();
                        if (token.id() != RubyTokenId.DOCUMENTATION && token.id() != RubyTokenId.LINE_COMMENT || (range = this.findParagraph(offset)) == OffsetRange.NONE) continue;
                        end = Utilities.getRowStart((BaseDocument)this.doc, (int)range.getStart()) - 1;
                        this.reflowParagraph(offset);
                        continue block2;
                    }
                    end = Utilities.getRowStart((BaseDocument)this.doc, (int)offset) - 1;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        private void reflowParagraph(int offset) {
            try {
                offset = Utilities.getRowFirstNonWhite((BaseDocument)this.doc, (int)offset);
                if (offset == -1) {
                    return;
                }
                Token<? extends RubyTokenId> token = LexUtilities.getToken(this.doc, offset);
                if (token == null) {
                    return;
                }
                if (token.id() == RubyTokenId.DOCUMENTATION) {
                    this.documentation = true;
                } else if (token.id() != RubyTokenId.LINE_COMMENT) {
                    return;
                }
                OffsetRange range = this.findParagraph(offset);
                if (range != OffsetRange.NONE) {
                    this.reflow(range);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        private OffsetRange findParagraph(int offset) {
            try {
                int start = Utilities.getRowStart((BaseDocument)this.doc, (int)offset);
                int end = Utilities.getRowEnd((BaseDocument)this.doc, (int)offset);
                while (offset >= 0) {
                    String line;
                    if (Utilities.isRowEmpty((BaseDocument)this.doc, (int)offset) || Utilities.isRowWhite((BaseDocument)this.doc, (int)offset)) {
                        if (this.currentSectionOnly || !this.documentation) break;
                        offset = Utilities.getRowStart((BaseDocument)this.doc, (int)offset) - 1;
                        continue;
                    }
                    int lineBegin = Utilities.getRowFirstNonWhite((BaseDocument)this.doc, (int)(offset = Utilities.getRowStart((BaseDocument)this.doc, (int)offset)));
                    Token<? extends RubyTokenId> token = LexUtilities.getToken(this.doc, lineBegin);
                    if (token == null) break;
                    if (token.id() == RubyTokenId.DOCUMENTATION) {
                        line = this.doc.getText(offset, Utilities.getRowEnd((BaseDocument)this.doc, (int)offset) - offset);
                        if (line.startsWith("=begin")) break;
                        start = offset;
                    } else {
                        if (token.id() != RubyTokenId.LINE_COMMENT) break;
                        start = offset;
                    }
                    if (this.currentSectionOnly && !this.documentation && ((line = this.doc.getText(lineBegin, Utilities.getRowEnd((BaseDocument)this.doc, (int)lineBegin) - lineBegin)).startsWith("#") && line.length() == 1 || line.equals("# ") || line.startsWith("# *") || line.startsWith("# - "))) break;
                    --offset;
                }
                int length = this.doc.getLength();
                offset = end;
                while (offset < length) {
                    String line;
                    if (Utilities.isRowEmpty((BaseDocument)this.doc, (int)offset) || Utilities.isRowWhite((BaseDocument)this.doc, (int)offset)) {
                        if (this.currentSectionOnly || !this.documentation) break;
                        offset = Utilities.getRowEnd((BaseDocument)this.doc, (int)offset) + 1;
                        continue;
                    }
                    offset = Utilities.getRowStart((BaseDocument)this.doc, (int)offset);
                    int lineBegin = Utilities.getRowFirstNonWhite((BaseDocument)this.doc, (int)offset);
                    int lineEnd = Utilities.getRowEnd((BaseDocument)this.doc, (int)offset);
                    Token<? extends RubyTokenId> token = LexUtilities.getToken(this.doc, lineBegin);
                    if (token == null) break;
                    if (token.id() == RubyTokenId.DOCUMENTATION) {
                        line = this.doc.getText(offset, lineEnd - offset);
                        if (line.startsWith("=end")) break;
                        end = lineEnd;
                    } else {
                        if (token.id() != RubyTokenId.LINE_COMMENT) break;
                        end = lineEnd;
                    }
                    if (this.currentSectionOnly && !this.documentation && ((line = this.doc.getText(lineBegin, lineEnd - lineBegin)).startsWith("#") && line.length() == 1 || line.equals("# ") || line.startsWith("# *") || line.startsWith("# - "))) break;
                    offset = lineEnd + 1;
                }
                return new OffsetRange(start, end);
            }
            catch (BadLocationException badLocationException) {
                return OffsetRange.NONE;
            }
        }

        private int findWordEnd(StringBuilder sb, int start) {
            int length = sb.length();
            for (int i = start; i < length; ++i) {
                char c = sb.charAt(i);
                if (!Character.isWhitespace(c)) continue;
                return i;
            }
            return sb.length();
        }

        private void reflow(OffsetRange range) throws BadLocationException {
            this.sb.setLength(0);
            final int start = range.getStart();
            final int end = range.getEnd();
            this.indent = GsfUtilities.getLineIndent((BaseDocument)this.doc, (int)start);
            int offset = start;
            boolean foundCaret = false;
            while (offset < end) {
                int lineBegin;
                int textBegin = this.documentation ? Utilities.getRowStart((BaseDocument)this.doc, (int)offset) : Utilities.getRowFirstNonWhite((BaseDocument)this.doc, (int)offset);
                int textEnd = Utilities.getRowLastNonWhite((BaseDocument)this.doc, (int)offset) + 1;
                int lineEnd = Utilities.getRowEnd((BaseDocument)this.doc, (int)offset);
                if (this.documentation) {
                    if (textEnd < textBegin) {
                        textEnd = lineEnd;
                    }
                    if (textBegin == -1 || textEnd == -1) {
                        int lineBegin2;
                        assert (this.documentation);
                        textBegin = lineBegin2 = Utilities.getRowStart((BaseDocument)this.doc, (int)offset);
                        textEnd = lineEnd;
                    }
                }
                String line = this.doc.getText(textBegin, textEnd - textBegin);
                if (!foundCaret && this.oldCaretPosition >= (lineBegin = Utilities.getRowStart((BaseDocument)this.doc, (int)offset)) && this.oldCaretPosition <= lineEnd) {
                    foundCaret = true;
                    if (this.oldCaretPosition > textEnd) {
                        line = this.doc.getText(textBegin, this.oldCaretPosition - textBegin);
                    }
                    if (this.oldCaretPosition < textBegin) {
                        line = line.startsWith("#") ? "#\u4dca" + line.substring(1) : '\u4dca' + line;
                    } else if (this.oldCaretPosition > textEnd) {
                        line = line + '\u4dca';
                    } else {
                        int split = this.oldCaretPosition - textBegin;
                        if (split < line.length()) {
                            String firstPart = line.substring(0, split);
                            String lastPart = line.substring(split);
                            line = lastPart.startsWith("#") && firstPart.trim().length() == 0 ? firstPart + lastPart.charAt(0) + '\u4dca' + lastPart.substring(1) : firstPart + '\u4dca' + lastPart;
                        } else {
                            line = line + '\u4dca';
                        }
                    }
                }
                this.appendLine(line);
                offset = lineEnd + 1;
            }
            this.flush();
            this.doc.runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        int index;
                        String replaceWith = ParagraphFormatter.this.sb.toString();
                        if (replaceWith.endsWith("\n")) {
                            replaceWith = replaceWith.substring(0, replaceWith.length() - 1);
                        }
                        if ((index = replaceWith.indexOf(19914)) != -1) {
                            replaceWith = replaceWith.substring(0, index) + replaceWith.substring(index + 1);
                        }
                        ParagraphFormatter.this.doc.replace(start, end - start, replaceWith, null);
                        if (index != -1 && ParagraphFormatter.this.target != null) {
                            ParagraphFormatter.this.target.getCaret().setDot(start + index);
                        }
                    }
                    catch (BadLocationException ble) {
                        Exceptions.printStackTrace((Throwable)ble);
                    }
                }
            });
        }

        public void appendLine(String text) {
            if (!this.documentation) {
                if (text.startsWith("# ")) {
                    text = text.substring(2);
                } else if (text.startsWith("#\u4dca ")) {
                    text = '\u4dca' + text.substring(3);
                } else if (text.equals("#")) {
                    text = "";
                } else if (text.length() == 2 && text.equals("#\u4dca")) {
                    text = "\u4dca";
                }
            }
            boolean isBlankLine = text.length() == 0;
            int caretIndex = text.indexOf(19914);
            if (caretIndex != -1 && text.substring(0, caretIndex).trim().length() == 0 && text.substring(caretIndex + 1).trim().length() == 0) {
                isBlankLine = true;
            }
            if (isBlankLine) {
                this.flush();
                this.finishSection();
                this.startComment();
                if (caretIndex != -1) {
                    this.sb.append('\u4dca');
                }
                this.sb.append("\n");
                return;
            }
            if (text.startsWith("* ") || text.startsWith("- ") || text.matches("^[0-9]+\\.\\s*( .*)?")) {
                this.flush();
                if (!this.inList) {
                    this.finishSection();
                    this.inList = true;
                }
                this.indentedList = false;
                this.appendFlowed(text.trim());
                this.appendFlowed(" ");
                this.listIndentation = 2;
                if (text.startsWith("* ") || text.startsWith("- ")) {
                    this.listIndentation = 1;
                    int i = 1;
                    while (i < text.length() && Character.isWhitespace(text.charAt(i))) {
                        ++i;
                        ++this.listIndentation;
                    }
                }
                return;
            }
            if (text.matches("^[\\S]+::\\s*( .*)?") || text.matches("^\\[[\\S]+\\]\\s*( .+)?")) {
                this.flush();
                if (!this.inList) {
                    this.finishSection();
                    this.inList = true;
                }
                this.indentedList = false;
                this.appendFlowed(text.trim());
                this.appendFlowed(" ");
                this.listIndentation = 2;
                if (!text.matches("^\\[[\\S]+\\] .+") && !text.matches("^[\\S]+:: .+")) {
                    this.flush();
                    this.indentedList = true;
                }
                return;
            }
            if (text.startsWith("Copyright")) {
                this.flush();
                this.startComment();
                this.finishSection();
                this.sb.append(text);
                this.sb.append("\n");
                return;
            }
            if (!this.inList && text.length() > 0 && Character.isWhitespace(text.charAt(0))) {
                this.flush();
                this.startComment();
                if (!this.inVerbatim) {
                    this.finishSection();
                    this.inVerbatim = true;
                }
                this.sb.append(text);
                this.sb.append("\n");
                return;
            }
            if (text.startsWith("=") || text.startsWith("#---") || text.startsWith("---")) {
                this.flush();
                this.finishSection();
                this.startComment();
                this.sb.append(text);
                this.sb.append("\n");
                return;
            }
            if (this.inVerbatim) {
                this.finishSection();
            }
            this.appendFlowed(text.trim());
            this.appendFlowed(" ");
        }

        private void startComment() {
            if (!this.documentation) {
                this.sb.append(IndentUtils.createIndentString((Document)this.doc, (int)this.indent));
                this.sb.append("# ");
            }
        }

        private void finishSection() {
            this.flush();
            if (this.inVerbatim) {
                this.flush();
                this.inVerbatim = false;
            }
            if (this.inList) {
                this.flush();
                this.indentedList = false;
                this.inList = false;
            }
        }

        private void appendFlowed(String text) {
            int ltIndex = text.indexOf(60);
            if (ltIndex != -1) {
                int brIndex = text.indexOf("<br>", ltIndex);
                if (brIndex == -1 && (brIndex = text.indexOf("<br/>", ltIndex)) == -1) {
                    brIndex = text.indexOf("<br />", ltIndex);
                }
                if (brIndex != -1) {
                    int brEnd = text.indexOf(62, brIndex) + 1;
                    String lineBegin = text.substring(0, brEnd);
                    String lineEnd = null;
                    if (brEnd < text.length() && (lineEnd = text.substring(brEnd).trim()).length() == 1 && lineEnd.charAt(0) == '\u4dca') {
                        lineBegin = lineBegin + '\u4dca';
                        lineEnd = null;
                    }
                    this.buffer.append(lineBegin);
                    this.flush();
                    if (lineEnd != null) {
                        this.appendFlowed(lineEnd);
                    }
                    return;
                }
            }
            this.buffer.append(text);
        }

        private void chompSpaces() {
            for (int i = this.sb.length() - 1; i >= 0; --i) {
                char c = this.sb.charAt(i);
                if (c == ' ') continue;
                this.sb.setLength(i + 1);
                break;
            }
        }

        private void flush() {
            char c;
            if (this.buffer.length() == 0) {
                return;
            }
            if (this.buffer.length() == 1 && this.buffer.charAt(0) == ' ') {
                return;
            }
            int column = 0;
            int offset = 0;
            int oldOffset = this.sb.length();
            this.startComment();
            if (this.inList && this.indentedList) {
                this.sb.append(IndentUtils.createIndentString((Document)this.doc, (int)this.listIndentation));
            }
            column += this.sb.length() - oldOffset;
            int maxWidth = this.rightMargin;
            while (offset < this.buffer.length() && Character.isWhitespace(c = this.buffer.charAt(offset))) {
                ++offset;
            }
            while (offset < this.buffer.length()) {
                char c2;
                int start = offset;
                int end = this.findWordEnd(this.buffer, start);
                int wordLength = end - start;
                if (column + wordLength > maxWidth && wordLength < maxWidth - this.indent) {
                    this.chompSpaces();
                    this.sb.append("\n");
                    oldOffset = this.sb.length();
                    this.startComment();
                    if (this.inList) {
                        this.sb.append(IndentUtils.createIndentString((Document)this.doc, (int)this.listIndentation));
                    }
                    column = this.sb.length() - oldOffset;
                }
                for (int i = start; i < end; ++i) {
                    char c3 = this.buffer.charAt(i);
                    if (c3 == '\u4dca') {
                        maxWidth = this.rightMargin + 1;
                    }
                    this.sb.append(c3);
                    ++column;
                }
                offset = end;
                this.sb.append(" ");
                ++column;
                ++offset;
                while (offset < this.buffer.length() && Character.isWhitespace(c2 = this.buffer.charAt(offset))) {
                    if (column < this.rightMargin) {
                        this.sb.append(c2);
                        ++column;
                    }
                    ++offset;
                }
            }
            this.chompSpaces();
            this.sb.append("\n");
            this.buffer.setLength(0);
        }
    }
}

