/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.util.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.UIManager;
import org.openide.util.NbBundle;

public final class DLightUIPrefs {
    public static final String INDICATOR_BORDER_COLOR = "indicator.border.color";
    public static final String INDICATOR_PADDING = "indicator.padding";
    public static final String INDICATOR_TITLE_FONT = "indicator.title.font";
    public static final String INDICATOR_TITLE_FONT_COLOR = "indicator.title.font.color";
    public static final String INDICATOR_GRAPH_WIDTH = "indicator.graph.width";
    public static final String INDICATOR_GRAPH_HEIGHT = "indicator.graph.height";
    public static final String INDICATOR_GRAPH_BGCOLOR_TOP = "indicator.graph.bgcolor_top";
    public static final String INDICATOR_GRAPH_BGCOLOR_BOTTOM = "indicator.graph.bgcolor_bottom";
    public static final String INDICATOR_GRAPH_FILTER_COLOR = "indicator.graph.filter.color";
    public static final String INDICATOR_LINE_THICKNESS = "indicator.line.thickness";
    public static final String INDICATOR_BALL_SIZE = "indicator.ball.size";
    public static final String INDICATOR_GRID_COLOR = "indicator.grid.color";
    public static final String INDICATOR_LEGEND_WIDTH = "indicator.legend.width";
    public static final String INDICATOR_LEGEND_HEIGHT = "indicator.legend.height";
    public static final String INDICATOR_LEGEND_BGCOLOR = "indicator.legend.bgcolor";
    public static final String INDICATOR_LEGEND_FONT = "indicator.legend.font";
    public static final String INDICATOR_LEGEND_FONT_COLOR = "indicator.legend.font.color";
    public static final String INDICATOR_X_AXIS_WIDTH = "indicator.x_axis.width";
    public static final String INDICATOR_X_AXIS_HEIGHT = "indicator.x_axis.height";
    public static final String INDICATOR_X_AXIS_FONT = "indicator.x_axis.font";
    public static final String INDICATOR_X_AXIS_FONT_COLOR = "indicator.x_axis.font_color";
    public static final String INDICATOR_Y_AXIS_WIDTH = "indicator.y_axis.width";
    public static final String INDICATOR_Y_AXIS_HEIGHT = "indicator.y_axis.height";
    public static final String INDICATOR_Y_AXIS_FONT = "indicator.y_axis.font";
    public static final String INDICATOR_Y_AXIS_FONT_COLOR = "indicator.y_axis.font_color";
    private final Map<String, Object> prefs = new HashMap<String, Object>();
    private static DLightUIPrefs instance;

    public static float getFloat(String key) {
        return DLightUIPrefs.getInstance()._getFloat(key);
    }

    public static int getInt(String key) {
        return DLightUIPrefs.getInstance()._getInt(key);
    }

    public static Color getColor(String key) {
        return DLightUIPrefs.getInstance()._getColor(key);
    }

    public static Font getFont(String key) {
        return DLightUIPrefs.getInstance()._getFont(key);
    }

    private DLightUIPrefs() {
        Font font = UIManager.getFont("Panel.font").deriveFont(10.0f);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        Color fontColor = new Color(49, 78, 114);
        int graphWidth = 20 + font.getSize() + fontMetrics.stringWidth(DLightUIPrefs.getMessage("indicator.legend.longest_text"));
        int graphHeight = 5 * fontMetrics.getHeight();
        this.prefs.put(INDICATOR_BORDER_COLOR, new Color(114, 138, 132));
        this.prefs.put(INDICATOR_PADDING, 12);
        this.prefs.put(INDICATOR_TITLE_FONT, UIManager.getFont("Label.font").deriveFont(1));
        this.prefs.put(INDICATOR_TITLE_FONT_COLOR, fontColor);
        this.prefs.put(INDICATOR_GRAPH_WIDTH, graphWidth);
        this.prefs.put(INDICATOR_GRAPH_HEIGHT, graphHeight);
        this.prefs.put(INDICATOR_GRAPH_BGCOLOR_TOP, Color.WHITE);
        this.prefs.put(INDICATOR_GRAPH_BGCOLOR_BOTTOM, new Color(214, 227, 243));
        this.prefs.put(INDICATOR_GRAPH_FILTER_COLOR, new Color(180, 180, 180, 128));
        this.prefs.put(INDICATOR_LINE_THICKNESS, Float.valueOf(2.0f));
        this.prefs.put(INDICATOR_BALL_SIZE, 5);
        this.prefs.put(INDICATOR_GRID_COLOR, new Color(215, 224, 227, 128));
        this.prefs.put(INDICATOR_LEGEND_WIDTH, graphWidth);
        this.prefs.put(INDICATOR_LEGEND_HEIGHT, graphHeight);
        this.prefs.put(INDICATOR_LEGEND_BGCOLOR, Color.WHITE);
        this.prefs.put(INDICATOR_LEGEND_FONT, font);
        this.prefs.put(INDICATOR_LEGEND_FONT_COLOR, fontColor);
        this.prefs.put(INDICATOR_X_AXIS_WIDTH, graphWidth);
        this.prefs.put(INDICATOR_X_AXIS_HEIGHT, 2 * font.getSize());
        this.prefs.put(INDICATOR_X_AXIS_FONT, font);
        this.prefs.put(INDICATOR_X_AXIS_FONT_COLOR, fontColor);
        this.prefs.put(INDICATOR_Y_AXIS_WIDTH, font.getSize() / 2 + fontMetrics.stringWidth(DLightUIPrefs.getMessage("indicator.y_axis.longest_text")));
        this.prefs.put(INDICATOR_Y_AXIS_HEIGHT, graphHeight);
        this.prefs.put(INDICATOR_Y_AXIS_FONT, font);
        this.prefs.put(INDICATOR_Y_AXIS_FONT_COLOR, fontColor);
    }

    private float _getFloat(String key) {
        Object value = this.prefs.get(key);
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        return 0.0f;
    }

    private int _getInt(String key) {
        Object value = this.prefs.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return 0;
    }

    private Color _getColor(String key) {
        Object value = this.prefs.get(key);
        if (value instanceof Color) {
            return (Color)value;
        }
        return null;
    }

    private Font _getFont(String key) {
        Object value = this.prefs.get(key);
        if (value instanceof Font) {
            return (Font)value;
        }
        return null;
    }

    private FontMetrics getFontMetrics(Font font) {
        BufferedImage img = new BufferedImage(10, 10, 6);
        return img.getGraphics().getFontMetrics(font);
    }

    private static synchronized DLightUIPrefs getInstance() {
        if (instance == null) {
            instance = new DLightUIPrefs();
        }
        return instance;
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(DLightUIPrefs.class, (String)key);
    }
}

