/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.microedition.m2g.SVGImage;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.CharSeq;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.editor.structure.api.DocumentModel;
import org.netbeans.modules.mobility.svgcore.composer.PerseusController;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.model.EncodingInputStream;
import org.netbeans.modules.mobility.svgcore.model.SVGFileModel;

public final class ElementMapping {
    private static final String ID_COUPLING_PREFIX = "_";
    private static final String ID_WRAPPER_PREFIX = "w_";
    private final SVGFileModel m_fileModel;
    private final Map<String, DocumentElement> m_ids = new HashMap<String, DocumentElement>();
    private boolean m_refreshNeeded = false;

    public ElementMapping(SVGFileModel fileModel) {
        this.m_fileModel = fileModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVGImage parseDocument(boolean update) throws BadLocationException, IOException, InterruptedException {
        StringBuilder sb;
        Object object = this.m_fileModel.getTransactionMonitor();
        synchronized (object) {
            if (update) {
                this.m_fileModel.updateModel();
            }
            DocumentModel docModel = this.m_fileModel.getModel();
            try {
                docModel.readLock();
                BaseDocument doc = (BaseDocument)docModel.getDocument();
                CharSeq charSeq = doc.getText();
                int docLength = charSeq.length();
                sb = new StringBuilder(docLength);
                for (int i = 0; i < docLength; ++i) {
                    sb.append(charSeq.charAt(i));
                }
                this.m_ids.clear();
                this.m_refreshNeeded = false;
                ArrayList<DocumentElement> elemsWithoutID = new ArrayList<DocumentElement>();
                this.collectAnonymousElements(docModel.getRootElement(), elemsWithoutID);
                int serial = 0;
                for (DocumentElement elem : elemsWithoutID) {
                    String id;
                    while (this.m_ids.containsKey(id = ID_COUPLING_PREFIX + serial++)) {
                    }
                    int startOffset = elem.getStartOffset();
                    String str = " id=\"" + id + "\" ";
                    sb.insert(startOffset += elem.getName().length() + 1, str);
                    ElementMapping.checkRemovedElement(elem);
                    if (this.m_ids.put(id, elem) == null) continue;
                    SceneManager.log(Level.SEVERE, "Duplicated id: " + id);
                }
            }
            finally {
                docModel.readUnlock();
            }
        }
        String encoding = this.m_fileModel.getDataObject().getEncodingHelper().getEncoding();
        EncodingInputStream in = new EncodingInputStream(sb, encoding);
        try {
            SVGImage svgImage;
            SVGImage sVGImage = svgImage = PerseusController.createImage(in);
            return sVGImage;
        }
        finally {
            in.close();
        }
    }

    public synchronized void add(DocumentElement newDe) {
        String id = SVGFileModel.getIdAttribute(newDe);
        if (SceneManager.isEnabled(Level.FINEST)) {
            SceneManager.log(Level.FINEST, "Adding mapping " + id + " <--> " + newDe);
        }
        ElementMapping.checkRemovedElement(newDe);
        if (id != null) {
            this.m_ids.put(id, newDe);
        } else {
            this.m_refreshNeeded = true;
        }
    }

    public synchronized void remove(DocumentElement oldDe) {
        String id = SVGFileModel.getIdAttribute(oldDe);
        if (id == null) {
            Iterator<DocumentElement> iter = this.m_ids.values().iterator();
            while (iter.hasNext()) {
                if (iter.next() != oldDe) continue;
                if (SceneManager.isEnabled(Level.FINEST)) {
                    SceneManager.log(Level.FINEST, "Removing mapping " + id + " <--> " + oldDe);
                }
                iter.remove();
                return;
            }
        } else {
            this.m_ids.remove(id);
        }
    }

    private void refresh() {
        try {
            SceneManager.log(Level.INFO, "Refreshing mapping");
            SVGImage img = this.parseDocument(false);
            this.m_fileModel.getDataObject().getSceneManager().setImage(img);
        }
        catch (Exception ex) {
            SceneManager.error("Mapping refresh failed", ex);
        }
    }

    synchronized DocumentElement id2element(String id) {
        DocumentElement elem;
        if (SceneManager.isEnabled(Level.FINER)) {
            SceneManager.log(Level.FINER, "Looking for element with id: " + id);
        }
        if ((elem = this.m_ids.get(id)) == null) {
            SceneManager.log(Level.FINER, "No element found.");
            if (this.m_refreshNeeded) {
                this.refresh();
                elem = this.m_ids.get(id);
            }
        }
        ElementMapping.checkRemovedElement(elem);
        if (SceneManager.isEnabled(Level.FINE)) {
            SceneManager.log(Level.FINE, "Mapping found: " + id + " -> " + elem);
        }
        return elem;
    }

    public synchronized String element2id(DocumentElement elem) {
        String id = null;
        for (Map.Entry<String, DocumentElement> e : this.m_ids.entrySet()) {
            if (e.getValue() != elem) continue;
            id = e.getKey();
            break;
        }
        if (SceneManager.isEnabled(Level.FINE)) {
            SceneManager.log(Level.FINE, "Mapping found: " + elem + " -> " + id);
        }
        return id;
    }

    synchronized String generateId(String prefix, boolean isWrapper, Set<String> extIds) {
        String id;
        int serial = 0;
        if (isWrapper) {
            prefix = ID_WRAPPER_PREFIX + prefix;
        }
        while (this.m_ids.containsKey(id = prefix + ID_COUPLING_PREFIX + serial++) || extIds != null && extIds.contains(id)) {
        }
        return id;
    }

    static boolean isWrapperId(String id) {
        return id != null && id.startsWith(ID_WRAPPER_PREFIX);
    }

    protected static void checkRemovedElement(DocumentElement de) {
        assert (de == null || de.getStartOffset() < de.getEndOffset()) : "Deleted element found: " + de;
    }

    synchronized void collectConflictingElements(DocumentElement elem, List<String> conflicts, Set<String> newIds) {
        String id;
        assert (elem != null);
        List children = elem.getChildren();
        for (int i = children.size() - 1; i >= 0; --i) {
            DocumentElement de = (DocumentElement)children.get(i);
            if (!SVGFileModel.isTagElement(de)) continue;
            this.collectConflictingElements(de, conflicts, newIds);
        }
        if (!"ROOT_ELEMENT".equals(elem.getType()) && (id = SVGFileModel.getIdAttribute(elem)) != null) {
            if (this.m_ids.containsKey(id)) {
                conflicts.add(id);
            } else {
                newIds.add(id);
            }
        }
    }

    protected void collectAnonymousElements(DocumentElement elem, List<DocumentElement> elems) {
        assert (elem != null);
        assert (elem.getDocumentModel() == this.m_fileModel.getModel()) : "Element " + elem + " has incorrect model " + elem.getDocumentModel();
        List children = elem.getChildren();
        for (int i = children.size() - 1; i >= 0; --i) {
            DocumentElement de = (DocumentElement)children.get(i);
            if (!SVGFileModel.isTagElement(de)) continue;
            if (de.getStartOffset() < de.getEndOffset()) {
                this.collectAnonymousElements(de, elems);
                continue;
            }
            SceneManager.log(Level.SEVERE, "Deleted element found in the model: " + de);
        }
        if (!"ROOT_ELEMENT".equals(elem.getType())) {
            String id = SVGFileModel.getIdAttribute(elem);
            if (id != null) {
                ElementMapping.checkRemovedElement(elem);
                if (this.m_ids.put(id, elem) != null) {
                    SceneManager.log(Level.SEVERE, "Duplicated id: " + id);
                }
            } else {
                elems.add(elem);
            }
        }
    }
}

