/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.export;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.WritableRaster;

public final class Quantizer {
    private static final int MAXCOLORS = 255;
    private static final int TRANSPARENT_COLOR = 255;
    private static final int HSIZE = 32768;
    private final int[] m_pixels32;
    private final int m_width;
    private final int m_height;
    private final int[] m_hist;
    private int[] m_histPtr;
    private ColorCube[] m_list;
    private IndexColorModel m_cm;

    public Quantizer(int[] pixels, int width, int height) {
        this.m_pixels32 = pixels;
        this.m_width = width;
        this.m_height = height;
        this.m_hist = new int[32768];
        for (int i = 0; i < width * height; ++i) {
            int n = this.rgb(this.m_pixels32[i]);
            this.m_hist[n] = this.m_hist[n] + 1;
        }
    }

    public int getColorCount() {
        int count = 0;
        for (int i = 0; i < 32768; ++i) {
            if (this.m_hist[i] <= 0) continue;
            ++count;
        }
        return count;
    }

    public Color getModalColor() {
        int max = 0;
        int c = 0;
        for (int i = 0; i < 32768; ++i) {
            if (this.m_hist[i] <= max) continue;
            max = this.m_hist[i];
            c = i;
        }
        return new Color(this.red(c), this.green(c), this.blue(c));
    }

    public BufferedImage toImage() {
        int i;
        int longdim = 0;
        this.m_list = new ColorCube[255];
        this.m_histPtr = new int[32768];
        int ncubes = 0;
        ColorCube cube = new ColorCube();
        int color = 0;
        for (i = 0; i <= Short.MAX_VALUE; ++i) {
            if (this.m_hist[i] == 0) continue;
            this.m_histPtr[color++] = i;
            cube.count = cube.count + this.m_hist[i];
        }
        cube.lower = 0;
        cube.upper = color - 1;
        cube.level = 0;
        this.reduce(cube);
        this.m_list[ncubes++] = cube;
        while (ncubes < 255) {
            int level = 255;
            int splitpos = -1;
            for (int k = 0; k <= ncubes - 1; ++k) {
                if (this.m_list[k].lower == this.m_list[k].upper || this.m_list[k].level >= level) continue;
                level = this.m_list[k].level;
                splitpos = k;
            }
            if (splitpos == -1) break;
            cube = this.m_list[splitpos];
            int lr = cube.rmax - cube.rmin;
            int lg = cube.gmax - cube.gmin;
            int lb = cube.bmax - cube.bmin;
            if (lr >= lg && lr >= lb) {
                longdim = 0;
            }
            if (lg >= lr && lg >= lb) {
                longdim = 1;
            }
            if (lb >= lr && lb >= lg) {
                longdim = 2;
            }
            this.changeColorOrder(this.m_histPtr, cube.lower, cube.upper, longdim);
            this.quickSort(this.m_histPtr, cube.lower, cube.upper);
            this.resetColorOrder(this.m_histPtr, cube.lower, cube.upper, longdim);
            int count = 0;
            for (i = cube.lower; i <= cube.upper - 1 && count < cube.count / 2; count += this.m_hist[color], ++i) {
                color = this.m_histPtr[i];
            }
            int median = i;
            ColorCube cubeA = new ColorCube();
            cubeA.lower = cube.lower;
            cubeA.upper = median - 1;
            cubeA.count = count;
            cubeA.level = cube.level + 1;
            this.reduce(cubeA);
            this.m_list[splitpos] = cubeA;
            ColorCube cubeB = new ColorCube();
            cubeB.lower = median;
            cubeB.upper = cube.upper;
            cubeB.count = cube.count - count;
            cubeB.level = cube.level + 1;
            this.reduce(cubeB);
            this.m_list[ncubes++] = cubeB;
        }
        this.invertMap(this.m_hist, ncubes);
        return this.makeBufferedImage();
    }

    private void reduce(ColorCube cube) {
        int rmin = 255;
        int rmax = 0;
        int gmin = 255;
        int gmax = 0;
        int bmin = 255;
        int bmax = 0;
        for (int i = cube.lower; i <= cube.upper; ++i) {
            int color = this.m_histPtr[i];
            int r = this.red(color);
            int g = this.green(color);
            int b = this.blue(color);
            if (r > rmax) {
                rmax = r;
            }
            if (r < rmin) {
                rmin = r;
            }
            if (g > gmax) {
                gmax = g;
            }
            if (g < gmin) {
                gmin = g;
            }
            if (b > bmax) {
                bmax = b;
            }
            if (b >= bmin) continue;
            bmin = b;
        }
        cube.rmin = rmin;
        cube.rmax = rmax;
        cube.gmin = gmin;
        cube.gmax = gmax;
        cube.gmin = gmin;
        cube.gmax = gmax;
    }

    private void invertMap(int[] hist, int ncubes) {
        int color;
        int i;
        ColorCube cube;
        int k;
        byte[] rLUT = new byte[256];
        byte[] gLUT = new byte[256];
        byte[] bLUT = new byte[256];
        for (k = 0; k <= ncubes - 1; ++k) {
            int b;
            int g;
            int r;
            cube = this.m_list[k];
            float bsum = 0.0f;
            float gsum = 0.0f;
            float rsum = 0.0f;
            for (i = cube.lower; i <= cube.upper; ++i) {
                color = this.m_histPtr[i];
                r = this.red(color);
                rsum += (float)r * (float)hist[color];
                g = this.green(color);
                gsum += (float)g * (float)hist[color];
                b = this.blue(color);
                bsum += (float)b * (float)hist[color];
            }
            r = (int)(rsum / (float)cube.count);
            g = (int)(gsum / (float)cube.count);
            b = (int)(bsum / (float)cube.count);
            if (r == 248 && g == 248 && b == 248) {
                b = 255;
                g = 255;
                r = 255;
            }
            rLUT[k] = (byte)r;
            gLUT[k] = (byte)g;
            bLUT[k] = (byte)b;
        }
        this.m_cm = new IndexColorModel(8, 256, rLUT, gLUT, bLUT, 255);
        for (k = 0; k <= ncubes - 1; ++k) {
            cube = this.m_list[k];
            for (i = cube.lower; i <= cube.upper; ++i) {
                color = this.m_histPtr[i];
                hist[color] = k;
            }
        }
    }

    private void changeColorOrder(int[] a, int lo, int hi, int longDim) {
        switch (longDim) {
            case 0: {
                for (int i = lo; i <= hi; ++i) {
                    int c = a[i];
                    int r = c & 0x1F;
                    a[i] = r << 10 | c >> 5;
                }
                break;
            }
            case 1: {
                for (int i = lo; i <= hi; ++i) {
                    int c = a[i];
                    int r = c & 0x1F;
                    int g = c >> 5 & 0x1F;
                    int b = c >> 10;
                    a[i] = g << 10 | b << 5 | r;
                }
                break;
            }
        }
    }

    void resetColorOrder(int[] a, int lo, int hi, int longDim) {
        switch (longDim) {
            case 0: {
                for (int i = lo; i <= hi; ++i) {
                    int c = a[i];
                    int r = c >> 10;
                    a[i] = (c & 0x3FF) << 5 | r;
                }
                break;
            }
            case 1: {
                for (int i = lo; i <= hi; ++i) {
                    int c = a[i];
                    int r = c & 0x1F;
                    int g = c >> 10;
                    int b = c >> 5 & 0x1F;
                    a[i] = b << 10 | g << 5 | r;
                }
                break;
            }
        }
    }

    void quickSort(int[] a, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            int mid = a[(lo0 + hi0) / 2];
            while (lo <= hi) {
                while (lo < hi0 && a[lo] < mid) {
                    ++lo;
                }
                while (hi > lo0 && a[hi] > mid) {
                    --hi;
                }
                if (lo > hi) continue;
                int t = a[lo];
                a[lo] = a[hi];
                a[hi] = t;
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                this.quickSort(a, lo0, hi);
            }
            if (lo < hi0) {
                this.quickSort(a, lo, hi0);
            }
        }
    }

    byte[] toByteArray() {
        byte[] pixels8 = new byte[this.m_width * this.m_height];
        for (int i = 0; i < this.m_width * this.m_height; ++i) {
            int color16 = this.rgb(this.m_pixels32[i]);
            pixels8[i] = (byte)this.m_hist[color16];
        }
        return pixels8;
    }

    BufferedImage makeBufferedImage() {
        byte[] pixels8 = this.toByteArray();
        BufferedImage bufferedImage = new BufferedImage(this.m_cm, this.m_cm.createCompatibleWritableRaster(this.m_width, this.m_height), false, null);
        WritableRaster raster = bufferedImage.getRaster();
        int[] pixelArray = new int[1];
        int i = 0;
        for (int x = 0; x < this.m_width; ++x) {
            for (int y = 0; y < this.m_height; ++y) {
                int pixel = this.m_pixels32[i];
                if (pixel >>> 24 > 127) {
                    pixelArray[0] = pixels8[i++];
                } else {
                    pixelArray[0] = 255;
                    ++i;
                }
                raster.setPixel(x, y, pixelArray);
            }
        }
        return bufferedImage;
    }

    Image makeImage() {
        byte[] pixels8 = this.toByteArray();
        Image img8 = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.m_width, this.m_height, (ColorModel)this.m_cm, pixels8, 0, this.m_width));
        return img8;
    }

    private final int rgb(int c) {
        int r = (c & 0xF80000) >> 19;
        int g = (c & 0xF800) >> 6;
        int b = (c & 0xF8) << 7;
        return b | g | r;
    }

    private final int red(int x) {
        return (x & 0x1F) << 3;
    }

    private final int green(int x) {
        return x >> 2 & 0xF8;
    }

    private final int blue(int x) {
        return x >> 7 & 0xF8;
    }

    private static final class ColorCube {
        private int lower;
        private int upper;
        private int count = 0;
        private int level;
        private int rmin;
        private int rmax;
        private int gmin;
        private int gmax;
        private int bmin;
        private int bmax;

        ColorCube() {
        }
    }
}

