/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.internal.runtime.methods;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.jruby.nb.RubyModule;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.anno.JavaMethodDescriptor;
import org.jruby.nb.internal.runtime.methods.CallConfiguration;
import org.jruby.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.internal.runtime.methods.ReflectedCompiledMethod;
import org.jruby.nb.internal.runtime.methods.ReflectedJavaMethod;
import org.jruby.nb.internal.runtime.methods.ReflectedJavaMultiMethod;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.MethodFactory;
import org.jruby.nb.runtime.Visibility;

public class ReflectionMethodFactory
extends MethodFactory {
    @Override
    public DynamicMethod getCompiledMethodLazily(RubyModule implementationClass, String methodName, Arity arity, Visibility visibility, StaticScope scope, Object scriptObject, CallConfiguration callConfig) {
        return this.getCompiledMethod(implementationClass, methodName, arity, visibility, scope, scriptObject, callConfig);
    }

    @Override
    public DynamicMethod getCompiledMethod(RubyModule implementationClass, String methodName, Arity arity, Visibility visibility, StaticScope scope, Object scriptObject, CallConfiguration callConfig) {
        try {
            Method method = scriptObject.getClass().getMethod(methodName, COMPILED_METHOD_PARAMS);
            return new ReflectedCompiledMethod(implementationClass, arity, visibility, scope, scriptObject, method, callConfig);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException("No method with name " + methodName + " found in " + scriptObject.getClass());
        }
    }

    @Override
    public DynamicMethod getAnnotatedMethod(RubyModule implementationClass, JavaMethodDescriptor desc) {
        try {
            Method method = desc.getDeclaringClass().getDeclaredMethod(desc.name, desc.getParameterClasses());
            ReflectedJavaMethod ic = new ReflectedJavaMethod(implementationClass, method, desc.anno);
            ic.setJavaName(method.getName());
            ic.setSingleton(Modifier.isStatic(method.getModifiers()));
            ic.setCallConfig(CallConfiguration.getCallConfigByAnno(desc.anno));
            return ic;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DynamicMethod getAnnotatedMethod(RubyModule implementationClass, List<JavaMethodDescriptor> descs) {
        try {
            ArrayList<Method> methods = new ArrayList<Method>();
            ArrayList<JRubyMethod> annotations = new ArrayList<JRubyMethod>();
            for (JavaMethodDescriptor desc : descs) {
                methods.add(desc.getDeclaringClass().getDeclaredMethod(desc.name, desc.getParameterClasses()));
                annotations.add(desc.anno);
            }
            Method method0 = (Method)methods.get(0);
            JRubyMethod anno0 = (JRubyMethod)annotations.get(0);
            ReflectedJavaMultiMethod ic = new ReflectedJavaMultiMethod(implementationClass, methods, annotations);
            ic.setJavaName(method0.getName());
            ic.setSingleton(Modifier.isStatic(method0.getModifiers()));
            ic.setCallConfig(CallConfiguration.getCallConfigByAnno(anno0));
            return ic;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Deprecated
    public void defineIndexedAnnotatedMethods(RubyModule implementationClass, Class type, MethodFactory.MethodDefiningCallback callback) {
        Method[] methods;
        for (Method method : methods = type.getDeclaredMethods()) {
            JRubyMethod jrubyMethod = method.getAnnotation(JRubyMethod.class);
            if (jrubyMethod == null) continue;
            callback.define(implementationClass, new JavaMethodDescriptor(method), this.getAnnotatedMethod(implementationClass, new JavaMethodDescriptor(method)));
        }
    }
}

