/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.internal.runtime.methods;

import org.jruby.nb.Ruby;
import org.jruby.nb.RubyModule;
import org.jruby.nb.exceptions.JumpException;
import org.jruby.nb.internal.runtime.JumpTarget;
import org.jruby.nb.internal.runtime.methods.CallConfiguration;
import org.jruby.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.RubyEvent;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.runtime.callback.Callback;

public class FullFunctionCallbackMethod
extends DynamicMethod
implements JumpTarget {
    private Callback callback;

    public FullFunctionCallbackMethod(RubyModule implementationClass, Callback callback, Visibility visibility) {
        super(implementationClass, visibility, CallConfiguration.FRAME_ONLY);
        this.callback = callback;
    }

    /*
     * Loose catch block
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
        try {
            IRubyObject iRubyObject;
            block14: {
                this.callConfig.pre(context, self, clazz, name, block, null, this);
                assert (args != null);
                Ruby runtime = context.getRuntime();
                boolean isTrace = runtime.hasEventHooks();
                if (isTrace) {
                    runtime.callEventHooks(context, RubyEvent.C_CALL, context.getFile(), context.getLine(), name, this.getImplementationClass());
                }
                try {
                    iRubyObject = this.callback.execute(self, args, block);
                    if (!isTrace) break block14;
                }
                catch (JumpException.ReturnJump rj) {
                    block15: {
                        if (rj.getTarget() != this) break block15;
                        IRubyObject iRubyObject2 = (IRubyObject)rj.getValue();
                        if (isTrace) {
                            runtime.callEventHooks(context, RubyEvent.C_RETURN, context.getFile(), context.getLine(), name, this.getImplementationClass());
                        }
                        this.callConfig.post(context);
                        return iRubyObject2;
                    }
                    throw rj;
                    {
                        catch (Throwable throwable) {
                            if (isTrace) {
                                runtime.callEventHooks(context, RubyEvent.C_RETURN, context.getFile(), context.getLine(), name, this.getImplementationClass());
                            }
                            throw throwable;
                        }
                    }
                }
                runtime.callEventHooks(context, RubyEvent.C_RETURN, context.getFile(), context.getLine(), name, this.getImplementationClass());
            }
            return iRubyObject;
        }
        finally {
            this.callConfig.post(context);
        }
    }

    public Callback getCallback() {
        return this.callback;
    }

    @Override
    public Arity getArity() {
        return this.getCallback().getArity();
    }

    @Override
    public DynamicMethod dup() {
        return new FullFunctionCallbackMethod(this.getImplementationClass(), this.callback, this.getVisibility());
    }
}

