/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeSupport;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.netbeans.modules.css.visual.model.ColorModel;
import org.netbeans.modules.css.visual.model.PropertyData;
import org.openide.util.NbBundle;

public class ColorSelectionField
extends JPanel {
    private PropertyChangeSupport propertyChangeSupport;
    ColorModel colorModel = new ColorModel();
    String currentColor = null;
    String oldColor = null;
    private JButton colorButton;
    private JComboBox colorComboBox;

    public ColorSelectionField() {
        this.initComponents();
        this.initialize();
    }

    private void initialize() {
        DefaultComboBoxModel colorList = this.colorModel.getColorList();
        this.colorComboBox.setModel(colorList);
        this.colorComboBox.setSelectedIndex(0);
    }

    private void initComponents() {
        this.colorButton = new ColorSelectionButton();
        this.colorComboBox = new JComboBox();
        this.setLayout(new BorderLayout(3, 0));
        this.colorButton.setToolTipText(NbBundle.getMessage(ColorSelectionField.class, (String)"COLOR_CHOOSER_BTN_LABEL"));
        this.colorButton.setPreferredSize(new Dimension(20, 20));
        this.colorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorSelectionField.this.colorButtonActionPerformed(evt);
            }
        });
        this.add((Component)this.colorButton, "East");
        this.colorButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ColorSelectionField.class, (String)"COLOR_EDITOR_BTN_ACCESS_NAME"));
        this.colorButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ColorSelectionField.class, (String)"COLOR_EDITOR_BTN_ACCESS_DESC"));
        this.colorComboBox.setEditable(true);
        this.colorComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorSelectionField.this.colorComboBoxActionPerformed(evt);
            }
        });
        this.colorComboBox.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ColorSelectionField.this.colorComboBoxFocusLost(evt);
            }
        });
        this.colorComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ColorSelectionField.this.colorComboBoxItemStateChanged(evt);
            }
        });
        this.add((Component)this.colorComboBox, "Center");
        this.colorComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ColorSelectionField.class, (String)"COLOR_SELECTION_COMBO_ACCESS_NAME"));
        this.colorComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ColorSelectionField.class, (String)"COLOR_SELECTION_COMBO_ACCESS_Desc"));
    }

    private void colorComboBoxItemStateChanged(ItemEvent evt) {
        this.setColor();
    }

    private void colorComboBoxFocusLost(FocusEvent evt) {
        this.setColor();
    }

    private void colorComboBoxActionPerformed(ActionEvent evt) {
        this.setColor();
    }

    private void colorButtonActionPerformed(ActionEvent evt) {
        Color newColor = JColorChooser.showDialog(this, NbBundle.getMessage(ColorSelectionField.class, (String)"COLOR_CHOOSER_TITLE"), this.colorModel.getColor());
        if (newColor != null) {
            this.colorModel.setColor(newColor);
            this.colorComboBox.setSelectedItem(this.colorModel.getHexColor());
        }
    }

    private void setColor() {
        PropertyData colorPropertyData = new PropertyData();
        this.currentColor = (String)this.colorComboBox.getSelectedItem();
        colorPropertyData.setValue(this.currentColor);
        this.colorModel.setColor(this.currentColor);
        this.repaint();
        this.firePropertyChange("color", this.oldColor, colorPropertyData.toString());
        this.oldColor = colorPropertyData.toString();
    }

    public void setColorString(String color) {
        this.currentColor = color;
        if (color == null || color.equals("")) {
            this.colorComboBox.setSelectedIndex(0);
        } else {
            this.colorComboBox.setSelectedItem(this.currentColor);
        }
        this.repaint();
    }

    public String getColorString() {
        return this.currentColor;
    }

    class ColorSelectionButton
    extends JButton {
        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D g2d = (Graphics2D)graphics;
            Color color = ColorSelectionField.this.colorModel.getColor();
            if (color == null) {
                color = Color.BLACK;
            }
            g2d.setColor(color);
            int w = this.getWidth();
            int h = this.getHeight();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.fillRoundRect(4, 4, w - 9, h - 9, 5, 5);
            g2d.setColor(color.darker());
            g2d.drawRoundRect(4, 4, w - 9, h - 9, 5, 5);
        }
    }
}

